/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.rest;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BlueprintBean {
    protected static final String BLUEPRINT_KEY = "blueprint";
    protected static final String NAME_KEY = "name";
    protected static final String SOURCE_KEY = "source";
    protected static final String DESTINATION_KEY = "destination";
    protected static final String DESTINATION_PAGE_ID_KEY = "pageId";
    protected static final String SPACE_KEY_KEY = "spaceKey";
    protected static final String SPACE_NAME_KEY = "spaceName";
    protected static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    protected static final String PAGE_TITLE_KEY = "pageTitle";
    protected static final String PARENT_PAGE_TITLE_ID_KEY = "parentPageTitleId";
    protected static final String PARENT_PAGE_TITLE_KEY = "parentPageTitle";
    protected static final String FIELDS_KEY = "fields";
    protected String blueprintName;
    protected String spaceKey;
    protected String spaceName;
    protected String spaceDescription;
    protected String pageTitle;
    protected String sourceSpaceKey;
    protected String sourcePageTitle;
    protected String parentPageTitle;
    protected Boolean replaceLabels;
    protected PageBlueprint pageBlueprint;
    protected SpaceBlueprint spaceBlueprint;
    protected Page destinationParentPage;
    protected AbstractPage destinationPage;
    protected Space destinationSpace;
    protected String valuesJson;
    protected List<String> pageLabels;
    protected Map<String, AttachmentResource> fileResources;

    public BlueprintBean(String jsonString) {
        try {
            JSONObject blueprint;
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(jsonString);
            if (json.containsKey((Object)BLUEPRINT_KEY) && (blueprint = (JSONObject)json.get((Object)BLUEPRINT_KEY)).containsKey((Object)NAME_KEY)) {
                this.setBlueprintName((String)blueprint.get((Object)NAME_KEY));
            }
            if (json.containsKey((Object)SOURCE_KEY)) {
                JSONObject source = (JSONObject)json.get((Object)SOURCE_KEY);
                if (source.containsKey((Object)SPACE_KEY_KEY)) {
                    this.setSourceSpaceKey((String)source.get((Object)SPACE_KEY_KEY));
                }
                if (source.containsKey((Object)PAGE_TITLE_KEY)) {
                    this.setSourcePageTitle((String)source.get((Object)PAGE_TITLE_KEY));
                }
            }
            if (json.containsKey((Object)DESTINATION_KEY)) {
                JSONObject destination = (JSONObject)json.get((Object)DESTINATION_KEY);
                if (destination.containsKey((Object)DESTINATION_PAGE_ID_KEY)) {
                    this.setDestinationPage((String)destination.get((Object)DESTINATION_PAGE_ID_KEY));
                } else if (destination.containsKey((Object)SPACE_KEY_KEY)) {
                    this.setSpaceKey((String)destination.get((Object)SPACE_KEY_KEY));
                }
                if (destination.containsKey((Object)PAGE_TITLE_KEY)) {
                    this.setPageTitle((String)destination.get((Object)PAGE_TITLE_KEY));
                }
                if (destination.containsKey((Object)SPACE_NAME_KEY)) {
                    this.setSpaceName((String)destination.get((Object)SPACE_NAME_KEY));
                }
                if (destination.containsKey((Object)SPACE_DESCRIPTION_KEY)) {
                    this.setSpaceDescription((String)destination.get((Object)SPACE_DESCRIPTION_KEY));
                }
                if (destination.containsKey((Object)PARENT_PAGE_TITLE_ID_KEY)) {
                    AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)destination.get((Object)PARENT_PAGE_TITLE_ID_KEY));
                    if (abstractPage != null) {
                        this.setParentPageTitle(Confluence.getTitle(abstractPage));
                    }
                } else if (destination.containsKey((Object)PARENT_PAGE_TITLE_KEY)) {
                    this.setParentPageTitle((String)destination.get((Object)PARENT_PAGE_TITLE_KEY));
                }
            }
            if (json.containsKey((Object)FIELDS_KEY)) {
                JSONArray values = (JSONArray)json.get((Object)FIELDS_KEY);
                this.setValuesJson(values.toJSONString());
            }
        }
        catch (ParseException ex) {
            BrikitLog.logDebug("Failed to parse parameters for Blueprint REST API", (Exception)((Object)ex));
        }
    }

    protected String getBlueprintName() {
        return this.blueprintName;
    }

    protected AbstractPage getDestinationPage() {
        if (this.destinationPage == null) {
            this.destinationPage = Confluence.getPage(this.getSpaceKey(), this.getPageTitle());
        }
        return this.destinationPage;
    }

    protected Page getDestinationParentPage() {
        if (this.destinationParentPage == null) {
            this.destinationParentPage = BrikitString.isSet(this.getParentPageTitle()) ? Confluence.getPage(this.getSpaceKey(), this.getParentPageTitle()) : Confluence.getSpaceHomePage(this.getSpaceKey());
        }
        return this.destinationParentPage;
    }

    protected Space getDestinationSpace() {
        if (this.destinationSpace == null) {
            this.destinationSpace = Confluence.getSpace(this.getSpaceKey());
        }
        return this.destinationSpace;
    }

    public Map<String, AttachmentResource> getFileResources() {
        return Collections.EMPTY_MAP;
    }

    protected PageBlueprint getPageBlueprint() {
        if (this.pageBlueprint == null) {
            this.pageBlueprint = BlueprintDefinitions.getPageBlueprint(this.getBlueprintName());
        }
        return this.pageBlueprint;
    }

    public List<String> getPageLabels() {
        return Collections.EMPTY_LIST;
    }

    protected String getPageTitle() {
        return this.pageTitle;
    }

    protected String getParentPageTitle() {
        return this.parentPageTitle;
    }

    protected Boolean getReplaceLabels() {
        return this.replaceLabels;
    }

    protected AbstractPage getSourcePage() {
        return Confluence.getPage(this.getSourceSpaceKey(), this.getSourcePageTitle());
    }

    public String getSourcePageTitle() {
        return this.sourcePageTitle;
    }

    protected Space getSourceSpace() {
        return Confluence.getSpace(this.getSourceSpaceKey());
    }

    public String getSourceSpaceKey() {
        return this.sourceSpaceKey;
    }

    protected SpaceBlueprint getSpaceBlueprint() {
        if (this.spaceBlueprint == null) {
            this.spaceBlueprint = BlueprintDefinitions.getSpaceBlueprint(this.getBlueprintName());
        }
        return this.spaceBlueprint;
    }

    public String getSpaceDescription() {
        return this.spaceDescription;
    }

    protected String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getValuesJson() {
        return this.valuesJson;
    }

    protected boolean isCreating() {
        return this.getDestinationPage() == null;
    }

    protected void setBlueprintName(String blueprintName) {
        this.blueprintName = blueprintName;
    }

    public void setDestinationPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost(pageIdAsString);
        if (abstractPage != null) {
            this.setSpaceKey(Confluence.getSpaceKey(abstractPage));
            this.setPageTitle(Confluence.getTitle(abstractPage));
        }
    }

    protected void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    protected void setParentPageTitle(String parentPageTitle) {
        this.parentPageTitle = parentPageTitle;
    }

    protected void setReplaceLabels(Boolean replaceLabels) {
        this.replaceLabels = replaceLabels;
    }

    public void setSourcePageTitle(String sourcePageTitle) {
        this.sourcePageTitle = sourcePageTitle;
    }

    public void setSourceSpaceKey(String sourceSpaceKey) {
        this.sourceSpaceKey = sourceSpaceKey;
    }

    public void setSpaceDescription(String spaceDescription) {
        this.spaceDescription = spaceDescription;
    }

    protected void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public void setValuesJson(String valuesJson) {
        this.valuesJson = valuesJson;
    }
}

