/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.rest;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.blueprintmaker.model.BlueprintMaker;
import com.brikit.blueprintmaker.rest.BlueprintBean;
import com.brikit.blueprintmaker.rest.BlueprintResourceModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import javax.ws.rs.core.Response;

public abstract class AbstractBlueprintResource {
    protected boolean noCreatePagePermissions(String spaceKey) {
        return !BlueprintMaker.canCreatePagesFromBlueprints(spaceKey);
    }

    protected boolean noCreateSpacePermissions() {
        return !BlueprintMaker.canCreateSpacesFromBlueprints();
    }

    protected boolean noDestinationPageFound(BlueprintBean bean) {
        return bean.getDestinationPage() == null;
    }

    protected boolean noDestinationParentPageFound(BlueprintBean bean) {
        return bean.getDestinationParentPage() == null;
    }

    protected boolean noDestinationSpaceFound(BlueprintBean bean) {
        return bean.getDestinationSpace() == null;
    }

    protected boolean noEditPermission(AbstractPage page) {
        return !Confluence.canEdit(page);
    }

    protected boolean noPageBlueprintFound(BlueprintBean bean) {
        return bean.getPageBlueprint() == null;
    }

    protected boolean noSourcePageFound(BlueprintBean bean) {
        return bean.getSourcePage() == null;
    }

    protected boolean noSourceSpaceFound(BlueprintBean bean) {
        return bean.getSourceSpace() == null;
    }

    protected boolean noSpaceBlueprintFound(BlueprintBean bean) {
        return bean.getSpaceBlueprint() == null;
    }

    protected Response response(Response.Status status, String message) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        builder.entity((Object)new BlueprintResourceModel(message));
        return Response.ok((Object)new BlueprintResourceModel(message)).build();
    }

    protected Response responseException(String message, Exception ex) {
        BrikitLog.logDebug(message, ex);
        return this.response(Response.Status.INTERNAL_SERVER_ERROR, message + " Check log files for more details. Error: " + ex.getMessage());
    }
}

