/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.spaces.Space;
import com.brikit.blueprintmaker.model.FieldSwapper;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import org.json.simple.parser.ParseException;

public class SpaceFields {
    public static final String SPACE_DATA_KEY = "com.brikit.blueprintmaker.space.data";

    public static void saveFieldsToSpace(Space aSpace, FieldSwapper fieldSwapper) {
        BrikitBandanaManager.saveEntry(aSpace, SPACE_DATA_KEY, fieldSwapper.toJSON());
    }

    public static FieldSwapper savedFieldsForSpace(String spaceKey) throws ParseException {
        return SpaceFields.savedFieldsForSpace(Confluence.getSpace(spaceKey));
    }

    public static FieldSwapper savedFieldsForSpace(Space aSpace) throws ParseException {
        FieldSwapper fieldSwapper = new FieldSwapper();
        fieldSwapper.addValues(SpaceFields.readRawData(aSpace));
        return fieldSwapper;
    }

    protected static String readRawData(Space aSpace) {
        return BrikitBandanaManager.getEntry(aSpace, SPACE_DATA_KEY);
    }

    public static boolean isFromTemplate(Space aSpace) {
        return BrikitString.isSet(SpaceFields.readRawData(aSpace));
    }

    public static boolean isFromTemplate(String spaceKey) {
        return BrikitString.isSet(SpaceFields.readRawData(Confluence.getSpace(spaceKey)));
    }
}

