/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.blueprintmaker.model.FieldSwapper;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import org.json.simple.parser.ParseException;

public class PageFields {
    public static final String PAGE_DATA_KEY = "com.brikit.blueprintmaker.page.data";

    public static void saveFieldsToPage(AbstractPage abstractPage, FieldSwapper fieldSwapper) {
        Confluence.saveTextData(PAGE_DATA_KEY, fieldSwapper.toJSON(), abstractPage);
    }

    public static FieldSwapper savedFieldsForPage(long pageId) throws ParseException {
        return PageFields.savedFieldsForPage(Confluence.getPageOrBlogPost(pageId));
    }

    public static FieldSwapper savedFieldsForPage(AbstractPage abstractPage) throws ParseException {
        if (!PageFields.isFromTemplate(abstractPage)) {
            return null;
        }
        FieldSwapper fieldSwapper = new FieldSwapper();
        fieldSwapper.addValues(PageFields.readRawData(abstractPage));
        return fieldSwapper;
    }

    public static String readRawData(AbstractPage abstractPage) {
        return Confluence.getTextData(PAGE_DATA_KEY, abstractPage);
    }

    public static boolean isFromTemplate(AbstractPage abstractPage) {
        return BrikitString.isSet(PageFields.readRawData(abstractPage));
    }

    public static String pageTempateId(AbstractPage abstractPage) {
        AbstractPage templatePage = PageFields.pageTemplate(abstractPage);
        return templatePage == null ? "" : templatePage.getIdAsString();
    }

    public static AbstractPage pageTemplate(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return null;
        }
        try {
            FieldSwapper fieldSwapper = PageFields.savedFieldsForPage(abstractPage);
            return fieldSwapper == null ? null : fieldSwapper.getBlueprintPageFromSavedTemplateId();
        }
        catch (ParseException ex) {
            BrikitLog.logDebug("Unable to read saved blueprint fields for page: " + abstractPage);
            return null;
        }
    }
}

