/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.brikit.blueprintmaker.model.BlueprintFieldType;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FieldValue {
    protected String name;
    protected BlueprintFieldType type;
    protected Object value;

    public FieldValue(String name, String type, Object value) {
        this(name, BlueprintFieldType.get(type), value);
    }

    public FieldValue(String name, BlueprintFieldType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Object getConvertedValue() {
        if (this.isListType()) {
            String trimmedString;
            String string = trimmedString = this.getValue() == null ? "" : this.getValue().toString().trim();
            if (trimmedString.startsWith("[")) {
                JSONParser parser = new JSONParser();
                JSONArray array = null;
                try {
                    array = (JSONArray)parser.parse(this.getValue().toString());
                }
                catch (ParseException e) {
                    return this.getValue();
                }
                return new BrikitList(array.iterator());
            }
            if (BrikitString.isSet(trimmedString)) {
                BrikitList<String> list = new BrikitList<String>(1);
                list.add(trimmedString);
                return list;
            }
            return BrikitList.EMPTY_LIST;
        }
        return this.getValue();
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        if (this.isListType() && this.getConvertedValue() instanceof BrikitList) {
            return ((BrikitList)this.getConvertedValue()).join(", ");
        }
        return this.value.toString();
    }

    public BlueprintFieldType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isFileType() {
        return this.getType() == BlueprintFieldType.FILE;
    }

    public boolean isListType() {
        return this.getType() == BlueprintFieldType.LIST;
    }
}

