/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.blueprintmaker.events.cluster.BlueprintsUpdateClusterEvent;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.AccessPermission;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.PageBlueprintType;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitOrderedMap;
import com.brikit.core.util.BrikitString;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class BlueprintDefinitions {
    public static final String BLUEPRINT_DEFINITIONS_FILENAME = "blueprint-definitions.json";
    public static final String SPACE_KEY_KEY = "spaceKey";
    public static final String SPACE_NAME_KEY = "spaceName";
    public static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    protected static final String SPACE_BLUEPRINTS_KEY = "spaceBlueprints";
    protected static final String ACCESS_LISTS_KEY = "accessLists";
    protected static final String BLUEPRINTS_FIELDS_KEY = "blueprintFields";
    protected static final String PAGE_BLUEPRINTS_KEY = "pageBlueprints";
    protected static final String NAME_KEY = "name";
    protected static final String PERMISSIONS_KEY = "permissions";
    protected static final String TYPE_KEY = "type";
    protected static final String CREATE_KEY = "create";
    protected static final String GRANT_KEY = "grant";
    protected static final String DESCRIPTION_KEY = "description";
    protected static final String ACCESS_KEY = "access";
    protected static final String SPACE_CATEGORIES_KEY = "spaceCategories";
    protected static final String BLUEPRINT_SPACE_KEY_KEY = "blueprintSpaceKey";
    protected static final String ID_KEY = "id";
    protected static final String REQUIRED_KEY = "required";
    protected static final String HELP_TEXT_KEY = "helpText";
    protected static final String VALIDATION_KEY = "validation";
    protected static final String PLACEHOLDER_KEY = "placeholder";
    protected static final String VALUES = "values";
    protected static final String MULTISELECT = "multiselect";
    protected static final String ADD_LABELS = "addLabels";
    protected static final String FILTER_GROUP = "filterGroup";
    protected static final String WORKFLOW_ID = "workflowId";
    protected static final String PAGE_TITLE_KEY = "pageTitle";
    protected static final String INCLUDE_CHILDREN_KEY = "includeChildren";
    protected static final String VISIBILITY_KEY = "visibility";
    protected static final String SPACE_METADATA_KEY = "spaceMetadata";
    protected static final String PAGE_METADATA_KEY = "pageMetadata";
    protected static final List<String> SPACE_METADATA_DEFAULT = Arrays.asList("atlassian.confluence.*", "com.brikit.*");
    protected static final List<String> PAGE_METADATA_DEFAULT = Arrays.asList("com.brikit.*");
    protected static final String CREATE_SPACE_GROUPS_KEY = "createSpaceGroups";
    protected static final String ANONYMOUS = "anonymous";
    protected static BrikitOrderedMap<String, SpaceBlueprint> spaceBlueprints;
    protected static BrikitOrderedMap<String, BlueprintField> blueprintFields;
    protected static BrikitOrderedMap<String, Access> accesses;
    protected static BrikitOrderedMap<String, PageBlueprint> pageBlueprints;
    protected static List<String> pageMetadata;
    protected static List<String> spaceMetadata;
    protected static List<String> createSpaceGroups;

    public static synchronized Map<String, Access> getAccesses() {
        if (accesses == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return accesses;
    }

    public static List<String> getCreateSpaceGroups() {
        if (createSpaceGroups == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return createSpaceGroups;
    }

    public static PageBlueprint getPageBlueprint(String blueprintName) {
        return (PageBlueprint)BlueprintDefinitions.getPageBlueprints().get(blueprintName);
    }

    public static PageBlueprint getPageBlueprint(AbstractPage blueprintPage) {
        if (blueprintPage == null) {
            return null;
        }
        for (String blueprint : BlueprintDefinitions.getPageBlueprints().getKeysInOrder()) {
            PageBlueprint pageBlueprint = (PageBlueprint)BlueprintDefinitions.getPageBlueprints().get(blueprint);
            if (pageBlueprint.getConfluencePage() == null || blueprintPage.getId() != pageBlueprint.getConfluencePage().getId()) continue;
            return pageBlueprint;
        }
        return null;
    }

    public static BrikitOrderedMap<String, PageBlueprint> getPageBlueprints() {
        if (pageBlueprints == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return pageBlueprints;
    }

    public static List<String> getPageMetadata() {
        if (pageMetadata == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return pageMetadata;
    }

    public static List<String> getSpaceMetadata() {
        if (spaceMetadata == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return spaceMetadata;
    }

    public static SpaceBlueprint getSpaceBlueprint(String blueprintName) {
        return (SpaceBlueprint)BlueprintDefinitions.getSpaceBlueprints().get(blueprintName);
    }

    public static synchronized BrikitOrderedMap<String, SpaceBlueprint> getSpaceBlueprints() {
        if (spaceBlueprints == null) {
            try {
                BlueprintDefinitions.readBlueprintsFromFile(BlueprintDefinitions.getBlueprintDefinitionsFile(), false);
            }
            catch (Exception ex) {
                if (BlueprintDefinitions.getBlueprintDefinitionsFile().exists()) {
                    BrikitLog.logDebug("Failed to read blueprint-definitions.json", ex);
                }
                spaceBlueprints = new BrikitOrderedMap();
                pageBlueprints = new BrikitOrderedMap();
                blueprintFields = new BrikitOrderedMap();
                accesses = new BrikitOrderedMap();
                pageMetadata = PAGE_METADATA_DEFAULT;
                spaceMetadata = SPACE_METADATA_DEFAULT;
                createSpaceGroups = new ArrayList<String>();
            }
        }
        return spaceBlueprints;
    }

    public static File getBlueprintDefinitionsFile() {
        return BrikitFile.getBrikitFile(BLUEPRINT_DEFINITIONS_FILENAME);
    }

    public static BlueprintField getBlueprintField(String name) {
        return (BlueprintField)BlueprintDefinitions.getBlueprintFields().get(name);
    }

    public static synchronized BrikitOrderedMap<String, BlueprintField> getBlueprintFields() {
        if (blueprintFields == null) {
            BlueprintDefinitions.getSpaceBlueprints();
        }
        return blueprintFields;
    }

    protected static void readBlueprintsFromFile(File aFile, boolean validateOnly) throws Exception {
        List<String> readSpaceMetadata;
        List<String> readPageMetadata;
        JSONParser parser = new JSONParser();
        String fileContents = BrikitFile.readFile(aFile);
        JSONObject allSettingsJSON = (JSONObject)parser.parse(fileContents);
        List<String> list = readPageMetadata = allSettingsJSON.containsKey((Object)PAGE_METADATA_KEY) ? BlueprintDefinitions.unpackStringList((JSONArray)allSettingsJSON.get((Object)PAGE_METADATA_KEY)) : PAGE_METADATA_DEFAULT;
        if (readPageMetadata == null || readPageMetadata.isEmpty()) {
            readPageMetadata = PAGE_METADATA_DEFAULT;
        }
        List<String> list2 = readSpaceMetadata = allSettingsJSON.containsKey((Object)SPACE_METADATA_KEY) ? BlueprintDefinitions.unpackStringList((JSONArray)allSettingsJSON.get((Object)SPACE_METADATA_KEY)) : SPACE_METADATA_DEFAULT;
        if (readSpaceMetadata == null || readSpaceMetadata.isEmpty()) {
            readSpaceMetadata = SPACE_METADATA_DEFAULT;
        }
        List<String> readCreateSpaceGroups = BlueprintDefinitions.unpackStringList((JSONArray)allSettingsJSON.get((Object)CREATE_SPACE_GROUPS_KEY));
        BrikitOrderedMap<String, Access> readAccesses = BlueprintDefinitions.unpackAccesses((JSONArray)allSettingsJSON.get((Object)ACCESS_LISTS_KEY));
        BrikitOrderedMap<String, BlueprintField> readBlueprintFields = BlueprintDefinitions.unpackBlueprintFields((JSONArray)allSettingsJSON.get((Object)BLUEPRINTS_FIELDS_KEY));
        BrikitOrderedMap<String, PageBlueprint> readPageBlueprints = BlueprintDefinitions.unpackPageBlueprints((JSONArray)allSettingsJSON.get((Object)PAGE_BLUEPRINTS_KEY), readBlueprintFields);
        BrikitOrderedMap<String, SpaceBlueprint> readSpaceBlueprints = BlueprintDefinitions.unpackSpaceBlueprints((JSONArray)allSettingsJSON.get((Object)SPACE_BLUEPRINTS_KEY), readBlueprintFields, readAccesses);
        if (!validateOnly) {
            spaceBlueprints = readSpaceBlueprints;
            blueprintFields = readBlueprintFields;
            accesses = readAccesses;
            spaceMetadata = readSpaceMetadata;
            pageMetadata = readPageMetadata;
            pageBlueprints = readPageBlueprints;
            createSpaceGroups = readCreateSpaceGroups;
        }
    }

    public static void reset() {
        spaceBlueprints = null;
        blueprintFields = null;
        accesses = null;
        spaceMetadata = null;
        pageMetadata = null;
        pageBlueprints = null;
        createSpaceGroups = null;
    }

    protected static BrikitOrderedMap<String, Access> unpackAccesses(JSONArray accessesJSON) throws Exception {
        BrikitOrderedMap<String, Access> accesses = new BrikitOrderedMap<String, Access>();
        for (Object accessObject : accessesJSON) {
            JSONObject accessJSON = (JSONObject)accessObject;
            String name = (String)accessJSON.get((Object)NAME_KEY);
            JSONArray permissionsJSON = (JSONArray)accessJSON.get((Object)PERMISSIONS_KEY);
            ArrayList<AccessPermission> permissions = new ArrayList<AccessPermission>();
            for (Object permissionObject : permissionsJSON) {
                JSONObject permissionJSON = (JSONObject)permissionObject;
                List<String> spacePermissions = BlueprintDefinitions.unpackStringList((JSONArray)permissionJSON.get((Object)GRANT_KEY));
                String type = (String)permissionJSON.get((Object)TYPE_KEY);
                String userOrGroup = ANONYMOUS.equalsIgnoreCase(type) ? "" : (String)permissionJSON.get((Object)NAME_KEY);
                boolean createGroup = "group".equalsIgnoreCase(type) && permissionJSON.containsKey((Object)CREATE_KEY) && (Boolean)permissionJSON.get((Object)CREATE_KEY) != false;
                AccessPermission accessPermission = new AccessPermission(type, userOrGroup, spacePermissions, createGroup);
                permissions.add(accessPermission);
            }
            accesses.put(name, new Access(name, permissions));
        }
        return accesses;
    }

    protected static BrikitOrderedMap<String, PageBlueprint> unpackPageBlueprints(JSONArray pageBlueprintsJSON, BrikitOrderedMap<String, BlueprintField> readBlueprintFields) throws Exception {
        BrikitOrderedMap<String, PageBlueprint> pageBlueprints = new BrikitOrderedMap<String, PageBlueprint>();
        for (Object pageBlueprint : pageBlueprintsJSON) {
            PageBlueprintType type;
            boolean includeChildren;
            JSONObject pageBlueprintJSON = (JSONObject)pageBlueprint;
            String pageTitle = (String)pageBlueprintJSON.get((Object)PAGE_TITLE_KEY);
            String name = pageBlueprintJSON.containsKey((Object)NAME_KEY) ? (String)pageBlueprintJSON.get((Object)NAME_KEY) : pageTitle;
            String spaceKey = (String)pageBlueprintJSON.get((Object)SPACE_KEY_KEY);
            String description = (String)pageBlueprintJSON.get((Object)DESCRIPTION_KEY);
            boolean bl = includeChildren = pageBlueprintJSON.containsKey((Object)INCLUDE_CHILDREN_KEY) ? (Boolean)pageBlueprintJSON.get((Object)INCLUDE_CHILDREN_KEY) : false;
            PageBlueprintType pageBlueprintType = pageBlueprintJSON.containsKey((Object)TYPE_KEY) ? PageBlueprintType.get((String)pageBlueprintJSON.get((Object)TYPE_KEY)) : (type = includeChildren ? PageBlueprintType.TREE : PageBlueprintType.PAGE);
            if (type == null) {
                type = PageBlueprintType.PAGE;
            }
            ArrayList<String> spaceCategories = pageBlueprintJSON.containsKey((Object)VISIBILITY_KEY) ? BlueprintDefinitions.unpackStringList((JSONArray)pageBlueprintJSON.get((Object)VISIBILITY_KEY)) : new ArrayList<String>();
            Long workflowIdLong = type == PageBlueprintType.PAGE && pageBlueprintJSON.containsKey((Object)WORKFLOW_ID) ? (Long)pageBlueprintJSON.get((Object)WORKFLOW_ID) : null;
            Integer workflowId = workflowIdLong == null ? null : Integer.valueOf(BrikitNumber.parseInteger(Long.toString(workflowIdLong)));
            ArrayList<BlueprintField> blueprintFields = new ArrayList<BlueprintField>();
            if (pageBlueprintJSON.containsKey((Object)BLUEPRINTS_FIELDS_KEY)) {
                JSONArray blueprintFieldsJSON = (JSONArray)pageBlueprintJSON.get((Object)BLUEPRINTS_FIELDS_KEY);
                for (Object blueprintFieldJSON : blueprintFieldsJSON) {
                    String id = (String)blueprintFieldJSON;
                    BlueprintField blueprintField = (BlueprintField)readBlueprintFields.get(id);
                    if (blueprintField == null) continue;
                    blueprintFields.add(blueprintField);
                }
            }
            pageBlueprints.put(name, new PageBlueprint(name, spaceKey, pageTitle, description, blueprintFields, type, spaceCategories, workflowId));
        }
        return pageBlueprints;
    }

    protected static BrikitOrderedMap<String, SpaceBlueprint> unpackSpaceBlueprints(JSONArray spaceBlueprintsJSON, BrikitOrderedMap<String, BlueprintField> readBlueprintFields, BrikitOrderedMap<String, Access> allAccesses) throws Exception {
        BrikitOrderedMap<String, SpaceBlueprint> spaceBlueprints = new BrikitOrderedMap<String, SpaceBlueprint>();
        for (Object spaceBlueprint : spaceBlueprintsJSON) {
            JSONObject spaceBlueprintJSON = (JSONObject)spaceBlueprint;
            String name = (String)spaceBlueprintJSON.get((Object)NAME_KEY);
            String description = (String)spaceBlueprintJSON.get((Object)DESCRIPTION_KEY);
            String categories = spaceBlueprintJSON.containsKey((Object)SPACE_CATEGORIES_KEY) ? (String)spaceBlueprintJSON.get((Object)SPACE_CATEGORIES_KEY) : "";
            BrikitList<String> spaceCategories = BrikitString.splitCommaSeparated(categories);
            String blueprintSpaceKey = (String)spaceBlueprintJSON.get((Object)BLUEPRINT_SPACE_KEY_KEY);
            String spaceKey = spaceBlueprintJSON.containsKey((Object)SPACE_KEY_KEY) ? (String)spaceBlueprintJSON.get((Object)SPACE_KEY_KEY) : "";
            String spaceName = spaceBlueprintJSON.containsKey((Object)SPACE_NAME_KEY) ? (String)spaceBlueprintJSON.get((Object)SPACE_NAME_KEY) : "";
            String spaceDescription = spaceBlueprintJSON.containsKey((Object)SPACE_DESCRIPTION_KEY) ? (String)spaceBlueprintJSON.get((Object)SPACE_DESCRIPTION_KEY) : "";
            JSONArray blueprintFieldsJSON = (JSONArray)spaceBlueprintJSON.get((Object)BLUEPRINTS_FIELDS_KEY);
            ArrayList<BlueprintField> blueprintFields = new ArrayList<BlueprintField>();
            for (Object blueprintFieldJSON : blueprintFieldsJSON) {
                String id = (String)blueprintFieldJSON;
                BlueprintField blueprintField = (BlueprintField)readBlueprintFields.get(id);
                if (blueprintField == null) continue;
                blueprintFields.add(blueprintField);
            }
            JSONArray accessesJSON = (JSONArray)spaceBlueprintJSON.get((Object)ACCESS_KEY);
            ArrayList<Access> accesses = new ArrayList<Access>();
            for (Object accessJSON : accessesJSON) {
                String accessName = (String)accessJSON;
                Access access = (Access)allAccesses.get(accessName);
                if (access == null) continue;
                accesses.add(access);
            }
            spaceBlueprints.put(name, new SpaceBlueprint(name, description, spaceCategories, blueprintSpaceKey, spaceKey, spaceName, spaceDescription, blueprintFields, accesses));
        }
        return spaceBlueprints;
    }

    protected static List<String> unpackStringList(JSONArray stringListJSON) throws Exception {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object object : stringListJSON) {
            strings.add((String)object);
        }
        return strings;
    }

    protected static BrikitOrderedMap<String, BlueprintField> unpackBlueprintFields(JSONArray blueprintFieldsJSON) throws Exception {
        BrikitOrderedMap<String, BlueprintField> blueprintFields = new BrikitOrderedMap<String, BlueprintField>();
        for (Object object : blueprintFieldsJSON) {
            JSONObject blueprintFieldJSON = (JSONObject)object;
            String id = (String)blueprintFieldJSON.get((Object)ID_KEY);
            String name = (String)blueprintFieldJSON.get((Object)NAME_KEY);
            String type = blueprintFieldJSON.containsKey((Object)TYPE_KEY) ? (String)blueprintFieldJSON.get((Object)TYPE_KEY) : "";
            String helpText = blueprintFieldJSON.containsKey((Object)HELP_TEXT_KEY) ? (String)blueprintFieldJSON.get((Object)HELP_TEXT_KEY) : "";
            String placeholder = blueprintFieldJSON.containsKey((Object)PLACEHOLDER_KEY) ? (String)blueprintFieldJSON.get((Object)PLACEHOLDER_KEY) : "";
            String validation = blueprintFieldJSON.containsKey((Object)VALIDATION_KEY) ? (String)blueprintFieldJSON.get((Object)VALIDATION_KEY) : "";
            boolean required = blueprintFieldJSON.containsKey((Object)REQUIRED_KEY) && (Boolean)blueprintFieldJSON.get((Object)REQUIRED_KEY) != false;
            JSONArray values = blueprintFieldJSON.containsKey((Object)VALUES) ? (JSONArray)blueprintFieldJSON.get((Object)VALUES) : new JSONArray();
            boolean multiselect = blueprintFieldJSON.containsKey((Object)MULTISELECT) && (Boolean)blueprintFieldJSON.get((Object)MULTISELECT) != false;
            boolean addLabels = blueprintFieldJSON.containsKey((Object)ADD_LABELS) && (Boolean)blueprintFieldJSON.get((Object)ADD_LABELS) != false;
            String filterGroup = blueprintFieldJSON.containsKey((Object)FILTER_GROUP) ? (String)blueprintFieldJSON.get((Object)FILTER_GROUP) : "";
            BlueprintField blueprintField = BlueprintField.create(id, name, type, helpText, placeholder, validation, required, new BrikitList<String>(values.iterator()), multiselect, addLabels, filterGroup);
            blueprintFields.put(id, blueprintField);
        }
        return blueprintFields;
    }

    public static synchronized void uploadSettings(File uploadedFile) throws Exception {
        BlueprintDefinitions.readBlueprintsFromFile(uploadedFile, true);
        Files.move(uploadedFile.toPath(), BlueprintDefinitions.getBlueprintDefinitionsFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        BlueprintDefinitions.reset();
        BlueprintsUpdateClusterEvent event = new BlueprintsUpdateClusterEvent(new Object());
        Confluence.getEventPublisher().publish((Object)event);
    }
}

