/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.brikit.blueprintmaker.model.BlueprintMaker;
import com.brikit.blueprintmaker.model.BlueprintPage;
import com.brikit.core.actions.BrikitActionSupport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import javax.servlet.http.HttpServletRequest;

public abstract class BlueprintMakerActionSupport
extends BrikitActionSupport
implements ServletRequestAware {
    protected HttpServletRequest servletRequest;
    protected Object taxonomyService;
    protected String templatePageId;
    protected String blueprintProperties;
    protected boolean liveBlueprint;
    protected String macroId;
    protected PluginLicenseManager pluginLicenseManager;

    public void checkLicense() {
        if (!this.isLicensed()) {
            this.addActionError("<a href='https://marketplace.atlassian.com/plugins/com.brikit.blueprintmaker' target='_blank'>Brikit Blueprint Maker</a> is not licensed.");
        }
    }

    public String getBlueprintProperties() {
        return this.blueprintProperties;
    }

    public JSONObject getBlueprintPropertiesJSONObject() {
        return BrikitString.isSet(this.getBlueprintProperties()) ? new JSONObject(this.getBlueprintProperties()) : null;
    }

    public String getMacroId() {
        return this.macroId;
    }

    public MultiPartRequestWrapper getMultiPartRequest() {
        return this.isMultiPartRequest() ? (MultiPartRequestWrapper)this.getServletRequest() : null;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public AbstractPage getTemplateConfluencePage() {
        return Confluence.getPageOrBlogPost(this.getTemplatePageId());
    }

    public BlueprintPage getTemplatePage() {
        return BlueprintPage.get(this.getTemplatePageId());
    }

    public String getTemplatePageId() {
        return this.templatePageId;
    }

    public boolean isLicensed() {
        return BlueprintMaker.isLicensed(this.getPluginLicenseManager());
    }

    public boolean isLiveBlueprint() {
        return this.liveBlueprint;
    }

    public boolean isMultiPartRequest() {
        return this.getServletRequest() instanceof MultiPartRequestWrapper;
    }

    public void setBlueprintProperties(String blueprintProperties) {
        this.blueprintProperties = blueprintProperties;
    }

    public void setLiveBlueprint(boolean liveBlueprint) {
        this.liveBlueprint = liveBlueprint;
    }

    public void setMacroId(String macroId) {
        this.macroId = macroId;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public void setTemplatePageId(String templatePageId) {
        this.templatePageId = templatePageId;
    }
}

