/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.json.jsonorg.JSONArray;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BrikitList<E>
extends ArrayList<E> {
    public static final BrikitList EMPTY_LIST = new BrikitList();

    public BrikitList() {
    }

    public BrikitList(Iterable<E> iterable) {
        for (E item : iterable) {
            this.add(item);
        }
    }

    public BrikitList(Iterator<E> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public BrikitList(List<E> aList) {
        super(aList);
    }

    public BrikitList(int size) {
        super(size);
    }

    public BrikitList(E ... objectArray) {
        super(Arrays.asList(objectArray));
    }

    public BrikitList(Set<E> aSet) {
        super(aSet);
    }

    public static BrikitList removeBlanks(List list) {
        BrikitList pruned = new BrikitList(list.size());
        for (Object element : list) {
            if (element == null || element instanceof String && !BrikitString.isSet((String)element)) continue;
            pruned.add(element);
        }
        return pruned;
    }

    public E after(E anObject) {
        int location = this.indexOf(anObject);
        return location < this.size() - 1 ? (E)this.get(location + 1) : null;
    }

    public E before(E anObject) {
        int location = this.indexOf(anObject);
        return location <= 0 ? null : (E)this.get(location - 1);
    }

    public BrikitList<BrikitList<E>> chunk(int chunkSize) {
        BrikitList<BrikitList<BrikitList<E>>> chunks = new BrikitList<BrikitList<BrikitList<E>>>();
        BrikitList chunk = null;
        int count = chunkSize;
        for (Object o : this) {
            if (count == chunkSize) {
                chunk = new BrikitList();
                chunks.add(chunk);
                count = 0;
            }
            chunk.add(o);
            ++count;
        }
        return chunks;
    }

    public void compact() {
        this.removeAll(Collections.singleton(null));
    }

    public void ensureContains(List<E> addList) {
        for (E element : addList) {
            if (this.contains(element)) continue;
            this.ensureContains(element);
        }
    }

    public void ensureContains(E anObject) {
        if (!this.contains(anObject)) {
            this.add(anObject);
        }
    }

    public E first() {
        return this.isEmpty() ? null : (E)this.get(0);
    }

    public void insertAfter(E element, E insertAfter) {
        int index = this.position(insertAfter);
        if (index == 0) {
            this.add(0, element);
        } else if (index == this.size()) {
            this.add(element);
        } else {
            this.add(index, element);
        }
    }

    public void insertBefore(E element, E insertBefore) {
        int index = this.indexOf(insertBefore);
        if (index == -1) {
            this.add(element);
        } else {
            this.add(index, element);
        }
    }

    public boolean isFirst(E anObject) {
        return anObject != null && anObject.equals(this.first());
    }

    public boolean isLast(E anObject) {
        return anObject != null && anObject.equals(this.last());
    }

    public String join() {
        return this.join(" ");
    }

    public String join(String aSeparator) {
        StringBuilder builder = new StringBuilder();
        for (Object element : this) {
            if (element == null) continue;
            if (BrikitString.isSet(element.toString()) && builder.length() > 0) {
                builder.append(aSeparator);
            }
            builder.append(element.toString().trim());
        }
        return builder.toString();
    }

    public E last() {
        return this.isEmpty() ? null : (E)this.get(this.size() - 1);
    }

    public BrikitList objectsAfter(E anObject) {
        int location = this.indexOf(anObject);
        return location < this.size() ? new BrikitList(this.subList(location + 1, this.size())) : new BrikitList<E>();
    }

    public BrikitList objectsBefore(E anObject) {
        int location = this.indexOf(anObject);
        return location < 1 ? new BrikitList<E>() : new BrikitList(this.subList(0, location));
    }

    public int position(E anObject) {
        return this.indexOf(anObject) + 1;
    }

    public void subtract(List<E> blackList) {
        for (E element : blackList) {
            if (!this.contains(element)) continue;
            this.remove(element);
        }
    }

    public JSONArray toJSON() {
        JSONArray json = new JSONArray();
        for (Object item : this) {
            json.put(item);
        }
        return json;
    }
}

