/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.spaces.Space;
import com.brikit.blueprintmaker.model.SpaceDefinition;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SpaceDefinitionSettings {
    public static final String SPACE_DEFINITIONS_FILENAME = "space-definitions.json";
    protected static final String SPACE_DEFINITIONS_KEY = "spaceDefinitions";
    protected static final String NAME_KEY = "name";
    protected static final String SPACE_KEY_KEY = "key";
    protected static final String SPACE_TEMPLATE_KEY = "spaceTemplate";
    protected static final String DESCRIPTION_KEY = "description";
    protected static Map<String, SpaceDefinition> spaceDefinitions;

    public static SpaceDefinition getSpaceDefinition(Space aSpace) {
        return aSpace == null ? null : SpaceDefinitionSettings.getSpaceDefinitions().get(aSpace.getKey());
    }

    public static synchronized Map<String, SpaceDefinition> getSpaceDefinitions() {
        if (spaceDefinitions == null) {
            try {
                spaceDefinitions = SpaceDefinitionSettings.readSpaceTemplatesFromFile(SpaceDefinitionSettings.getSpaceDefinitionsFile());
            }
            catch (Exception ex) {
                if (SpaceDefinitionSettings.getSpaceDefinitionsFile().exists()) {
                    BrikitLog.logDebug("Failed to read space-definitions.json", ex);
                }
                spaceDefinitions = new HashMap<String, SpaceDefinition>();
            }
        }
        return spaceDefinitions;
    }

    public static File getSpaceDefinitionsFile() {
        return BrikitFile.getBrikitFile(SPACE_DEFINITIONS_FILENAME);
    }

    protected static Map<String, SpaceDefinition> readSpaceTemplatesFromFile(File aFile) throws Exception {
        String fileContents = BrikitFile.readFile(aFile);
        return SpaceDefinitionSettings.unpackSpaceDefinitions(fileContents);
    }

    public static void reset() {
        spaceDefinitions = null;
    }

    protected static Map<String, SpaceDefinition> unpackSpaceDefinitions(String json) throws Exception {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(json);
        JSONArray spaceDefinitionsJSON = (JSONArray)jsonObject.get((Object)SPACE_DEFINITIONS_KEY);
        HashMap<String, SpaceDefinition> definitions = new HashMap<String, SpaceDefinition>();
        for (Object object : spaceDefinitionsJSON) {
            JSONObject spaceDefinitionJSON = (JSONObject)object;
            String name = (String)spaceDefinitionJSON.get((Object)NAME_KEY);
            String key = (String)spaceDefinitionJSON.get((Object)SPACE_KEY_KEY);
            String description = (String)spaceDefinitionJSON.get((Object)DESCRIPTION_KEY);
            String category = (String)spaceDefinitionJSON.get((Object)SPACE_TEMPLATE_KEY);
            definitions.put(key, new SpaceDefinition(name, key, description, category));
        }
        return definitions;
    }

    public static synchronized void uploadSettings(File uploadedFile) throws Exception {
        SpaceDefinitionSettings.readSpaceTemplatesFromFile(uploadedFile);
        uploadedFile.renameTo(SpaceDefinitionSettings.getSpaceDefinitionsFile());
        SpaceDefinitionSettings.reset();
    }
}

