/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.rest;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.brikit.blueprintmaker.model.BlueprintPage;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.blueprintmaker.rest.AbstractBlueprintResource;
import com.brikit.blueprintmaker.rest.BlueprintBean;
import com.brikit.blueprintmaker.rest.BlueprintResourceModel;
import com.brikit.core.confluence.Confluence;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
public class BlueprintResource
extends AbstractBlueprintResource {
    protected final BlueprintManager blueprintManager;
    protected final ContentBlueprintManager contentBlueprintManager;

    public BlueprintResource(@ComponentImport BlueprintManager blueprintManager, @ComponentImport ContentBlueprintManager contentBlueprintManager) {
        this.blueprintManager = blueprintManager;
        this.contentBlueprintManager = contentBlueprintManager;
    }

    @PUT
    @Path(value="/copypage")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response copyPage(String jsonString) {
        BlueprintBean bean = new BlueprintBean(jsonString);
        if (this.noSourcePageFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Page to copy not found.");
        }
        if (this.noCreatePagePermissions(bean.getSpaceKey())) {
            return this.response(Response.Status.FORBIDDEN, "You don't have permission to create pages in the specified space.");
        }
        if (this.noDestinationSpaceFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Destination space not found.");
        }
        if (!this.noDestinationPageFound(bean)) {
            return this.response(Response.Status.FORBIDDEN, "Destination page already exists.");
        }
        Page parent = this.noDestinationParentPageFound(bean) ? Confluence.getParent((Page)bean.getSourcePage()) : bean.getDestinationParentPage();
        try {
            AbstractPage abstractPage = BlueprintPage.copyPage(bean.getSourcePage(), bean.getSpaceKey(), bean.getPageTitle(), parent);
            return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
        }
        catch (Exception ex) {
            return this.responseException("Copy page not successful.", ex);
        }
    }

    @PUT
    @Path(value="/copyspace")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response copySpace(String jsonString) {
        BlueprintBean bean = new BlueprintBean(jsonString);
        if (this.noSourceSpaceFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Space to copy not found.");
        }
        if (this.noCreateSpacePermissions()) {
            return this.response(Response.Status.FORBIDDEN, "You don't have permission to create spaces.");
        }
        if (!this.noDestinationSpaceFound(bean)) {
            return this.response(Response.Status.FORBIDDEN, "Destination space already exists.");
        }
        try {
            Space newSpace = SpaceBlueprint.createFromSpaceBlueprint("@copy-space", bean.getSourceSpaceKey(), bean.getSpaceName(), bean.getSpaceKey(), bean.getSpaceDescription(), bean.getValuesJson(), bean.getFileResources(), this.getBlueprintManager(), this.getContentBlueprintManager());
            Page abstractPage = Confluence.getSpaceHomePage(newSpace);
            return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
        }
        catch (Exception ex) {
            return this.responseException("Copy space not successful.", ex);
        }
    }

    @PUT
    @Path(value="/createpage")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response createPage(String jsonString) {
        BlueprintBean bean = new BlueprintBean(jsonString);
        if (this.noPageBlueprintFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Blueprint not found.");
        }
        if (this.noCreatePagePermissions(bean.getSpaceKey())) {
            return this.response(Response.Status.FORBIDDEN, "You don't have permission to create pages in the specified space.");
        }
        if (this.noDestinationSpaceFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Destination space not found.");
        }
        if (!this.noDestinationPageFound(bean)) {
            return this.response(Response.Status.FORBIDDEN, "Destination page already exists.");
        }
        try {
            AbstractPage abstractPage = BlueprintPage.createFromPageBlueprint(bean.getBlueprintName(), bean.getSpaceKey(), bean.getPageTitle(), bean.getDestinationParentPage(), bean.getValuesJson(), bean.getFileResources(), bean.getPageLabels());
            return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
        }
        catch (Exception ex) {
            return this.responseException("Create page not successful.", ex);
        }
    }

    @PUT
    @Path(value="/createspace")
    @Produces(value={"application/json", "application/xml"})
    @PublicApi
    public Response createSpace(String jsonString) {
        BlueprintBean bean = new BlueprintBean(jsonString);
        if (this.noCreateSpacePermissions()) {
            return this.response(Response.Status.FORBIDDEN, "You don't have permission to create spaces.");
        }
        if (!this.noDestinationSpaceFound(bean)) {
            return this.response(Response.Status.FORBIDDEN, "Destination space already exists.");
        }
        try {
            Space newSpace = SpaceBlueprint.createFromSpaceBlueprint(bean.getBlueprintName(), bean.getSourceSpaceKey(), bean.getSpaceName(), bean.getSpaceKey(), bean.getSpaceDescription(), bean.getValuesJson(), bean.getFileResources(), this.getBlueprintManager(), this.getContentBlueprintManager());
            Page abstractPage = Confluence.getSpaceHomePage(newSpace);
            return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
        }
        catch (Exception ex) {
            return this.responseException("Create space not successful.", ex);
        }
    }

    public BlueprintManager getBlueprintManager() {
        return this.blueprintManager;
    }

    public ContentBlueprintManager getContentBlueprintManager() {
        return this.contentBlueprintManager;
    }

    @POST
    @Path(value="/updatepage/{pageid}")
    @Produces(value={"application/json", "application/xml"})
    public Response updatePage(@PathParam(value="pageid") String pageId, String jsonString) {
        BlueprintBean bean = new BlueprintBean(jsonString);
        String newPageTitle = bean.getPageTitle();
        bean.setDestinationPage(pageId);
        if (this.noPageBlueprintFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Blueprint not found.");
        }
        if (this.noDestinationPageFound(bean)) {
            return this.response(Response.Status.NOT_FOUND, "Destination page not found.");
        }
        try {
            AbstractPage abstractPage = BlueprintPage.regeneratePageFromBlueprint(bean.getBlueprintName(), pageId, newPageTitle, bean.getValuesJson(), bean.getFileResources(), bean.getPageLabels());
            return Response.ok((Object)new BlueprintResourceModel(abstractPage.getId())).build();
        }
        catch (Exception ex) {
            return this.responseException("Update page not successful.", ex);
        }
    }
}

