AJS.toInit(function ($){
    const ACTION_GET_SETTING = "get";
    const ACTION_GET_DEFAULT_SETTING = "default";

    init();

    function init() {
        setupEditForm();
    }

    function setupEditForm() {
            // Update settings for this space
            AJS.$('#ehp-formSettings').on('aui-valid-submit', function(event) {
                event.preventDefault();
                updateSetting();
            });

        // Reset the settings to default values
        $("#ehp-buttonCopyWikiMacro").off("click").on("click", function(e) {
            e.preventDefault();

            console.log("clicking copy button...");

            // Define a list of fields with corresponding methods to get their values
            // Must use parameter names not field names (some of them are different)
            const fields = [
                { key: "selector", value: () => $("#field-selector").val() },
                { key: "headingIndent", value: () => $("#field-headingIndent").val() },
                { key: "expandOption", value: () => $("#field-expandCollapseOption").val() },
                { key: "titleExpandClickable", value: () => $("#field-titleExpandClickable").is(":checked") },
                { key: "useNavigation", value: () => $("#field-useNavigation").is(":checked") },
                { key: "useNavigationHiddenMode", value: () => $("#field-hideNavigation").is(":checked") ? "right-popup" : "right" },   //fixed wrong parameter name
                { key: "wrapNavigationText", value: () => $("#field-wrapNavigationText").is(":checked") },
                { key: "navigationTitle", value: () => $("#field-navigationTitle").val() },
                { key: "navigationTop", value: () => $("#field-navigationTop").val() },
                { key: "navigationWidth", value: () => $("#field-navigationWidth").val() },
                { key: "navigationIndent", value: () => $("#field-navigationIndent").val() }, // this was missed
                { key: "disableNavLinksUnder", value: () => $("#field-disableNavLinksUnder").val() },
                { key: "navigationExpandOption", value: () => $("#field-expandCollapseNavOption").val() },  //fixed wrong parameter name
                { key: "relatedLinksTitle", value: () => $("#field-relatedLinksTitle").val() },
                { key: "relatedLinksTarget", value: () => $("#field-relatedLinksTarget").val() },
                { key: "linkText1", value: () => $("#field-linkText1").val() },
                { key: "linkUrl1", value: () => $("#field-linkUrl1").val() },
                { key: "linkText2", value: () => $("#field-linkText2").val() },
                { key: "linkUrl2", value: () => $("#field-linkUrl2").val() },
                { key: "linkText3", value: () => $("#field-linkText3").val() },
                { key: "linkUrl3", value: () => $("#field-linkUrl3").val() },
                { key: "linkText4", value: () => $("#field-linkText4").val() },
                { key: "linkUrl4", value: () => $("#field-linkUrl4").val() },
                { key: "linkText5", value: () => $("#field-linkText5").val() },
                { key: "linkUrl5", value: () => $("#field-linkUrl5").val() },
                { key: "linkText6", value: () => $("#field-linkText6").val() },
                { key: "linkUrl6", value: () => $("#field-linkUrl6").val() },
                { key: "macrosTOCDisabled", value: () => $("#field-macrosTOCDisabled").val() },
                { key: "macrosToRemoveContainer", value: () => $("#field-macrosToRemoveContainer").val() }
            ];

            // Build wiki macro string, with ':' after macro name and '|' between parameters
            let wikiMacro = "{easy-heading-free:";
            const params = [];

            // Iterate over fields and add only those with non-empty values
            fields.forEach(field => {
                const val = field.value();
                if (val !== null && val !== undefined && val !== "") {
                    params.push(`${field.key}=${val}`);
                }
            });

            // Join all parameters with '|'
            wikiMacro += params.join("|");
            wikiMacro += "}";

            // Output to console and UI
            console.log("wikiMacro=", wikiMacro);
            $("#textWikiMacro").val(wikiMacro);

            AJS.dialog2("#dialog-copy").show();
        });

        $("#dialog-copy-button").off("click").on("click", function(e) {
            e.preventDefault();

            let macro = $("#textWikiMacro").val();
            console.log("get macro from textarea, ", macro);

            navigator.clipboard.writeText(macro).then(
                () => {
                    /* clipboard successfully set */
                },
                () => {
                    /* clipboard write failed */
                }
            );
        });

        // Reset the settings to default values
        $("#ehp-buttonResetSetting").off("click").on("click", function(e) {
            e.preventDefault();
            // Load default values without saving
            resetSetting();
        });
        }

    function updateSetting() {
        let url = AJS.contextPath() + "/plugins/servlet/easy-heading-macro/system-setting";
        let data = {
            action: ACTION_GET_SETTING,
            selector: $("#field-selector").val(),
            headingIndent: Number($("#field-headingIndent").val()),
            expandCollapseOption: $("#field-expandCollapseOption").val(),
            titleExpandClickable: $("#field-titleExpandClickable").is(":checked"),
            useNavigation: $("#field-useNavigation").is(":checked"),
            navigationMode: $("#field-hideNavigation").is(":checked") ? "right-popup" : "right",
            wrapNavigationText: $("#field-wrapNavigationText").is(":checked"),
            navigationTitle: $("#field-navigationTitle").val(),
            navigationTop: Number($("#field-navigationTop").val()),
            navigationWidth: Number($("#field-navigationWidth").val()),
            navigationIndent: Number($("#field-navigationIndent").val()),
            disableNavLinksUnder: Number($("#field-disableNavLinksUnder").val()),
            expandCollapseNavOption: $("#field-expandCollapseNavOption").val(),
            relatedLinksTitle: $("#field-relatedLinksTitle").val(),
            relatedLinksTarget: $("#field-relatedLinksTarget").val(),
            linkText1: $("#field-linkText1").val(),
            linkUrl1: $("#field-linkUrl1").val(),
            linkText2: $("#field-linkText2").val(),
            linkUrl2: $("#field-linkUrl2").val(),
            linkText3: $("#field-linkText3").val(),
            linkUrl3: $("#field-linkUrl3").val(),
            linkText4: $("#field-linkText4").val(),
            linkUrl4: $("#field-linkUrl4").val(),
            linkText5: $("#field-linkText5").val(),
            linkUrl5: $("#field-linkUrl5").val(),
            linkText6: $("#field-linkText6").val(),
            linkUrl6: $("#field-linkUrl6").val(),
            macrosTOCDisabled: $("#field-macrosTOCDisabled").val(),
            macrosToRemoveContainer: $("#field-macrosToRemoveContainer").val()
        };

        $.ajax({
            url: url,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            processData: false,
            success: function (data, textStatus, XMLHttpRequest) {
                loadSetting(data);
                showMessage("success", AJS.I18n.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.message-default-parameters-updated"));
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function resetSetting() {
        let url = AJS.contextPath() + "/plugins/servlet/easy-heading-macro/system-setting";
        let data = {
            action: ACTION_GET_DEFAULT_SETTING
        };

        $.ajax({
            url: url,
            type: "GET",
            data: data,
            success: function (data, textStatus, XMLHttpRequest) {
                loadSetting(data);
                forceFormValidation();
                $("#ehp-selectTemplate").val("none");
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    // Load the parameters to UI
    function loadSetting(setting) {
        // For Page
        $("#field-selector").val(setting.selector);
        $("#field-headingIndent").val(setting.headingIndent);
        $("#field-expandCollapseOption").val(setting.expandCollapseOption);

        // For Navigation
        $("#field-useNavigation").prop("checked", setting.useNavigation);
        $("#field-hideNavigation").prop("checked", setting.navigationMode == "right-popup");
        $("#field-wrapNavigationText").prop("checked", setting.wrapNavigationText);
        $("#field-navigationTitle").val(setting.navigationTitle);
        $("#field-navigationTop").val(setting.navigationTop);
        $("#field-navigationWidth").val(setting.navigationWidth);
        $("#field-navigationIndent").val(setting.navigationIndent);
        $("#field-disableNavLinksUnder").val(setting.disableNavLinksUnder);
        $("#field-expandCollapseNavOption").val(setting.expandCollapseNavOption);

        // For related links
        $("#field-relatedLinksTitle").val(setting.relatedLinksTitle);
        $("#field-relatedLinksTarget").val(setting.relatedLinksTarget);
        $("#field-linkText1").val(setting.linkText1);
        $("#field-linkUrl1").val(setting.linkUrl1);
        $("#field-linkText2").val(setting.linkText2);
        $("#field-linkUrl2").val(setting.linkUrl2);
        $("#field-linkText3").val(setting.linkText3);
        $("#field-linkUrl3").val(setting.linkUrl3);
        $("#field-linkText4").val(setting.linkText4);
        $("#field-linkUrl4").val(setting.linkUrl4);
        $("#field-linkText5").val(setting.linkText5);
        $("#field-linkUrl5").val(setting.linkUrl5);
        $("#field-linkText6").val(setting.linkText6);
        $("#field-linkUrl6").val(setting.linkUrl6);

        $("#field-macrosTOCDisabled").val(setting.macrosTOCDisabled);
        $("#field-macrosToRemoveContainer").val(setting.macrosToRemoveContainer);
    }

    function forceFormValidation() {
        // This is to remove the previous validation errors
        $("#ehp-formSettings").find("input,select").trigger("change");
    }

    // Common
    function showMessage(type, message) {
            AJS.flag({
                type: type,
                body: message,
                close: "auto"
            });
        }
});