/*
 * Decompiled with CFR 0.152.
 */
package com.binguo.confluence.headingfree.servlet;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.binguo.confluence.headingfree.service.MacroDataService;
import com.binguo.confluence.headingfree.servlet.MacroEditServlet;
import com.binguo.confluence.headingfree.viewmodel.DefaultParametersViewModel;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSettingServlet
extends HttpServlet {
    private static final String ACTION_GET_SETTING = "get";
    private static final String ACTION_GET_DEFAULT_SETTING = "default";
    private static final Logger log = LoggerFactory.getLogger(MacroEditServlet.class);
    private final I18nResolver i18nResolver;
    private final AccessModeService accessModeService;
    private final UserManager userManager;
    private final MacroDataService macroDataService;

    @Inject
    public SystemSettingServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport AccessModeService accessModeService, @ComponentImport UserManager userManager, MacroDataService macroDataService) {
        this.i18nResolver = i18nResolver;
        this.accessModeService = accessModeService;
        this.userManager = userManager;
        this.macroDataService = macroDataService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null || !this.userManager.isSystemAdmin(user.getUserKey()) && !this.userManager.isAdmin(user.getUserKey())) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-no-permission"));
            response.getWriter().flush();
            return;
        }
        String action = request.getParameter("action");
        try {
            if (action.equals(ACTION_GET_DEFAULT_SETTING)) {
                response.setContentType("application/json");
                DefaultParametersViewModel result = this.macroDataService.getDefaultDefaultParameters();
                JSONObject jsonObject = new JSONObject((Object)result);
                response.getWriter().write(jsonObject.toString());
            } else if (action.equals(ACTION_GET_SETTING)) {
                response.setContentType("application/json");
                DefaultParametersViewModel result = this.macroDataService.getDefaultParameters();
                JSONObject jsonObject = new JSONObject((Object)result);
                response.getWriter().write(jsonObject.toString());
            }
            response.setStatus(200);
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error("Error to fetch default parameters with DefaultParametersServlet", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null || !this.userManager.isSystemAdmin(user.getUserKey()) && !this.userManager.isAdmin(user.getUserKey())) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-no-permission"));
            response.getWriter().flush();
            return;
        }
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free..error-message-read-only-mode"));
            response.getWriter().flush();
            return;
        }
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            log.error("Error reading value from request with BufferedReader", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jb.toString());
        }
        catch (JSONException e) {
            log.error("Error extracting json object from StringBuffer", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-request-handle-failed"));
            response.getWriter().flush();
            return;
        }
        JSONObject jsonObjectResult = null;
        try {
            DefaultParametersViewModel defaultParameters = new DefaultParametersViewModel(jsonObject.getString("selector"), jsonObject.getInt("headingIndent"), jsonObject.getString("expandCollapseOption"), jsonObject.getBoolean("titleExpandClickable"), jsonObject.getBoolean("useNavigation"), jsonObject.getString("navigationMode"), jsonObject.getBoolean("wrapNavigationText"), jsonObject.getString("navigationTitle"), jsonObject.getInt("navigationTop"), jsonObject.getInt("navigationWidth"), jsonObject.getInt("navigationIndent"), jsonObject.getInt("disableNavLinksUnder"), jsonObject.getString("expandCollapseNavOption"), jsonObject.getString("relatedLinksTitle"), jsonObject.getString("relatedLinksTarget"), jsonObject.getString("linkText1"), jsonObject.getString("linkUrl1"), jsonObject.getString("linkText2"), jsonObject.getString("linkUrl2"), jsonObject.getString("linkText3"), jsonObject.getString("linkUrl3"), jsonObject.getString("linkText4"), jsonObject.getString("linkUrl4"), jsonObject.getString("linkText5"), jsonObject.getString("linkUrl5"), jsonObject.getString("linkText6"), jsonObject.getString("linkUrl6"), jsonObject.getString("macrosTOCDisabled"), jsonObject.getString("macrosToRemoveContainer"));
            DefaultParametersViewModel result = this.macroDataService.saveDefaultParameters(defaultParameters);
            jsonObjectResult = new JSONObject((Object)result);
        }
        catch (Exception e) {
            log.error("Error save default parameters", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
        response.setStatus(200);
        response.setContentType("application/json");
        response.getWriter().write(jsonObjectResult.toString());
        response.getWriter().close();
    }
}

