/*
 * Decompiled with CFR 0.152.
 */
package com.binguo.confluence.headingfree.migration;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.ContainerV1;
import com.atlassian.migration.app.PaginatedContainers;
import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.SiteContainerV1;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class MigrationListener
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(MigrationListener.class);
    private final Gson gson = new Gson();

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        log.info("Migration Listener triggered for Easy Heading Macro server app - transferId: {}, migrationDetails: {}", (Object)transferId, (Object)this.gson.toJson(migrationDetails));
    }

    public void onStartAppMigration_backup(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            log.info("Migration context summary: " + this.gson.toJson(migrationDetails));
            PaginatedMapping paginatedMapping = gateway.getPaginatedMapping(transferId, "confluence:page", 5);
            while (paginatedMapping.next()) {
                Map<String, String> mappings = paginatedMapping.getMapping();
                log.info("mappings = {}", (Object)this.gson.toJson(mappings));
            }
            gateway.getMappingById(transferId, "identity:user", Collections.singleton("email/admin@example.com"));
            PaginatedContainers paginatedSiteContainers = gateway.getPaginatedContainers(transferId, ContainerType.Site, 1);
            while (paginatedSiteContainers.next()) {
                List<ContainerV1> siteContainers = paginatedSiteContainers.getContainers();
                log.info("Site containers = {}", (Object)this.gson.toJson(siteContainers));
                for (ContainerV1 container : siteContainers) {
                    log.info("Site selections: " + String.valueOf(((SiteContainerV1)container).getSelections()));
                }
            }
            OutputStream firstDataStream = gateway.createAppData(transferId);
            firstDataStream.write("Your binary data goes here".getBytes());
            firstDataStream.close();
            OutputStream secondDataStream = gateway.createAppData(transferId, "some-optional-label");
            secondDataStream.write("more bytes".getBytes());
            secondDataStream.close();
            log.info("App data has been uploaded");
        }
        catch (IOException e) {
            log.error("Error while running the migration", (Throwable)e);
        }
    }

    @Override
    public String getServerAppKey() {
        return "com.binguo.confluence.headingfree.easy-heading-free";
    }

    @Override
    public String getCloudAppKey() {
        return "com.binguo.confluence.headingfree.easy-heading-free";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_UGC, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

