/*
 * Decompiled with CFR 0.152.
 */
package com.binguo.confluence.headingfree;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.binguo.confluence.headingfree.LicenseHelper;
import com.binguo.confluence.headingfree.MacroContentUpdateHelper;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EasyHeadingFree
extends BaseMacro
implements Macro {
    private final PageBuilderService pageBuilderService;
    private final I18nResolver i18nResolver;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final PluginLicenseManager pluginLicenseManager;

    @Autowired
    public EasyHeadingFree(@ComponentImport PageBuilderService pageBuilderService, @ComponentImport I18nResolver i18nResolver, @ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pageBuilderService = pageBuilderService;
        this.i18nResolver = i18nResolver;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        String licenseError;
        if (!EasyHeadingFree.isPdfOrWordExport(conversionContext)) {
            this.pageBuilderService.assembler().resources().requireWebResource("com.binguo.confluenceheading.easy-heading:easy-heading-resources");
        }
        licenseError = (licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver)) != null ? licenseError.trim() : "";
        return MacroContentUpdateHelper.ApplyMacroToBody(map, bodyContent, licenseError);
    }

    private static boolean isPdfOrWordExport(ConversionContext conversionContext) {
        String outputType = conversionContext.getOutputType();
        return "pdf".equals(outputType) || "word".equals(outputType);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)parameters, body, (ConversionContext)new DefaultConversionContext(renderContext));
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }
}

