/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.check;

import com.atlassian.migration.app.check.CheckStatus;
import com.atlassian.migration.app.check.CsvFileContent;
import java.util.Objects;

public class CheckResult {
    private final CheckStatus status;
    private final String stepsToResolveKey;
    private final CsvFileContent csvFileContent;

    public CheckResult(CheckStatus status) {
        this(status, "default", null);
    }

    public CheckResult(CheckStatus status, String stepsToResolveKey) {
        this(status, stepsToResolveKey, null);
    }

    public CheckResult(CheckStatus status, String stepsToResolveKey, CsvFileContent csvFileContent) {
        this.status = status;
        this.stepsToResolveKey = stepsToResolveKey;
        this.csvFileContent = csvFileContent;
    }

    public CheckStatus getStatus() {
        return this.status;
    }

    public String getStepsToResolveKey() {
        return this.stepsToResolveKey;
    }

    public CsvFileContent getCsvFileContent() {
        return this.csvFileContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CheckResult)) {
            return false;
        }
        CheckResult that = (CheckResult)o;
        return this.status == that.status && this.stepsToResolveKey.equals(that.stepsToResolveKey) && Objects.equals(this.csvFileContent, that.csvFileContent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.csvFileContent});
    }
}

