/*
 * Decompiled with CFR 0.152.
 */
package com.binguo.confluence.headingfree.servlet;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.webresource.api.WebResourceManager;
import com.binguo.confluence.headingfree.service.MacroDataService;
import com.binguo.confluence.headingfree.viewmodel.DefaultParametersViewModel;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUIServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdminUIServlet.class);
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final LoginUriProvider loginUriProvider;
    private final WebResourceManager webResourceManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final MacroDataService macroDataService;

    @Inject
    public AdminUIServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport WebResourceManager webResourceManager, @ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport PluginLicenseManager licenseManager, MacroDataService macroDataService) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.loginUriProvider = loginUriProvider;
        this.webResourceManager = webResourceManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.macroDataService = macroDataService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null || !this.userManager.isSystemAdmin(user.getUserKey()) && !this.userManager.isAdmin(user.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        this.webResourceManager.requireResourcesForContext("easy-heading-macro-system-admin");
        DefaultParametersViewModel defaultParametersViewModel = this.macroDataService.getDefaultParameters();
        HashMap<String, DefaultParametersViewModel> context = new HashMap<String, DefaultParametersViewModel>();
        context.put("setting", defaultParametersViewModel);
        String html = this.soyTemplateRenderer.render("com.binguo.confluence.headingfree.easy-heading-free:soy-templates", String.format("com.binguo.confluence.headingfree.templates.%s", "systemAdmin"), context);
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(html);
        response.getWriter().close();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

