define('com/ehpNavigationView/plugins', ['ajs', 'jquery'], function (AJS, $){
    "use strict";

    var NAVIGATION_MODE_LEFT = "left";
    var NAVIGATION_MODE_RIGHT = "right";
    var DEFAULT_NAV_WIDTH = 250;
    var MAX_WIDTH_NAVIGATION = 600;
    var MIN_WIDTH_NAVIGATION = 130;
    var SELECTOR_HEADINGS = "h1,h2,h3,h4,h5,h6";
    var SCROLLING_OFFSET_FIX = 20;
    var SCROLLING_ANIMATION_DURATION = 800;
    var SCROLL_HIGHLIGHT_OFFSET_FIX = 50;
    var NAV_PADDING_STEP = 16;

    var COOKIE_NAV_ENABLED = "easy-heading-pro.editor-nav-enabled";
    var COOKIE_NAV_WIDTH = "easy-heading-pro.editor-nav-width";
    var COOKIE_NAV_MODE = "easy-heading-pro.editor-nav-mode";
    var COOKIE_EXPIRE_DAYS = 720;

    var TIME_OUT_WHEN_HEADINGS_MORE_THAN = 80;  // Don't use setTimeout when there are less headings than this value
    var TIME_OUT_UPDATE_HEADING_LINES_NORMAL = 800;    // 0.8 seconds
    var TIME_OUT_UPDATE_HEADING_LINES_LARGE = 2000;    // 2 seconds
    var INTERVAL_UPDATE_INVITE_BUTTONS_POSITION = 500;
    var INTERVAL_RUN_MAX_COUNT_UPDATE_INVITE_BUTTONS_POSITION = 5;

    var editor;
    var paras;
    var navigationMode = NAVIGATION_MODE_RIGHT;
    var navigationEnabled = false;
    var mouseXPosition;
    var mouseIsDown = false;
    var timeoutForUpdate;   // Resolve the response slowness issue when chaning content
    var intervalForInviteButtons;
    var intervalRunCount = 0;
    var notSelectorMacros = ""; // not apply TOC to headings for macros

    //debug: calculate the time consuming to render the sidebar links
    var timeWatcher = Date.now();

    function toggleNavigation(doc, navMode, enabled) {
        //console.log("entering toggleNavigation, navMode=" + navMode + ", enabled=" + enabled);
        navigationMode = navMode;
        navigationEnabled = enabled;
        var navWidth = $("#ehpe-navigation").width();

        // Restore layout
        $("#ehpe-navigation").hide();
        $("#rte").css("width", "").css("float", "");
        $("#editor-precursor").css("left", "");
        $("#editor-precursor").css("margin-right", "");
        $("#editor-precursor").css("width", "");
        $("#inviteToEditLink").css("right", "");
        $("#avatar-list").css("right", "");
        $("#synchrony-presence-overlay").css("right", "");
        $("iframe#wysiwygTextarea_ifr").contents().find("body").css("margin-right", "");

        if (!navigationEnabled) {
            return;
        }

        if (navigationMode == NAVIGATION_MODE_LEFT) {
            $("#ehpe-drag-bar").css("left", "")
            $("#ehpe-drag-bar").css("right", "-17px")
            $("#ehpe-navigation").show();
            $("#ehpe-navigation").css("top", "").css("right", "");
            $("#rte").width($("#wysiwyg").width() - navWidth).css("float", "right");
            $("#editor-precursor").width($("#wysiwyg").width()-navWidth)
                .css("left", navWidth + "px");
            $("#macro-navigation-switcher").toggleClass("macro-nav-switcher-left", true)
                .toggleClass("macro-nav-switcher-right", false);

        } else if (navigationMode == NAVIGATION_MODE_RIGHT) {
            $("#ehpe-drag-bar").css("left", "-17px")
            $("#ehpe-drag-bar").css("right", "")
            $("#ehpe-navigation").show();
            var toolbarHeight = $("#rte-toolbar").height() + 8;
            $("#ehpe-navigation").css("top", toolbarHeight + "px").css("right", "20px");
            $("#editor-precursor").css("margin-right", (navWidth + 40) + "px");
            $("#editor-precursor").css("width", "auto");

            //console.log("#inviteToEditLink length: " + $("#inviteToEditLink").length);
            updatePositionForInviteButtons();
            $("iframe#wysiwygTextarea_ifr").contents().find("body").css("margin-right", (navWidth + 40) + "px");
            $("#macro-navigation-switcher").toggleClass("macro-nav-switcher-left", false)
                .toggleClass("macro-nav-switcher-right", true);
        }
    }

    function updateNavigationPosition() {
        // Update width for editor
        if ($("#ehpe-navigation").is(":visible")) {
            if (navigationMode == NAVIGATION_MODE_LEFT) {
                var navWidth = $("#ehpe-navigation").width();
                $("#rte").width($("#wysiwyg").width() - navWidth);
                $("#editor-precursor").width($("#wysiwyg").width() - navWidth)
                    .css("left", navWidth + "px");

            } else if (navigationMode == NAVIGATION_MODE_RIGHT) {
                var navWidth = $("#ehpe-navigation").width();
                $("#editor-precursor").css("margin-right", (navWidth + 20) + "px");
                $("#inviteToEditLink").css("right", (20 + navWidth + 20) + "px");
                $("#avatar-list").css("right", (70 + navWidth + 20) + "px");
                $("iframe#wysiwygTextarea_ifr").contents().find("body").css("margin-right", (navWidth + 20) + "px");
            }
        }

        // Update top for navigation
        var toolbarHeight = $("#rte-toolbar").height() + 7;
        $("#ehpe-navigation").css("top", toolbarHeight + "px");

        // Update height for navigation
        var navSidebarHeight = $("#editpageform, #createpageform").height() - toolbarHeight - $("#savebar-container").height();
        $("#ehpe-navigation").height(navSidebarHeight);
        $("#ehpe-drag-bar").height(navSidebarHeight);

        var navLinkContainerHeight = navSidebarHeight - $("#ehpe-navigation-title").height() - 20;
        $("#ehpe-nav-container").height(navLinkContainerHeight);
    }

    function updatePositionForInviteButtons() {
        intervalForInviteButtons = setInterval(function(){
            intervalRunCount = intervalRunCount + 1;
            //console.log("intervalRunCount=" + intervalRunCount);
            if (intervalRunCount > INTERVAL_RUN_MAX_COUNT_UPDATE_INVITE_BUTTONS_POSITION) {
                clearInterval(intervalForInviteButtons);
                intervalRunCount = 0;
                return;
            }

            if ($("#inviteToEditLink").length < 0) return;

            if (navigationMode == NAVIGATION_MODE_RIGHT && $("#ehpe-navigation").is(":visible")) {
                var navWidth = $("#ehpe-navigation").width();
                $("#inviteToEditLink").css("right", (20 + navWidth + 20) + "px");
                $("#avatar-list").css("right", (70 + navWidth + 20) + "px");
                $("#synchrony-presence-overlay").css("right", (70 + navWidth + 20) + "px");
            }

            clearInterval(intervalForInviteButtons);
            intervalRunCount = 0;
        }, INTERVAL_UPDATE_INVITE_BUTTONS_POSITION);
    }

    function createNavigationContainer(doc) {
        var nav = $('<div id="ehpe-navigation" style="display:none;">'
            + '<div id="ehpe-navigation-title">Navigation</div>'
            + '<div id="ehpe-drag-bar"><i class="fas fa-grip-lines-vertical editor-nav-drag-button"></i></div>'
            + '<div id="ehpe-nav-container"><ul id="ehpe-navigation-list"></ul></div>'
            + '<i id="macro-navigation-switcher" class="fas fa-lg fa-window-maximize nav-switcher macro-nav-switcher-left"></i>'
            + '</div>');

        // Load user settings from cookie data
        nav.width(paras.navigationEditWidth).appendTo($("#wysiwyg"));
    }

    function updateHeadingExpandButtons() {
        $("#ehpe-navigation-list>li").each(function(index){
            var isParentNode = false;
            var nextLink = $(this).next();
            if (nextLink.length > 0) {
                isParentNode = Number($(nextLink).css("padding-left").replace("px","")) > Number($(this).css("padding-left").replace("px",""));
            }
            $(this).find("i").remove();
            if (isParentNode) {
                $('<i class="fas fa-xs fa-chevron-down nav-arrow"></i>').prependTo($(this));
            } else {
                $('<span class="nav-empty"></span>').prependTo($(this));
            }
        });

        $("#ehpe-navigation-list .nav-arrow").off("click").on("click", function(){
            event.preventDefault();

            // Expand/Collapse sub headings
            $(this).toggleClass("fa-chevron-right").toggleClass("fa-chevron-down");

            // Show/Hide sub headings
            var number = $(this).parent().attr("id").replace("number","");
            $("#ehpe-navigation-list [id^='number" + number + "']:not(#number" + number + ")").each(function(){
                var num = $(this).attr("id").replace("number","");
                var visible = true;

                while(num.match(/\d{1,3}-$/g) != null && num.match(/\d{1,3}-$/g).length > 0) {
                    num = num.replace(/\d{1,3}-$/g, "");
                    var parentNode = $("#number" + num);
                    if (parentNode.length == 0) break;

                    visible = parentNode.find("i.nav-arrow").hasClass("fa-chevron-down");
                    if (!visible) break;
                }
                $(this).toggle(visible);
            });
        });
    }

    function callUpdateHeadingLinks(doc) {
        debugWatcher("callUpdateHeadingLinks, #ehpe-nav-container>ul>li length=" + $("#ehpe-nav-container>ul>li").length + ", heading count=" + doc.find(SELECTOR_HEADINGS).not(notSelectorMacros).length);

        // For this first time of creating the navigation don't use timeout
        if ($("#ehpe-nav-container>ul>li").length == 0) {
            updateHeadingLinks(doc);
            highlightCurrentHeading(doc);
            return;
        }

        if (!$("#ehpe-navigation").is(":visible")) {
            return;
        }

        // Use timer to update to avoid stopping user to type by continuous useless updates
        var headingCount = doc.find(SELECTOR_HEADINGS).not(notSelectorMacros).length;
        clearTimeout(timeoutForUpdate);

        var timing = headingCount > TIME_OUT_WHEN_HEADINGS_MORE_THAN ? TIME_OUT_UPDATE_HEADING_LINES_LARGE : TIME_OUT_UPDATE_HEADING_LINES_NORMAL;
        timeoutForUpdate = setTimeout(function(){
            updateHeadingLinks(doc);
            highlightCurrentHeading(doc);
        }, timing);
    }

    function updateHeadingLinks(doc) {
        // Create and update links
        var linksContainer = $("#ehpe-navigation-list");
        var headings = doc.find(SELECTOR_HEADINGS).not(notSelectorMacros).filter(function(){
            return $(this).text().trim() != "";
        });

        // Remove the redundant navigation links
        if (headings.length == 0) {
            $("#ehpe-navigation-list>li").remove();

            $("<li style='margin-bottom:8px'>Create an interactive outline of your document with Headings.</li>").appendTo(linksContainer);
            $("<li>Click the Navigation View icon in editor toolbar to open/close this sidebar. </li>").appendTo(linksContainer);
            return;
        } else {
            $("#ehpe-navigation-list>li:gt(" + (headings.length - 1) + ")").remove();
        }

        var layers = [];
        var preLevel = 0;
        var numbers = [];
        var preNumber = 1;
        for (var i=0; i<headings.length; i++) {
            var level = parseInt(headings.eq(i)[0].nodeName.substring(1), 10);
            var preLevel = 0;
            var preNumber = 1;
            if (layers.length > 0) {
                preLevel = layers[layers.length-1];
                preNumber = numbers[numbers.length-1];
            }

            //console.log("i = " + i + ", level = " + level + ", preLevel = " + preLevel + ", preNumber = " + preNumber + ", text = " + headings.eq(i).text());

            if (level == preLevel) {
                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            } else if (level > preLevel) {
                layers.push(level);
                numbers.push(1);
            } else if (level < preLevel) {
                // reduce indent
                while (level < preLevel && layers.length > 0) {
                    layers.pop();

                    if (layers.length == 0) {
                        preLevel = 0;
                    } else {
                        preLevel = layers[layers.length-1];
                    }

                    if (level > preLevel) {
                        layers.push(level);
                    } else {
                        numbers.pop();
                    }
                }

                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            }

            //console.log("layers and numbers:");
            //console.log(layers);
            //console.log(numbers);

            var linkId = "number" + numbers.join("-") + "-";
            var padding = NAV_PADDING_STEP * (layers.length-1);
            var link = $("<li id='" + linkId + "' class='nav-link-nowrap' style='padding-left: "
                + padding + "px;'><a href='#'>" + htmlEncode(headings.eq(i).text()) + "</a></li>");
            link.find("a").on("click", function(e){
                e.preventDefault();
                var heading = doc.find(SELECTOR_HEADINGS).not(notSelectorMacros)
                    .filter(function(){
                        return $(this).text().trim() != "";
                    })
                    .eq($(this).parent().index());
                doc.find("html, body").stop().animate({ scrollTop: heading.offset().top - SCROLLING_OFFSET_FIX }, SCROLLING_ANIMATION_DURATION);
            });

            // Update the link or create a new link
            var existingLink = linksContainer.find("li").eq(i);
            if (existingLink.length > 0) {
                existingLink.replaceWith(link);
            } else {
                link.appendTo(linksContainer);
            }
        }

        // Update expanding/collapsing buttons
        updateHeadingExpandButtons();
    }

    function bindDragEventForNavigation() {
        // Dragging to resize
        var dragBar = document.getElementById('ehpe-drag-bar');
        dragBar.addEventListener('mousedown', function(event) {
            event.preventDefault();
            mouseIsDown = true;
            mouseXPosition = event.clientX;
            $("#wysiwygTextarea_ifr").css("pointer-events", "none");
        }, true);

        document.addEventListener('mouseup', function() {
            mouseIsDown = false;
            $("#wysiwygTextarea_ifr").css("pointer-events", "inherit");
        }, true);

        document.addEventListener('mousemove', function(event) {
            if ($("#ehpe-navigation").length == 0) return;

            var xOffset = navigationMode == NAVIGATION_MODE_LEFT ? event.clientX - mouseXPosition : mouseXPosition - event.clientX;
            var navigationWidth = $("#ehpe-navigation").width();
            var canDragRight = xOffset > 0 && navigationWidth < MAX_WIDTH_NAVIGATION;
            var canDragLeft = xOffset < 0 && navigationWidth > MIN_WIDTH_NAVIGATION;
            if (mouseIsDown && (canDragRight || canDragLeft)) {
                mouseXPosition = event.clientX;
                resizeNavigation(xOffset);
            }

            // Save the mode to cookie so that it remembers this for user
            setCookie(COOKIE_NAV_WIDTH, "" + navigationWidth, COOKIE_EXPIRE_DAYS);
        }, true);
    }

    function bindSwicherEventForNavigation(doc) {
        $("#macro-navigation-switcher").click(function(event) {
            event.preventDefault();

            navigationMode = navigationMode == NAVIGATION_MODE_LEFT ? NAVIGATION_MODE_RIGHT : NAVIGATION_MODE_LEFT;
            // Save the mode to cookie so that it remembers this for user
            var cookieNavigationMode = navigationMode;
            setCookie(COOKIE_NAV_MODE, cookieNavigationMode, COOKIE_EXPIRE_DAYS);

            // Update navigation with selected mode
            toggleNavigation(doc, navigationMode, true);
            updateNavigationPosition();
        });

        // Hover on the switcher button
        $("#macro-navigation-switcher").hover(function(event) {
            $(this).toggleClass("nav-switcher-hover", true).toggleClass("nav-switcher", false);
        }, function(event) {
            $(this).toggleClass("nav-switcher", true).toggleClass("nav-switcher-hover", false);
        });
    }

    function resizeNavigation(xOffset) {
        $("#ehpe-navigation").width($("#ehpe-navigation").width() + xOffset);
        updateNavigationPosition();
    }

    function highlightCurrentHeading(doc) {
        var headers = doc.find(SELECTOR_HEADINGS).not(notSelectorMacros).filter(function(){
                return $(this).text().trim() != "";
            });

        var viewPosition = doc.scrollTop() + SCROLL_HIGHLIGHT_OFFSET_FIX;
        var index = 0;
        var contentBottom = doc.find("body").height();
        for (i = 0; i<headers.length; i++) {
            var prev = headers.eq(i).offset().top;
            var next = i < headers.length-1 ? headers.eq(i+1).offset().top : contentBottom + 99999;
            //console.log("prev=" + prev + ", next=" + next);
            if (viewPosition >= prev && viewPosition < next) {
                index = i;
                break;
            }
        }

        // highlight the current heading
        var targetLink = $("#ehpe-navigation-list").find("a:eq(" + index + ")");
        if (!targetLink.hasClass("ehpe-highlight")) {
            $(".ehpe-highlight").removeClass("ehpe-highlight");
            targetLink.addClass("ehpe-highlight");
        }
    }

    function setCookie(cname, cvalue, exdays) {
      var d = new Date();
      d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
      var expires = "expires="+d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function getCookie(cname) {
      var name = cname + "=";
      var ca = document.cookie.split(';');
      for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
          c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
          return c.substring(name.length, c.length);
        }
      }
      return "";
    }

    function getToolbarIconName() {
        var arry = AJS.version.split(".");
        var majorVersion = parseInt(arry[0]);
        var minorVersion = parseInt(arry[1]);
        if (majorVersion >= 6 && minorVersion >= 7) {
            return "aui-icon aui-icon-small aui-iconfont-table-of-contents";
        } else {
            return "aui-icon aui-icon-small aui-iconfont-editor-macro-toc";
        }
    }

    function bindContentChangeEvents(ed) {
        ed.onKeyPress.add(function(ed, e){
            clearTimeout(timeoutForUpdate);
        });

        ed.onChange.add(function(ed, e) {
            debugWatcher("ed.onChange triggered");

            callUpdateHeadingLinks($(ed.contentDocument));
        });

        AJS.bind("editor.remote.change", function(e) {
            debugWatcher("editor.remote.change triggered");

            callUpdateHeadingLinks($(ed.contentDocument));
        });

    }

    function bindWindowSizeChangeEvents() {
        $(window).resize(function(e){
          updateNavigationPosition();
        });

        var editor = document.getElementById('rte');
        new ResizeSensor(editor, function() {
            updateNavigationPosition();
        });
    }

    function setUpToolbar(ed) {
        // create new group
        $("#rte-toolbar .toolbar-primary").append($("<ul class='aui-buttons'></ul>")
            .addClass("rte-toolbar-group-navigation"));

        ed.addCommand('mceNavigationView', function() {
            //console.log(paras);

            var enabled = $("#ehpe-navigation").is(":visible");

            if (!enabled && paras.licenseError != null) {
                alert(paras.licenseError);
                return;
            }

            toggleNavigation($(ed.contentDocument), navigationMode, !enabled);
            callUpdateHeadingLinks($(ed.contentDocument));
            setCookie(COOKIE_NAV_ENABLED, (!enabled).toString().toLowerCase(), COOKIE_EXPIRE_DAYS);
        });

        // Register button in a new group
        ed.addButton('confluence-example-button', {
            //default value of "toolbar" is "toolbar-primary"
            title: "",
            tooltip: "Navigation View",
            cmd: "mceNavigationView",
            className: "navigationView",
            icon: getToolbarIconName(),
            locationGroup: "rte-toolbar-group-navigation",
            weight: 0
        });
    }

    function getParameters(ed) {
        if (paras != null) return;

        // Default setting values
        paras = {
            enable: true,
            navigationEditMode: NAVIGATION_MODE_RIGHT,
            navigationEditWidth: 250,
            macrosTOCDisabled: ""
        };

        // Load settings from cookies
        paras = loadUserCookieData(paras);

        debugWatcher("getParameters");
        init(ed);
    }

    function loadUserCookieData(paras) {
        var navEnabledCookie = getCookie(COOKIE_NAV_ENABLED);
        if (navEnabledCookie != null && navEnabledCookie != "") {
            paras.enabled = navEnabledCookie == "true";
        }

        var navModeCookie = getCookie(COOKIE_NAV_MODE);
        if (navModeCookie != null && navModeCookie != "") {
            paras.navigationEditMode = navModeCookie;
        }

        paras.navigationEditWidth = DEFAULT_NAV_WIDTH;
        var navWidthCookie = Number(getCookie(COOKIE_NAV_WIDTH));
        if (navWidthCookie != null && navWidthCookie != "") {
            paras.navigationEditWidth = navWidthCookie;
        }
        return paras;
    }


    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }

    // Encode to resolve XSS vulnerability
    function htmlEncode(str) {
        return Array.from(str).map(c => {
            const code = c.codePointAt(0);
            return code > 127 ? `&#${code};` : c;
        }).join('');
    }

    function init(ed) {
        debugWatcher("start-init");
        if (paras.licenseError != null) {
            showMessage("error", paras.licenseError);
            return;
        }

        // Only work for Create/Edit Page
        if ($('#editpageform, #createpageform').length == 0) {
            return;
        }
        if ($('form.editor>div#wysiwyg>div#rte').length == 0) {
            return;
        }

        // Do not apply this plugin to inside of the specified macros
        notSelectorMacros = getSelectorByMacroNames(paras.macrosTOCDisabled, SELECTOR_HEADINGS);

        debugWatcher("getSelectorByMacroNames");

        // Create navigation sidebar and bind events
        createNavigationContainer($(ed.contentDocument));
        debugWatcher("createNavigationContainer");

        updateNavigationPosition();
        debugWatcher("updateNavigationPosition");

        bindDragEventForNavigation();
        debugWatcher("bindDragEventForNavigation");

        bindSwicherEventForNavigation($(ed.contentDocument));
        bindContentChangeEvents(ed);
        bindWindowSizeChangeEvents();
        debugWatcher("bindWindowSizeChangeEvents");

        toggleNavigation($(ed.contentDocument), paras.navigationEditMode, paras.enabled);
        $(ed.getWin()).bind('scroll', function(e){
            //console.log('Editor window scrolled!');
            highlightCurrentHeading($(e.target));
        });

        // Display or hide navigation sidebar
        toggleNavigation($(ed.contentDocument), paras.navigationEditMode, paras.enabled);
        if (paras.enabled) {
            callUpdateHeadingLinks($(ed.contentDocument));
        }
        debugWatcher("end");
    }

    function getSelectorByMacroNames(macroNames, headingSelectors) {
        var names = macroNames.replace(/[&\/\\\s\|\[\];+()$~%.:*?<>{}#@!="'`^]/g, '');
        var headingSelectors = headingSelectors.replace(/[&\/\\\s\|\[\];+()$~%.:*?<>{}#@!="'`^]/g, '');
        if (names == "") return "";

        var selector = "";
        var arryNames = names.split(",");
        var arryHeadingSelectors = headingSelectors.split(",");
        for (var i=0; i<arryNames.length; i++) {
            for (var j=0; j<arryHeadingSelectors.length; j++) {
                if (selector != "") selector = selector + ",";
                selector = selector + ".wysiwyg-macro[data-macro-name='"+ arryNames[i] +"'] " + arryHeadingSelectors[j];
            }
        }
        return selector;
    }

    function debugWatcher(process) {
        var currentTime = Date.now();
        var elapsedTime = (currentTime - timeWatcher) / 1000;
        timeWatcher = currentTime;
        //console.log("Elapsed time for " + process + ": " + elapsedTime);
    }

    function plugin() {
        return {
            init : function(ed) {
                debugWatcher("begin");

                editor = ed;
                AJS.bind("init.rte", function(){
                    debugWatcher("init.rte triggered");
                    getParameters(ed);
                });
                setUpToolbar(ed);

            },
            getInfo : function() {
                //console.log("tinymce version: " + tinymce.majorVersion + "." + tinymce.minorVersion);
                return {
                    longname : 'ehpNavigationView',
                    author : 'Shinetech Software',
                    authorurl : 'https://www.shinetechsoftware.com',
                    version : tinymce.majorVersion + "." + tinymce.minorVersion
                };
            }
        }
    }

    return plugin;
});

require('confluence/module-exporter')
    .safeRequire('com/ehpNavigationView/plugins', function(MyPlugin) {
        var tinymce = require('tinymce');
        //console.log("> tinymce version: " + tinymce.majorVersion + "." + tinymce.minorVersion);

        // Register plugin
        tinymce.PluginManager.add('ehpNavigationView', MyPlugin);

        require('confluence-editor/loader/tinymce-bootstrap').addTinyMcePluginInit(function(settings) {
            settings.plugins += ",ehpNavigationView";
        });
    });
