/*
 * Decompiled with CFR 0.152.
 */
package com.binguo.confluence.headingfree.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.binguo.confluence.headingfree.service.MacroDataService;
import com.binguo.confluence.headingfree.viewmodel.DefaultParametersViewModel;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUIServlet
extends HttpServlet {
    private final String TEMPLATE_SYSTEM_ADMIN = "templates/system-admin-macro.vm";
    private static final Logger log = LoggerFactory.getLogger(AdminUIServlet.class);
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final MacroDataService macroDataService;

    @Inject
    public AdminUIServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport PluginLicenseManager licenseManager, MacroDataService macroDataService) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.macroDataService = macroDataService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null || !this.userManager.isSystemAdmin(user.getUserKey()) && !this.userManager.isAdmin(user.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        DefaultParametersViewModel defaultParametersViewModel = this.macroDataService.getDefaultParameters();
        Map context = MacroUtils.defaultVelocityContext();
        context.put("setting", defaultParametersViewModel);
        String html = VelocityUtils.getRenderedTemplate((String)"templates/system-admin-macro.vm", (Map)context);
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(html);
        response.getWriter().close();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

