AJS.toInit(function(){
    let apiCalled = false;
    let defaultParas = null;

    AJS.bind("init.rte", function(){
        $(document).ajaxComplete(function() {
            init();
        });
    });

    function init() {
        if( AJS.$("table[data-macro-name = 'easy-heading-free']")){
            // Must verify that the MacroBrowser is available to prevent errors
            if (AJS.MacroBrowser) {
                if ($('#editpageform, #createpageform').length > 0) {
                    getDefaultParameters();
                } else {
                    hideEditedFlag();
                }
            }
        }
    }

    function hideEditedFlag() {
        AJS.MacroBrowser.setMacroJsOverride("easy-heading-free", {
            fields: {
                string: {
                    "hiddenEditedFlag": function (param) {
                        let parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, {});
                        if (!parameterField.getValue() || parameterField.getValue() == "") {
                            parameterField.setValue("false");
                        }
                        return parameterField;
                    }
                }
            }
        });
    }

    function getDefaultParameters() {
        if (apiCalled) return;

        apiCalled = true;
        let url = AJS.contextPath() + "/plugins/servlet/easy-heading-macro/macro-edit";

        $.ajax({
            url: url,
            type: "GET",
            success: function (data, textStatus, XMLHttpRequest) {
                defaultParas = data;
                applyDefaultParameters();
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showMessage("error", jqXHR.responseText);
            }
        });
    }

    function applyDefaultParameters() {
        //override command that selectes the ds macro and the field/s selected
        AJS.MacroBrowser.setMacroJsOverride("easy-heading-free", {
            fields: {
                string: {
                    "hiddenEditedFlag": function (param) {
                        let parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, {});
                        if (!parameterField.getValue() || parameterField.getValue() == "") {
                            parameterField.setValue("false");
                        }
                        return parameterField;
                    }
                }
            },

            beforeParamsSet : function (params) {
                if (AJS.MacroBrowser.settings.mode != "insert") {
                    return params;
                }

                // Only for new macro we load the default parameters
                return updateParameterValues(params, defaultParas);
            }
        });
    }

    function updateParameterValues(params, defaultParas) {
        params.selector = defaultParas.selector;
        params.headingIndent = defaultParas.headingIndent;
        params.expandOption = defaultParas.expandCollapseOption;
        params.titleExpandClickable = defaultParas.titleExpandClickable;
        params.useNavigation = defaultParas.useNavigation;
        params.useNavigationHiddenMode = defaultParas.navigationMode == "right-popup";
        params.wrapNavigationText = defaultParas.wrapNavigationText;
        params.navigationTitle = defaultParas.navigationTitle;
        params.navigationTop = defaultParas.navigationTop;
        params.navigationWidth = defaultParas.navigationWidth;
        params.navigationIndent = defaultParas.navigationIndent;
        params.disableNavLinksUnder = defaultParas.disableNavLinksUnder;
        params.navigationExpandOption = defaultParas.expandCollapseNavOption;

        params.relatedLinksTitle = defaultParas.relatedLinksTitle;
        params.relatedLinksTarget = defaultParas.relatedLinksTarget;
        params.linkText1 = defaultParas.linkText1;
        params.linkUrl1 = defaultParas.linkUrl1;
        params.linkText2 = defaultParas.linkText2;
        params.linkUrl2 = defaultParas.linkUrl2;
        params.linkText3 = defaultParas.linkText3;
        params.linkUrl3 = defaultParas.linkUrl3;
        params.linkText4 = defaultParas.linkText4;
        params.linkUrl4 = defaultParas.linkUrl4;
        params.linkText5 = defaultParas.linkText5;
        params.linkUrl5 = defaultParas.linkUrl5;
        params.linkText6 = defaultParas.linkText6;
        params.linkUrl6 = defaultParas.linkUrl6;

        params.macrosTOCDisabled = defaultParas.macrosTOCDisabled;
        params.macrosToRemoveContainer = defaultParas.macrosToRemoveContainer;

        // Set flag to indicate the macro has been edited once
        params.hiddenEditedFlag = "true";

        return params;
    }

    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }
});