/*
 * Decompiled with CFR 0.152.
 */
package com.binguo.confluence.headingfree.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.binguo.confluence.headingfree.service.MacroDataService;
import com.binguo.confluence.headingfree.viewmodel.DefaultParametersViewModel;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroEditServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MacroEditServlet.class);
    private final I18nResolver i18nResolver;
    private final MacroDataService macroDataService;

    @Inject
    public MacroEditServlet(@ComponentImport I18nResolver i18nResolver, MacroDataService macroDataService) {
        this.i18nResolver = i18nResolver;
        this.macroDataService = macroDataService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || currentUser.getKey().getStringValue().isEmpty()) {
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-not-authenticated"));
            response.getWriter().flush();
        }
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            DefaultParametersViewModel result = this.macroDataService.getDefaultParameters();
            JSONObject jsonObject = new JSONObject((Object)result);
            response.getWriter().write(jsonObject.toString());
            response.getWriter().close();
        }
        catch (Exception e) {
            log.error("Error to fetch default parameters with DefaultParametersServlet", (Throwable)e);
            response.setStatus(400);
            response.getWriter().print(this.i18nResolver.getText("com.binguo.confluence.headingfree.easy-heading-free.easy-heading-free.error-message-request-handle-failed"));
            response.getWriter().flush();
        }
    }
}

