AJS.toInit(function(){
    const MAX_WIDTH_NAVIGATION = 600;
    const MIN_WIDTH_NAVIGATION = 40;
    const SCROLLING_OFFSET_FIX = 100;
    const SCROLLING_ANIMATION_DURATION = 800;
    const SCROLLING_EXPAND_WAIT_TIME = 500;
    const OFFSET_NAV_TO_TOP = 90;
    const OFFSET_NAV_TOP_FIX = 30;
    const OFFSET_NAV_TO_BOTTOM = 80;
    const OFFSET_NAV_TO_CONTENT = 10;
    const WIDTH_NAV_DRAG_BAR = 25;
    const OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV = 36;
    const EMPTY_SELECTOR_HEADERS = "h1,h2,h3,h4,h5,h6";
    const SELECTOR_MAIN = "#main";
    const SELECTOR_CONTENT = "#content";
    const SELECTOR_BODY = "#main-content";
    const SELECTOR_MACRO = ".easy-heading-free";
    const SELECTOR_NAV_WRAPPER = "#ehp-navigation-wrapper";
    const SELECTOR_NAV_CONTENT = "#ehp-navigation-content";
    const SELECTOR_NAV_LIST = "#ehp-navigation-list";

    let notSelectorMacros = ""; // not apply TOC to headings for macros

    let paras;
    let mouseXPosition;
    let mouseIsDown = false;
    let navigationCreated = false;
    let navigationWidth =  0;
    let useNavigationHiddenMode = false;
    let originalContentPaddingRight = 0;

    // For scrolling by Url
    const TIME_LAPSE_NO_CHANGE_MAX = 700;
    const TIME_LAPSE_USER_STOP_DUE = 2000;
    let intervalForScroll;
    let timeLapse = 0;
    let timeLapseNoChange = 0;
    let timeStep = 100;
    let prevScrollHeight = 0;

    AJS.populateParameters();

    if (initAddon()) {
        applyAddonForPage();
        applyAddonForSidebar();
        handleHeadingByUrl();
    }

    function isProInstalled() {
        return $("#page-menu-easy-heading-pro-link").length > 0;
    }

    function initAddon() {
        setupStyle();

        // Use parameters of the first macro if there are multiple
        paras = getMacroParameters();
        if (!paras.enabled) return false;

        // Check license
        if (paras.licenseError.length > 0) {
            showMessage("error", paras.licenseError);
            return false;
        }

        // Integrate with Pro version
        if (isProInstalled()) {
            console.log("the macro will be enabled because it has higher PRI than pro plugin");
            $("head>#eh-style").remove();
        }

        // Apply to all headings if none defined
        if (paras.selector == null || paras.selector.trim() == "") {
            paras.selector = EMPTY_SELECTOR_HEADERS;
        }

        // Workaround: Do not apply this plugin to headings inside the specified macros
        notSelectorMacros = getSelectorByMacroNames(paras.macrosTOCDisabled, paras.selector);

        // Workaround: Remove containers for specified special macros to avoid conflicts
        let macroNames = paras.macrosToRemoveContainer.split(",");
        macroNames.forEach(removeMacroContainer);

        return true;
    }

    function applyAddonForPage() {
        // Update block to all headings
        $(SELECTOR_BODY).find(paras.selector).not(notSelectorMacros).each(function(){
            processHeadings($(this), paras);
        });

        if (paras.enableExpandCollapse) {
            bindHeadingExpandEvent();
        }
    }

    function applyAddonForSidebar() {
        let headings = $(SELECTOR_BODY).find(paras.selector).not(notSelectorMacros).filter(function(){
            return $(this).text() && $(this).text().trim() != "";
        });

        // Only enable sidebar when it satisfy the parameter
        if (headings.length < paras.disableNavLinksUnder) {
            return false;
        }

        // It will only use the paras of the first macro block for navigation set up
        navigationCreated = createNavigation(headings, paras);

        //console.log("navigationCreated = " + navigationCreated);
        if (navigationCreated) {
            bindDragEventForNavigation();
            bindWidthChangeForNavigation();
            bindSwicherEventForNavigation();
            bindLinkEventForNavigation();

            // Highlight current heading in navigation bar
            updateNavigationPosition();
            highlightCurrentHeading();
            $(document).on("scroll", function(event){
                updateNavigationPosition();
                highlightCurrentHeading();
            });

            bindAnchorLinks();
        }
    }

    function handleHeadingByUrl() {
        let targetId = decodeURI(location.hash).replace("#", "");
        if (targetId == "") return;

        $(window).scrollTop();
        intervalForScroll = setInterval(function(){
            let scrollHeight = document.body.scrollHeight;
            if (prevScrollHeight != scrollHeight) {
                prevScrollHeight = scrollHeight;
                timeLapseNoChange = 0;
            }
            timeLapse = timeLapse + timeStep;
            timeLapseNoChange = timeLapseNoChange + timeStep;

            //console.log("scrollHeight=" + scrollHeight + ", timeLapseNoChange=" + timeLapseNoChange + ", timeLapse=" + timeLapse);
            if (timeLapseNoChange >= TIME_LAPSE_NO_CHANGE_MAX) {
                clearInterval(intervalForScroll);
                navigateToHeading(targetId);
            }

        }, timeStep);

        // Cancel scrolling if user starts scrolling with mousewheel (not able to detect dragging scrollbar by user)
        $("html, body").bind('mousewheel DOMMouseScroll onmousewheel touchmove', function(){
            if (timeLapse >= TIME_LAPSE_USER_STOP_DUE) {
                clearInterval(intervalForScroll);
            }
        });
    }

    function setupStyle() {
        if ($("head>#eh-style").length > 0) {
            return;
        }

        // Move the style from the first macro to header
        let macroBlock = $(SELECTOR_MAIN + " " + SELECTOR_MACRO + ":eq(0)");
        let style = macroBlock.find(">style").html();
        $("head").append('<style id="eh-style" type="text/css">' + style + '</style>');

        // Remove style for all macros on the page
        $(SELECTOR_MAIN + " " + SELECTOR_MACRO + ">style").remove();
    }

    function getMacroParameters() {
        let macroBlock = $(SELECTOR_MAIN + " " + SELECTOR_MACRO + ":eq(0)");
        let parameters = {
            licenseError : htmlEncode(macroBlock.find(".hid-license-error:eq(0)").val()),
            enabled: macroBlock.find(".hid-enabled:eq(0)").val() == "true",
            selector: macroBlock.find(".hid-selector:eq(0)").val(),
            // for headings on page
            headingIndent : Number(macroBlock.find(".hid-headingIndent:eq(0)").val()),
            enableExpandCollapse : macroBlock.find(".hid-enableExpandCollapse:eq(0)").val() == "true",
            expandAllByDefault : macroBlock.find(".hid-expandAllByDefault:eq(0)").val() == "true",
            expandUntil: Number(macroBlock.find(".hid-expandUntil:eq(0)").val()),
            titleExpandClickable : macroBlock.find(".hid-titleExpandClickable:eq(0)").val() == "true",
            // for Navigation
            useNavigation : macroBlock.find(".hid-useNavigation:eq(0)").val() == "true",
            useNavigationHiddenMode: macroBlock.find(".hid-useNavigationHiddenMode:eq(0)").val() == "true",
            wrapNavigationText: macroBlock.find(".hid-wrapNavigationText:eq(0)").val() == "true",
            navigationTitle : htmlEncode(macroBlock.find(".hid-navigationTitle:eq(0)").val()),
            navigationTop: Number(macroBlock.find(".hid-navigationTop:eq(0)").val()),
            navigationWidth : Number(macroBlock.find(".hid-navigationWidth:eq(0)").val()),
            navigationIndent : Number(macroBlock.find(".hid-navigationIndent:eq(0)").val()),
            disableNavLinksUnder : Number(macroBlock.find(".hid-disableNavLinksUnder:eq(0)").val()),
            enableNavExpandCollapse : macroBlock.find(".hid-enableNavExpandCollapse:eq(0)").val() == "true",
            expandNavAllByDefault : macroBlock.find(".hid-expandNavAllByDefault:eq(0)").val() == "true",
            expandNavUntil: Number(macroBlock.find(".hid-expandNavUntil:eq(0)").val()),
            // for related links
            relatedLinksTitle: htmlEncode(macroBlock.find(".hid-relatedLinksTitle:eq(0)").val()),
            relatedLinksTarget: macroBlock.find(".hid-relatedLinksTarget:eq(0)").val(),
            macrosTOCDisabled: macroBlock.find(".hid-macrosTOCDisabled:eq(0)").val(),
            macrosToRemoveContainer: macroBlock.find(".hid-macrosToRemoveContainer:eq(0)").val()
        };
        parameters.relatedLinks = [];
        let linkText1 = macroBlock.find(".hid-linkText1:eq(0)").val();
        let linkUrl1 = macroBlock.find(".hid-linkUrl1:eq(0)").val();
        if (linkText1.trim().length > 0 && linkUrl1.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText1), linkUrl: linkUrl1});
        let linkText2 = macroBlock.find(".hid-linkText2:eq(0)").val();
        let linkUrl2 = macroBlock.find(".hid-linkUrl2:eq(0)").val();
        if (linkText2.trim().length > 0 && linkUrl2.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText2), linkUrl: linkUrl2});
        let linkText3 = macroBlock.find(".hid-linkText3:eq(0)").val();
        let linkUrl3 = macroBlock.find(".hid-linkUrl3:eq(0)").val();
        if (linkText3.trim().length > 0 && linkUrl3.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText3), linkUrl: linkUrl3});
        let linkText4 = macroBlock.find(".hid-linkText4:eq(0)").val();
        let linkUrl4 = macroBlock.find(".hid-linkUrl4:eq(0)").val();
        if (linkText4.trim().length > 0 && linkUrl4.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText4), linkUrl: linkUrl4});
        let linkText5 = macroBlock.find(".hid-linkText5:eq(0)").val();
        let linkUrl5 = macroBlock.find(".hid-linkUrl5:eq(0)").val();
        if (linkText5.trim().length > 0 && linkUrl5.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText5), linkUrl: linkUrl5});
        let linkText6 = macroBlock.find(".hid-linkText6:eq(0)").val();
        let linkUrl6 = macroBlock.find(".hid-linkUrl6:eq(0)").val();
        if (linkText6.trim().length > 0 && linkUrl6.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText6), linkUrl: linkUrl6});
        return parameters;
    }

    function removeMacroContainer(name) {
        let macroName = encodeSelector(name);
        if (macroName == "") return;

        $(".conf-macro[data-macro-name='"+ macroName +"']").each(function(){
            $(this).replaceWith($(this).children());
        });
    }

    /* Process heading blocks on the page */
    // Attention, this is a recursive function
    function processHeadings(h, paras) {
        if (h == null || h.length == 0) return;
        // Don't process empty headings
        if (h.text().trim() == "") {
            processHeadings(h.next(paras.selector), paras);
            return;
        }
        // Don't process the same heading second time
        if (h.parent().hasClass("heading-expand-header")) return;

        let divHeader = updateHeading(h, paras);
        let divBody = divHeader.next("div.heading-expand-body");
        processHeadings(divBody.find(paras.selector).not(notSelectorMacros).eq(0), paras);
        let hNext = divBody.next(paras.selector).not(notSelectorMacros);
        processHeadings(hNext, paras);
    }

    function updateHeading(h, paras){
        // Create the body div and move all its sub H elements into it
        let level = parseInt(h[0].nodeName.substring(1), 10);
        let until = ".easy-heading-free-end";
        for (i = level; i > 0; i--){
            if (until != "") until += ",";
            until += "h" + i;
        }

        let expandHeading = paras.expandAllByDefault || (paras.expandUntil > 0 && level <= paras.expandUntil);
        //console.log("level=" + level + ", paras.expandUntil=" + paras.expandUntil);

        let styleIndent = "padding-left: " + paras.headingIndent + "px;";
        let style = !expandHeading && paras.enableExpandCollapse ? styleIndent + "display:none;" : styleIndent + "display:block;";

        $("<div class='heading-expand-body' style='" + style + "'></div>").insertAfter(h);

        // Check if this is version 6 or lower version
        let isVersion6 = false;
        let version = $('meta[name="ajs-version-number"]');
        if (version.length == 1) {
            let arrConVersion = version.attr('content').split(".");
            isVersion6 = Number(arrConVersion[0]) <= 6;
        }

        h.next("div").each(function(){
            // Avoid executing the script inside other macro blocks for Confluence version lower than 7
            if (isVersion6) {
                $(this).nextUntil(until).find('script').remove();
            }
            $(this).nextUntil(until).appendTo($(this));
        });

        // Move header elements into the header div along with the expanding/collapsing icon
        let encodedText = encodeHeadingText(h.text());
        let headerId = encodedText;
        let index = 1;
        while ($("#" + headerId).length > 0) {
            index = index + 1;
            headerId = encodedText + "-" + index;
        }

        let buttonClass = expandHeading ? "fa-caret-down" : "fa-caret-right";
        let buttonHtml = paras.enableExpandCollapse ? "<i class='fa fa-ms heading-arrow " + buttonClass + "'></i>" : "";
        let divHeader = $("<div id='"+ headerId +"' class='heading-expand-header' style='display:flex;'>" + buttonHtml + "</div>");
        divHeader.insertAfter(h);
        h.appendTo(divHeader);

        return divHeader;
    }

    function bindHeadingExpandEvent() {
        // Bind expand/collapse event
        let selElementsClicking = paras.titleExpandClickable ? "i:eq(0), " + paras.selector : "i:eq(0)";
        $(SELECTOR_BODY).find(".heading-expand-header").find(selElementsClicking).click(function(event){
            event.preventDefault();

            $(this).parent().find("i:eq(0)").toggleClass("fa-caret-down").toggleClass("fa-caret-right");
            let bodyDiv = $(this).parent().next("div.heading-expand-body");
            bodyDiv.css("display", bodyDiv.is(":visible") ? "none" : "block" );
        });

        // Bind hover event for expanding buttons
        $(SELECTOR_BODY + " .heading-expand-header").find(".heading-arrow-hover, .heading-arrow").hover(function() {
            $(this).toggleClass("heading-arrow-hover", true).toggleClass("heading-arrow", false);
        }, function() {
            $(this).toggleClass("heading-arrow-hover", false).toggleClass("heading-arrow", true);
        });
    }

    /* Create floating navigation bar */
    function createNavigation(headings, paras) {
        if (!paras.useNavigation || navigationCreated) return false;
        if ($(SELECTOR_NAV_WRAPPER).length > 0) return false;

        // Don't show sidebar when there are no headings and no related links
        if (headings.length == 0 && paras.relatedLinks.length == 0) return false;

        // Still display related links when there is no headings but related links exist and use title of related links as title of sidebar
        let navTitle = paras.navigationTitle;
        if (headings.length == 0 && paras.relatedLinks.length > 0) {
            navTitle = paras.relatedLinksTitle;
        }

        // Copy all heading text and create a list
        let divNavigationWrapper =  $('<div id="ehp-navigation-wrapper"></div>');
        let divNavigation = $('<div id="ehp-navigation"></div>');
        let divNavContentWrapper = $('<div id="ehp-nav-content-wrapper"></div>');
        let divNavigationContent = $('<div id="ehp-navigation-content"></div>');
        let divDragBar = $('<div id="ehp-drag-bar"><i class="fas fa-grip-lines-vertical nav-drag-button"></i></div>');
        let divTitle = $('<div id="ehp-navigation-title">' + navTitle + '</div>');
        let classNavList = paras.wrapNavigationText ? "nav-list-wrap" : "nav-list-nowrap";
        let divList = $('<ul id="ehp-navigation-list" class="' + classNavList + '"></ul>');
        let divNavigationBottom = $('<div id="ehp-navigation-bottom"></div>');

        // Save right padding of content
        originalContentPaddingRight = Number($(SELECTOR_CONTENT).css("padding-right").replace("px", ""));

        // Set width of navigation
        navigationWidth = paras.navigationWidth;
        divNavigationWrapper.width(navigationWidth);
        divNavigation.width(navigationWidth);

        // Give navigation one column to display
        let switcherIconClass = "fa-list-alt";
        let switcherStyle = "";
        useNavigationHiddenMode = paras.useNavigationHiddenMode;
        if (useNavigationHiddenMode) {
            divNavigation.toggleClass("ehp-nav-popup", true);
        } else {
            switcherIconClass = "fa-columns";
            switcherStyle = ' style="display:none"';
            $(SELECTOR_CONTENT).css({"cssText": "padding-right:" + (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px !important"});
        }
        let divNavSwicher = $('<i id="ehp-navigation-switcher" class="fas fa-lg nav-switcher ' + switcherIconClass + '"' + switcherStyle + '></i>"');
        divNavSwicher.toggle(useNavigationHiddenMode);
        divNavigationContent.toggle(!useNavigationHiddenMode);
        divNavigationContent.toggleClass("ehp-navigation-shadow", useNavigationHiddenMode);

        // Add navigation content elements
        divNavigationContent.append(divDragBar).append(divTitle).append(divList).append(divNavigationBottom);
        divNavContentWrapper.append(divNavigationContent).append(divNavSwicher).appendTo(divNavigation);
        divNavigationWrapper.append(divNavigation).appendTo($(SELECTOR_CONTENT));

        // Initialize the y position for the wrapper
        let stickyStartY = $(SELECTOR_CONTENT).offset().top - $(SELECTOR_NAV_WRAPPER).offsetParent().offset().top;
        $(SELECTOR_NAV_WRAPPER).css("top", stickyStartY + "px");

        let isMultipleLayer = createNavigationLinks(headings, paras);
        if (isMultipleLayer) {
            createHeadingExpandButtons(paras);
        }

        createRelatedLinks(headings.length > 0, paras);
        return true;
    }

    function createNavigationLinks(headings, paras) {
        let isMultipleLayers = false;
        let linksContainer = $(SELECTOR_NAV_LIST);
        let indent = paras.navigationIndent;

        let layers = [];
        let numbers = [];
        for (let i=0; i<headings.length; i++) {
            let level = parseInt(headings.eq(i)[0].nodeName.substring(1), 10);
            let preLevel = 0;
            let preNumber = 1;
            if (layers.length > 0) {
                preLevel = layers[layers.length-1];
                preNumber = numbers[numbers.length-1];
            }
            if (layers.length > 1) {
                isMultipleLayers = true;
            }

            //console.log("i = " + i + ", level = " + level + ", preLevel = " + preLevel + ", preNumber = " + preNumber + ", text = " + headings.eq(i).text());

            if (level == preLevel) {
                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            } else if (level > preLevel) {
                layers.push(level);
                numbers.push(1);
            } else if (level < preLevel) {
                // reduce indent
                while (level < preLevel && layers.length > 0) {
                    layers.pop();

                    if (layers.length == 0) {
                        preLevel = 0;
                    } else {
                        preLevel = layers[layers.length-1];
                    }

                    if (level > preLevel) {
                        layers.push(level);
                    } else {
                        numbers.pop();
                    }
                }

                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            }

            //console.log("layers and numbers:");
            //console.log(layers);
            //console.log(numbers);

            let linkId = "number" + numbers.join("-") + "-";
            let padding = indent * (layers.length-1);
            let linkText = htmlEncode(filterHeadingText(headings.eq(i)));
            let encodedText = encodeHeadingText(filterHeadingText(headings.eq(i)));
            let linkAnchor = encodedText;
            let index = 1;
            while ($("a[href='#" + linkAnchor + "']").length > 0) {
                index = index + 1;
                linkAnchor = encodedText + "-" + index;
            }

            let textWrapClass = paras.wrapNavigationText ? "nav-header-wrap" : "nav-header-nowrap";
            let link = $("<li id='" + linkId + "' class='" + textWrapClass + "' style='padding-left: "
                + padding + "px;'><a href='#" + linkAnchor + "'>" + linkText
                + "</a><input type='hidden' value='" + level + "'></li>");

            // Update the link or create a new link
            link.appendTo(linksContainer);
        }
        return isMultipleLayers;
    }

    function createHeadingExpandButtons(paras) {
        $(SELECTOR_NAV_LIST +">li").each(function(index){
            // Check if the current link (li) has sub links
            let isParentNode = false;
            let nextLink = $(this).next();
            if (nextLink.length > 0) {
                //todo: replace this way because we should not use padding value which can be 0 from settings
                isParentNode = Number($(nextLink).css("padding-left").replace("px","")) > Number($(this).css("padding-left").replace("px",""));
            }

            // Set status for the expand/collapse buttons
            let level = Number($(this).find("input:hidden").val());
            let expandNavHeading = paras.expandNavAllByDefault || (paras.expandNavUntil > 0 && level <= paras.expandNavUntil);
            let buttonClass = expandNavHeading ? "fa-chevron-down" : "fa-chevron-right";
            let button;
            if (paras.enableNavExpandCollapse) {
                button = isParentNode ? $("<i class='fas fa-xs nav-arrow " + buttonClass + "'></i>") : $("<span class='nav-empty'></span>");
                $(this).find("i").remove();
                button.prependTo($(this));

                // Set visible for current link based on previous link
                let parentLinkId = $(this).attr("id").replace(/\d{1,3}-$/g, "");
                let parentLink = $("li#" + parentLinkId);
                if (parentLink.length > 0) {
                    let linkVisible = parentLink.find(".nav-arrow, .nav-arrow-hover").hasClass("fa-chevron-down");
                    $(this).toggle(linkVisible);
                }
            }
        });

        $(SELECTOR_NAV_LIST).find(".nav-arrow, .nav-arrow-hover").off("click").on("click", function(){
            event.preventDefault();

            // Expand/Collapse sub headings
            $(this).toggleClass("fa-chevron-right").toggleClass("fa-chevron-down");

            // Show/Hide sub headings
            let number = $(this).parent().attr("id").replace("number","");
            $(SELECTOR_NAV_LIST + " [id^='number" + number + "']:not(#number" + number + ")").each(function(){
                let num = $(this).attr("id").replace("number","");
                let visible = true;

                while(num.match(/\d{1,3}-$/g) != null && num.match(/\d{1,3}-$/g).length > 0) {
                    num = num.replace(/\d{1,3}-$/g, "");
                    let parentNode = $("#number" + num);
                    if (parentNode.length == 0) break;

                    visible = parentNode.find(".nav-arrow, .nav-arrow-hover").hasClass("fa-chevron-down");
                    if (!visible) break;
                }
                $(this).toggle(visible);
            });

            updateLinkWidthForWrap();
        });
    }

    function createRelatedLinks(displayingTitle, paras) {
        if (paras.relatedLinks.length == 0) return;

        let linksContainer = $(SELECTOR_NAV_LIST);
        if (displayingTitle) {
            $("<li id='ehp-related-links-title'>" + paras.relatedLinksTitle + "</li>").appendTo(linksContainer);
        }

        let target = paras.relatedLinksTarget == "new-window" ? "_blank" : "_top";
        for (let i=0; i<paras.relatedLinks.length; i++) {
            let textWrapClass = paras.wrapNavigationText ? "nav-header-wrap" : "nav-header-nowrap";
            $("<li class='" + textWrapClass + "'><a href='" + paras.relatedLinks[i].linkUrl + "' target='" + target + "'>" + paras.relatedLinks[i].linkText + "</a></li>").appendTo(linksContainer);
        }
    }

    function bindSwicherEventForNavigation() {
        $("#ehp-navigation-switcher").click(function(event) {
            event.preventDefault();

            useNavigationHiddenMode = !useNavigationHiddenMode;
            $(this).toggleClass("fa-list-alt").toggleClass("fa-columns");
            $("#ehp-navigation").toggleClass("ehp-nav-popup", useNavigationHiddenMode);

            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).addClass("ehp-navigation-shadow");
                $(SELECTOR_CONTENT).css({"cssText": "padding-right:" + (OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV) + "px !important"});

            } else {
                $(SELECTOR_NAV_CONTENT).removeClass("ehp-navigation-shadow");
                $(SELECTOR_CONTENT).css({"cssText": "padding-right:" + (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px !important"});
            }
            resizeNavigation(0);
        });

        // Hover on the switcher button
        $("#ehp-navigation-switcher").hover(function(event) {
            $(this).toggleClass("nav-switcher-hover", true).toggleClass("nav-switcher", false);

        }, function(event) {
            $(this).toggleClass("nav-switcher", true).toggleClass("nav-switcher-hover", false);

        });

        // Hover in and out the navigation
        $(SELECTOR_NAV_WRAPPER).hover(function(event) {
            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).show();
            } else {
                $("#ehp-navigation-switcher").show();
            }
            updateLinkWidthForWrap();
        }, function(event) {
            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).hide();
            } else {
                $("#ehp-navigation-switcher").hide();
            }
        });
    }

    function bindLinkEventForNavigation() {
        $(SELECTOR_NAV_LIST).find(".nav-arrow-hover, .nav-arrow").hover(function() {
            $(this).toggleClass("nav-arrow-hover", true).toggleClass("nav-arrow", false);
        }, function() {
            $(this).toggleClass("nav-arrow-hover", false).toggleClass("nav-arrow", true);
        });
    }

    function bindDragEventForNavigation() {
        // Dragging to resize
        dragBar = $("#ehp-drag-bar")[0];
        dragBar.addEventListener('mousedown', function(event) {
            event.preventDefault();
            mouseIsDown = true;
            mouseXPosition = event.clientX;
        }, true);

        document.addEventListener('mouseup', function() {
            mouseIsDown = false;
        }, true);

        document.addEventListener('mousemove', function(event) {
            if ($("#ehp-navigation").length == 0) return;

            navigationWidth = $(SELECTOR_NAV_WRAPPER).width();
            let xOffset = event.clientX - mouseXPosition;
            let canDragRight = xOffset > 0 && navigationWidth > MIN_WIDTH_NAVIGATION;
            let canDragLeft = xOffset < 0 && navigationWidth < MAX_WIDTH_NAVIGATION;
            if (mouseIsDown && (canDragRight || canDragLeft)) {
                mouseXPosition = event.clientX;
                resizeNavigation(xOffset);
            }
        }, true);
    }

    function bindWidthChangeForNavigation() {
        let elementBody = document.getElementById('main-content');
        new ResizeSensor(elementBody, function() {
            if ($(SELECTOR_NAV_WRAPPER).length == 0) return;

            if (!useNavigationHiddenMode) {
                let commentWidth = $(".ic-display-comment-view").width();
                navigationWidth = Math.max(commentWidth, $(SELECTOR_NAV_WRAPPER).width());
                $(SELECTOR_NAV_WRAPPER).width(navigationWidth);
                $("#ehp-navigation").width(navigationWidth);
                $(SELECTOR_CONTENT).css({"cssText": "padding-right:" + (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px !important"});
            } else {
                let commentWidth = Math.max(0, $(".ic-display-comment-view").width());
                if (commentWidth > 0) {
                    $(SELECTOR_CONTENT).css({"cssText": "padding-right:" +commentWidth + "px !important"});
                } else {
                    $(SELECTOR_CONTENT).css({"cssText": "padding-right:" + (OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV) + "px !important"});
                }
            }

    		updateNavigationPosition();
    		// Fix issue: when switch off the inline comment, drag left side bar will lead layout issue for navigation
    		$(SELECTOR_BODY).css("position", "relative");
        });
    }

    function bindAnchorLinks() {
        $(SELECTOR_CONTENT + ' a[href^="#heading-"]').click(function(event){
            event.preventDefault();

            // Add hash to the link without jump there directly
            let hash = $(this).attr("href");
            if(history.pushState) {
                history.pushState(null, null, hash);
            }
            else {
                location.hash = hash;
            }

            // Expand the target heading and scroll to the target heading only once it's completely expanded
            let targetId = hash.replace("#", "");
            navigateToHeading(targetId);

            return false;
        });
    }

    function navigateToHeading(targetId) {
        let expanded = isHeadingExpanded(targetId);
        if (expanded) {
            scrollToHeading(targetId);
        } else {
            expandHeading(targetId);
            setTimeout(function(){
                scrollToHeading(targetId);
            }, SCROLLING_EXPAND_WAIT_TIME);
        }

        let headingHeader = getHeadingHeader(targetId);
        expandNavHeading(headingHeader.attr("id"));
    }

    function updateNavigationPosition() {
    	// Update left of the navigation
        let offsetParent = $(SELECTOR_NAV_WRAPPER).offsetParent();
        let offsetParentElement = offsetParent[0];
        let contentLeft = document.getElementById("content").getBoundingClientRect().left;
        let offsetParentLeft = offsetParentElement.getBoundingClientRect().left;

        if (useNavigationHiddenMode) {
            let navLeft = contentLeft - offsetParentLeft  + $(SELECTOR_CONTENT).width() - $(SELECTOR_NAV_WRAPPER).width() + OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV;
            //console.log(contentLeft, offsetParentLeft, $(SELECTOR_CONTENT).width());
            $(SELECTOR_NAV_WRAPPER).css("left", navLeft + "px");
        } else {
            let navLeft = contentLeft - offsetParentLeft  + $(SELECTOR_CONTENT).width() + WIDTH_NAV_DRAG_BAR + OFFSET_NAV_TO_CONTENT;
            //console.log(contentLeft, offsetParentLeft, $(SELECTOR_CONTENT).width());
            $(SELECTOR_NAV_WRAPPER).css("left", navLeft + "px");
        }

        // Make the navigation floating
        let stickyTop = paras.navigationTop <= 0 ? OFFSET_NAV_TO_TOP : paras.navigationTop;
        let stickyStartY = $(SELECTOR_CONTENT).offset().top - $(SELECTOR_NAV_WRAPPER).offsetParent().offset().top;
        let contentBottom = $(SELECTOR_CONTENT).offset().top + $(SELECTOR_CONTENT).height();
        let navHeight = $("#ehp-navigation").height();
        let contentHeight = $(SELECTOR_CONTENT).height();
        if (navHeight > contentHeight) {
            navHeight = contentHeight;
        }
        let stickyStopY = contentBottom - navHeight - OFFSET_NAV_TO_BOTTOM;

        // console.log(window.pageYOffset, stickyStartY, stickyStopY, -1, $(SELECTOR_CONTENT).offset().top, $(SELECTOR_CONTENT).height(), -1, $("#ehp-navigation").height(), stickyStartY , OFFSET_NAV_TO_BOTTOM);
        if (window.pageYOffset >= stickyStopY) {
            $(SELECTOR_NAV_WRAPPER).css("top",  stickyStopY + "px");
            $("#ehp-navigation").toggleClass("nav-sticky", false).css("top",  "0px");
        } else if (window.pageYOffset >= stickyStartY) {
            $(SELECTOR_NAV_WRAPPER).css("top", stickyStartY + "px");
            $("#ehp-navigation").toggleClass("nav-sticky", true).css("top", stickyTop + "px");
        } else {
            $(SELECTOR_NAV_WRAPPER).css("top", (stickyStartY + OFFSET_NAV_TOP_FIX ) + "px");
            $("#ehp-navigation").toggleClass("nav-sticky", false).css("top",  "0px");
        }

        updateLinkWidthForWrap();
    }

    function resizeNavigation(xOffset) {
        if (!useNavigationHiddenMode) {
            let contentMarginRight = Number($(SELECTOR_CONTENT).css("padding-right").replace("px", ""));
            $(SELECTOR_CONTENT).css({"cssText": "padding-right:" + (contentMarginRight - xOffset) + "px !important"});
        }

        $(SELECTOR_NAV_WRAPPER).width($(SELECTOR_NAV_WRAPPER).width() - xOffset);
        $("#ehp-navigation").width($(SELECTOR_NAV_WRAPPER).width());

        updateNavigationPosition();
    }

    function highlightCurrentHeading() {
        let headers = $(SELECTOR_BODY).find(".heading-expand-header");
        if (headers.length == 0) return;

        let viewPosition = $(document).scrollTop() + SCROLLING_OFFSET_FIX;
        let index = 0;
        let contentBottom = $(SELECTOR_CONTENT).offset().top + $(SELECTOR_CONTENT).height();
        for (i = 0; i<headers.length; i++) {
            let prev = headers.eq(i).offset().top;
            let next = i < headers.length-1 ? headers.eq(i+1).offset().top : contentBottom + 99999;
            //console.log("prev=" + prev + ", next=" + next);
            if (viewPosition >= prev && viewPosition < next) {
                index = i;
                break;
            }
        }

        // highlight the current heading
        let targetLink = $(SELECTOR_NAV_LIST + " a:eq(" + index + ")");
        if (!targetLink.hasClass("ehp-highlight")) {
            $(".ehp-highlight").removeClass("ehp-highlight");
            targetLink.addClass("ehp-highlight");
        }
    }

    function getHeadingHeader(targetId) {
        let target = $(SELECTOR_BODY + " #" + targetId);
        let isHeader = target.hasClass("heading-expand-header");
        if (isHeader) {
            return target;
        } else {
            return target.closest(".heading-expand-body").prev(".heading-expand-header");
        }
    }

    function getHeadingBody(targetId) {
        let target = $(SELECTOR_BODY + " #" + targetId);
        let isHeader = target.hasClass("heading-expand-header");
        if (isHeader) {
            return target.next(".heading-expand-body");
        } else {
            return target.closest(".heading-expand-body");
        }
    }

    function isHeadingExpanded(targetId) {
        let headingBody = getHeadingBody(targetId);
        return headingBody.is(":hidden") == false && headingBody.parents(".heading-expand-body:hidden").length == 0;
    }

    function expandNavHeading(headerId) {
        $(SELECTOR_NAV_LIST + " a[href='#" + headerId + "']")
            .parents(".nav-expand-body:hidden")
            .each(function(){
                $(this).show();
                $(this).prev()
                    .find("i.nav-arrow")
                    .toggleClass("fa-chevron-right", false)
                    .toggleClass("fa-chevron-down", true);
            });

    }

    function scrollToHeading(targetId) {
        let target = $(SELECTOR_BODY + " #" + targetId);
        $('html, body').stop().animate({ scrollTop: target.offset().top - SCROLLING_OFFSET_FIX + 1 }, SCROLLING_ANIMATION_DURATION);
    }

    function expandHeading(targetId) {
        getHeadingBody(targetId)
            .parents(".heading-expand-body:hidden")
            .andSelf()
            .each(function(){
                $(this).show();
                $(this).prev()
                    .find("i.heading-arrow")
                    .toggleClass("fa-caret-right", false)
                    .toggleClass("fa-caret-down", true);
            });
    }

    function updateLinkWidthForWrap() {
        $(SELECTOR_NAV_LIST + " a").each(function(){
            let header = $(this).parent();
            let icon = header.find("span,i");
            if (icon.length == 1) {
                $(this).width(header.width() - icon.width());
            }
        });
    }

    function filterHeadingText(heading) {
        return heading.contents().not("i, img, input, select").text().trim();
    }

    // Encode to resolve XSS vulnerability
    function htmlEncode(str){
      return String(str).replace(/[^\w. ]/gi, function(c){
         return '&#'+c.charCodeAt(0)+';';
      });
    }

    // Encode text to generate id of heading
    function encodeHeadingText(text) {
        let result = text.replace(/[&\/\\\s\|\[\],;+()$~%.:*?<>{}#@!="'`^]/g, '');
        result = "heading-" + result.substring(0, 100);
        return result;
    }

    // Encode selector, should not encode comma
    function encodeSelector(name) {
        return name.replace(/[&\/\\\s\|\[\];+()$~%.:*?<>{}#@!="'`^]/g, '');
    }

    function getSelectorByMacroNames(macroNames, headingSelectors) {
        let names = encodeSelector(macroNames);
        let headingSelectorsEncoded = encodeSelector(headingSelectors);
        if (names == "") return "";

        let selector = "";
        let arryNames = names.split(",");
        let arryHeadingSelectors = headingSelectorsEncoded.split(",");
        for (let i=0; i<arryNames.length; i++) {
            for (let j=0; j<arryHeadingSelectors.length; j++) {
                if (selector != "") selector = selector + ",";
                selector = selector + ".conf-macro[data-macro-name='"+ arryNames[i] +"'] " + arryHeadingSelectors[j];
            }
        }
        return selector;
    }

    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }
});