define('com/ehmFreeDefaults/plugins', ['ajs', 'jquery'], function (AJS, $){
    "use strict";

    function updateParameterValues(oldParams, defaultParas) {
        let params = $.extend({}, oldParams);

        params.selector = defaultParas.selector;
        params.headingIndent = defaultParas.headingIndent;
        params.expandOption = defaultParas.expandCollapseOption;
        params.titleExpandClickable = defaultParas.titleExpandClickable;
        params.useNavigation = defaultParas.useNavigation;
        params.useNavigationHiddenMode = defaultParas.navigationMode == "right-popup";
        params.wrapNavigationText = defaultParas.wrapNavigationText;
        params.navigationTitle = defaultParas.navigationTitle;
        params.navigationTop = defaultParas.navigationTop;
        params.navigationWidth = defaultParas.navigationWidth;
        params.navigationIndent = defaultParas.navigationIndent;
        params.disableNavLinksUnder = defaultParas.disableNavLinksUnder;
        params.navigationExpandOption = defaultParas.expandCollapseNavOption;

        params.relatedLinksTitle = defaultParas.relatedLinksTitle;
        params.relatedLinksTarget = defaultParas.relatedLinksTarget;
        params.linkText1 = defaultParas.linkText1;
        params.linkUrl1 = defaultParas.linkUrl1;
        params.linkText2 = defaultParas.linkText2;
        params.linkUrl2 = defaultParas.linkUrl2;
        params.linkText3 = defaultParas.linkText3;
        params.linkUrl3 = defaultParas.linkUrl3;
        params.linkText4 = defaultParas.linkText4;
        params.linkUrl4 = defaultParas.linkUrl4;
        params.linkText5 = defaultParas.linkText5;
        params.linkUrl5 = defaultParas.linkUrl5;
        params.linkText6 = defaultParas.linkText6;
        params.linkUrl6 = defaultParas.linkUrl6;

        params.macrosTOCDisabled = defaultParas.macrosTOCDisabled;
        params.macrosToRemoveContainer = defaultParas.macrosToRemoveContainer;

        // Set flag to indicate the macro has been edited once
        params.hiddenEditedFlag = "true";

        return params;
    }

    function convertParamValueToString(parameters) {
        for (let paramName in parameters) {
            parameters[paramName] = String(parameters[paramName]);
        }
        return parameters;
    }

    // Common
    function showMessage(type, message) {
        AJS.flag({
            type: type,
            body: message,
            close: "auto"
        });
    }

    return {
        init : function(ed) {
            AJS.bind("macro-browser.macro-inserted", function(a,b){

                //console.log("event macro-browser.macro-inserted");

                let currentNode = tinymce.confluence.macrobrowser.getCurrentNode();
                let macroNode = currentNode.find("[data-macro-name='easy-heading-free']");
                if (macroNode.length == 0) {
                    return;
                }

                let paramsText = macroNode.attr("data-macro-parameters") || "";
                let params = Confluence.MacroParameterSerializer.deserialize(paramsText);
                if (params.hiddenEditedFlag == "true") {
                    return;
                }

                // Apply defaults to the macro
                let url = AJS.contextPath() + "/plugins/servlet/easy-heading-macro/macro-edit";

                $.ajax({
                    url: url,
                    type: "GET",
                    success: function (data, textStatus, XMLHttpRequest) {
                        let updatedParams = convertParamValueToString(updateParameterValues(params, data));
                        let updatedParamsText = Confluence.MacroParameterSerializer.serialize(updatedParams);
                        macroNode.attr("data-macro-parameters", updatedParamsText);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        showMessage("error", jqXHR.responseText);
                    }
                });

            });

        },
        getInfo : function() {
            //console.log("tinymce version: " + tinymce.majorVersion + "." + tinymce.minorVersion);
            return {
                longname : 'ehmNavigationView',
                author : 'Shinetech Software',
                authorurl : 'https://www.shinetechsoftware.com',
                version : tinymce.majorVersion + "." + tinymce.minorVersion
            };
        }
    }
});

require('confluence/module-exporter')
    .safeRequire('com/ehmFreeDefaults/plugins', function(MyPlugin) {
        let tinymce = require('tinymce');
        //console.log("> tinymce version: " + tinymce.majorVersion + "." + tinymce.minorVersion);
        tinymce.create('tinymce.plugins.ehmFreeDefaults', MyPlugin);

        // Register plugin
        tinymce.PluginManager.add('ehmFreeDefaults', tinymce.plugins.ehmFreeDefaults);
        require('confluence-editor/loader/tinymce-bootstrap').addTinyMcePluginInit(function(settings) {
            settings.plugins += ",ehmFreeDefaults";
        });
    });
