AJS.toInit(function() {
    const OFFSET_NAV_TO_CONTENT = 10;
    const WIDTH_NAV_DRAG_BAR = 25;
    const OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV = 36;
    const EMPTY_SELECTOR_HEADERS = "h1,h2,h3,h4,h5,h6";
    const SELECTOR_MAIN = "#main";
    const SELECTOR_CONTENT = "#content";
    const SELECTOR_BODY = "#main-content";
    const SELECTOR_MACRO = ".easy-heading-free";
    const SELECTOR_NAV_WRAPPER = "#ehp-navigation-wrapper";
    const SELECTOR_NAV_CONTENT = "#ehp-navigation-content";
    const SELECTOR_NAV_LIST = "#ehp-navigation-list-preview";

    let notSelectorMacros = ""; // not apply TOC to headings for macros

    let navigationCreated = false;
    let navigationWidth =  0;
    let useNavigationHiddenMode = false;
    let originalContentPaddingRight = 0;

    preview();

    function preview() {
        setupStyle();
        AJS.populateParameters();
        let paras = getMacroParameters();
        //console.log("paras", paras);

        if (!paras.enabled) return false;

        // Apply to all headings if none defined
        if (paras.selector == null || paras.selector.trim() == "") {
            paras.selector = EMPTY_SELECTOR_HEADERS;
        }

        // Workaround: Do not apply this plugin to headings inside the specified macros
        notSelectorMacros = getSelectorByMacroNames(paras.macrosTOCDisabled, paras.selector);

        //todo: or use servlet to get page content with API?
        // Mock headings for preview purpose
        let headingContent = mockHeadings();

        // Create sidebar
        let headings = headingContent.find(paras.selector).not(notSelectorMacros).filter(function(){
            return $(this).text() && $(this).text().trim() != "";
        });

        //console.log("headings", headings);

        navigationCreated = createNavigation(headings, paras);
        if (navigationCreated) {
            bindSwicherEventForNavigation();
        }
    }

    function setupStyle() {
        if ($("head>#eh-style").length > 0) {
            return;
        }

        // Move the style from the first macro to header
        let macroBlock = $(SELECTOR_MAIN + " " + SELECTOR_MACRO + ":eq(0)");
        let style = macroBlock.find(">style").html();
        $("head").append('<style id="eh-style" type="text/css">' + style + '</style>');

        // Remove style for all macros on the page
        $(SELECTOR_MAIN + " " + SELECTOR_MACRO + ">style").remove();
    }

    function getMacroParameters() {
        let macroBlock = $(SELECTOR_MAIN + " " + SELECTOR_MACRO + ":eq(0)");
        let parameters = {
            licenseError : htmlEncode(macroBlock.find(".hid-license-error:eq(0)").val()),
            enabled: macroBlock.find(".hid-enabled:eq(0)").val() == "true",
            selector: macroBlock.find(".hid-selector:eq(0)").val(),
            // for headings on page
            headingIndent : Number(macroBlock.find(".hid-headingIndent:eq(0)").val()),
            enableExpandCollapse : macroBlock.find(".hid-enableExpandCollapse:eq(0)").val() == "true",
            expandAllByDefault : macroBlock.find(".hid-expandAllByDefault:eq(0)").val() == "true",
            expandUntil: Number(macroBlock.find(".hid-expandUntil:eq(0)").val()),
            titleExpandClickable : macroBlock.find(".hid-titleExpandClickable:eq(0)").val() == "true",
            // for Navigation
            useNavigation : macroBlock.find(".hid-useNavigation:eq(0)").val() == "true",
            useNavigationHiddenMode: macroBlock.find(".hid-useNavigationHiddenMode:eq(0)").val() == "true",
            wrapNavigationText: macroBlock.find(".hid-wrapNavigationText:eq(0)").val() == "true",
            navigationTitle : htmlEncode(macroBlock.find(".hid-navigationTitle:eq(0)").val()),
            navigationTop: Number(macroBlock.find(".hid-navigationTop:eq(0)").val()),
            navigationWidth : Number(macroBlock.find(".hid-navigationWidth:eq(0)").val()),
            navigationIndent : Number(macroBlock.find(".hid-navigationIndent:eq(0)").val()),
            disableNavLinksUnder : Number(macroBlock.find(".hid-disableNavLinksUnder:eq(0)").val()),
            enableNavExpandCollapse : macroBlock.find(".hid-enableNavExpandCollapse:eq(0)").val() == "true",
            expandNavAllByDefault : macroBlock.find(".hid-expandNavAllByDefault:eq(0)").val() == "true",
            expandNavUntil: Number(macroBlock.find(".hid-expandNavUntil:eq(0)").val()),
            // for related links
            relatedLinksTitle: htmlEncode(macroBlock.find(".hid-relatedLinksTitle:eq(0)").val()),
            relatedLinksTarget: macroBlock.find(".hid-relatedLinksTarget:eq(0)").val(),
            macrosTOCDisabled: macroBlock.find(".hid-macrosTOCDisabled:eq(0)").val(),
            macrosToRemoveContainer: macroBlock.find(".hid-macrosToRemoveContainer:eq(0)").val()
        };
        parameters.relatedLinks = [];
        let linkText1 = macroBlock.find(".hid-linkText1:eq(0)").val();
        let linkUrl1 = macroBlock.find(".hid-linkUrl1:eq(0)").val();
        if (linkText1.trim().length > 0 && linkUrl1.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText1), linkUrl: linkUrl1});
        let linkText2 = macroBlock.find(".hid-linkText2:eq(0)").val();
        let linkUrl2 = macroBlock.find(".hid-linkUrl2:eq(0)").val();
        if (linkText2.trim().length > 0 && linkUrl2.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText2), linkUrl: linkUrl2});
        let linkText3 = macroBlock.find(".hid-linkText3:eq(0)").val();
        let linkUrl3 = macroBlock.find(".hid-linkUrl3:eq(0)").val();
        if (linkText3.trim().length > 0 && linkUrl3.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText3), linkUrl: linkUrl3});
        let linkText4 = macroBlock.find(".hid-linkText4:eq(0)").val();
        let linkUrl4 = macroBlock.find(".hid-linkUrl4:eq(0)").val();
        if (linkText4.trim().length > 0 && linkUrl4.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText4), linkUrl: linkUrl4});
        let linkText5 = macroBlock.find(".hid-linkText5:eq(0)").val();
        let linkUrl5 = macroBlock.find(".hid-linkUrl5:eq(0)").val();
        if (linkText5.trim().length > 0 && linkUrl5.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText5), linkUrl: linkUrl5});
        let linkText6 = macroBlock.find(".hid-linkText6:eq(0)").val();
        let linkUrl6 = macroBlock.find(".hid-linkUrl6:eq(0)").val();
        if (linkText6.trim().length > 0 && linkUrl6.trim().length > 0) parameters.relatedLinks.push({linkText: htmlEncode(linkText6), linkUrl: linkUrl6});
        return parameters;
    }

    function mockHeadings() {
        let html = "<div>";
        html += "<h1>This is mocked example of heading title for h1</h1><h2>This is mocked example of heading title for h2</h2><h3>This is mocked example of heading title for h3</h3><h4>This is mocked example of heading title for h4</h4><h5>This is mocked example of heading title for h5</h5><h6>This is mocked example of heading title for h6</h6>";
        html += "<h1>This is mocked example of heading title for h1</h1><h2>This is mocked example of heading title for h2</h2><h3>This is mocked example of heading title for h3</h3><h4>This is mocked example of heading title for h4</h4><h5>This is mocked example of heading title for h5</h5><h6>This is mocked example of heading title for h6</h6>";
        html += "<h1>This is mocked example of heading title for h1</h1><h2>This is mocked example of heading title for h2</h2><h3>This is mocked example of heading title for h3</h3><h4>This is mocked example of heading title for h4</h4><h5>This is mocked example of heading title for h5</h5><h6>This is mocked example of heading title for h6</h6>";
        html += "</div>";
        return $(html);
    }

    function createNavigation(headings, paras) {
        if (!paras.useNavigation || navigationCreated) return false;
        if ($(SELECTOR_NAV_WRAPPER).length > 0) return false;

        // Don't show sidebar when there are no headings and no related links
        if (headings.length == 0 && paras.relatedLinks.length == 0) return false;

        // Still display related links when there is no headings but related links exist and use title of related links as title of sidebar
        let navTitle = paras.navigationTitle;
        if (headings.length == 0 && paras.relatedLinks.length > 0) {
            navTitle = paras.relatedLinksTitle;
        }

        // Copy all heading text and create a list
        let divNavigationWrapper =  $('<div id="ehp-navigation-wrapper"></div>');
        let divNavigation = $('<div id="ehp-navigation"></div>');
        let divNavContentWrapper = $('<div id="ehp-nav-content-wrapper"></div>');
        let divNavigationContent = $('<div id="ehp-navigation-content"></div>');
        let divDragBar = $('<div id="ehp-drag-bar"><i class="fas fa-grip-lines-vertical nav-drag-button"></i></div>');
        let divTitle = $('<div id="ehp-navigation-title">' + navTitle + '</div>');
        let classNavList = paras.wrapNavigationText ? "nav-list-wrap" : "nav-list-nowrap";
        let divList = $('<ul id="ehp-navigation-list-preview" class="' + classNavList + '"></ul>');
        let divNavigationBottom = $('<div id="ehp-navigation-bottom"></div>');

        // Save right padding of content
        originalContentPaddingRight = Number($(SELECTOR_CONTENT).css("padding-right").replace("px", ""));

        // Set width of navigation
        navigationWidth = paras.navigationWidth;
        divNavigationWrapper.width(navigationWidth);
        divNavigation.width(navigationWidth);

        // Give navigation one column to display
        let switcherIconClass = "fa-list-alt";
        let switcherStyle = "";

        // Don't use this icon in preview mode
        useNavigationHiddenMode = paras.useNavigationHiddenMode;
        // useNavigationHiddenMode = false;

        if (useNavigationHiddenMode) {
            divNavigation.toggleClass("ehp-nav-popup", true);
        } else {
            switcherIconClass = "fa-columns";
            switcherStyle = ' style="display:block"';
            $(SELECTOR_CONTENT).css("padding-right", (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px");
        }
        let divNavSwicher = $('<i id="ehp-navigation-switcher" class="fas fa-lg nav-switcher ' + switcherIconClass + '"' + switcherStyle + '></i>"');
        divNavSwicher.toggle(useNavigationHiddenMode);
        divNavigationContent.toggle(!useNavigationHiddenMode);
        divNavigationContent.toggleClass("ehp-navigation-shadow", useNavigationHiddenMode);

        // Add navigation content elements
        divNavigationContent.append(divDragBar).append(divTitle).append(divList).append(divNavigationBottom);
        divNavContentWrapper.append(divNavigationContent).append(divNavSwicher).appendTo(divNavigation);
        divNavigationWrapper.append(divNavigation).appendTo($(SELECTOR_CONTENT));

        // Initialize the y position for the wrapper
        let stickyStartY = $(SELECTOR_CONTENT).offset().top - $(SELECTOR_NAV_WRAPPER).offsetParent().offset().top;
        $(SELECTOR_NAV_WRAPPER).css("top", stickyStartY + "px");

        let isMultipleLayer = createNavigationLinks(headings, paras);
        if (isMultipleLayer) {
            createHeadingExpandButtons(paras);
        }

        createRelatedLinks(headings.length > 0, paras);
        return true;
    }

    function createNavigationLinks(headings, paras) {
        let isMultipleLayers = false;
        let linksContainer = $(SELECTOR_NAV_LIST);
        let indent = paras.navigationIndent;

        let layers = [];
        let numbers = [];
        for (let i=0; i<headings.length; i++) {
            console.log("createNavigationLinks - heading", headings.eq(i)[0]);

            let level = parseInt(headings.eq(i)[0].nodeName.substring(1), 10);
            let preLevel = 0;
            let preNumber = 1;
            if (layers.length > 0) {
                preLevel = layers[layers.length-1];
                preNumber = numbers[numbers.length-1];
            }
            if (layers.length > 1) {
                isMultipleLayers = true;
            }

            //console.log("i = " + i + ", level = " + level + ", preLevel = " + preLevel + ", preNumber = " + preNumber + ", text = " + headings.eq(i).text());

            if (level == preLevel) {
                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            } else if (level > preLevel) {
                layers.push(level);
                numbers.push(1);
            } else if (level < preLevel) {
                // reduce indent
                while (level < preLevel && layers.length > 0) {
                    layers.pop();

                    if (layers.length == 0) {
                        preLevel = 0;
                    } else {
                        preLevel = layers[layers.length-1];
                    }

                    if (level > preLevel) {
                        layers.push(level);
                    } else {
                        numbers.pop();
                    }
                }

                numbers[numbers.length-1] = numbers[numbers.length-1] + 1;
            }

            //console.log("layers and numbers:");
            //console.log(layers);
            //console.log(numbers);

            let linkId = "number" + numbers.join("-") + "-";
            let padding = indent * (layers.length-1);
            let linkText = htmlEncode(filterHeadingText(headings.eq(i)));

            // Disable links for preview
            // let encodedText = encodeHeadingText(filterHeadingText(headings.eq(i)));
            // let linkAnchor = encodedText;
            // let index = 1;
            // while ($("a[href='#" + linkAnchor + "']").length > 0) {
            //     index = index + 1;
            //     linkAnchor = encodedText + "-" + index;
            // }
            let linkAnchor = "";

            let textWrapClass = paras.wrapNavigationText ? "nav-header-wrap" : "nav-header-nowrap";
            let link = $("<li id='" + linkId + "' class='" + textWrapClass + "' style='padding-left: "
                + padding + "px;'><a href='#" + linkAnchor + "'>" + linkText
                + "</a><input type='hidden' value='" + level + "'></li>");


            console.log("createNavigationLinks - link", link);

            // Update the link or create a new link
            link.appendTo(linksContainer);
        }
        return isMultipleLayers;
    }

    function createHeadingExpandButtons(paras) {
        $(SELECTOR_NAV_LIST +">li").each(function(index){
            // Check if the current link (li) has sub links
            let isParentNode = false;
            let nextLink = $(this).next();
            if (nextLink.length > 0) {
                //todo: replace this way because we should not use padding value which can be 0 from settings
                isParentNode = Number($(nextLink).css("padding-left").replace("px","")) > Number($(this).css("padding-left").replace("px",""));
            }

            // Set status for the expand/collapse buttons
            let level = Number($(this).find("input:hidden").val());
            let expandNavHeading = paras.expandNavAllByDefault || (paras.expandNavUntil > 0 && level <= paras.expandNavUntil);
            let buttonClass = expandNavHeading ? "fa-chevron-down" : "fa-chevron-right";
            let button;
            if (paras.enableNavExpandCollapse) {
                button = isParentNode ? $("<i class='fas fa-xs nav-arrow " + buttonClass + "'></i>") : $("<span class='nav-empty'></span>");
                $(this).find("i").remove();
                button.prependTo($(this));

                // Set visible for current link based on previous link
                let parentLinkId = $(this).attr("id").replace(/\d{1,3}-$/g, "");
                let parentLink = $("li#" + parentLinkId);
                if (parentLink.length > 0) {
                    let linkVisible = parentLink.find(".nav-arrow, .nav-arrow-hover").hasClass("fa-chevron-down");
                    $(this).toggle(linkVisible);
                }
            }
        });

        $(SELECTOR_NAV_LIST).find(".nav-arrow, .nav-arrow-hover").off("click").on("click", function(){
            event.preventDefault();

            // Expand/Collapse sub headings
            $(this).toggleClass("fa-chevron-right").toggleClass("fa-chevron-down");

            // Show/Hide sub headings
            let number = $(this).parent().attr("id").replace("number","");
            $(SELECTOR_NAV_LIST + " [id^='number" + number + "']:not(#number" + number + ")").each(function(){
                let num = $(this).attr("id").replace("number","");
                let visible = true;

                while(num.match(/\d{1,3}-$/g) != null && num.match(/\d{1,3}-$/g).length > 0) {
                    num = num.replace(/\d{1,3}-$/g, "");
                    let parentNode = $("#number" + num);
                    if (parentNode.length == 0) break;

                    visible = parentNode.find(".nav-arrow, .nav-arrow-hover").hasClass("fa-chevron-down");
                    if (!visible) break;
                }
                $(this).toggle(visible);
            });

            updateLinkWidthForWrap();
        });
    }

    function updateLinkWidthForWrap() {
        $(SELECTOR_NAV_LIST + " a").each(function(){
            let header = $(this).parent();
            let icon = header.find("span,i");
            if (icon.length == 1) {
                $(this).width(header.width() - icon.width());
            }
        });
    }

    function createRelatedLinks(displayingTitle, paras) {
        if (paras.relatedLinks.length == 0) return;

        let linksContainer = $(SELECTOR_NAV_LIST);
        if (displayingTitle) {
            $("<li id='ehp-related-links-title'>" + paras.relatedLinksTitle + "</li>").appendTo(linksContainer);
        }

        let target = paras.relatedLinksTarget == "new-window" ? "_blank" : "_top";
        for (let i=0; i<paras.relatedLinks.length; i++) {
            let textWrapClass = paras.wrapNavigationText ? "nav-header-wrap" : "nav-header-nowrap";
            $("<li class='" + textWrapClass + "'><a href='" + paras.relatedLinks[i].linkUrl + "' target='" + target + "'>" + paras.relatedLinks[i].linkText + "</a></li>").appendTo(linksContainer);
        }
    }

    function bindSwicherEventForNavigation() {
        $("#ehp-navigation-switcher").click(function(event) {
            event.preventDefault();

            useNavigationHiddenMode = !useNavigationHiddenMode;
            $(this).toggleClass("fa-list-alt").toggleClass("fa-columns");
            $("#ehp-navigation").toggleClass("ehp-nav-popup", useNavigationHiddenMode);

            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).addClass("ehp-navigation-shadow");
                $(SELECTOR_CONTENT).css("padding-right", (OFFSET_CONTENT_MARGIN_RIGHT_FOR_HIDDEN_NAV) + "px");

            } else {
                $(SELECTOR_NAV_CONTENT).removeClass("ehp-navigation-shadow");
                $(SELECTOR_CONTENT).css("padding-right", (OFFSET_NAV_TO_CONTENT + WIDTH_NAV_DRAG_BAR + navigationWidth) + "px");
            }
        });

        // Hover on the switcher button
        $("#ehp-navigation-switcher").hover(function(event) {
            $(this).toggleClass("nav-switcher-hover", true).toggleClass("nav-switcher", false);

        }, function(event) {
            $(this).toggleClass("nav-switcher", true).toggleClass("nav-switcher-hover", false);

        });

        // Hover in and out the navigation
        $(SELECTOR_NAV_WRAPPER).hover(function(event) {
            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).show();
            } else {
                $("#ehp-navigation-switcher").show();
            }
            updateLinkWidthForWrap();
        }, function(event) {
            if (useNavigationHiddenMode) {
                $(SELECTOR_NAV_CONTENT).hide();
            } else {
                $("#ehp-navigation-switcher").hide();
            }
        });
    }

    function getSelectorByMacroNames(macroNames, headingSelectors) {
        let names = encodeSelector(macroNames);
        let headingSelectorsEncoded = encodeSelector(headingSelectors);
        if (names == "") return "";

        let selector = "";
        let arryNames = names.split(",");
        let arryHeadingSelectors = headingSelectorsEncoded.split(",");
        for (let i=0; i<arryNames.length; i++) {
            for (let j=0; j<arryHeadingSelectors.length; j++) {
                if (selector != "") selector = selector + ",";
                selector = selector + ".conf-macro[data-macro-name='"+ arryNames[i] +"'] " + arryHeadingSelectors[j];
            }
        }
        return selector;
    }

    function filterHeadingText(heading) {
        return heading.contents().not("i, img, input, select").text().trim();
    }

    // Encode to resolve XSS vulnerability
    function htmlEncode(str){
        return String(str).replace(/[^\w. ]/gi, function(c){
            return '&#'+c.charCodeAt(0)+';';
        });
    }

    // Encode selector, should not encode comma
    function encodeSelector(name) {
        return name.replace(/[&\/\\\s\|\[\];+()$~%.:*?<>{}#@!="'`^]/g, '');
    }

});