(function () {
    if (!window.lrefDescriptor) {
        window.lrefDescriptor = {}
    }
    window.lrefDescriptor['com.bilith.lref.confluence-gdrive'] = {
 "baseUrl": "/plugins/servlet/lref/gdrive-confluence",
 "key": "com.bilith.lref.confluence-gdrive",
 "modules": {
  "adminPages": [{
   "name": {"value": "Google Drive"},
   "key": "admin-page",
   "url": "/view?id=admin_page&provider=gdrive&bundle=gdrive-confluence"
  }],
  "dynamicContentMacros": [
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Google Drive Live Link Macro"},
     "editTitle": {"value": "Edit Google Drive Live Link Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_link_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-file",
     "height": "350px"
    },
    "featured": true,
    "hidden": false,
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_link.png",
     "height": 80
    },
    "description": {"value": "Live Link to Google Drive file, folder or document"},
    "outputType": "INLINE",
    "url": "/view?id=conf_ref_link_macro&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-file&c-ref_link-gdrive={c-ref_link-gdrive}&url={url}&page_id={page.id}",
    "autoconvert": {
     "matchers": [
      {"pattern": "https://drive.google.com/open?id={}"},
      {"pattern": "https://docs.google.com/open?id={}"},
      {"pattern": "https://drive.google.com/a/{}/open?id={}"},
      {"pattern": "https://docs.google.com/document/{}/{}"},
      {"pattern": "https://docs.google.com/document/{}/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/document/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/document/{}/{}/{}"},
      {"pattern": "https://docs.google.com/document/d/{}/mobilebasic"},
      {"pattern": "https://docs.google.com/document/u/{}/d/{}/mobilebasic"},
      {"pattern": "https://docs.google.com/spreadsheets/{}/{}"},
      {"pattern": "https://docs.google.com/spreadsheets/{}/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/spreadsheets/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/spreadsheets/{}/{}/{}"},
      {"pattern": "https://docs.google.com/presentation/{}/{}"},
      {"pattern": "https://docs.google.com/presentation/{}/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/presentation/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/presentation/{}/{}/{}"},
      {"pattern": "https://docs.google.com/presentation/d/{}/mobilepresent?slide=id.p"},
      {"pattern": "https://docs.google.com/presentation/u/{}/d/{}/mobilepresent?slide=id.p"},
      {"pattern": "https://docs.google.com/drawings/{}/{}"},
      {"pattern": "https://docs.google.com/drawings/{}/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/drawings/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/drawings/{}/{}/{}"},
      {"pattern": "https://docs.google.com/forms/{}/{}"},
      {"pattern": "https://docs.google.com/forms/{}/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/forms/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/forms/{}/{}/{}"},
      {"pattern": "https://jamboard.google.com/d/{}/{}"},
      {"pattern": "https://jamboard.google.com/karma/d/{}/{}"},
      {"pattern": "https://www.google.com/maps/d/{}"},
      {"pattern": "https://www.google.com/maps/d/u/{}/{}"},
      {"pattern": "https://drive.google.com/drive/folders/{}"},
      {"pattern": "https://drive.google.com/drive/u/{}/folders/{}"},
      {"pattern": "https://drive.google.com/embeddedfolderview?id={}"},
      {"pattern": "https://drive.google.com/drive/mobile/folders/{}"},
      {"pattern": "https://drive.google.com/drive/u/{}/mobile/folders/{}"},
      {"pattern": "https://drive.google.com/folderview?id={}"},
      {"pattern": "https://docs.google.com/folderview?id={}"},
      {"pattern": "https://drive.google.com/file/d/{}/{}"},
      {"pattern": "https://drive.google.com/a/{}/file/d/{}/{}"},
      {"pattern": "https://drive.google.com/a/{}/file/d/{}"},
      {"pattern": "https://docs.google.com/file/d/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/file/d/{}/{}"},
      {"pattern": "https://docs.google.com/a/{}/file/d/{}"},
      {"pattern": "https://drive.google.com/drive/u/{}/my-drive"},
      {"pattern": "https://drive.google.com/drive/my-drive"},
      {"pattern": "https://drive.google.com/drive/mobile/my-drive"},
      {"pattern": "https://drive.google.com/drive/u/{}/mobile/my-drive"},
      {"pattern": "https://drive.google.com/drive/search?q={}"},
      {"pattern": "https://drive.google.com/drive/u/{}/search?q={}"},
      {"pattern": "https://colab.research.google.com/drive/{}"},
      {"pattern": "https://drive.google.com/drive/shared-with-me"},
      {"pattern": "https://drive.google.com/drive/u/{}/shared-with-me"},
      {"pattern": "https://drive.google.com/drive/recent"},
      {"pattern": "https://drive.google.com/drive/u/{}/recent"},
      {"pattern": "https://drive.google.com/drive/starred"},
      {"pattern": "https://drive.google.com/drive/u/{}/starred"},
      {"pattern": "https://drive.google.com/drive/shared-drives"},
      {"pattern": "https://drive.google.com/drive/u/{}/shared-drives"}
     ],
     "urlParameter": "url"
    },
    "name": {"value": "Google Drive Live Link"},
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_link-gdrive",
      "name": {"value": "c-ref_link-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-gdrive-file"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Google Drive Live Link Macro"},
     "editTitle": {"value": "Edit Google Drive Live Link Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_link_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gdoclink",
     "height": "350px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Google Drive Live Link"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_link.png",
     "height": 80
    },
    "description": {"value": "Live Link to Google Drive file, folder or document"},
    "outputType": "INLINE",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_link-gdrive",
      "name": {"value": "c-ref_link-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gdoclink",
    "url": "/view?id=conf_ref_link_macro&provider=gdrive&bundle=gdrive-confluence&key=gdoclink&c-ref_link-gdrive={c-ref_link-gdrive}&url={url}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive Folder Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive Folder Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_children_list_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gdoclist",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive Folder"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_children_list.png",
     "height": 80
    },
    "description": {"value": "Content of Google Drive folder"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_children_list-gdrive",
      "name": {"value": "c-ref_children_list-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "sort",
      "name": {"value": "sort"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "folder",
      "name": {"value": "folder"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gdoclist",
    "url": "/view?id=conf_ref_children_list_macro&provider=gdrive&bundle=gdrive-confluence&key=gdoclist&c-ref_children_list-gdrive={c-ref_children_list-gdrive}&url={url}&limit={limit}&sort={sort}&folder={folder}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive Folder Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive Folder Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_children_list_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-files-list",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Embedded Google Drive Folder"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_children_list.png",
     "height": 80
    },
    "description": {"value": "Content of Google Drive folder"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_children_list-gdrive",
      "name": {"value": "c-ref_children_list-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "sort",
      "name": {"value": "sort"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-gdrive-files-list",
    "url": "/view?id=conf_ref_children_list_macro&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-files-list&c-ref_children_list-gdrive={c-ref_children_list-gdrive}&url={url}&limit={limit}&sort={sort}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-embedded-file",
     "height": "500px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "gid",
      "name": {"value": "gid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "slide",
      "name": {"value": "slide"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-gdrive-embedded-file",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-embedded-file&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&gid={gid}&slide={slide}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=google-drive-docs",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     }
    ],
    "key": "google-drive-docs",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=google-drive-docs&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=google-drive-sheets",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     }
    ],
    "key": "google-drive-sheets",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=google-drive-sheets&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=google-drive-slides",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     }
    ],
    "key": "google-drive-slides",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=google-drive-slides&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gdocument",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gdocument",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=gdocument&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gdrawing",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gdrawing",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=gdrawing&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gspreadsheet",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gspreadsheet",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=gspreadsheet&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gpresentation",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gpresentation",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=gpresentation&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gform",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gform",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=gform&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Google Drive File Macro"},
     "editTitle": {"value": "Edit Embedded Google Drive File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=gpdf",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Google Drive File"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Google Drive file or document"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-gdrive",
      "name": {"value": "c-ref_preview-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "docid",
      "name": {"value": "docid"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "gpdf",
    "url": "/view?id=conf_ref_preview_macro&provider=gdrive&bundle=gdrive-confluence&key=gpdf&c-ref_preview-gdrive={c-ref_preview-gdrive}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&docid={docid}&migrated={migrated}&page_id={page.id}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Google Drive Search Result Macro"},
     "editTitle": {"value": "Edit Google Drive Search Result Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_query_list_macro_editor&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-query-list",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Google Drive Search Result"},
    "icon": {
     "width": 80,
     "url": "/static/img/gdrive/macro_ref_query_list.png",
     "height": 80
    },
    "description": {"value": "Shows files/folders that match the specified filter"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_query_list-gdrive",
      "name": {"value": "c-ref_query_list-gdrive"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "sort",
      "name": {"value": "sort"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-gdrive-query-list",
    "url": "/view?id=conf_ref_query_list_macro&provider=gdrive&bundle=gdrive-confluence&key=lref-gdrive-query-list&c-ref_query_list-gdrive={c-ref_query_list-gdrive}&url={url}&limit={limit}&sort={sort}&page_id={page.id}"
   }
  ],
  "generalPages": [
   {
    "name": {"value": ""},
    "key": "user-settings",
    "url": "/view?id=user_settings&provider=gdrive&bundle=gdrive-confluence"
   },
   {
    "name": {"value": ""},
    "key": "admin-settings",
    "url": "/view?id=admin_settings&provider=gdrive&bundle=gdrive-confluence"
   }
  ],
  "dialogs": [
   {
    "options": {"header": {"value": ""}},
    "key": "dialog",
    "url": "/view?id=dialog&provider=gdrive&bundle=gdrive-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "picker",
    "url": "/view?id=picker&provider=gdrive&bundle=gdrive-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "creator",
    "url": "/view?id=creator&provider=gdrive&bundle=gdrive-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "uploader",
    "url": "/view?id=uploader&provider=gdrive&bundle=gdrive-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "sharer",
    "url": "/view?id=sharer&provider=gdrive&bundle=gdrive-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "google-picker",
    "url": "/view?id=google_picker&provider=gdrive&bundle=gdrive-confluence"
   }
  ]
 }
}
}())