/*
 * Decompiled with CFR 0.152.
 */
package com.bilith.atlasServer.commons;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.bilith.atlasServer.commons.Commons;
import com.bilith.atlasServer.commons.ContainerInfo;
import com.bilith.lref.LrefCommonUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class ViewServlet
extends HttpServlet {
    @Nonnull
    private final PluginLicenseManager pluginLicenseManager;

    public ViewServlet(@Nonnull PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    private boolean isActiveLicense() {
        Option licenseOption = this.pluginLicenseManager.getLicense();
        return Commons.isDevMode() || licenseOption.isDefined() && ((PluginLicense)licenseOption.get()).isValid();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String viewId = Commons.getQueryParam(req, "id");
        if (viewId == null) {
            return;
        }
        LrefCommonUtils.addP3PHeader(resp);
        JSONObject lrefObj = Commons.getLrefObj();
        boolean devMode = Commons.isDevMode();
        lrefObj.put("lrefHost", "lref.bilith.com");
        lrefObj.put("contextPath", req.getContextPath());
        lrefObj.put("enableLicensing", !devMode);
        lrefObj.put("lic", this.isActiveLicense());
        lrefObj.put("hosting", "server");
        LrefCommonUtils.setContainerInfo(lrefObj, "confluence", ContainerInfo.getVersion());
        lrefObj.put("imgBaseUrl", Commons.imgResourceUrl("img"));
        LrefCommonUtils.addBundleObj(lrefObj, "com.bilith.lref.confluence-gdrive", "gdrive-confluence", "Google Drive & Docs for Confluence");
        LrefCommonUtils.addProviderObj(lrefObj, "gdrive", "google-drive");
        resp.getWriter().write(LrefCommonUtils.getViewEndpointDefaultOutput(viewId, "gdrive", Commons.jsResourceUrl("atlassian-connect-iframe.js"), null, Commons.libsResourceUrl("static"), Commons.jsResourceUrl("vendor.js"), Commons.jsResourceUrl("main.js"), Commons.jsResourceUrl("all.css"), lrefObj, null));
    }
}

