(function () {
    if (!window.lrefDescriptor) {
        window.lrefDescriptor = {}
    }
    window.lrefDescriptor['com.bilith.lref.confluence-box'] = {
 "baseUrl": "/plugins/servlet/lref/box-confluence",
 "key": "com.bilith.lref.confluence-box",
 "modules": {
  "adminPages": [{
   "name": {"value": "Box"},
   "key": "admin-page",
   "url": "/view?id=admin_page&provider=box&bundle=box-confluence"
  }],
  "dynamicContentMacros": [
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Box Live Link Macro"},
     "editTitle": {"value": "Edit Box Live Link Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_link_macro_editor&provider=box&bundle=box-confluence&key=lref-box-file",
     "height": "350px"
    },
    "featured": true,
    "hidden": false,
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_link.png",
     "height": 80
    },
    "description": {"value": "Live Link to Box file or folder"},
    "outputType": "INLINE",
    "url": "/view?id=conf_ref_link_macro&provider=box&bundle=box-confluence&key=lref-box-file&c-ref_link-box={c-ref_link-box}&url={url}&page_id={page.id}&output_type={output.type}",
    "autoconvert": {
     "matchers": [
      {"pattern": "https://{}.box.com/s/{}"},
      {"pattern": "https://{}.box.com/v/{}"},
      {"pattern": "https://{}.box.com/file/{}"},
      {"pattern": "https://{}.box.com/folder/{}"},
      {"pattern": "https://{}.box.com/files/0/f/{}"},
      {"pattern": "https://{}.box.com/files/0/f/{}/{}"},
      {"pattern": "https://{}.box.com/files/0/f/{}/1/f_{}"},
      {"pattern": "https://{}.app.box.com/s/{}"},
      {"pattern": "https://{}.app.box.com/v/{}"},
      {"pattern": "https://{}.app.box.com/file/{}"},
      {"pattern": "https://{}.app.box.com/folder/{}"},
      {"pattern": "https://{}.app.box.com/files/0/f/{}"},
      {"pattern": "https://{}.app.box.com/files/0/f/{}/{}"},
      {"pattern": "https://{}.app.box.com/files/0/f/{}/1/f_{}"}
     ],
     "urlParameter": "url"
    },
    "name": {"value": "Box Live Link"},
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_link-box",
      "name": {"value": "c-ref_link-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-box-file"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Box Folder Macro"},
     "editTitle": {"value": "Edit Embedded Box Folder Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_children_list_macro_editor&provider=box&bundle=box-confluence&key=lref-box-files-list",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Embedded Box Folder"},
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_children_list.png",
     "height": 80
    },
    "description": {"value": "Content of Box folder"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_children_list-box",
      "name": {"value": "c-ref_children_list-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "columns",
      "name": {"value": "columns"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "sort",
      "name": {"value": "sort"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-box-files-list",
    "url": "/view?id=conf_ref_children_list_macro&provider=box&bundle=box-confluence&key=lref-box-files-list&c-ref_children_list-box={c-ref_children_list-box}&url={url}&limit={limit}&columns={columns}&sort={sort}&page_id={page.id}&output_type={output.type}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Box File Macro"},
     "editTitle": {"value": "Edit Embedded Box File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=box&bundle=box-confluence&key=lref-box-embedded-file",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Embedded Box File"},
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Box file"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-box",
      "name": {"value": "c-ref_preview-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-box-embedded-file",
    "url": "/view?id=conf_ref_preview_macro&provider=box&bundle=box-confluence&key=lref-box-embedded-file&c-ref_preview-box={c-ref_preview-box}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&page_id={page.id}&output_type={output.type}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Box Folder Macro"},
     "editTitle": {"value": "Edit Embedded Box Folder Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_children_list_macro_editor&provider=box&bundle=box-confluence&key=box-folder",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Box Folder"},
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_children_list.png",
     "height": 80
    },
    "description": {"value": "Content of Box folder"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_children_list-box",
      "name": {"value": "c-ref_children_list-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "columns",
      "name": {"value": "columns"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "sort",
      "name": {"value": "sort"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "boxId",
      "name": {"value": "boxId"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "box-folder",
    "url": "/view?id=conf_ref_children_list_macro&provider=box&bundle=box-confluence&key=box-folder&c-ref_children_list-box={c-ref_children_list-box}&url={url}&limit={limit}&columns={columns}&sort={sort}&boxId={boxId}&migrated={migrated}&page_id={page.id}&output_type={output.type}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Box File Macro"},
     "editTitle": {"value": "Edit Embedded Box File Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_preview_macro_editor&provider=box&bundle=box-confluence&key=box-document",
     "height": "400px"
    },
    "featured": false,
    "hidden": true,
    "name": {"value": "Embedded Box File"},
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_preview.png",
     "height": 80
    },
    "description": {"value": "Preview of Box file"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_preview-box",
      "name": {"value": "c-ref_preview-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "width",
      "name": {"value": "width"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "height",
      "name": {"value": "height"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "fullwidth",
      "name": {"value": "fullwidth"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "align",
      "name": {"value": "align"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "boxId",
      "name": {"value": "boxId"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "unit",
      "name": {"value": "unit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "migrated",
      "name": {"value": "migrated"},
      "type": "string",
      "required": false
     }
    ],
    "key": "box-document",
    "url": "/view?id=conf_ref_preview_macro&provider=box&bundle=box-confluence&key=box-document&c-ref_preview-box={c-ref_preview-box}&url={url}&width={width}&height={height}&fullwidth={fullwidth}&align={align}&boxId={boxId}&unit={unit}&migrated={migrated}&page_id={page.id}&output_type={output.type}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Box Search Result Macro"},
     "editTitle": {"value": "Edit Box Search Result Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_query_list_macro_editor&provider=box&bundle=box-confluence&key=lref-box-query-list",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Box Search Result"},
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_query_list.png",
     "height": 80
    },
    "description": {"value": "Shows files/folders that match the specified filter"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_query_list-box",
      "name": {"value": "c-ref_query_list-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "columns",
      "name": {"value": "columns"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-box-query-list",
    "url": "/view?id=conf_ref_query_list_macro&provider=box&bundle=box-confluence&key=lref-box-query-list&c-ref_query_list-box={c-ref_query_list-box}&url={url}&limit={limit}&columns={columns}&page_id={page.id}&output_type={output.type}"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Box Folder Gallery Macro"},
     "editTitle": {"value": "Edit Box Folder Gallery Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_children_gallery_macro_editor&provider=box&bundle=box-confluence&key=lref-box-children-gallery",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Box Folder Gallery"},
    "icon": {
     "width": 80,
     "url": "/static/img/box/macro_ref_children_gallery.png",
     "height": 80
    },
    "description": {"value": "Content of Box folder as gallery"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c-ref_children_gallery-box",
      "name": {"value": "c-ref_children_gallery-box"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "columns",
      "name": {"value": "columns"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "sort",
      "name": {"value": "sort"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-box-children-gallery",
    "url": "/view?id=conf_ref_children_gallery_macro&provider=box&bundle=box-confluence&key=lref-box-children-gallery&c-ref_children_gallery-box={c-ref_children_gallery-box}&url={url}&limit={limit}&columns={columns}&sort={sort}&page_id={page.id}&output_type={output.type}"
   }
  ],
  "generalPages": [
   {
    "name": {"value": ""},
    "key": "user-settings",
    "url": "/view?id=user_settings&provider=box&bundle=box-confluence"
   },
   {
    "name": {"value": ""},
    "key": "admin-settings",
    "url": "/view?id=admin_settings&provider=box&bundle=box-confluence"
   }
  ],
  "dialogs": [
   {
    "options": {"header": {"value": ""}},
    "key": "dialog",
    "url": "/view?id=dialog&provider=box&bundle=box-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "picker",
    "url": "/view?id=picker&provider=box&bundle=box-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "creator",
    "url": "/view?id=creator&provider=box&bundle=box-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "uploader",
    "url": "/view?id=uploader&provider=box&bundle=box-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "sharer",
    "url": "/view?id=sharer&provider=box&bundle=box-confluence"
   }
  ]
 }
}
}())