/*
 * Decompiled with CFR 0.152.
 */
package com.bilith.atlasServer.commons;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.bilith.lref.LrefCommonUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public final class Commons {
    private static final String CP_DEV_JIRA = "/jiralref";
    private static final String CP_DEV_CONFLUENCE = "/wikilref";

    @Nonnull
    private static String resourcesUrl(String fileName, @Nonnull String resourcesKey) {
        return Commons.getWebResourceUrlProvider().getStaticPluginResourceUrl(resourcesKey, fileName, UrlMode.RELATIVE);
    }

    @Nonnull
    private static String jsResourcesKey() {
        return "com.bilith.lref.confluence-box:js-resources";
    }

    @Nonnull
    public static String jsResourceUrl(String fileName) {
        return Commons.resourcesUrl(fileName, Commons.jsResourcesKey());
    }

    @Nonnull
    private static String libsResourcesKey() {
        return "com.bilith.lref.confluence-box:libs-resources";
    }

    @Nonnull
    public static String libsResourceUrl(String fileName) {
        return Commons.resourcesUrl(fileName, Commons.libsResourcesKey());
    }

    @Nonnull
    private static String imgResourcesKey() {
        return "com.bilith.lref.confluence-box:img-resources";
    }

    @Nonnull
    public static String imgResourceUrl(String fileName) {
        return Commons.resourcesUrl(fileName, Commons.imgResourcesKey());
    }

    @Nullable
    public static String getQueryParam(@Nonnull HttpServletRequest req, @Nonnull String paramName) {
        String[] keyValues;
        String queryString = req.getQueryString();
        if (queryString == null) {
            return null;
        }
        for (String keyValue : keyValues = queryString.split("&")) {
            if (!keyValue.startsWith(paramName + "=")) continue;
            String value = keyValue.substring(paramName.length() + 1);
            return LrefCommonUtils.urlDecode(value);
        }
        return null;
    }

    public static boolean isDevMode() {
        String baseUrl = Commons.getWebResourceUrlProvider().getBaseUrl();
        return CP_DEV_JIRA.equals(baseUrl) || CP_DEV_CONFLUENCE.equals(baseUrl);
    }

    @Nonnull
    public static JSONObject getLrefObj() {
        return LrefCommonUtils.getLref("174", !Commons.isDevMode(), "https://78e2eb043ce74107840f00fa88ece404@o479991.ingest.sentry.io/5525923");
    }

    @Nonnull
    private static WebResourceUrlProvider getWebResourceUrlProvider() {
        return (WebResourceUrlProvider)ComponentLocator.getComponent(WebResourceUrlProvider.class);
    }

    @Nonnull
    public static String dataContextAsHtmlAttributeValue(@Nonnull JSONObject jsonObject) {
        return jsonObject.toString(0).replace("\"", "&quot;").replace("\n", "");
    }

    @Nonnull
    public static String injectionCode(@Nonnull String addonKey, @Nonnull String moduleKey, @Nonnull String context, @Nonnull String holderTag, @Nonnull String[] holderClasses) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(holderTag).append(" class=\"uninitialized_lref_module");
        for (String holderClass : holderClasses) {
            stringBuilder.append(" ").append(holderClass);
        }
        stringBuilder.append("\" data-context=\"").append(context).append("\"").append(" data-addon-key=\"").append(addonKey).append("\"").append(" data-module-key=\"").append(moduleKey).append("\">").append("</").append(holderTag).append(">");
        return stringBuilder.toString();
    }

    @Nonnull
    public static String injectionCode(@Nonnull String moduleKey, @Nonnull JSONObject context, @Nonnull String holderTag, @Nonnull String[] holderClasses) {
        String contextAsString = Commons.dataContextAsHtmlAttributeValue(context);
        return Commons.injectionCode("com.bilith.lref.confluence-box", moduleKey, contextAsString, holderTag, holderClasses);
    }

    private Commons() {
    }
}

