/*
 * Decompiled with CFR 0.152.
 */
package com.bilith.atlasServer.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.bilith.atlasServer.commons.Commons;
import com.bilith.atlasServer.confluence.RefMacroParameterConverter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.json.JSONObject;

public abstract class RefMacro
implements Macro {
    private static final String RAW_DATA_CONTEXT = ": = | RAW | = :";
    private static final RefMacroParameterConverter DEFAULT_MACRO_PARAMETER_CONVERTER = new RefMacroParameterConverter();
    @Nonnull
    private final String myModuleKey;
    @Nonnull
    private final Macro.OutputType myOutputType;
    @Nonnull
    private final RefMacroParameterConverter myMacroParameterConverter;

    public RefMacro(@Nonnull String moduleKey, @Nonnull Macro.OutputType outputType, @Nonnull RefMacroParameterConverter macroParameterConverter) {
        this.myModuleKey = moduleKey;
        this.myOutputType = outputType;
        this.myMacroParameterConverter = macroParameterConverter;
    }

    public RefMacro(@Nonnull String moduleKey, @Nonnull Macro.OutputType outputType) {
        this.myModuleKey = moduleKey;
        this.myOutputType = outputType;
        this.myMacroParameterConverter = DEFAULT_MACRO_PARAMETER_CONVERTER;
    }

    @Nonnull
    public final String execute(Map<String, String> params, String s, ConversionContext conversionContext) {
        HashMap<String, String> preparedParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            Map.Entry<String, String> param;
            if (RAW_DATA_CONTEXT.equals(entry.getKey()) || (param = this.myMacroParameterConverter.mapParam(entry)) == null) continue;
            preparedParams.put(param.getKey(), param.getValue());
        }
        return this.execute(preparedParams);
    }

    @Nonnull
    private String execute(@Nonnull Map<String, String> params) {
        String[] stringArray;
        JSONObject dataContext = new JSONObject();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            dataContext.put(entry.getKey(), entry.getValue());
        }
        boolean inline = this.myOutputType == Macro.OutputType.INLINE;
        String holderTag = inline ? "span" : "div";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(holderTag).append(" class=\"ap-container");
        if (inline) {
            stringBuilder.append(" ap-inline");
        }
        stringBuilder.append("\">");
        if (inline) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "ap-content";
            stringArray = stringArray2;
            stringArray2[1] = "ap-inline";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "ap-content";
        }
        String[] injectionSpanClasses = stringArray;
        stringBuilder.append(Commons.injectionCode(this.myModuleKey, dataContext, holderTag, injectionSpanClasses));
        stringBuilder.append("</").append(holderTag).append(">");
        return stringBuilder.toString();
    }

    @Nonnull
    public final Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    @Nonnull
    public final Macro.OutputType getOutputType() {
        return this.myOutputType;
    }
}

