/*
 * Decompiled with CFR 0.152.
 */
package com.bilith.atlasServer.commons;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.bilith.lref.LrefCommonUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public final class Commons {
    public static final String VAR_LREF = "{{{lref}}}";
    public static final String VAR_VENDORS_JS_URL = "{{{vendors-js-url}}}";
    public static final String VAR_APP_JS_URL = "{{{app-js-url}}}";
    private static final String CP_DEV_JIRA = "/jiralref";
    private static final String CP_DEV_CONFLUENCE = "/wikilref";
    private static final String UTF_8 = "UTF-8";

    @Nonnull
    public static String getBaseUrl(@Nonnull ApplicationProperties applicationProperties) {
        return applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    @Nonnull
    public static String jsResourcesBasePath() {
        String jsResourcesBasePath = Commons.jsResourceUrl("");
        if (jsResourcesBasePath.endsWith("/")) {
            return jsResourcesBasePath.substring(0, jsResourcesBasePath.length() - 1);
        }
        return jsResourcesBasePath;
    }

    @Nonnull
    private static String resourcesUrl(String fileName, @Nonnull String resourcesKey) {
        return Commons.getWebResourceUrlProvider().getStaticPluginResourceUrl(resourcesKey, fileName, com.atlassian.plugin.webresource.UrlMode.RELATIVE);
    }

    @Nonnull
    private static String jsResourcesKey() {
        return "com.bilith.lref.confluence-box:js-resources";
    }

    @Nonnull
    public static String jsResourceUrl(String fileName) {
        return Commons.resourcesUrl(fileName, Commons.jsResourcesKey());
    }

    @Nonnull
    private static String libsResourcesKey() {
        return "com.bilith.lref.confluence-box:libs-resources";
    }

    @Nonnull
    public static String libsResourceUrl(String fileName) {
        return Commons.resourcesUrl(fileName, Commons.libsResourcesKey());
    }

    @Nonnull
    private static String imgResourcesKey() {
        return "com.bilith.lref.confluence-box:img-resources";
    }

    @Nonnull
    public static String imgResourceUrl(String fileName) {
        return Commons.resourcesUrl(fileName, Commons.imgResourcesKey());
    }

    @Nullable
    public static String getQueryParam(@Nonnull HttpServletRequest req, @Nonnull String paramName) {
        String[] keyValues;
        String queryString = req.getQueryString();
        if (queryString == null) {
            return null;
        }
        for (String keyValue : keyValues = queryString.split("&")) {
            if (!keyValue.startsWith(paramName + "=")) continue;
            String value = keyValue.substring(paramName.length() + 1);
            return LrefCommonUtils.urlDecode(value);
        }
        return null;
    }

    public static boolean isDevMode() {
        String baseUrl = Commons.getWebResourceUrlProvider().getBaseUrl();
        return CP_DEV_JIRA.equals(baseUrl) || CP_DEV_CONFLUENCE.equals(baseUrl);
    }

    @Nonnull
    public static JSONObject getLrefObj() {
        return LrefCommonUtils.getLref("160", !Commons.isDevMode(), "https://78e2eb043ce74107840f00fa88ece404@o479991.ingest.sentry.io/5525923");
    }

    @Nonnull
    private static WebResourceUrlProvider getWebResourceUrlProvider() {
        return (WebResourceUrlProvider)ComponentLocator.getComponent(WebResourceUrlProvider.class);
    }

    @Nonnull
    public static String dataContextAsHtmlAttributeValue(@Nonnull JSONObject jsonObject) {
        return jsonObject.toString(0).replace("\"", "&quot;").replace("\n", "");
    }

    @Nonnull
    public static String injectionCode(@Nonnull String addonKey, @Nonnull String moduleKey, @Nonnull String context, @Nonnull String holderTag, @Nonnull String[] holderClasses) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(holderTag).append(" class=\"uninitialized_lref_module");
        for (String holderClass : holderClasses) {
            stringBuilder.append(" ").append(holderClass);
        }
        stringBuilder.append("\" data-context=\"").append(context).append("\"").append(" data-addon-key=\"").append(addonKey).append("\"").append(" data-module-key=\"").append(moduleKey).append("\">").append("</").append(holderTag).append(">");
        return stringBuilder.toString();
    }

    @Nonnull
    public static String injectionCode(@Nonnull String moduleKey, @Nonnull JSONObject context, @Nonnull String holderTag, @Nonnull String[] holderClasses) {
        String contextAsString = Commons.dataContextAsHtmlAttributeValue(context);
        return Commons.injectionCode("com.bilith.lref.confluence-box", moduleKey, contextAsString, holderTag, holderClasses);
    }

    public static void oauth2Callback(@Nonnull HttpServletResponse resp, @Nonnull String authProviderId, @Nonnull String originalUrl, @Nullable String accessToken, String expiresIn, @Nullable String refreshToken, String scope) throws IOException {
        LrefCommonUtils.addP3PHeader(resp);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceAsStream = contextClassLoader.getResourceAsStream("templates/oauth2_callback.html");
        String s = IOUtils.toString((InputStream)resourceAsStream);
        s = s.replace(VAR_VENDORS_JS_URL, Commons.jsResourceUrl("vendor.js"));
        s = s.replace(VAR_APP_JS_URL, Commons.jsResourceUrl("auth.js"));
        JSONObject lrefObj = Commons.getLrefObj();
        JSONObject oauth2Obj = new JSONObject();
        oauth2Obj.put("auth_provider_id", authProviderId);
        oauth2Obj.put("original_url", originalUrl);
        oauth2Obj.put("token", accessToken);
        oauth2Obj.put("expires_in", expiresIn);
        oauth2Obj.put("refresh_token", refreshToken);
        oauth2Obj.put("scope", scope);
        lrefObj.put("oauth2", oauth2Obj);
        s = s.replace(VAR_LREF, lrefObj.toString(0));
        resp.getWriter().write(s);
    }

    public static boolean isAccessForbidden(@Nonnull UserManager userManager) {
        UserKey userKey = userManager.getRemoteUserKey();
        return userKey == null || !userManager.isSystemAdmin(userKey);
    }

    public static void sendMissingRequiredParameter(@Nonnull HttpServletResponse resp, @Nonnull String paramName) throws IOException {
        resp.sendError(400, "Missing required parameter '" + paramName + "'");
    }

    private Commons() {
    }
}

