/*
 * Decompiled with CFR 0.152.
 */
package com.bilith.lref;

import com.bilith.lref.resources.LrefRes;
import com.bilith.lref.resources.ResFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public final class LrefCommonUtils {
    public static final String UTF_8 = "UTF-8";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String LREF_HOST = "lref.bilith.com";
    private static final String HEADER_P3P_NAME = "P3P";
    private static final String HEADER_P3P_VALUE = "CP=\"CURa ADMa DEVa CONo HISa OUR IND DSP ALL COR\"";
    public static final String STATE_ORIGINAL_URL_PARAM = "u";
    public static final String STATE_DIALOG_PARAM = "d";
    public static final String ATTR_OAUTH2 = "oauth2";
    public static final String OAUTH2 = "oauth2";
    public static final String ATTR_TOKEN = "token";
    public static final String TOKEN = "token";
    public static final String ATTR_REFRESH_TOKEN = "refresh_token";
    public static final String REFRESH_TOKEN = "refreshToken";
    public static final String ATTR_EXPIRES_IN = "expires_in";
    public static final String EXPIRES_IN = "expiresIn";
    public static final String ATTR_DIALOG = "dialog";
    public static final String ATTR_ERROR = "error";
    public static final String ATTR_SCOPE = "scope";
    public static final String SCOPE = "scope";
    public static final String ATTR_ORIGINAL_URL = "original_url";
    public static final String ORIGINAL_URL = "originalUrl";
    public static final String ATTR_AUTH_PROVIDER_ID = "auth_provider_id";
    public static final String ATTR_MESSAGE = "message";
    public static final String BUNDLE = "bundle";
    public static final String PROVIDER = "provider";
    public static final String PARAM_BUNDLE_ID = "bundle_id";
    public static final String PARAM_AUTH_PROVIDER_ID = "auth_provider_id";
    public static final String PARAM_ORIGINAL_URL = "original_url";
    public static final String PARAM_SCOPE = "scope";
    public static final String PARAM_REFRESH_TOKEN = "refresh_token";
    public static final String PARAM_CODE = "code";
    public static final String PARAM_ERROR = "error";
    public static final String PARAM_DIALOG = "dialog";
    public static final String PARAM_STATE = "state";
    public static final String PATH_PROVIDER_ID = "provider_id";
    public static final String ATTR_CONTAINER = "container";
    public static final String ATTR_CONTAINER_NAME = "name";
    public static final String ATTR_CONTAINER_VERSION = "version";

    private LrefCommonUtils() {
    }

    public static void addBundleObj(@Nonnull JSONObject lrefObj, @Nonnull String bundleKey, @Nonnull String bundleId, @Nonnull String bundleName) {
        JSONObject bundleObj = new JSONObject();
        bundleObj.put("key", bundleKey);
        bundleObj.put("id", bundleId);
        bundleObj.put(ATTR_CONTAINER_NAME, bundleName);
        lrefObj.put(BUNDLE, bundleObj);
    }

    public static void addProviderObj(@Nonnull JSONObject lrefObj, @Nonnull String id, @Nonnull String presentableId) {
        JSONObject providerObj = new JSONObject();
        providerObj.put("id", id);
        providerObj.put("presentableId", presentableId);
        lrefObj.put(PROVIDER, providerObj);
    }

    public static void addP3PHeader(@Nonnull HttpServletResponse response) {
        response.setHeader(HEADER_P3P_NAME, HEADER_P3P_VALUE);
    }

    @Nonnull
    public static JSONObject getLref(@Nonnull String appVersion, boolean sentryEnabled, @Nonnull String sentryDsn) {
        JSONObject lrefObj = new JSONObject();
        lrefObj.put("appVersion", appVersion);
        JSONObject sentryObj = new JSONObject();
        sentryObj.put("enabled", sentryEnabled);
        sentryObj.put("dsn", sentryDsn);
        lrefObj.put("sentry", sentryObj);
        return lrefObj;
    }

    @Nonnull
    public static String urlDecode(@Nonnull String str) {
        try {
            return URLDecoder.decode(str, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Nonnull
    public static String getMicrosoftAdminConsentUrl(@Nonnull String originalUrl, @Nonnull String apiKey, @Nonnull String baseUrl) {
        String redirectUri = baseUrl + "/azure-admin-consent-callback";
        return "https://login.microsoftonline.com/common/adminconsent?client_id=" + apiKey + "&state=" + originalUrl + "&redirect_uri=" + redirectUri;
    }

    public static void setContainerInfo(@Nonnull JSONObject lrefObj, @Nonnull String containerName, @Nonnull String containerVersion) {
        JSONObject containerObj = new JSONObject();
        containerObj.put(ATTR_CONTAINER_NAME, containerName);
        containerObj.put(ATTR_CONTAINER_VERSION, containerVersion);
        lrefObj.put(ATTR_CONTAINER, containerObj);
    }

    @Nonnull
    public static String getViewEndpointDefaultOutput(@Nonnull String viewId, @Nullable String providerId, @Nonnull String atlassianConnectJsUrl, @Nullable String allJsIntegrityHash, @Nonnull String staticUrl, @Nonnull String vendorsJsUrl, @Nonnull String appJsUrl, @Nonnull String allCssUrl, @Nonnull JSONObject lref, @Nullable String scriptNonce) {
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append("<!doctype html>\n").append("<html lang=\"en\">\n").append("<head>\n").append("    <meta charset=\"utf-8\">\n");
        LrefCommonUtils.appendAtlassianConnectJs(responseBuilder, atlassianConnectJsUrl, allJsIntegrityHash);
        LrefCommonUtils.appendResCssFile(responseBuilder, staticUrl, ResFile.AUI_PROTOTYPING_CSS);
        if (LrefCommonUtils.includeBoxContentPreview(viewId, providerId)) {
            LrefCommonUtils.appendResCssFile(responseBuilder, staticUrl, ResFile.BOX_CONTENT_PREVIEW_CSS);
        }
        LrefCommonUtils.appendResJsFile(responseBuilder, staticUrl, ResFile.JQUERY_MIN_JS);
        LrefCommonUtils.appendResJsFile(responseBuilder, staticUrl, ResFile.AUI_PROTOTYPING_JS);
        if (LrefCommonUtils.includeBoxContentPreview(viewId, providerId)) {
            LrefCommonUtils.appendResJsFile(responseBuilder, staticUrl, ResFile.BOX_CONTENT_PREVIEW_JS);
        }
        responseBuilder.append("    <link rel=\"stylesheet\" href=\"").append(allCssUrl).append("\" media=\"all\">\n").append("    <script src=\"").append(vendorsJsUrl).append("\"></script>\n");
        if (scriptNonce != null) {
            responseBuilder.append("    <script type=\"application/javascript\" nonce=\"").append(scriptNonce).append("\">\n");
        } else {
            responseBuilder.append("    <script type=\"application/javascript\">\n");
        }
        responseBuilder.append("        (function (window) {\n").append("            window.lref = JSON.parse('").append(LrefCommonUtils.prepareToInjectIntoJSONParse(lref)).append("');\n").append("        })(window);\n").append("    </script>\n").append("</head>\n").append("<body>\n").append("<div id=\"root\"></div>\n").append("<script src=\"").append(appJsUrl).append("\"></script>\n").append("</body>\n").append("</html>\n");
        return responseBuilder.toString();
    }

    private static void appendAtlassianConnectJs(@Nonnull StringBuilder responseBuilder, @Nonnull String atlassianConnectJsUrl, @Nullable String integrityHash) {
        responseBuilder.append("    <script src=\"").append(atlassianConnectJsUrl).append("\" data-options=\"resize:false\"");
        if (integrityHash != null) {
            responseBuilder.append(" integrity=\"sha384-").append(integrityHash).append("\"");
            responseBuilder.append(" crossorigin=\"anonymous\"");
        }
        responseBuilder.append("></script>\n");
    }

    @Nonnull
    public static String prepareToInjectIntoJSONParse(@Nonnull JSONObject jsonObject) {
        return jsonObject.toString(0).replace("'", "\\'");
    }

    public static void appendResJsFile(@Nonnull StringBuilder stringBuilder, @Nonnull String staticUrl, @Nonnull LrefRes resFile) {
        stringBuilder.append("    <script src=\"").append(staticUrl).append("/").append(resFile.getRelativePath()).append("\"></script>\n");
    }

    public static void appendResCssFile(@Nonnull StringBuilder stringBuilder, @Nonnull String staticUrl, @Nonnull LrefRes resFile) {
        stringBuilder.append("    <link rel=\"stylesheet\" href=\"").append(staticUrl).append("/").append(resFile.getRelativePath()).append("\" media=\"all\">\n");
    }

    private static boolean includeBoxContentPreview(@Nonnull String viewId, @Nullable String providerId) {
        return "box".equals(providerId) && (viewId.equals("conf_ref_preview_macro") || viewId.equals("jira_ref_preview_gadget") || viewId.equals("dialog"));
    }
}

