/*
 * Decompiled with CFR 0.152.
 */
package com.bilith.atlasServer.confluence;

import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RefMacroParameterConverter {
    @Nullable
    protected Map.Entry<String, String> mapParam(@Nonnull Map.Entry<String, String> param) {
        return param;
    }

    @Nonnull
    protected static Map.Entry<String, String> mapEntry(@Nonnull String name, @Nonnull String value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(name, value);
    }

    @Nullable
    protected static Map.Entry<String, String> mapEntryDefaultValue(@Nonnull String paramName, @Nullable String defaultValue) {
        return defaultValue == null ? null : RefMacroParameterConverter.mapEntry(paramName, defaultValue);
    }

    @Nullable
    protected static Map.Entry<String, String> mapHeightParam(@Nonnull String paramName, @Nonnull String paramValue) {
        return RefMacroParameterConverter.mapSizeParam(paramName, paramValue, "600");
    }

    @Nullable
    protected static Map.Entry<String, String> mapWidthParam(@Nonnull String paramName, @Nonnull String paramValue) {
        return RefMacroParameterConverter.mapSizeParam(paramName, paramValue, null);
    }

    @Nullable
    protected static Map.Entry<String, String> mapSizeParam(@Nonnull String paramName, @Nullable String paramValue, @Nullable String defaultValue) {
        if (paramValue == null || paramValue.length() == 0 || paramValue.endsWith("%")) {
            return RefMacroParameterConverter.mapEntryDefaultValue(paramName, defaultValue);
        }
        if (paramValue.endsWith("px")) {
            String newParamValue = paramValue.substring(0, paramValue.length() - 2);
            return RefMacroParameterConverter.mapSizeParam(paramName, newParamValue, defaultValue);
        }
        try {
            int parsedParamValue = Integer.parseInt(paramValue);
            if (parsedParamValue <= 100) {
                return RefMacroParameterConverter.mapEntryDefaultValue(paramName, defaultValue);
            }
        }
        catch (NumberFormatException e) {
            return RefMacroParameterConverter.mapEntryDefaultValue(paramName, defaultValue);
        }
        return RefMacroParameterConverter.mapEntry(paramName, paramValue);
    }
}

