/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.apis.imgur.ImgurOAuthService;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.ParameterList;
import java.io.OutputStream;
import java.util.Map;

public class ImgurApi
extends DefaultApi20 {
    protected ImgurApi() {
    }

    public static ImgurApi instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public String getAccessTokenEndpoint() {
        return "https://api.imgur.com/oauth2/token";
    }

    @Override
    public String getAuthorizationUrl(String responseType, String apiKey, String callback, String scope, String state, Map<String, String> additionalParams) {
        ParameterList parameters = new ParameterList(additionalParams);
        parameters.add("response_type", ImgurApi.isOob(callback) ? "pin" : "code");
        parameters.add("client_id", apiKey);
        if (callback != null) {
            parameters.add("redirect_uri", callback);
        }
        if (scope != null) {
            parameters.add("scope", scope);
        }
        if (state != null) {
            parameters.add("state", state);
        }
        return parameters.appendTo("https://api.imgur.com/oauth2/authorize");
    }

    @Override
    protected String getAuthorizationBaseUrl() {
        throw new UnsupportedOperationException("use getAuthorizationUrl instead");
    }

    @Override
    public ImgurOAuthService createService(String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new ImgurOAuthService(this, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    public static boolean isOob(String callback) {
        return "oob".equals(callback);
    }

    private static class InstanceHolder {
        private static final ImgurApi INSTANCE = new ImgurApi();

        private InstanceHolder() {
        }
    }
}

