var AP = (function () {
  'use strict';

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf(subClass, superClass);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct.bind();
    } else {
      _construct = function _construct(Parent, args, Class) {
        var a = [null];
        a.push.apply(a, args);
        var Constructor = Function.bind.apply(Parent, a);
        var instance = new Constructor();
        if (Class) _setPrototypeOf(instance, Class.prototype);
        return instance;
      };
    }
    return _construct.apply(null, arguments);
  }

  var LOG_PREFIX = "[Simple-XDM] ";
  var nativeBind = Function.prototype.bind;
  var util = {
    locationOrigin: function locationOrigin() {
      if (!window.location.origin) {
        return window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '');
      } else {
        return window.location.origin;
      }
    },
    randomString: function randomString() {
      return Math.floor(Math.random() * 1000000000).toString(16);
    },
    isString: function isString(str) {
      return typeof str === "string" || str instanceof String;
    },
    argumentsToArray: function argumentsToArray(arrayLike) {
      return Array.prototype.slice.call(arrayLike);
    },
    argumentNames: function argumentNames(fn) {
      return fn.toString().replace(/((\/\/.*$)|(\/\*[^]*?\*\/))/mg, '') // strip comments
      .replace(/[^(]+\(([^)]*)[^]+/, '$1') // get signature
      .match(/([^\s,]+)/g) || [];
    },
    hasCallback: function hasCallback(args) {
      var length = args.length;
      return length > 0 && typeof args[length - 1] === 'function';
    },
    error: function error(msg) {
      if (window.console && window.console.error) {
        var outputError = [];
        if (typeof msg === "string") {
          outputError.push(LOG_PREFIX + msg);
          outputError = outputError.concat(Array.prototype.slice.call(arguments, 1));
        } else {
          outputError.push(LOG_PREFIX);
          outputError = outputError.concat(Array.prototype.slice.call(arguments));
        }
        window.console.error.apply(null, outputError);
      }
    },
    warn: function warn(msg) {
      if (window.console) {
        console.warn(LOG_PREFIX + msg);
      }
    },
    log: function log(msg) {
      if (window.console) {
        window.console.log(LOG_PREFIX + msg);
      }
    },
    _bind: function _bind(thisp, fn) {
      if (nativeBind && fn.bind === nativeBind) {
        return fn.bind(thisp);
      }
      return function () {
        return fn.apply(thisp, arguments);
      };
    },
    throttle: function throttle(func, wait, context) {
      var previous = 0;
      return function () {
        var now = Date.now();
        if (now - previous > wait) {
          previous = now;
          func.apply(context, arguments);
        }
      };
    },
    each: function each(list, iteratee) {
      var length;
      var key;
      if (list) {
        length = list.length;
        if (length != null && typeof list !== 'function') {
          key = 0;
          while (key < length) {
            if (iteratee.call(list[key], key, list[key]) === false) {
              break;
            }
            key += 1;
          }
        } else {
          for (key in list) {
            if (list.hasOwnProperty(key)) {
              if (iteratee.call(list[key], key, list[key]) === false) {
                break;
              }
            }
          }
        }
      }
    },
    extend: function extend(dest) {
      var args = arguments;
      var srcs = [].slice.call(args, 1, args.length);
      srcs.forEach(function (source) {
        if (typeof source === "object") {
          Object.getOwnPropertyNames(source).forEach(function (name) {
            dest[name] = source[name];
          });
        }
      });
      return dest;
    },
    sanitizeStructuredClone: function sanitizeStructuredClone(object) {
      var whiteList = [Boolean, String, Date, RegExp, Blob, File, FileList, ArrayBuffer];
      var blackList = [Error, Node];
      var warn = util.warn;
      var visitedObjects = [];
      function _clone(value) {
        if (typeof value === 'function') {
          warn("A function was detected and removed from the message.");
          return null;
        }
        if (blackList.some(function (t) {
          if (value instanceof t) {
            warn(t.name + " object was detected and removed from the message.");
            return true;
          }
          return false;
        })) {
          return {};
        }
        if (value && typeof value === 'object' && whiteList.every(function (t) {
          return !(value instanceof t);
        })) {
          var newValue;
          if (Array.isArray(value)) {
            newValue = value.map(function (element) {
              return _clone(element);
            });
          } else {
            if (visitedObjects.indexOf(value) > -1) {
              warn("A circular reference was detected and removed from the message.");
              return null;
            }
            visitedObjects.push(value);
            newValue = {};
            for (var name in value) {
              if (value.hasOwnProperty(name)) {
                var clonedValue = _clone(value[name]);
                if (clonedValue !== null) {
                  newValue[name] = clonedValue;
                }
              }
            }
            visitedObjects.pop();
          }
          return newValue;
        }
        return value;
      }
      return _clone(object);
    },
    getOrigin: function getOrigin(url, base) {
      // everything except IE11
      if (typeof URL === 'function') {
        try {
          return new URL(url, base).origin;
        } catch (e) {}
      }
      // ie11 + safari 10
      var doc = document.implementation.createHTMLDocument('');
      if (base) {
        var baseElement = doc.createElement('base');
        baseElement.href = base;
        doc.head.appendChild(baseElement);
      }
      var anchorElement = doc.createElement('a');
      anchorElement.href = url;
      doc.body.appendChild(anchorElement);
      var origin = anchorElement.protocol + '//' + anchorElement.hostname;
      //ie11, only include port if referenced in initial URL
      if (url.match(/\/\/[^/]+:[0-9]+\//)) {
        origin += anchorElement.port ? ':' + anchorElement.port : '';
      }
      return origin;
    }
  };

  var PostMessage = /*#__PURE__*/function () {
    function PostMessage(data) {
      var d = data || {};
      this._registerListener(d.listenOn);
    }
    var _proto = PostMessage.prototype;
    _proto._registerListener = function _registerListener(listenOn) {
      if (!listenOn || !listenOn.addEventListener) {
        listenOn = window;
      }
      listenOn.addEventListener("message", util._bind(this, this._receiveMessage), false);
    };
    _proto._receiveMessage = function _receiveMessage(event) {
      var handler = this._messageHandlers[event.data.type],
        extensionId = event.data.eid,
        reg;
      if (extensionId && this._registeredExtensions) {
        reg = this._registeredExtensions[extensionId];
      }
      if (!handler || !this._checkOrigin(event, reg)) {
        return false;
      }
      handler.call(this, event, reg);
    };
    return PostMessage;
  }();

  var VALID_EVENT_TIME_MS = 30000; //30 seconds
  var XDMRPC = /*#__PURE__*/function (_PostMessage) {
    _inheritsLoose(XDMRPC, _PostMessage);
    var _proto = XDMRPC.prototype;
    _proto._padUndefinedArguments = function _padUndefinedArguments(array, length) {
      return array.length >= length ? array : array.concat(new Array(length - array.length));
    };
    function XDMRPC(config) {
      var _this;
      config = config || {};
      _this = _PostMessage.call(this, config) || this;
      _this._registeredExtensions = config.extensions || {};
      _this._registeredAPIModules = {};
      _this._registeredAPIModules._globals = {};
      _this._pendingCallbacks = {};
      _this._keycodeCallbacks = {};
      _this._clickHandler = null;
      _this._pendingEvents = {};
      _this._messageHandlers = {
        init: _this._handleInit,
        req: _this._handleRequest,
        resp: _this._handleResponse,
        broadcast: _this._handleBroadcast,
        event_query: _this._handleEventQuery,
        key_triggered: _this._handleKeyTriggered,
        addon_clicked: _this._handleAddonClick,
        get_host_offset: _this._getHostOffset,
        unload: _this._handleUnload,
        sub: _this._handleSubInit
      };
      return _this;
    }
    _proto._verifyAPI = function _verifyAPI(event, reg) {
      var untrustedTargets = event.data.targets;
      if (!untrustedTargets) {
        return;
      }
      var trustedSpec = this.getApiSpec();
      var tampered = false;
      function check(trusted, untrusted) {
        Object.getOwnPropertyNames(untrusted).forEach(function (name) {
          if (typeof untrusted[name] === 'object' && trusted[name]) {
            check(trusted[name], untrusted[name]);
          } else {
            if (untrusted[name] === 'parent' && trusted[name]) {
              tampered = true;
            }
          }
        });
      }
      check(trustedSpec, untrustedTargets);
      event.source.postMessage({
        type: 'api_tamper',
        tampered: tampered
      }, reg.extension.url);
    };
    _proto._handleInit = function _handleInit(event, reg) {
      event.source.postMessage({
        type: 'init_received'
      }, reg.extension.url);
      this._registeredExtensions[reg.extension_id].source = event.source;
      if (reg.initCallback) {
        reg.initCallback(event.data.eid);
        delete reg.initCallback;
      }
      if (event.data.targets) {
        this._verifyAPI(event, reg);
      }
    }
    // postMessage method to do registerExtension
    ;
    _proto._handleSubInit = function _handleSubInit(event, reg) {
      var blocked = reg.extension.options.noSub || this._getBooleanFeatureFlag && this._getBooleanFeatureFlag('com.atlassian.connect.resolve_inner_iframe_url');
      var data = event.data;
      if (blocked) {
        util.error("Sub-Extension requested by [" + reg.extension.addon_key + "] but feature is disabled");
      } else {
        this.registerExtension(data.ext.id, {
          extension: data.ext
        });
      }
      if (this._registeredRequestNotifier) {
        this._registeredRequestNotifier.call(null, {
          sub: data.ext,
          type: data.type,
          addon_key: reg.extension.addon_key,
          key: reg.extension.key,
          extension_id: reg.extension_id,
          blocked: blocked
        });
      }
    };
    _proto._getHostOffset = function _getHostOffset(event, _window) {
      var hostWindow = event.source;
      var hostFrameOffset = null;
      var windowReference = _window || window; // For testing

      if (windowReference === windowReference.top && typeof windowReference.getHostOffsetFunctionOverride === 'function') {
        hostFrameOffset = windowReference.getHostOffsetFunctionOverride(hostWindow);
      }
      if (typeof hostFrameOffset !== 'number') {
        hostFrameOffset = 0;
        // Find the closest frame that has the same origin as event source
        while (!this._hasSameOrigin(hostWindow)) {
          // Climb up the iframe tree 1 layer
          hostFrameOffset++;
          hostWindow = hostWindow.parent;
        }
      }
      event.source.postMessage({
        hostFrameOffset: hostFrameOffset
      }, event.origin);
    };
    _proto._hasSameOrigin = function _hasSameOrigin(window) {
      if (window === window.top) {
        return true;
      }
      try {
        // Try set & read a variable on the given window
        // If we can successfully read the value then it means the given window has the same origin
        // as the window that is currently executing the script
        var testVariableName = 'test_var_' + Math.random().toString(16).substr(2);
        window[testVariableName] = true;
        return window[testVariableName];
      } catch (e) {
        // A exception will be thrown if the windows doesn't have the same origin
      }
      return false;
    };
    _proto._handleResponse = function _handleResponse(event) {
      var data = event.data;
      var pendingCallback = this._pendingCallbacks[data.mid];
      if (pendingCallback) {
        delete this._pendingCallbacks[data.mid];
        pendingCallback.apply(window, data.args);
      }
    };
    _proto.registerRequestNotifier = function registerRequestNotifier(cb) {
      this._registeredRequestNotifier = cb;
    };
    _proto._handleRequest = function _handleRequest(event, reg) {
      function sendResponse() {
        var args = util.sanitizeStructuredClone(util.argumentsToArray(arguments));
        event.source.postMessage({
          mid: event.data.mid,
          type: 'resp',
          forPlugin: true,
          args: args
        }, reg.extension.url);
      }
      var data = event.data;
      var module = this._registeredAPIModules[data.mod];
      var extension = this.getRegisteredExtensions(reg.extension)[0];
      if (module) {
        var fnName = data.fn;
        if (data._cls) {
          var Cls = module[data._cls];
          var ns = data.mod + '-' + data._cls + '-';
          sendResponse._id = data._id;
          if (fnName === 'constructor') {
            if (!Cls._construct) {
              Cls.constructor.prototype._destroy = function () {
                delete this._context._proxies[ns + this._id];
              };
              Cls._construct = function () {
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                  args[_key] = arguments[_key];
                }
                var inst = _construct(Cls.constructor, args);
                var callback = args[args.length - 1];
                inst._id = callback._id;
                inst._context = callback._context;
                inst._context._proxies[ns + inst._id] = inst;
                return inst;
              };
            }
            module = Cls;
            fnName = '_construct';
          } else {
            module = extension._proxies[ns + data._id];
          }
        }
        var method = module[fnName];
        if (method) {
          var methodArgs = data.args;
          var padLength = method.length - 1;
          if (fnName === '_construct') {
            padLength = module.constructor.length - 1;
          }
          sendResponse._context = extension;
          methodArgs = this._padUndefinedArguments(methodArgs, padLength);
          methodArgs.push(sendResponse);
          var promiseResult = method.apply(module, methodArgs);
          if (method.returnsPromise) {
            if (!(typeof promiseResult === 'object' || typeof promiseResult === 'function') || typeof promiseResult.then !== 'function') {
              sendResponse('Defined module method did not return a promise.');
            } else {
              promiseResult.then(function (result) {
                sendResponse(undefined, result);
              }).catch(function (err) {
                err = err instanceof Error ? err.message : err;
                sendResponse(err);
              });
            }
          }
          if (this._registeredRequestNotifier) {
            this._registeredRequestNotifier.call(null, {
              module: data.mod,
              fn: data.fn,
              type: data.type,
              addon_key: reg.extension.addon_key,
              key: reg.extension.key,
              extension_id: reg.extension_id
            });
          }
        }
      }
    };
    _proto._handleBroadcast = function _handleBroadcast(event, reg) {
      var event_data = event.data;
      var targetSpec = function targetSpec(r) {
        return r.extension.addon_key === reg.extension.addon_key && r.extension_id !== reg.extension_id;
      };
      this.dispatch(event_data.etyp, targetSpec, event_data.evnt, null, null);
    };
    _proto._handleKeyTriggered = function _handleKeyTriggered(event, reg) {
      var eventData = event.data;
      var keycodeEntry = this._keycodeKey(eventData.keycode, eventData.modifiers, reg.extension_id);
      var listeners = this._keycodeCallbacks[keycodeEntry];
      if (listeners) {
        listeners.forEach(function (listener) {
          listener.call(null, {
            addon_key: reg.extension.addon_key,
            key: reg.extension.key,
            extension_id: reg.extension_id,
            keycode: eventData.keycode,
            modifiers: eventData.modifiers
          });
        }, this);
      }
    };
    _proto.defineAPIModule = function defineAPIModule(module, moduleName) {
      moduleName = moduleName || '_globals';
      this._registeredAPIModules[moduleName] = util.extend({}, this._registeredAPIModules[moduleName] || {}, module);
      return this._registeredAPIModules;
    };
    _proto.isAPIModuleDefined = function isAPIModuleDefined(moduleName) {
      return typeof this._registeredAPIModules[moduleName] !== 'undefined';
    };
    _proto._pendingEventKey = function _pendingEventKey(targetSpec, time) {
      var key = targetSpec.addon_key || 'global';
      if (targetSpec.key) {
        key = key + "@@" + targetSpec.key;
      }
      key = key + "@@" + time;
      return key;
    };
    _proto.queueEvent = function queueEvent(type, targetSpec, event, callback) {
      var loaded_frame,
        targets = this._findRegistrations(targetSpec);
      loaded_frame = targets.some(function (target) {
        return target.registered_events !== undefined;
      }, this);
      if (loaded_frame) {
        this.dispatch(type, targetSpec, event, callback);
      } else {
        this._cleanupInvalidEvents();
        var time = new Date().getTime();
        this._pendingEvents[this._pendingEventKey(targetSpec, time)] = {
          type: type,
          targetSpec: targetSpec,
          event: event,
          callback: callback,
          time: time,
          uid: util.randomString()
        };
      }
    };
    _proto._cleanupInvalidEvents = function _cleanupInvalidEvents() {
      var _this2 = this;
      var now = new Date().getTime();
      var keys = Object.keys(this._pendingEvents);
      keys.forEach(function (index) {
        var element = _this2._pendingEvents[index];
        var eventIsValid = now - element.time <= VALID_EVENT_TIME_MS;
        if (!eventIsValid) {
          delete _this2._pendingEvents[index];
        }
      });
    };
    _proto._handleEventQuery = function _handleEventQuery(message, extension) {
      var _this3 = this;
      var executed = {};
      var now = new Date().getTime();
      var keys = Object.keys(this._pendingEvents);
      keys.forEach(function (index) {
        var element = _this3._pendingEvents[index];
        var eventIsValid = now - element.time <= VALID_EVENT_TIME_MS;
        var isSameTarget = !element.targetSpec || _this3._findRegistrations(element.targetSpec).length !== 0;
        if (isSameTarget && element.targetSpec.key) {
          isSameTarget = element.targetSpec.addon_key === extension.extension.addon_key && element.targetSpec.key === extension.extension.key;
        }
        if (eventIsValid && isSameTarget) {
          executed[index] = element;
          element.targetSpec = element.targetSpec || {};
          _this3.dispatch(element.type, element.targetSpec, element.event, element.callback, message.source);
        } else if (!eventIsValid) {
          delete _this3._pendingEvents[index];
        }
      });
      this._registeredExtensions[extension.extension_id].registered_events = message.data.args;
      return executed;
    };
    _proto._handleUnload = function _handleUnload(event, reg) {
      if (!reg) {
        return;
      }
      if (reg.extension_id && this._registeredExtensions[reg.extension_id]) {
        delete this._registeredExtensions[reg.extension_id].source;
      }
      if (reg.unloadCallback) {
        reg.unloadCallback(event.data.eid);
      }
    };
    _proto.dispatch = function dispatch(type, targetSpec, event, callback, source) {
      function sendEvent(reg, evnt) {
        if (reg.source && reg.source.postMessage) {
          var mid;
          if (callback) {
            mid = util.randomString();
            this._pendingCallbacks[mid] = callback;
          }
          reg.source.postMessage({
            type: 'evt',
            mid: mid,
            etyp: type,
            evnt: evnt
          }, reg.extension.url);
        }
      }
      var registrations = this._findRegistrations(targetSpec || {});
      registrations.forEach(function (reg) {
        if (source && !reg.source) {
          reg.source = source;
        }
        if (reg.source) {
          util._bind(this, sendEvent)(reg, event);
        }
      }, this);
    };
    _proto._findRegistrations = function _findRegistrations(targetSpec) {
      var _this4 = this;
      if (this._registeredExtensions.length === 0) {
        util.error('no registered extensions', this._registeredExtensions);
        return [];
      }
      var keys = Object.getOwnPropertyNames(targetSpec);
      var registrations = Object.getOwnPropertyNames(this._registeredExtensions).map(function (key) {
        return _this4._registeredExtensions[key];
      });
      if (targetSpec instanceof Function) {
        return registrations.filter(targetSpec);
      } else {
        return registrations.filter(function (reg) {
          return keys.every(function (key) {
            return reg.extension[key] === targetSpec[key];
          });
        });
      }
    };
    _proto.registerExtension = function registerExtension(extension_id, data) {
      data._proxies = {};
      data.extension_id = extension_id;
      this._registeredExtensions[extension_id] = data;
    };
    _proto._keycodeKey = function _keycodeKey(key, modifiers, extension_id) {
      var code = key;
      if (modifiers) {
        if (typeof modifiers === "string") {
          modifiers = [modifiers];
        }
        modifiers.sort();
        modifiers.forEach(function (modifier) {
          code += '$$' + modifier;
        }, this);
      }
      return code + '__' + extension_id;
    };
    _proto.registerKeyListener = function registerKeyListener(extension_id, key, modifiers, callback) {
      if (typeof modifiers === "string") {
        modifiers = [modifiers];
      }
      var reg = this._registeredExtensions[extension_id];
      var keycodeEntry = this._keycodeKey(key, modifiers, extension_id);
      if (!this._keycodeCallbacks[keycodeEntry]) {
        this._keycodeCallbacks[keycodeEntry] = [];
        reg.source.postMessage({
          type: 'key_listen',
          keycode: key,
          modifiers: modifiers,
          action: 'add'
        }, reg.extension.url);
      }
      this._keycodeCallbacks[keycodeEntry].push(callback);
    };
    _proto.unregisterKeyListener = function unregisterKeyListener(extension_id, key, modifiers, callback) {
      var keycodeEntry = this._keycodeKey(key, modifiers, extension_id);
      var potentialCallbacks = this._keycodeCallbacks[keycodeEntry];
      var reg = this._registeredExtensions[extension_id];
      if (potentialCallbacks) {
        if (callback) {
          var index = potentialCallbacks.indexOf(callback);
          this._keycodeCallbacks[keycodeEntry].splice(index, 1);
        } else {
          delete this._keycodeCallbacks[keycodeEntry];
        }
        if (reg.source && reg.source.postMessage) {
          reg.source.postMessage({
            type: 'key_listen',
            keycode: key,
            modifiers: modifiers,
            action: 'remove'
          }, reg.extension.url);
        }
      }
    };
    _proto.registerClickHandler = function registerClickHandler(callback) {
      if (typeof callback !== 'function') {
        throw new Error('callback must be a function');
      }
      if (this._clickHandler !== null) {
        throw new Error('ClickHandler already registered');
      }
      this._clickHandler = callback;
    };
    _proto._handleAddonClick = function _handleAddonClick(event, reg) {
      if (typeof this._clickHandler === 'function') {
        this._clickHandler({
          addon_key: reg.extension.addon_key,
          key: reg.extension.key,
          extension_id: reg.extension_id
        });
      }
    };
    _proto.unregisterClickHandler = function unregisterClickHandler() {
      this._clickHandler = null;
    };
    _proto.getApiSpec = function getApiSpec(addonKey) {
      var _this5 = this;
      function getModuleDefinition(mod) {
        return Object.getOwnPropertyNames(mod).reduce(function (accumulator, memberName) {
          var member = mod[memberName];
          switch (typeof member) {
            case 'function':
              accumulator[memberName] = {
                args: util.argumentNames(member),
                returnsPromise: member.returnsPromise || false
              };
              break;
            case 'object':
              if (member.hasOwnProperty('constructor')) {
                accumulator[memberName] = getModuleDefinition(member);
              }
              break;
          }
          return accumulator;
        }, {});
      }
      return Object.getOwnPropertyNames(this._registeredAPIModules).reduce(function (accumulator, moduleName) {
        var module = _this5._registeredAPIModules[moduleName];
        if (typeof module.addonKey === 'undefined' || module.addonKey === addonKey) {
          accumulator[moduleName] = getModuleDefinition(module);
        }
        return accumulator;
      }, {});
    };
    _proto._originEqual = function _originEqual(url, origin) {
      function strCheck(str) {
        return typeof str === 'string' && str.length > 0;
      }
      var urlOrigin = util.getOrigin(url);
      // check strings are strings and they contain something
      if (!strCheck(url) || !strCheck(origin) || !strCheck(urlOrigin)) {
        return false;
      }
      return origin === urlOrigin;
    }

    // validate origin of postMessage
    ;
    _proto._checkOrigin = function _checkOrigin(event, reg) {
      var no_source_types = ['init'];
      var isNoSourceType = reg && !reg.source && no_source_types.indexOf(event.data.type) > -1;
      var sourceTypeMatches = reg && event.source === reg.source;
      var hasExtensionUrl = reg && this._originEqual(reg.extension.url, event.origin);
      var isValidOrigin = hasExtensionUrl && (isNoSourceType || sourceTypeMatches);

      // get_host_offset fires before init
      if (event.data.type === 'get_host_offset' && window === window.top) {
        isValidOrigin = true;
      }

      // check undefined for chromium (Issue 395010)
      if (event.data.type === 'unload' && (sourceTypeMatches || event.source === undefined)) {
        isValidOrigin = true;
      }
      return isValidOrigin;
    };
    _proto.getRegisteredExtensions = function getRegisteredExtensions(filter) {
      if (filter) {
        return this._findRegistrations(filter);
      }
      return this._registeredExtensions;
    };
    _proto.unregisterExtension = function unregisterExtension(filter) {
      var registrations = this._findRegistrations(filter);
      if (registrations.length !== 0) {
        registrations.forEach(function (registration) {
          var _this6 = this;
          var keys = Object.keys(this._pendingEvents);
          keys.forEach(function (index) {
            var element = _this6._pendingEvents[index];
            var targetSpec = element.targetSpec || {};
            if (targetSpec.addon_key === registration.extension.addon_key && targetSpec.key === registration.extension.key) {
              delete _this6._pendingEvents[index];
            }
          });
          delete this._registeredExtensions[registration.extension_id];
        }, this);
      }
    };
    _proto.setFeatureFlagGetter = function setFeatureFlagGetter(getBooleanFeatureFlag) {
      this._getBooleanFeatureFlag = getBooleanFeatureFlag;
    };
    return XDMRPC;
  }(PostMessage);

  var Connect = /*#__PURE__*/function () {
    function Connect() {
      this._xdm = new XDMRPC();
    }

    /**
     * Send a message to iframes matching the targetSpec. This message is added to
     *  a message queue for delivery to ensure the message is received if an iframe
     *  has not yet loaded
     *
     * @param type The name of the event type
     * @param targetSpec The spec to match against extensions when sending this event
     * @param event The event payload
     * @param callback A callback to be executed when the remote iframe calls its callback
     */
    var _proto = Connect.prototype;
    _proto.dispatch = function dispatch(type, targetSpec, event, callback) {
      this._xdm.queueEvent(type, targetSpec, event, callback);
      return this.getExtensions(targetSpec);
    }

    /**
     * Send a message to iframes matching the targetSpec immediately. This message will
     *  only be sent to iframes that are already open, and will not be delivered if none
     *  are currently open.
     *
     * @param type The name of the event type
     * @param targetSpec The spec to match against extensions when sending this event
     * @param event The event payload
     */;
    _proto.broadcast = function broadcast(type, targetSpec, event) {
      this._xdm.dispatch(type, targetSpec, event, null, null);
      return this.getExtensions(targetSpec);
    };
    _proto._createId = function _createId(extension) {
      if (!extension.addon_key || !extension.key) {
        throw Error('Extensions require addon_key and key');
      }
      return extension.addon_key + '__' + extension.key + '__' + util.randomString();
    }
    /**
    * Creates a new iframed module, without actually creating the DOM element.
    * The iframe attributes are passed to the 'setupCallback', which is responsible for creating
    * the DOM element and returning the window reference.
    *
    * @param extension The extension definition. Example:
    *   {
    *     addon_key: 'my-addon',
    *     key: 'my-module',
    *     url: 'https://example.com/my-module',
    *     options: {
    *         autoresize: false,
    *         hostOrigin: 'https://connect-host.example.com/'
    *     }
    *   }
    *
    * @param initCallback The optional initCallback is called when the bridge between host and iframe is established.
    **/;
    _proto.create = function create(extension, initCallback, unloadCallback) {
      var extension_id = this.registerExtension(extension, initCallback, unloadCallback);
      var options = extension.options || {};
      var data = {
        extension_id: extension_id,
        api: this._xdm.getApiSpec(extension.addon_key),
        origin: util.locationOrigin(),
        options: options
      };
      return {
        id: extension_id,
        name: JSON.stringify(data),
        src: extension.url
      };
    };
    _proto.registerRequestNotifier = function registerRequestNotifier(callback) {
      this._xdm.registerRequestNotifier(callback);
    };
    _proto.registerExtension = function registerExtension(extension, initCallback, unloadCallback) {
      var extension_id = this._createId(extension);
      this._xdm.registerExtension(extension_id, {
        extension: extension,
        initCallback: initCallback,
        unloadCallback: unloadCallback
      });
      return extension_id;
    };
    _proto.registerKeyListener = function registerKeyListener(extension_id, key, modifiers, callback) {
      this._xdm.registerKeyListener(extension_id, key, modifiers, callback);
    };
    _proto.unregisterKeyListener = function unregisterKeyListener(extension_id, key, modifiers, callback) {
      this._xdm.unregisterKeyListener(extension_id, key, modifiers, callback);
    };
    _proto.registerClickHandler = function registerClickHandler(callback) {
      this._xdm.registerClickHandler(callback);
    };
    _proto.unregisterClickHandler = function unregisterClickHandler() {
      this._xdm.unregisterClickHandler();
    };
    _proto.defineModule = function defineModule(moduleName, module, options) {
      this._xdm.defineAPIModule(module, moduleName, options);
    };
    _proto.isModuleDefined = function isModuleDefined(moduleName) {
      return this._xdm.isAPIModuleDefined(moduleName);
    };
    _proto.defineGlobals = function defineGlobals(module) {
      this._xdm.defineAPIModule(module);
    };
    _proto.getExtensions = function getExtensions(filter) {
      return this._xdm.getRegisteredExtensions(filter);
    };
    _proto.unregisterExtension = function unregisterExtension(filter) {
      return this._xdm.unregisterExtension(filter);
    };
    _proto.returnsPromise = function returnsPromise(wrappedMethod) {
      wrappedMethod.returnsPromise = true;
    };
    _proto.setFeatureFlagGetter = function setFeatureFlagGetter(getBooleanFeatureFlag) {
      this._xdm.setFeatureFlagGetter(getBooleanFeatureFlag);
    };
    _proto.registerExistingExtension = function registerExistingExtension(extension_id, data) {
      return this._xdm.registerExtension(extension_id, data);
    };
    return Connect;
  }();

  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }

  var _each$1 = util.each,
    document$2 = window.document;
  function $$2(sel, context) {
    context = context || document$2;
    var els = [];
    if (sel) {
      if (typeof sel === 'string') {
        var results = context.querySelectorAll(sel),
          arr_results = Array.prototype.slice.call(results);
        Array.prototype.push.apply(els, arr_results);
      } else if (sel.nodeType === 1) {
        els.push(sel);
      } else if (sel === window) {
        els.push(sel);
      } else if (typeof sel === 'function') {
        $$2.onDomLoad(sel);
      }
    }
    util.extend(els, {
      each: function each(it) {
        _each$1(this, it);
        return this;
      },
      bind: function bind(name, callback) {
        this.each(function (i, el) {
          this.bind(el, name, callback);
        });
      },
      attr: function attr(k) {
        var v;
        this.each(function (i, el) {
          v = el[k] || el.getAttribute && el.getAttribute(k);
          return !v;
        });
        return v;
      },
      removeClass: function removeClass(className) {
        return this.each(function (i, el) {
          if (el.className) {
            el.className = el.className.replace(new RegExp('(^|\\s)' + className + '(\\s|$)'), ' ');
          }
        });
      },
      html: function html(_html) {
        return this.each(function (i, el) {
          el.innerHTML = _html;
        });
      },
      append: function append(spec) {
        return this.each(function (i, to) {
          var el = context.createElement(spec.tag);
          _each$1(spec, function (k, v) {
            if (k === '$text') {
              if (el.styleSheet) {
                // style tags in ie
                el.styleSheet.cssText = v;
              } else {
                el.appendChild(context.createTextNode(v));
              }
            } else if (k !== 'tag') {
              el[k] = v;
            }
          });
          to.appendChild(el);
        });
      }
    });
    return els;
  }
  function binder$1(std, odd) {
    std += 'EventListener';
    odd += 'Event';
    return function (el, e, fn) {
      if (el[std]) {
        el[std](e, fn, false);
      } else if (el[odd]) {
        el[odd]('on' + e, fn);
      }
    };
  }
  $$2.bind = binder$1('add', 'attach');
  $$2.unbind = binder$1('remove', 'detach');
  $$2.onDomLoad = function (func) {
    var w = window,
      readyState = w.document.readyState;
    if (readyState === "complete") {
      func.call(w);
    } else {
      $$2.bind(w, "load", function () {
        func.call(w);
      });
    }
  };

  function getContainer() {
    // Look for these two selectors first... you need these to allow for the auto-shrink to work
    // Otherwise, it'll default to document.body which can't auto-grow or auto-shrink
    var container = $$2('.ac-content, #content');
    return container.length > 0 ? container[0] : document.body;
  }

  /**
  * Extension wide configuration values
  */
  var ConfigurationOptions = /*#__PURE__*/function () {
    function ConfigurationOptions() {
      this.options = {};
    }
    var _proto = ConfigurationOptions.prototype;
    _proto._flush = function _flush() {
      this.options = {};
    };
    _proto.get = function get(item) {
      return item ? this.options[item] : this.options;
    };
    _proto.set = function set(data, value) {
      var _this = this;
      if (!data) {
        return;
      }
      if (value) {
        var _data;
        data = (_data = {}, _data[data] = value, _data);
      }
      var keys = Object.getOwnPropertyNames(data);
      keys.forEach(function (key) {
        _this.options[key] = data[key];
      }, this);
    };
    return ConfigurationOptions;
  }();
  var ConfigurationOptions$1 = new ConfigurationOptions();

  var size = function size(width, height, container) {
    var verticalScrollbarWidth = function verticalScrollbarWidth() {
      var sbWidth = window.innerWidth - container.clientWidth;
      // sanity check only
      sbWidth = sbWidth < 0 ? 0 : sbWidth;
      sbWidth = sbWidth > 50 ? 50 : sbWidth;
      return sbWidth;
    };
    var horizontalScrollbarHeight = function horizontalScrollbarHeight() {
      var sbHeight = window.innerHeight - Math.min(container.clientHeight, document.documentElement.clientHeight);
      // sanity check only
      sbHeight = sbHeight < 0 ? 0 : sbHeight;
      sbHeight = sbHeight > 50 ? 50 : sbHeight;
      return sbHeight;
    };
    var w = width == null ? '100%' : width,
      h,
      docHeight;
    var widthInPx = Boolean(ConfigurationOptions$1.get('widthinpx'));
    container = container || getContainer();
    if (!container) {
      util.warn('size called before container or body appeared, ignoring');
    }
    if (widthInPx && typeof w === "string" && w.search('%') !== -1) {
      w = Math.max(container.scrollWidth, container.offsetWidth, container.clientWidth);
    }
    if (height) {
      h = height;
    } else {
      // Determine height of document element
      docHeight = Math.max(container.scrollHeight, document.documentElement.scrollHeight, container.offsetHeight, document.documentElement.offsetHeight, container.clientHeight, document.documentElement.clientHeight);
      if (container === document.body) {
        h = docHeight;
      } else {
        var computed = window.getComputedStyle(container);
        h = container.getBoundingClientRect().height;
        if (h === 0) {
          h = docHeight;
        } else {
          var additionalProperties = ['margin-top', 'margin-bottom'];
          additionalProperties.forEach(function (property) {
            var floated = parseFloat(computed[property]);
            h += floated;
          });
        }
      }
    }

    // Include iframe scroll bars if visible and using exact dimensions
    w = typeof w === 'number' && Math.min(container.scrollHeight, document.documentElement.scrollHeight) > Math.min(container.clientHeight, document.documentElement.clientHeight) ? w + verticalScrollbarWidth() : w;
    h = typeof h === 'number' && container.scrollWidth > container.clientWidth ? h + horizontalScrollbarHeight() : h;
    return {
      w: w,
      h: h
    };
  };

  function EventQueue() {
    this.q = [];
    this.add = function (ev) {
      this.q.push(ev);
    };
    var i, j;
    this.call = function () {
      for (i = 0, j = this.q.length; i < j; i++) {
        this.q[i].call();
      }
    };
  }
  function attachResizeEvent(element, resized) {
    if (!element.resizedAttached) {
      element.resizedAttached = new EventQueue();
      element.resizedAttached.add(resized);
    } else if (element.resizedAttached) {
      element.resizedAttached.add(resized);
      return;
    }

    // padding / margins on the body causes numerous resizing bugs.
    if (element.nodeName === 'BODY') {
      ['padding', 'margin'].forEach(function (attr) {
        element.style[attr + '-bottom'] = '0px';
        element.style[attr + '-top'] = '0px';
      }, this);
    }
    element.resizeSensor = document.createElement('div');
    element.resizeSensor.className = 'ac-resize-sensor';
    var style = 'position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: scroll; z-index: -1; visibility: hidden;';
    var styleChild = 'position: absolute; left: 0; top: 0;';
    element.resizeSensor.style.cssText = style;
    var expand = document.createElement('div');
    expand.className = "ac-resize-sensor-expand";
    expand.style.cssText = style;
    var expandChild = document.createElement('div');
    expand.appendChild(expandChild);
    expandChild.style.cssText = styleChild;
    var shrink = document.createElement('div');
    shrink.className = "ac-resize-sensor-shrink";
    shrink.style.cssText = style;
    var shrinkChild = document.createElement('div');
    shrink.appendChild(shrinkChild);
    shrinkChild.style.cssText = styleChild + ' width: 200%; height: 200%';
    element.resizeSensor.appendChild(expand);
    element.resizeSensor.appendChild(shrink);
    element.appendChild(element.resizeSensor);

    // https://bugzilla.mozilla.org/show_bug.cgi?id=548397
    // do not set body to relative
    if (element.nodeName !== 'BODY' && window.getComputedStyle && window.getComputedStyle(element).position === 'static') {
      element.style.position = 'relative';
    }
    var lastWidth, lastHeight;
    var reset = function reset() {
      expandChild.style.width = expand.offsetWidth + 10 + 'px';
      expandChild.style.height = expand.offsetHeight + 10 + 'px';
      expand.scrollLeft = expand.scrollWidth;
      expand.scrollTop = expand.scrollHeight;
      shrink.scrollLeft = shrink.scrollWidth;
      shrink.scrollTop = shrink.scrollHeight;
      lastWidth = element.offsetWidth;
      lastHeight = element.offsetHeight;
    };
    reset();
    var changed = function changed() {
      if (element.resizedAttached) {
        element.resizedAttached.call();
      }
    };
    var onScroll = function onScroll() {
      if (element.offsetWidth !== lastWidth || element.offsetHeight !== lastHeight) {
        changed();
      }
      reset();
    };
    expand.addEventListener('scroll', onScroll);
    shrink.addEventListener('scroll', onScroll);
    var observerConfig = {
      attributes: true,
      attributeFilter: ['style']
    };
    var observer = new MutationObserver(onScroll);
    element.resizeObserver = observer;
    observer.observe(element, observerConfig);
  }
  var resizeListener = {
    add: function add(fn) {
      var container = getContainer();
      attachResizeEvent(container, fn);
    },
    remove: function remove() {
      var container = getContainer();
      if (container.resizeSensor) {
        container.resizeObserver.disconnect();
        container.removeChild(container.resizeSensor);
        delete container.resizeSensor;
        delete container.resizedAttached;
      }
    }
  };

  var AutoResizeAction = /*#__PURE__*/function () {
    function AutoResizeAction(callback) {
      this.resizeError = util.throttle(function (msg) {
        console.info(msg);
      }, 1000);
      this.dimensionStores = {
        width: [],
        height: []
      };
      this.callback = callback;
    }
    var _proto = AutoResizeAction.prototype;
    _proto._setVal = function _setVal(val, type, time) {
      this.dimensionStores[type] = this.dimensionStores[type].filter(function (entry) {
        return time - entry.setAt < 400;
      });
      this.dimensionStores[type].push({
        val: parseInt(val, 10),
        setAt: time
      });
    };
    _proto._isFlicker = function _isFlicker(val, type) {
      return this.dimensionStores[type].length >= 5;
    };
    _proto.triggered = function triggered(dimensions) {
      dimensions = dimensions || size();
      var now = Date.now();
      this._setVal(dimensions.w, 'width', now);
      this._setVal(dimensions.h, 'height', now);
      var isFlickerWidth = this._isFlicker(dimensions.w, 'width', now);
      var isFlickerHeight = this._isFlicker(dimensions.h, 'height', now);
      if (isFlickerWidth) {
        dimensions.w = "100%";
        this.resizeError("SIMPLE XDM: auto resize flickering width detected, setting to 100%");
      }
      if (isFlickerHeight) {
        var vals = this.dimensionStores['height'].map(function (x) {
          return x.val;
        });
        dimensions.h = Math.max.apply(null, vals) + 'px';
        this.resizeError("SIMPLE XDM: auto resize flickering height detected, setting to: " + dimensions.h);
      }
      this.callback(dimensions.w, dimensions.h);
    };
    return AutoResizeAction;
  }();

  var ConsumerOptions = /*#__PURE__*/function () {
    function ConsumerOptions() {}
    var _proto = ConsumerOptions.prototype;
    _proto._elementExists = function _elementExists($el) {
      return $el && $el.length === 1;
    };
    _proto._elementOptions = function _elementOptions($el) {
      return $el.attr("data-options");
    };
    _proto._getConsumerOptions = function _getConsumerOptions() {
      var options = {},
        $optionElement = $$2("#ac-iframe-options"),
        $scriptElement = $$2("script[src*='/atlassian-connect/all']"),
        $cdnScriptElement = $$2("script[src*='/connect-cdn.atl-paas.net/all']");
      if (!this._elementExists($optionElement) || !this._elementOptions($optionElement)) {
        if (this._elementExists($scriptElement)) {
          $optionElement = $scriptElement;
        } else if (this._elementExists($cdnScriptElement)) {
          $optionElement = $cdnScriptElement;
        }
      }
      if (this._elementExists($optionElement)) {
        // get its data-options attribute, if any
        var optStr = this._elementOptions($optionElement);
        if (optStr) {
          // if found, parse the value into kv pairs following the format of a style element
          optStr.split(";").forEach(function (nvpair) {
            nvpair = nvpair.trim();
            if (nvpair) {
              var nv = nvpair.split(":"),
                k = nv[0].trim(),
                v = nv[1].trim();
              if (k && v != null) {
                options[k] = v === "true" || v === "false" ? v === "true" : v;
              }
            }
          });
        }
      }
      return options;
    };
    _proto._flush = function _flush() {
      delete this._options;
    };
    _proto.get = function get(key) {
      if (!this._options) {
        this._options = this._getConsumerOptions();
      }
      if (key) {
        return this._options[key];
      }
      return this._options;
    };
    return ConsumerOptions;
  }();
  var consumerOptions = new ConsumerOptions();

  var POSSIBLE_MODIFIER_KEYS = ['ctrl', 'shift', 'alt', 'meta'];
  var AP = /*#__PURE__*/function (_PostMessage) {
    _inheritsLoose(AP, _PostMessage);
    function AP(options, initCheck) {
      var _this;
      if (initCheck === void 0) {
        initCheck = true;
      }
      _this = _PostMessage.call(this) || this;
      ConfigurationOptions$1.set(options);
      _this._data = _this._parseInitData();
      ConfigurationOptions$1.set(_this._data.options);
      _this._data.options = _this._data.options || {};
      _this._hostOrigin = _this._data.options.hostOrigin || '*';
      _this._top = window.top;
      _this._host = window.parent || window;
      _this._topHost = _this._getHostFrame(_this._data.options.hostFrameOffset);
      if (_this._topHost !== _this._top) {
        _this._verifyHostFrameOffset();
      }
      _this._initTimeout = 5000;
      _this._initReceived = false;
      _this._initCheck = initCheck;
      _this._isKeyDownBound = false;
      _this._hostModules = {};
      _this._eventHandlers = {};
      _this._pendingCallbacks = {};
      _this._keyListeners = [];
      _this._version = "5.3.100";
      _this._apiTampered = undefined;
      _this._isSubIframe = _this._topHost !== window.parent;
      _this._onConfirmedFns = [];
      _this._promise = Promise;
      if (_this._data.api) {
        _this._setupAPI(_this._data.api);
        _this._setupAPIWithoutRequire(_this._data.api);
      }
      _this._messageHandlers = {
        init_received: _this._handleInitReceived,
        resp: _this._handleResponse,
        evt: _this._handleEvent,
        key_listen: _this._handleKeyListen,
        api_tamper: _this._handleApiTamper
      };
      if (_this._data.origin) {
        _this._sendInit(_this._host, _this._data.origin);
        if (_this._isSubIframe) {
          _this._sendInit(_this._topHost, _this._hostOrigin);
        }
      }
      _this._registerOnUnload();
      _this.resize = util._bind(_assertThisInitialized(_this), function (width, height) {
        if (!getContainer()) {
          util.warn('resize called before container or body appeared, ignoring');
          return;
        }
        var dimensions = size();
        if (!width) {
          width = dimensions.w;
        }
        if (!height) {
          height = dimensions.h;
        }
        if (_this._hostModules.env && _this._hostModules.env.resize) {
          _this._hostModules.env.resize(width, height);
        }
      });
      $$2(util._bind(_assertThisInitialized(_this), _this._autoResizer));
      _this.container = getContainer;
      _this.size = size;
      window.addEventListener('click', function (e) {
        _this._host.postMessage({
          eid: _this._data.extension_id,
          type: 'addon_clicked'
        }, _this._hostOrigin);
      });
      return _this;
    }
    var _proto = AP.prototype;
    _proto._getHostFrame = function _getHostFrame(offset) {
      // Climb up the iframe tree to find the real host
      if (offset && typeof offset === 'number') {
        var hostFrame = window;
        for (var i = 0; i < offset; i++) {
          hostFrame = hostFrame.parent;
        }
        return hostFrame;
      } else {
        return this._top;
      }
    };
    _proto._verifyHostFrameOffset = function _verifyHostFrameOffset() {
      var _this2 = this;
      // Asynchronously verify the host frame option with this._top
      var callback = function callback(e) {
        if (e.source === _this2._top && e.data && typeof e.data.hostFrameOffset === 'number') {
          window.removeEventListener('message', callback);
          if (_this2._getHostFrame(e.data.hostFrameOffset) !== _this2._topHost) {
            util.error('hostFrameOffset tampering detected, setting host frame to top window');
            _this2._topHost = _this2._top;
          }
        }
      };
      window.addEventListener('message', callback);
      this._top.postMessage({
        type: 'get_host_offset'
      }, this._hostOrigin);
    };
    _proto._handleApiTamper = function _handleApiTamper(event) {
      if (event.data.tampered !== false) {
        this._host = undefined;
        this._apiTampered = true;
        util.error('XDM API tampering detected, api disabled');
      } else {
        this._apiTampered = false;
        this._onConfirmedFns.forEach(function (cb) {
          cb.apply(null);
        });
      }
      this._onConfirmedFns = [];
    };
    _proto._registerOnUnload = function _registerOnUnload() {
      $$2.bind(window, 'unload', util._bind(this, function () {
        this._sendUnload(this._host, this._data.origin);
        if (this._isSubIframe) {
          this._sendUnload(this._topHost, this._hostOrigin);
        }
      }));
    };
    _proto._sendUnload = function _sendUnload(frame, origin) {
      frame.postMessage({
        eid: this._data.extension_id,
        type: 'unload'
      }, origin || '*');
    };
    _proto._bindKeyDown = function _bindKeyDown() {
      if (!this._isKeyDownBound) {
        $$2.bind(window, 'keydown', util._bind(this, this._handleKeyDownDomEvent));
        this._isKeyDownBound = true;
      }
    };
    _proto._autoResizer = function _autoResizer() {
      this._enableAutoResize = Boolean(ConfigurationOptions$1.get('autoresize'));
      if (consumerOptions.get('resize') === false || consumerOptions.get('sizeToParent') === true) {
        this._enableAutoResize = false;
      }
      if (this._enableAutoResize) {
        this._initResize();
      }
    }

    /**
    * The initialization data is passed in when the iframe is created as its 'name' attribute.
    * Example:
    * {
    *   extension_id: The ID of this iframe as defined by the host
    *   origin: 'https://example.org'  // The parent's window origin
    *   api: {
    *     _globals: { ... },
    *     messages = {
    *       clear: {},
    *       ...
    *     },
    *     ...
    *   }
    * }
    **/;
    _proto._parseInitData = function _parseInitData(data) {
      try {
        return JSON.parse(data || window.name);
      } catch (e) {
        return {};
      }
    };
    _proto._findTarget = function _findTarget(moduleName, methodName) {
      return this._data.options && this._data.options.targets && this._data.options.targets[moduleName] && this._data.options.targets[moduleName][methodName] ? this._data.options.targets[moduleName][methodName] : 'top';
    };
    _proto._createModule = function _createModule(moduleName, api) {
      var _this3 = this;
      return Object.getOwnPropertyNames(api).reduce(function (accumulator, memberName) {
        var member = api[memberName];
        if (member.hasOwnProperty('constructor')) {
          accumulator[memberName] = _this3._createProxy(moduleName, member, memberName);
        } else {
          accumulator[memberName] = _this3._createMethodHandler({
            mod: moduleName,
            fn: memberName,
            returnsPromise: member.returnsPromise
          });
        }
        return accumulator;
      }, {});
    };
    _proto._setupAPI = function _setupAPI(api) {
      var _this4 = this;
      this._hostModules = Object.getOwnPropertyNames(api).reduce(function (accumulator, moduleName) {
        accumulator[moduleName] = _this4._createModule(moduleName, api[moduleName], api[moduleName]._options);
        return accumulator;
      }, {});
      Object.getOwnPropertyNames(this._hostModules._globals || {}).forEach(function (global) {
        _this4[global] = _this4._hostModules._globals[global];
      });
    };
    _proto._setupAPIWithoutRequire = function _setupAPIWithoutRequire(api) {
      var _this5 = this;
      Object.getOwnPropertyNames(api).forEach(function (moduleName) {
        if (typeof _this5[moduleName] !== "undefined") {
          throw new Error('XDM module: ' + moduleName + ' will collide with existing variable');
        }
        _this5[moduleName] = _this5._createModule(moduleName, api[moduleName]);
      }, this);
    };
    _proto._pendingCallback = function _pendingCallback(mid, fn, metaData) {
      if (metaData) {
        Object.getOwnPropertyNames(metaData).forEach(function (metaDataName) {
          fn[metaDataName] = metaData[metaDataName];
        });
      }
      this._pendingCallbacks[mid] = fn;
    };
    _proto._createProxy = function _createProxy(moduleName, api, className) {
      var module = this._createModule(moduleName, api);
      function Cls(args) {
        if (!(this instanceof Cls)) {
          return new Cls(arguments);
        }
        this._cls = className;
        this._id = util.randomString();
        module.constructor.apply(this, args);
        return this;
      }
      Object.getOwnPropertyNames(module).forEach(function (methodName) {
        if (methodName !== 'constructor') {
          Cls.prototype[methodName] = module[methodName];
        }
      });
      return Cls;
    };
    _proto._createMethodHandler = function _createMethodHandler(methodData) {
      var that = this;
      return function () {
        var args = util.argumentsToArray(arguments);
        var data = {
          eid: that._data.extension_id,
          type: 'req',
          mod: methodData.mod,
          fn: methodData.fn
        };
        var targetOrigin;
        var target;
        var xdmPromise;
        var mid = util.randomString();
        if (that._findTarget(methodData.mod, methodData.fn) === 'top') {
          target = that._topHost;
          targetOrigin = that._hostOrigin;
        } else {
          target = that._host;
          targetOrigin = that._data.origin;
        }
        if (util.hasCallback(args)) {
          data.mid = mid;
          that._pendingCallback(data.mid, args.pop(), {
            useCallback: true,
            isPromiseMethod: Boolean(methodData.returnsPromise)
          });
        } else if (methodData.returnsPromise) {
          data.mid = mid;
          xdmPromise = new Promise(function (resolve, reject) {
            that._pendingCallback(data.mid, function (err, result) {
              if (err || typeof result === 'undefined' && typeof err === 'undefined') {
                reject(err);
              } else {
                resolve(result);
              }
            }, {
              useCallback: false,
              isPromiseMethod: Boolean(methodData.returnsPromise)
            });
          });
          xdmPromise.catch(function (err) {
            util.warn("Failed promise: " + err);
          });
        }
        if (this && this._cls) {
          data._cls = this._cls;
          data._id = this._id;
        }
        data.args = util.sanitizeStructuredClone(args);
        if (that._isSubIframe && typeof that._apiTampered === 'undefined') {
          that._onConfirmedFns.push(function () {
            target.postMessage(data, targetOrigin);
          });
        } else {
          target.postMessage(data, targetOrigin);
        }
        if (xdmPromise) {
          return xdmPromise;
        }
      };
    };
    _proto._handleResponse = function _handleResponse(event) {
      var data = event.data;
      if (!data.forPlugin) {
        return;
      }
      var pendingCallback = this._pendingCallbacks[data.mid];
      if (pendingCallback) {
        delete this._pendingCallbacks[data.mid];
        try {
          // Promise methods always return error result as first arg
          // If a promise method is invoked using callbacks, strip first arg.
          if (pendingCallback.useCallback && pendingCallback.isPromiseMethod) {
            data.args.shift();
          }
          pendingCallback.apply(window, data.args);
        } catch (e) {
          util.error(e.message, e.stack);
        }
      }
    };
    _proto._handleEvent = function _handleEvent(event) {
      var sendResponse = function sendResponse() {
        var args = util.argumentsToArray(arguments);
        event.source.postMessage({
          eid: this._data.extension_id,
          mid: event.data.mid,
          type: 'resp',
          args: args
        }, this._data.origin);
      };
      var data = event.data;
      sendResponse = util._bind(this, sendResponse);
      sendResponse._context = {
        eventName: data.etyp
      };
      function toArray(handlers) {
        if (handlers) {
          if (!Array.isArray(handlers)) {
            handlers = [handlers];
          }
          return handlers;
        }
        return [];
      }
      var handlers = toArray(this._eventHandlers[data.etyp]);
      handlers = handlers.concat(toArray(this._eventHandlers._any));
      handlers.forEach(function (handler) {
        try {
          handler(data.evnt, sendResponse);
        } catch (e) {
          util.error('exception thrown in event callback for:' + data.etyp);
        }
      }, this);
      if (data.mid) {
        sendResponse();
      }
    };
    _proto._handleKeyDownDomEvent = function _handleKeyDownDomEvent(event) {
      var modifiers = [];
      POSSIBLE_MODIFIER_KEYS.forEach(function (modifierKey) {
        if (event[modifierKey + 'Key']) {
          modifiers.push(modifierKey);
        }
      }, this);
      var keyListenerId = this._keyListenerId(event.keyCode, modifiers);
      var requestedKey = this._keyListeners.indexOf(keyListenerId);
      if (requestedKey >= 0) {
        this._host.postMessage({
          eid: this._data.extension_id,
          keycode: event.keyCode,
          modifiers: modifiers,
          type: 'key_triggered'
        }, this._data.origin);
      }
    };
    _proto._keyListenerId = function _keyListenerId(keycode, modifiers) {
      var keyListenerId = keycode;
      if (modifiers) {
        if (typeof modifiers === "string") {
          modifiers = [modifiers];
        }
        modifiers.sort();
        modifiers.forEach(function (modifier) {
          keyListenerId += '$$' + modifier;
        }, this);
      }
      return keyListenerId;
    };
    _proto._handleKeyListen = function _handleKeyListen(postMessageEvent) {
      var keyListenerId = this._keyListenerId(postMessageEvent.data.keycode, postMessageEvent.data.modifiers);
      if (postMessageEvent.data.action === "remove") {
        var index = this._keyListeners.indexOf(keyListenerId);
        this._keyListeners.splice(index, 1);
      } else if (postMessageEvent.data.action === "add") {
        // only bind onKeyDown once a key is registered.
        this._bindKeyDown();
        this._keyListeners.push(keyListenerId);
      }
    };
    _proto._checkOrigin = function _checkOrigin(event) {
      var no_source_types = ['api_tamper'];
      if (event.data && no_source_types.indexOf(event.data.type) > -1) {
        return true;
      }
      if (this._isSubIframe && event.source === this._topHost) {
        return true;
      }
      return event.origin === this._data.origin && event.source === this._host;
    };
    _proto._handleInitReceived = function _handleInitReceived() {
      this._initReceived = true;
    };
    _proto._sendInit = function _sendInit(frame, origin) {
      var _this6 = this;
      var targets;
      if (frame === this._topHost && this._topHost !== window.parent) {
        targets = ConfigurationOptions$1.get('targets');
      }
      frame.postMessage({
        eid: this._data.extension_id,
        type: 'init',
        targets: targets
      }, origin || '*');
      this._initCheck && this._data.options.globalOptions.check_init && setTimeout(function () {
        if (!_this6._initReceived) {
          throw new Error("Initialization message not received");
        }
      }, this._initTimeout);
    };
    _proto.sendSubCreate = function sendSubCreate(extension_id, options) {
      options.id = extension_id;
      this._topHost.postMessage({
        eid: this._data.extension_id,
        type: 'sub',
        ext: options
      }, this._hostOrigin);
    };
    _proto.broadcast = function broadcast(event, evnt) {
      if (!util.isString(event)) {
        throw new Error("Event type must be string");
      }
      this._host.postMessage({
        eid: this._data.extension_id,
        type: 'broadcast',
        etyp: event,
        evnt: evnt
      }, this._data.origin);
    };
    _proto.require = function require(modules, callback) {
      var _this7 = this;
      var requiredModules = Array.isArray(modules) ? modules : [modules],
        args = requiredModules.map(function (module) {
          return _this7._hostModules[module] || _this7._hostModules._globals[module];
        });
      callback.apply(window, args);
    };
    _proto.register = function register(handlers) {
      if (typeof handlers === "object") {
        this._eventHandlers = _extends({}, this._eventHandlers, handlers) || {};
        this._host.postMessage({
          eid: this._data.extension_id,
          type: 'event_query',
          args: Object.getOwnPropertyNames(handlers)
        }, this._data.origin);
      }
    };
    _proto.registerAny = function registerAny(handlers) {
      this.register({
        '_any': handlers
      });
    };
    _proto._initResize = function _initResize() {
      this.resize();
      var autoresize = new AutoResizeAction(this.resize);
      resizeListener.add(util._bind(autoresize, autoresize.triggered));
    };
    return AP;
  }(PostMessage);

  var Combined = /*#__PURE__*/function (_Host) {
    _inheritsLoose(Combined, _Host);
    function Combined(initCheck) {
      var _this;
      _this = _Host.call(this) || this;
      _this.parentTargets = {
        _globals: {}
      };
      var plugin = new AP(undefined, initCheck);
      // export options from plugin to host.
      Object.getOwnPropertyNames(plugin).forEach(function (prop) {
        if (['_hostModules', '_globals'].indexOf(prop) === -1 && this[prop] === undefined) {
          this[prop] = plugin[prop];
        }
      }, _assertThisInitialized(_this));
      ['registerAny', 'register'].forEach(function (prop) {
        this[prop] = Object.getPrototypeOf(plugin)[prop].bind(plugin);
      }, _assertThisInitialized(_this));

      //write plugin modules to host.
      var moduleSpec = plugin._data.api;
      if (typeof moduleSpec === 'object') {
        Object.getOwnPropertyNames(moduleSpec).forEach(function (moduleName) {
          var accumulator = {};
          Object.getOwnPropertyNames(moduleSpec[moduleName]).forEach(function (methodName) {
            // class proxies
            if (moduleSpec[moduleName][methodName].hasOwnProperty('constructor')) {
              accumulator[methodName] = plugin._hostModules[moduleName][methodName].prototype;
            } else {
              // all other methods
              accumulator[methodName] = plugin._hostModules[moduleName][methodName];
              accumulator[methodName]['returnsPromise'] = moduleSpec[moduleName][methodName]['returnsPromise'] || false;
            }
          }, this);
          this._xdm.defineAPIModule(accumulator, moduleName);
        }, _assertThisInitialized(_this));
      }
      _this._hostModules = plugin._hostModules;
      _this.defineGlobal = function (module) {
        this.parentTargets['_globals'] = util.extend({}, this.parentTargets['_globals'], module);
        this._xdm.defineAPIModule(module);
      };
      _this.defineModule = function (moduleName, module) {
        this._xdm.defineAPIModule(module, moduleName);
        this.parentTargets[moduleName] = {};
        Object.getOwnPropertyNames(module).forEach(function (name) {
          this.parentTargets[moduleName][name] = 'parent';
        }, this);
      };
      _this.subCreate = function (extensionOptions, initCallback) {
        extensionOptions.options = extensionOptions.options || {};
        extensionOptions.options.targets = util.extend({}, this.parentTargets, extensionOptions.options.targets);
        var extension = this.create(extensionOptions, initCallback);
        if (!this._data.options.globalOptions.resolve_inner_iframe_url) {
          plugin.sendSubCreate(extension.id, extensionOptions);
        }
        return extension;
      };
      return _this;
    }
    return Combined;
  }(Connect);

  var combined = new Combined();

  function deprecate (fn, name, alternate, sinceVersion) {
    var called = false;
    return function () {
      if (!called && typeof console !== 'undefined' && console.warn) {
        called = true;
        console.warn("DEPRECATED API - " + name + " has been deprecated " + (sinceVersion ? "since ACJS " + sinceVersion : 'in ACJS') + (" and will be removed in a future release. " + (alternate ? "Use " + alternate + " instead." : 'No alternative will be provided.')));
        if (combined._analytics) {
          combined._analytics.trackDeprecatedMethodUsed(name);
        }
      }
      return fn.apply(void 0, arguments);
    };
  }

  // universal iterator utility
  function each(o, it) {
    var l;
    var k;
    if (o) {
      l = o.length;
      if (l != null && typeof o !== 'function') {
        k = 0;
        while (k < l) {
          if (it.call(o[k], k, o[k]) === false) {
            break;
          }
          k += 1;
        }
      } else {
        for (k in o) {
          if (o.hasOwnProperty(k) && it.call(o[k], k, o[k]) === false) {
            break;
          }
        }
      }
    }
  }
  function binder(std, odd) {
    std += 'EventListener';
    odd += 'Event';
    return function (el, e, fn) {
      if (el[std]) {
        el[std](e, fn, false);
      } else if (el[odd]) {
        el[odd]('on' + e, fn);
      }
    };
  }
  function log() {
    var console = this.console;
    if (console && console.log) {
      var args = [].slice.call(arguments);
      if (console.log.apply) {
        console.log.apply(console, args);
      } else {
        for (var i = 0, l = args.length; i < l; i += 1) {
          args[i] = JSON.stringify(args[i]);
        }
        console.log(args.join(' '));
      }
      return true;
    }
  }
  function decodeQueryComponent(encodedURI) {
    return encodedURI == null ? null : decodeURIComponent(encodedURI.replace(/\+/g, '%20'));
  }
  var _util = {
    each: each,
    log: log,
    decodeQueryComponent: decodeQueryComponent,
    bind: binder('add', 'attach'),
    unbind: binder('remove', 'detach'),
    extend: function extend(dest) {
      var args = arguments;
      var srcs = [].slice.call(args, 1, args.length);
      each(srcs, function (i, src) {
        each(src, function (k, v) {
          dest[k] = v;
        });
      });
      return dest;
    },
    trim: function trim(s) {
      return s && s.replace(/^\s+|\s+$/g, '');
    },
    debounce: function debounce(fn, wait) {
      var timeout;
      return function () {
        var ctx = this;
        var args = [].slice.call(arguments);
        function later() {
          timeout = null;
          fn.apply(ctx, args);
        }
        if (timeout) {
          clearTimeout(timeout);
        }
        timeout = setTimeout(later, wait || 50);
      };
    },
    isFunction: function isFunction(fn) {
      return typeof fn === 'function';
    },
    handleError: function handleError(err) {
      if (!log.apply(this, err && err.message ? [err, err.message] : [err])) {
        throw err;
      }
    }
  };

  var _each = _util.each;
  var extend = _util.extend;
  var document$1 = window.document;
  function $(sel, context) {
    context = context || document$1;
    var els = [];
    if (sel) {
      if (typeof sel === 'string') {
        var results = context.querySelectorAll(sel);
        _each(results, function (i, v) {
          els.push(v);
        });
      } else if (sel.nodeType === 1) {
        els.push(sel);
      } else if (sel === window) {
        els.push(sel);
      }
    }
    extend(els, {
      each: function each(it) {
        _each(this, it);
        return this;
      },
      bind: function bind(name, callback) {
        this.each(function (i, el) {
          _util.bind(el, name, callback);
        });
      },
      attr: function attr(k) {
        var v;
        this.each(function (i, el) {
          v = el[k] || el.getAttribute && el.getAttribute(k);
          return !v;
        });
        return v;
      },
      removeClass: function removeClass(className) {
        return this.each(function (i, el) {
          if (el.className) {
            el.className = el.className.replace(new RegExp('(^|\\s)' + className + '(\\s|$)'), ' ');
          }
        });
      },
      html: function html(_html) {
        return this.each(function (i, el) {
          el.innerHTML = _html;
        });
      },
      append: function append(spec) {
        return this.each(function (i, to) {
          var el = context.createElement(spec.tag);
          _each(spec, function (k, v) {
            if (k === '$text') {
              if (el.styleSheet) {
                // style tags in ie
                el.styleSheet.cssText = v;
              } else {
                el.appendChild(context.createTextNode(v));
              }
            } else if (k !== 'tag') {
              el[k] = v;
            }
          });
          to.appendChild(el);
        });
      }
    });
    return els;
  }
  var $$1 = extend($, _util);

  /**
   * The Events module provides a mechanism for emitting and receiving events.<br>
   *
   * A event emitted by `emit` method will only be received by the modules defined in the same add-on.<br>
   * Public events that emitted by `emitPublic` are used for cross add-on communication.
   * They can be received by any add-on modules that are currently presented on the page.
   *
   * <h3>Basic example</h3>
   * Add-on A:
   * ```
   * // The following will create an alert message every time the event `customEvent` is triggered.
   * AP.events.on('customEvent', function(){
   *   alert('event fired');
   * });
   *
   *
   * AP.events.emit('customEvent');
   * AP.events.emitPublic('customPublicEvent');
   * ```
   *
   *
   * Add-on B:
   * ```
   * // The following will create an alert message every time the event `customPublicEvent` is triggered by add-on A.
   * AP.events.onPublic('customPublicEvent', function(){
   *   alert('public event fired');
   * });
   * ```
   *
   * @name Events
   * @module
   */
  var Events = /*#__PURE__*/function () {
    function Events() {
      this._events = {};
      this.ANY_PREFIX = '_any';
      this.methods = ['off', 'offAll', 'offAny', 'on', 'onAny', 'once'];
    }
    var _proto = Events.prototype;
    _proto._anyListener = function _anyListener(data, callback) {
      var eventName = callback._context.eventName;
      var any = this._events[this.ANY_PREFIX] || [];
      var byName = this._events[eventName] || [];
      if (!Array.isArray(data)) {
        data = [data];
      }
      any.forEach(function (handler) {
        //clone data before modifying
        var args = data.slice(0);
        args.unshift(eventName);
        args.push({
          args: data,
          name: eventName
        });
        handler.apply(null, args);
      });
      byName.forEach(function (handler) {
        handler.apply(null, data);
      });
    };
    _proto.off = function off(name, listener) {
      if (this._events[name]) {
        var index = this._events[name].indexOf(listener);
        if (index > -1) {
          this._events[name].splice(index, 1);
        }
        if (this._events[name].length === 0) {
          delete this._events[name];
        }
      }
    };
    _proto.offAll = function offAll(name) {
      delete this._events[name];
    };
    _proto.offAny = function offAny(listener) {
      this.off(this.ANY_PREFIX, listener);
    };
    _proto.on = function on(name, listener) {
      if (!this._events[name]) {
        this._events[name] = [];
      }
      this._events[name].push(listener);
    };
    _proto.onAny = function onAny(listener) {
      this.on(this.ANY_PREFIX, listener);
    };
    _proto.once = function once(name, listener) {
      var _that = this;
      function runOnce() {
        listener.apply(null, arguments);
        _that.off(name, runOnce);
      }
      this.on(name, runOnce);
    }
    /**
     * Adds a listener for all occurrences of an event of a particular name.<br>
     * Listener arguments include any arguments passed to `events.emit`, followed by an object describing the complete event information.
     * @name on
     * @method
     * @memberof module:Events#
     * @param {String} name The event name to subscribe the listener to
     * @param {Function} listener A listener callback to subscribe to the event name
     */

    /**
     * Adds a listener for all occurrences of a public event of a particular name.<br>
     * Listener arguments include any arguments passed to `events.emitPublic`, followed by an object describing the complete event information.<br>
     * Event emitter's information will be passed to the first argument of the filter function. The listener callback will only be called when filter function returns `true`.
     * @name onPublic
     * @method
     * @memberof module:Events#
     * @param {String} name The event name to subscribe the listener to
     * @param {Function} listener A listener callback to subscribe to the event name
     * @param {Function} [filter] A filter function to filter the events. Callback will always be called when a matching event occurs if the filter is unspecified
     */

    /**
     * Adds a listener for one occurrence of an event of a particular name.<br>
     * Listener arguments include any argument passed to `events.emit`, followed by an object describing the complete event information.
     * @name once
     * @method
     * @memberof module:Events#
     * @param {String} name The event name to subscribe the listener to
     * @param {Function} listener A listener callback to subscribe to the event name
     */

    /**
     * Adds a listener for one occurrence of a public event of a particular name.<br>
     * Listener arguments include any argument passed to `events.emit`, followed by an object describing the complete event information.<br>
     * Event emitter's information will be passed to the first argument of the filter function. The listener callback will only be called when filter function returns `true`.
     * @name oncePublic
     * @method
     * @memberof module:Events#
     * @param {String} name The event name to subscribe the listener to
     * @param {Function}listener A listener callback to subscribe to the event name
     * @param {Function} [filter] A filter function to filter the events. Callback will always be called when a matching event occurs if the filter is unspecified
     */

    /**
     * Adds a listener for all occurrences of any event, regardless of name.<br>
     * Listener arguments begin with the event name, followed by any arguments passed to `events.emit`, followed by an object describing the complete event information.
     * @name onAny
     * @method
     * @memberof module:Events#
     * @param {Function} listener A listener callback to subscribe for any event name
     */

    /**
     * Adds a listener for all occurrences of any event, regardless of name.<br>
     * Listener arguments begin with the event name, followed by any arguments passed to `events.emit`, followed by an object describing the complete event information.<br>
     * Event emitter's information will be passed to the first argument of the filter function. The listener callback will only be called when filter function returns `true`.
     * @name onAnyPublic
     * @method
     * @memberof module:Events#
     * @param {Function} listener A listener callback to subscribe for any event name
     * @param {Function} [filter] A filter function to filter the events. Callback will always be called when a matching event occurs if the filter is unspecified
     */

    /**
     * Removes a particular listener for an event.
     * @name off
     * @method
     * @memberof module:Events#
     * @param {String} name The event name to unsubscribe the listener from
     * @param {Function} listener The listener callback to unsubscribe from the event name
     */

    /**
     * Removes a particular listener for a public event.
     * @name offPublic
     * @method
     * @memberof module:Events#
     * @param {String} name The event name to unsubscribe the listener from
     * @param {Function} listener The listener callback to unsubscribe from the event name
     */

    /**
     * Removes all listeners from an event name, or unsubscribes all event-name-specific listeners
     * if no name if given.
     * @name offAll
     * @method
     * @memberof module:Events#
     * @param {String} [name] The event name to unsubscribe all listeners from
     */

    /**
     * Removes all listeners from a public event name, or unsubscribes all event-name-specific listeners for public events
     * if no name if given.
     * @name offAllPublic
     * @method
     * @memberof module:Events#
     * @param {String} [name] The event name to unsubscribe all listeners from
     */

    /**
     * Removes an `any` event listener.
     * @name offAny
     * @method
     * @memberof module:Events#
     * @param {Function} listener A listener callback to unsubscribe from any event name
     */

    /**
     * Removes an `anyPublic` event listener.
     * @name offAnyPublic
     * @method
     * @memberof module:Events#
     * @param {Function} listener A listener callback to unsubscribe from any event name
     */

    /**
     * Emits an event on this bus, firing listeners by name as well as all 'any' listeners.<br>
     * Arguments following the name parameter are captured and passed to listeners.
     * @name emit
     * @method
     * @memberof module:Events#
     * @param {String} name The name of event to emit
     * @param {String[]} args 0 or more additional data arguments to deliver with the event
     */

    /**
     * Emits a public event on this bus, firing listeners by name as well as all 'anyPublic' listeners.<br>
     * The event can be received by any add-on modules that are currently presented on the page.<br>
     * Arguments following the name parameter are captured and passed to listeners.
     * @name emitPublic
     * @method
     * @memberof module:Events#
     * @param {String} name The name of event to emit
     * @param {String[]} args 0 or more additional data arguments to deliver with the event
     */;
    return Events;
  }();

  var EventsInstance = new Events();

  var PublicEvents = /*#__PURE__*/function (_Events) {
    _inheritsLoose(PublicEvents, _Events);
    function PublicEvents() {
      var _this;
      _this = _Events.call(this) || this;
      _this.methods = ['offPublic', 'offAllPublic', 'offAnyPublic', 'onPublic', 'onAnyPublic', 'oncePublic'];
      return _this;
    }
    var _proto = PublicEvents.prototype;
    _proto._filterEval = function _filterEval(filter, toCompare) {
      var value = true;
      if (!filter) {
        return value;
      }
      switch (typeof filter) {
        case 'function':
          value = Boolean(filter.call(null, toCompare));
          break;
        case 'object':
          value = Object.getOwnPropertyNames(filter).every(function (prop) {
            return toCompare[prop] === filter[prop];
          });
          break;
      }
      return value;
    };
    _proto.once = function once(name, listener, filter) {
      var that = this;
      function runOnce(data) {
        listener.apply(null, data);
        that.off(name, runOnce);
      }
      this.on(name, runOnce, filter);
    };
    _proto.on = function on(name, listener, filter) {
      listener._wrapped = function (data) {
        if (this._filterEval(filter, data.sender)) {
          listener.apply(null, data.event);
        }
      }.bind(this);
      _Events.prototype.on.call(this, name, listener._wrapped);
    };
    _proto.off = function off(name, listener) {
      if (listener._wrapped) {
        _Events.prototype.off.call(this, name, listener._wrapped);
      } else {
        _Events.prototype.off.call(this, name, listener);
      }
    };
    _proto.onAny = function onAny(listener, filter) {
      listener._wrapped = function (data) {
        if (data.sender && this._filterEval(filter, data.sender)) {
          listener.apply(null, data.event);
        }
      };
      _Events.prototype.onAny.call(this, listener._wrapped);
    };
    _proto.offAny = function offAny(listener) {
      if (listener._wrapped) {
        _Events.prototype.offAny.call(this, name, listener._wrapped);
      } else {
        _Events.prototype.offAny.call(this, name, listener);
      }
    };
    return PublicEvents;
  }(Events);
  var PublicEventsInstance = new PublicEvents();

  var customButtonIncrement = 1;
  var getCustomData = deprecate(function () {
    return combined._data.options.customData;
  }, 'AP.dialog.customData', 'AP.dialog.getCustomData()', '5.0');
  if (combined._hostModules && combined._hostModules.dialog) {
    /**
     * Returns the custom data Object passed to the dialog at creation.
     * @noDemo
     * @deprecated after August 2017 | Please use <code>dialog.getCustomData(callback)</code> instead.
     * @name customData
     * @memberOf module:Dialog
     * @ignore
     * @example
     * var myDataVariable = AP.dialog.customData.myDataVariable;
     *
     * @return {Object} Data Object passed to the dialog on creation.
     */
    Object.defineProperty(combined._hostModules.dialog, 'customData', {
      get: getCustomData
    });
    Object.defineProperty(combined.dialog, 'customData', {
      get: getCustomData
    });
    combined.dialog._disableCloseOnSubmit = false;
    combined.dialog.disableCloseOnSubmit = function () {
      combined.dialog._disableCloseOnSubmit = true;
    };
  }
  var dialogHandlers = {};
  EventsInstance.onAny(eventDelegator);
  function eventDelegator(name, args) {
    var dialogEventMatch = name.match(/^dialog\.(\w+)/);
    if (!dialogEventMatch) {
      return;
    }
    if (name === 'dialog.button.click') {
      customButtonEvent(args.button.identifier, args);
    } else {
      submitOrCancelEvent(dialogEventMatch[1], args);
    }
  }
  function customButtonEvent(buttonIdentifier, args) {
    var callbacks = dialogHandlers[buttonIdentifier];
    if (callbacks && callbacks.length !== 0) {
      try {
        callbacks.forEach(function (callback) {
          callback.call(null, args);
        });
      } catch (err) {
        console.error(err);
      }
    }
  }
  function submitOrCancelEvent(name, args) {
    var handlers = dialogHandlers[name];
    var shouldClose = name !== 'close';
    var context = null;
    // ignore events that are triggered by button clicks
    // allow dialog.close through for close on ESC
    if (shouldClose && typeof args.button === 'undefined') {
      return;
    }

    // if the submit button has been set to not close on click
    if (name === 'submit' && combined.dialog._disableCloseOnSubmit) {
      shouldClose = false;
    }
    try {
      if (handlers) {
        if (args && args.button && args.button.name) {
          context = combined.dialog.getButton(args.button.name);
        }
        shouldClose = handlers.reduce(function (result, cb) {
          return cb.call(context, args) && result;
        }, shouldClose);
      }
    } catch (err) {
      console.error(err);
    } finally {
      var shouldRemoveHandler = shouldClose || name === 'close';
      if (shouldRemoveHandler) {
        delete dialogHandlers[name];
      }
    }
    if (shouldClose) {
      combined.dialog.close();
    }
  }
  function registerHandler(event, callback) {
    if (typeof callback === 'function') {
      if (!dialogHandlers[event]) {
        dialogHandlers[event] = [];
      }
      dialogHandlers[event].push(callback);
    }
  }
  if (combined.dialog && combined.dialog.create) {
    var original_dialogCreate = combined.dialog.create.prototype.constructor.bind({});
    combined.dialog.create = combined._hostModules.dialog.create = function () {
      var dialog = original_dialogCreate.apply(void 0, arguments);
      /**
       * Allows the add-on to register a callback function for the given event. The listener is only called once and must be re-registered if needed.
       * @deprecated after August 2017 | Please use <code>AP.events.on("dialog.close", callback)</code> instead.
       * @memberOf Dialog~Dialog
       * @method on
       * @ignore
       * @param {String} event name of the event to listen for, such as 'close'.
       * @param {Function} callback function to receive the event callback.
       * @noDemo
       * @example
       * AP.dialog.create(opts).on("close", callbackFunc);
       */
      dialog.on = deprecate(registerHandler, 'AP.dialog.on("close", callback)', 'AP.events.on("dialog.close", callback)', '5.0');
      return dialog;
    };
  }
  if (combined.dialog && combined.dialog.getButton) {
    var original_dialogGetButton = combined.dialog.getButton.prototype.constructor.bind({});
    combined.dialog.getButton = combined._hostModules.dialog.getButton = function (name) {
      try {
        var button = original_dialogGetButton(name);
        /**
         * Registers a function to be called when the button is clicked.
         * @deprecated after August 2017 | Please use <code>AP.events.on("dialog.message", callback)</code> instead.
         * @method bind
         * @memberOf Dialog~DialogButton
         * @ignore
         * @param {Function} callback function to be triggered on click or programatically.
         * @noDemo
         * @example
         * AP.dialog.getButton('submit').bind(function(){
         *   alert('clicked!');
         * });
         */
        button.bind = deprecate(function (callback) {
          return registerHandler(name, callback);
        }, 'AP.dialog.getDialogButton().bind()', 'AP.events.on("dialog.message", callback)', '5.0');
        return button;
      } catch (e) {
        return {};
      }
    };
  }
  if (combined.dialog && combined.dialog.createButton) {
    var original_dialogCreateButton = combined.dialog.createButton.prototype.constructor.bind({});
    combined.dialog.createButton = combined._hostModules.dialog.createButton = function (options) {
      var buttonProperties = {};
      if (typeof options !== 'object') {
        buttonProperties.text = options;
        buttonProperties.identifier = options;
      } else {
        buttonProperties = options;
      }
      if (!buttonProperties.identifier) {
        buttonProperties.identifier = 'user.button.' + customButtonIncrement++;
      }
      original_dialogCreateButton(buttonProperties);
      return combined.dialog.getButton(buttonProperties.identifier);
    };
  }

  /**
   * Register callbacks responding to messages from the host dialog, such as "submit" or "cancel"
   * @deprecated after August 2017 | Please use <code>AP.events.on("dialog.message", callback)</code> instead.
   * @memberOf module:Dialog
   * @method onDialogMessage
   * @ignore
   * @param {String} buttonName - button either "cancel" or "submit"
   * @param {Function} listener - callback function invoked when the requested button is pressed
   */
  if (combined.dialog) {
    combined.dialog.onDialogMessage = combined._hostModules.dialog.onDialogMessage = deprecate(registerHandler, 'AP.dialog.onDialogMessage()', 'AP.events.on("dialog.message", callback)', '5.0');
  }
  if (!combined.Dialog) {
    combined.Dialog = combined._hostModules.Dialog = combined.dialog;
  }

  var modules = {};
  function reqAll(deps, callback) {
    var mods = [];
    var i = 0;
    var len = deps.length;
    function addOne(mod) {
      mods.push(mod);
      if (mods.length === len) {
        var exports = [];
        var i = 0;
        for (; i < len; i += 1) {
          exports[i] = mods[i].exports;
        }
        if (callback) {
          callback.apply(window, exports);
        }
      }
    }
    if (deps && deps.length > 0) {
      for (; i < len; i += 1) {
        reqOne(deps[i], addOne);
      }
    } else {
      if (callback) {
        callback();
      }
    }
  }
  function reqOne(name, callback) {
    // naive impl that assumes all modules are already loaded
    callback(getOrCreate(name));
  }
  function getOrCreate(name) {
    // get defined module
    if (modules[name]) {
      return modules[name];
    }

    // get a host module
    var hostModule = getFromHostModules(name);
    if (hostModule) {
      return modules[name] = hostModule;
    }

    // create a new module
    return modules[name] = {
      name: name,
      exports: function () {
        function exports() {
          var target = exports.__target__;
          if (target) {
            return target.apply(window, arguments);
          }
        }
        return exports;
      }()
    };
  }
  function getFromHostModules(name) {
    var module;
    if (combined._hostModules) {
      if (combined._hostModules[name]) {
        module = combined._hostModules[name];
      }
      if (combined._hostModules._globals && combined._hostModules._globals[name]) {
        module = combined._hostModules._globals[name];
      }
      if (module) {
        return {
          name: name,
          exports: module
        };
      }
    }
  }

  // define(name, objOrFn)
  // define(name, deps, fn(dep1, dep2, ...))
  var AMD = {
    define: function define(name, deps, exports) {
      var mod = getOrCreate(name);
      var factory;
      if (!exports) {
        exports = deps;
        deps = [];
      }
      if (exports) {
        factory = typeof exports !== 'function' ? function () {
          return exports;
        } : exports;
        reqAll(deps, function () {
          var exports = factory.apply(window, arguments);
          if (exports) {
            if (typeof exports === 'function') {
              mod.exports.__target__ = exports;
            }
            for (var k in exports) {
              if (exports.hasOwnProperty(k)) {
                mod.exports[k] = exports[k];
              }
            }
          }
        });
      }
    },
    require: function require(deps, callback) {
      reqAll(typeof deps === 'string' ? [deps] : deps, callback);
    }
  };

  function getMeta(name) {
    return $$1("meta[name='ap-" + name + "']").attr('content');
  }
  var Meta = {
    getMeta: getMeta,
    localUrl: function localUrl(path) {
      var url = getMeta('local-base-url');
      return typeof url === 'undefined' || typeof path === 'undefined' ? url : "" + url + path;
    }
  };

  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }
    if (info.done) {
      resolve(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }
  function _asyncToGenerator(fn) {
    return function () {
      var self = this,
        args = arguments;
      return new Promise(function (resolve, reject) {
        var gen = fn.apply(self, args);
        function _next(value) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
        }
        function _throw(err) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
        }
        _next(undefined);
      });
    };
  }

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  var regeneratorRuntime$1 = {exports: {}};

  var _typeof$1 = {exports: {}};

  (function (module) {
  function _typeof(obj) {
    "@babel/helpers - typeof";

    return (module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, module.exports.__esModule = true, module.exports["default"] = module.exports), _typeof(obj);
  }
  module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;
  }(_typeof$1));

  (function (module) {
  var _typeof = _typeof$1.exports["default"];
  function _regeneratorRuntime() {

    /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
    module.exports = _regeneratorRuntime = function _regeneratorRuntime() {
      return exports;
    }, module.exports.__esModule = true, module.exports["default"] = module.exports;
    var exports = {},
      Op = Object.prototype,
      hasOwn = Op.hasOwnProperty,
      defineProperty = Object.defineProperty || function (obj, key, desc) {
        obj[key] = desc.value;
      },
      $Symbol = "function" == typeof Symbol ? Symbol : {},
      iteratorSymbol = $Symbol.iterator || "@@iterator",
      asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
      toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
    function define(obj, key, value) {
      return Object.defineProperty(obj, key, {
        value: value,
        enumerable: !0,
        configurable: !0,
        writable: !0
      }), obj[key];
    }
    try {
      define({}, "");
    } catch (err) {
      define = function define(obj, key, value) {
        return obj[key] = value;
      };
    }
    function wrap(innerFn, outerFn, self, tryLocsList) {
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
        generator = Object.create(protoGenerator.prototype),
        context = new Context(tryLocsList || []);
      return defineProperty(generator, "_invoke", {
        value: makeInvokeMethod(innerFn, self, context)
      }), generator;
    }
    function tryCatch(fn, obj, arg) {
      try {
        return {
          type: "normal",
          arg: fn.call(obj, arg)
        };
      } catch (err) {
        return {
          type: "throw",
          arg: err
        };
      }
    }
    exports.wrap = wrap;
    var ContinueSentinel = {};
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function () {
      return this;
    });
    var getProto = Object.getPrototypeOf,
      NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function (method) {
        define(prototype, method, function (arg) {
          return this._invoke(method, arg);
        });
      });
    }
    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if ("throw" !== record.type) {
          var result = record.arg,
            value = result.value;
          return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
            invoke("next", value, resolve, reject);
          }, function (err) {
            invoke("throw", err, resolve, reject);
          }) : PromiseImpl.resolve(value).then(function (unwrapped) {
            result.value = unwrapped, resolve(result);
          }, function (error) {
            return invoke("throw", error, resolve, reject);
          });
        }
        reject(record.arg);
      }
      var previousPromise;
      defineProperty(this, "_invoke", {
        value: function value(method, arg) {
          function callInvokeWithMethodAndArg() {
            return new PromiseImpl(function (resolve, reject) {
              invoke(method, arg, resolve, reject);
            });
          }
          return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
        }
      });
    }
    function makeInvokeMethod(innerFn, self, context) {
      var state = "suspendedStart";
      return function (method, arg) {
        if ("executing" === state) throw new Error("Generator is already running");
        if ("completed" === state) {
          if ("throw" === method) throw arg;
          return doneResult();
        }
        for (context.method = method, context.arg = arg;;) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }
          if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
            if ("suspendedStart" === state) throw state = "completed", context.arg;
            context.dispatchException(context.arg);
          } else "return" === context.method && context.abrupt("return", context.arg);
          state = "executing";
          var record = tryCatch(innerFn, self, context);
          if ("normal" === record.type) {
            if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
            return {
              value: record.arg,
              done: context.done
            };
          }
          "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
        }
      };
    }
    function maybeInvokeDelegate(delegate, context) {
      var methodName = context.method,
        method = delegate.iterator[methodName];
      if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
      var record = tryCatch(method, delegate.iterator, context.arg);
      if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
      var info = record.arg;
      return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
    }
    function pushTryEntry(locs) {
      var entry = {
        tryLoc: locs[0]
      };
      1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
    }
    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal", delete record.arg, entry.completion = record;
    }
    function Context(tryLocsList) {
      this.tryEntries = [{
        tryLoc: "root"
      }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
    }
    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) return iteratorMethod.call(iterable);
        if ("function" == typeof iterable.next) return iterable;
        if (!isNaN(iterable.length)) {
          var i = -1,
            next = function next() {
              for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
              return next.value = undefined, next.done = !0, next;
            };
          return next.next = next;
        }
      }
      return {
        next: doneResult
      };
    }
    function doneResult() {
      return {
        value: undefined,
        done: !0
      };
    }
    return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
      value: GeneratorFunctionPrototype,
      configurable: !0
    }), defineProperty(GeneratorFunctionPrototype, "constructor", {
      value: GeneratorFunction,
      configurable: !0
    }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
      var ctor = "function" == typeof genFun && genFun.constructor;
      return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
    }, exports.mark = function (genFun) {
      return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
    }, exports.awrap = function (arg) {
      return {
        __await: arg
      };
    }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
      return this;
    }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      void 0 === PromiseImpl && (PromiseImpl = Promise);
      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
      return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
        return result.done ? result.value : iter.next();
      });
    }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
      return this;
    }), define(Gp, "toString", function () {
      return "[object Generator]";
    }), exports.keys = function (val) {
      var object = Object(val),
        keys = [];
      for (var key in object) keys.push(key);
      return keys.reverse(), function next() {
        for (; keys.length;) {
          var key = keys.pop();
          if (key in object) return next.value = key, next.done = !1, next;
        }
        return next.done = !0, next;
      };
    }, exports.values = values, Context.prototype = {
      constructor: Context,
      reset: function reset(skipTempReset) {
        if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
      },
      stop: function stop() {
        this.done = !0;
        var rootRecord = this.tryEntries[0].completion;
        if ("throw" === rootRecord.type) throw rootRecord.arg;
        return this.rval;
      },
      dispatchException: function dispatchException(exception) {
        if (this.done) throw exception;
        var context = this;
        function handle(loc, caught) {
          return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
        }
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i],
            record = entry.completion;
          if ("root" === entry.tryLoc) return handle("end");
          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc"),
              hasFinally = hasOwn.call(entry, "finallyLoc");
            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            } else {
              if (!hasFinally) throw new Error("try statement without catch or finally");
              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
            }
          }
        }
      },
      abrupt: function abrupt(type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }
        finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
        var record = finallyEntry ? finallyEntry.completion : {};
        return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
      },
      complete: function complete(record, afterLoc) {
        if ("throw" === record.type) throw record.arg;
        return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
      },
      finish: function finish(finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
        }
      },
      "catch": function _catch(tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if ("throw" === record.type) {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }
        throw new Error("illegal catch attempt");
      },
      delegateYield: function delegateYield(iterable, resultName, nextLoc) {
        return this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
      }
    }, exports;
  }
  module.exports = _regeneratorRuntime, module.exports.__esModule = true, module.exports["default"] = module.exports;
  }(regeneratorRuntime$1));

  // TODO(Babel 8): Remove this file.

  var runtime = regeneratorRuntime$1.exports();
  var regenerator = runtime;

  // Copied from https://github.com/facebook/regenerator/blob/main/packages/runtime/runtime.js#L736=
  try {
    regeneratorRuntime = runtime;
  } catch (accidentalStrictMode) {
    if (typeof globalThis === "object") {
      globalThis.regeneratorRuntime = runtime;
    } else {
      Function("r", "regeneratorRuntime = r")(runtime);
    }
  }

  var THEME_DATA_ATTRIBUTE = 'data-theme';
  var COLOR_MODE_ATTRIBUTE = 'data-color-mode';

  function _typeof(obj) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, _typeof(obj);
  }

  function _toPrimitive(input, hint) {
    if (_typeof(input) !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (_typeof(res) !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }

  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return _typeof(key) === "symbol" ? key : String(key);
  }

  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
    if (null != _i) {
      var _s,
        _e,
        _x,
        _r,
        _arr = [],
        _n = !0,
        _d = !1;
      try {
        if (_x = (_i = _i.call(arr)).next, 0 === i) {
          if (Object(_i) !== _i) return;
          _n = !1;
        } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0);
      } catch (err) {
        _d = !0, _e = err;
      } finally {
        try {
          if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return;
        } finally {
          if (_d) throw _e;
        }
      }
      return _arr;
    }
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  var dist = {};

  var bind$1 = {};

  Object.defineProperty(bind$1, "__esModule", {
    value: true
  });
  bind$1.bind = void 0;
  function bind(target, _a) {
    var type = _a.type,
      listener = _a.listener,
      options = _a.options;
    target.addEventListener(type, listener, options);
    return function unbind() {
      target.removeEventListener(type, listener, options);
    };
  }
  bind$1.bind = bind;

  var bindAll$1 = {};

  var __assign = commonjsGlobal && commonjsGlobal.__assign || function () {
    __assign = Object.assign || function (t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
    };
    return __assign.apply(this, arguments);
  };
  Object.defineProperty(bindAll$1, "__esModule", {
    value: true
  });
  bindAll$1.bindAll = void 0;
  var bind_1 = bind$1;
  function toOptions(value) {
    if (typeof value === 'undefined') {
      return undefined;
    }
    if (typeof value === 'boolean') {
      return {
        capture: value
      };
    }
    return value;
  }
  function getBinding(original, sharedOptions) {
    if (sharedOptions == null) {
      return original;
    }
    var binding = __assign(__assign({}, original), {
      options: __assign(__assign({}, toOptions(sharedOptions)), toOptions(original.options))
    });
    return binding;
  }
  function bindAll(target, bindings, sharedOptions) {
    var unbinds = bindings.map(function (original) {
      var binding = getBinding(original, sharedOptions);
      return (0, bind_1.bind)(target, binding);
    });
    return function unbindAll() {
      unbinds.forEach(function (unbind) {
        return unbind();
      });
    };
  }
  bindAll$1.bindAll = bindAll;

  (function (exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.bindAll = exports.bind = void 0;
  var bind_1 = bind$1;
  Object.defineProperty(exports, "bind", {
    enumerable: true,
    get: function get() {
      return bind_1.bind;
    }
  });
  var bind_all_1 = bindAll$1;
  Object.defineProperty(exports, "bindAll", {
    enumerable: true,
    get: function get() {
      return bind_all_1.bindAll;
    }
  });
  }(dist));

  /**
   * An empty function which does nothing.
   */
  // eslint-disable-next-line @repo/internal/react/use-noop
  function noop() {}

  var _ref, _globalThis$process, _globalThis$process$e, _globalThis$process2, _globalThis$process2$;
  // We can't rely on NODE_ENV === 'test' if its value is already configured by the consumer to some other value, so better to use JEST_WORKER_ID
  // https://jestjs.io/docs/environment-variables#jest_worker_id
  var TESTS_MODE = (_ref = (globalThis === null || globalThis === void 0 ? void 0 : (_globalThis$process = globalThis.process) === null || _globalThis$process === void 0 ? void 0 : (_globalThis$process$e = _globalThis$process.env) === null || _globalThis$process$e === void 0 ? void 0 : _globalThis$process$e.JEST_WORKER_ID) !== undefined) !== null && _ref !== void 0 ? _ref : false;
  var DEBUG_MODE = !TESTS_MODE && (globalThis === null || globalThis === void 0 ? void 0 : (_globalThis$process2 = globalThis.process) === null || _globalThis$process2 === void 0 ? void 0 : (_globalThis$process2$ = _globalThis$process2.env) === null || _globalThis$process2$ === void 0 ? void 0 : _globalThis$process2$.NODE_ENV) !== 'production';
  var debug = function debug() {
    var _console;
    if (!DEBUG_MODE) {
      return;
    }

    // eslint-disable-next-line no-console
    (_console = console).debug.apply(_console, arguments);
  };

  var pkgName = '@atlaskit/platform-feature-flags';
  var hasProcessEnv = typeof process !== 'undefined' && typeof process.env !== 'undefined';

  // FF global overrides can be configured by test runners or Storybook
  var ENV_ENABLE_PLATFORM_FF = hasProcessEnv ?
  // Use global "process" variable and process.env['FLAG_NAME'] syntax, so it can be replaced by webpack DefinePlugin
  undefined === 'true' : false;

  // STORYBOOK_ENABLE_PLATFORM_FF is included as storybook only allows env vars prefixed with STORYBOOK
  // https://github.com/storybookjs/storybook/issues/12270

  var ENV_STORYBOOK_ENABLE_PLATFORM_FF = hasProcessEnv ?
  // Use global "process" variable and process.env['FLAG_NAME'] syntax, so it can be replaced by webpack DefinePlugin
  undefined === 'true' : false;
  var ENABLE_GLOBAL_PLATFORM_FF_OVERRIDE = ENV_ENABLE_PLATFORM_FF || ENV_STORYBOOK_ENABLE_PLATFORM_FF;
  var booleanResolver = function booleanResolver(flagKey) {
    return false;
  };
  function resolveBooleanFlag(flagKey) {
    if (ENABLE_GLOBAL_PLATFORM_FF_OVERRIDE) {
      debug('[%s]: The feature flags were enabled while running tests. The flag "%s" will be always enabled.', pkgName, flagKey);
      return true;
    }
    try {
      var result = booleanResolver(flagKey);
      if (typeof result !== 'boolean') {
        // eslint-disable-next-line no-console
        console.warn("".concat(flagKey, " resolved to a non-boolean value, returning false for safety"));
        return false;
      }
      return result;
    } catch (e) {
      return false;
    }
  }

  /**
   * Returns the value of a feature flag. If the flag does not resolve, it returns the "false" as a default value.
   * @param name
   */
  function getBooleanFF(name) {
    return resolveBooleanFlag(name);
  }

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   *
   * This file contains a dynamic import for each theme this package exports.
   * Themes are loaded asynchronously at runtime to minimise the amount of CSS we send to the client.
   * This allows users to compose their themes and only use the tokens that are requested.
   * When a new theme is created, the import should automatically be added to the map
   *
   * @codegen <<SignedSource::de402397f676704af035feafc2b4f3c3>>
   * @codegenCommand yarn build tokens
   */

  var themeImportsMap = {
    'light': function light() {
      return Promise.resolve().then(function () { return atlassianLight$1; });
    },
    'dark': function dark() {
      return Promise.resolve().then(function () { return atlassianDark$1; });
    },
    'legacy-light': function legacyLight() {
      return Promise.resolve().then(function () { return atlassianLegacyLight$1; });
    },
    'legacy-dark': function legacyDark() {
      return Promise.resolve().then(function () { return atlassianLegacyDark$1; });
    },
    'spacing': function spacing() {
      return Promise.resolve().then(function () { return atlassianSpacing$1; });
    },
    'typography': function typography() {
      return Promise.resolve().then(function () { return atlassianTypography$1; });
    },
    'shape': function shape() {
      return Promise.resolve().then(function () { return atlassianShape$1; });
    },
    'light-new-input-border': function lightNewInputBorder() {
      return Promise.resolve().then(function () { return atlassianLightNewInputBorder$1; });
    },
    'dark-new-input-border': function darkNewInputBorder() {
      return Promise.resolve().then(function () { return atlassianDarkNewInputBorder$1; });
    }
  };
  var themeImportMap = themeImportsMap;

  var loadAndAppendThemeCss = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(themeId) {
      var themeCss, style;
      return regenerator.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            if (!document.head.querySelector("style[".concat(THEME_DATA_ATTRIBUTE, "=\"").concat(themeId, "\"]"))) {
              _context.next = 2;
              break;
            }
            return _context.abrupt("return");
          case 2:
            _context.next = 4;
            return loadThemeCss(themeId);
          case 4:
            themeCss = _context.sent;
            style = document.createElement('style');
            style.textContent = themeCss;
            style.dataset.theme = themeId;
            document.head.appendChild(style);
          case 9:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function loadAndAppendThemeCss(_x) {
      return _ref.apply(this, arguments);
    };
  }();
  var loadThemeCss = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2(themeId) {
      var _yield$themeImportMap, themeCss;
      return regenerator.wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return themeImportMap[themeId]();
          case 2:
            _yield$themeImportMap = _context2.sent;
            themeCss = _yield$themeImportMap.default;
            return _context2.abrupt("return", themeCss);
          case 5:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function loadThemeCss(_x2) {
      return _ref2.apply(this, arguments);
    };
  }();

  /**
   * This file contains the source of truth for themes and all associated meta data.
   */
  /**
   * Theme ids: The value that will be mounted to the DOM as a data attr
   * For example: `data-theme="light:light dark:dark spacing:spacing"
   *
   * These ids must be kebab case
   */
  var themeIds = ['light', 'dark', 'legacy-light', 'legacy-dark', 'spacing', 'typography', 'shape'];

  var themeKinds = ['light', 'dark', 'spacing', 'typography', 'shape'];
  var isThemeKind = function isThemeKind(themeKind) {
    return themeKinds.find(function (kind) {
      return kind === themeKind;
    }) !== undefined;
  };
  var isThemeIds = function isThemeIds(themeId) {
    return themeIds.find(function (id) {
      return id === themeId;
    }) !== undefined;
  };
  var isColorMode = function isColorMode(modeId) {
    return ['light', 'dark', 'auto'].includes(modeId);
  };

  /**
   * Converts a theme object to a string formatted for the `data-theme` HTML attribute.
   *
   * @param {object} themes The themes that should be applied.
   *
   * @example
   * ```
   * themeObjectToString({ dark: 'dark', light: 'legacy-light', spacing: 'spacing' });
   * // returns 'dark:dark light:legacy-light spacing:spacing'
   * ```
   */
  var themeObjectToString = function themeObjectToString(themeState) {
    return Object.entries(themeState).reduce(function (themeString, _ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        kind = _ref4[0],
        id = _ref4[1];
      return (kind === 'colorMode' || isThemeKind(kind)) && (isThemeIds(id) || isColorMode(id)) ? themeString + "".concat(themeString ? ' ' : '') + "".concat(kind, ":").concat(id) : themeString;
    }, '');
  };

  // Represents theme state once mounted to the page (auto is hidden from observers)

  var defaultColorMode = 'light';
  var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;
  var darkModeMediaQuery = '(prefers-color-scheme: dark)';
  var darkModeMql = isMatchMediaAvailable && window.matchMedia(darkModeMediaQuery);
  var unbindThemeChangeListener = noop;
  var themeStateDefaults = {
    colorMode: 'auto',
    dark: 'dark',
    light: 'light',
    shape: undefined,
    spacing: undefined,
    typography: undefined
  };

  /**
   * Updates the current theme when the system theme changes. Should be bound
   * to an event listener listening on the '(prefers-color-scheme: dark)' query
   * @param e The event representing a change in system theme.
   */
  var checkNativeListener = function checkNativeListener(e) {
    var element = document.documentElement;
    element.setAttribute(COLOR_MODE_ATTRIBUTE, e.matches ? 'dark' : 'light');
  };
  var getThemePreferences = function getThemePreferences(themeState) {
    var colorMode = themeState.colorMode,
      dark = themeState.dark,
      light = themeState.light,
      shape = themeState.shape,
      spacing = themeState.spacing,
      typography = themeState.typography;
    var themePreferences = colorMode === 'auto' ? [light, dark] : [themeState[colorMode]];
    [shape, spacing, typography].forEach(function (themeId) {
      if (themeId) {
        themePreferences.push(themeId);
      }
    });
    if (getBooleanFF('platform.design-system-team.border-checkbox_nyoiu')) {
      themePreferences.push("".concat(themePreferences.includes('dark') ? 'dark' : 'light', "-new-input-border"));
    }

    // Load shape and spacing by default, currently behind a feature flag
    if (getBooleanFF('platform.design-system-team.space-and-shape-tokens_q5me6')) {
      if (!themePreferences.includes('shape')) {
        themePreferences.push('shape');
      }
      if (!themePreferences.includes('spacing')) {
        themePreferences.push('spacing');
      }
    }
    return _toConsumableArray(new Set(themePreferences));
  };

  /**
   * Sets the theme globally at runtime. This updates the `data-theme` and `data-color-mode` attributes on your page's <html> tag.
   *
   * @param {Object<string, string>} themeState The themes and color mode that should be applied.
   * @param {string} themeState.colorMode Determines which color theme is applied. If set to `auto`, the theme applied will be determined by the OS setting.
   * @param {string} themeState.dark The color theme to be applied when the color mode resolves to 'dark'.
   * @param {string} themeState.light The color theme to be applied when the color mode resolves to 'light'.
   * @param {string} themeState.shape The shape theme to be applied.
   * @param {string} themeState.spacing The spacing theme to be applied.
   * @param {string} themeState.typography The typography theme to be applied.
   *
   * @returns A Promise of an unbind function, that can be used to stop listening for changes to system theme.
   *
   * @example
   * ```
   * setGlobalTheme({colorMode: 'auto', light: 'light', dark: 'dark', spacing: 'spacing'});
   * ```
   */
  var setGlobalTheme = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2() {
      var _ref2,
        _ref2$colorMode,
        colorMode,
        _ref2$dark,
        dark,
        _ref2$light,
        light,
        _ref2$shape,
        shape,
        _ref2$spacing,
        spacing,
        _ref2$typography,
        typography,
        themePreferences,
        themeAttributes,
        _args2 = arguments;
      return regenerator.wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _ref2 = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : {}, _ref2$colorMode = _ref2.colorMode, colorMode = _ref2$colorMode === void 0 ? themeStateDefaults['colorMode'] : _ref2$colorMode, _ref2$dark = _ref2.dark, dark = _ref2$dark === void 0 ? themeStateDefaults['dark'] : _ref2$dark, _ref2$light = _ref2.light, light = _ref2$light === void 0 ? themeStateDefaults['light'] : _ref2$light, _ref2$shape = _ref2.shape, shape = _ref2$shape === void 0 ? themeStateDefaults['shape'] : _ref2$shape, _ref2$spacing = _ref2.spacing, spacing = _ref2$spacing === void 0 ? themeStateDefaults['spacing'] : _ref2$spacing, _ref2$typography = _ref2.typography, typography = _ref2$typography === void 0 ? themeStateDefaults['typography'] : _ref2$typography;
            themePreferences = getThemePreferences({
              colorMode: colorMode,
              dark: dark,
              light: light,
              shape: shape,
              spacing: spacing,
              typography: typography
            });
            _context2.next = 4;
            return Promise.all(themePreferences.map( /*#__PURE__*/function () {
              var _ref3 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(themeId) {
                return regenerator.wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return loadAndAppendThemeCss(themeId);
                    case 2:
                      return _context.abrupt("return", _context.sent);
                    case 3:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x) {
                return _ref3.apply(this, arguments);
              };
            }()));
          case 4:
            if (colorMode === 'auto' && darkModeMql) {
              colorMode = darkModeMql.matches ? 'dark' : 'light';
              // Add an event listener for changes to the system theme.
              // If the function exists, it will not be added again.
              unbindThemeChangeListener = dist.bind(darkModeMql, {
                type: 'change',
                listener: checkNativeListener
              });
            } else {
              unbindThemeChangeListener();
            }
            themeAttributes = getThemeHtmlAttrs({
              colorMode: colorMode,
              dark: dark,
              light: light,
              shape: shape,
              spacing: spacing,
              typography: typography
            });
            Object.entries(themeAttributes).forEach(function (_ref4) {
              var _ref5 = _slicedToArray(_ref4, 2),
                key = _ref5[0],
                value = _ref5[1];
              document.documentElement.setAttribute(key, value);
            });
            return _context2.abrupt("return", unbindThemeChangeListener);
          case 8:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function setGlobalTheme() {
      return _ref.apply(this, arguments);
    };
  }();

  /**
   * Server-side rendering utility. Generates the valid HTML attributes for a given theme.
   * Note: this utility does not handle automatic theme switching.
   *
   * @param {Object<string, string>} themeOptions - Theme options object
   * @param {string} themeState.colorMode Determines which color theme is applied. If set to `auto`, the theme applied will be determined by the OS setting.
   * @param {string} themeState.dark The color theme to be applied when the color mode resolves to 'dark'.
   * @param {string} themeState.light The color theme to be applied when the color mode resolves to 'light'.
   * @param {string} themeState.spacing The spacing theme to be applied.
   * @param {string} themeState.typography The typography theme to be applied.
   *
   * @returns {Object} Object of HTML attributes to be applied to the document root
   */
  var getThemeHtmlAttrs = function getThemeHtmlAttrs() {
    var _ref10;
    var _ref9 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref9$colorMode = _ref9.colorMode,
      colorMode = _ref9$colorMode === void 0 ? themeStateDefaults['colorMode'] : _ref9$colorMode,
      _ref9$dark = _ref9.dark,
      dark = _ref9$dark === void 0 ? themeStateDefaults['dark'] : _ref9$dark,
      _ref9$light = _ref9.light,
      light = _ref9$light === void 0 ? themeStateDefaults['light'] : _ref9$light,
      _ref9$shape = _ref9.shape,
      shape = _ref9$shape === void 0 ? themeStateDefaults['shape'] : _ref9$shape,
      _ref9$spacing = _ref9.spacing,
      spacing = _ref9$spacing === void 0 ? themeStateDefaults['spacing'] : _ref9$spacing,
      _ref9$typography = _ref9.typography,
      typography = _ref9$typography === void 0 ? themeStateDefaults['typography'] : _ref9$typography;
    var themePreferences = {
      dark: dark,
      light: light,
      shape: shape,
      spacing: spacing,
      typography: typography
    };

    // Load shape and spacing by default, currently behind a feature flag
    if (getBooleanFF('platform.design-system-team.space-and-shape-tokens_q5me6')) {
      themePreferences = {
        dark: dark,
        light: light,
        shape: 'shape',
        spacing: 'spacing',
        typography: typography
      };
    }
    var themeAttribute = themeObjectToString(themePreferences);
    return _ref10 = {}, _defineProperty(_ref10, THEME_DATA_ATTRIBUTE, themeAttribute), _defineProperty(_ref10, COLOR_MODE_ATTRIBUTE, colorMode === 'auto' ? defaultColorMode : colorMode), _ref10;
  };
  var setGlobalTheme$1 = setGlobalTheme;

  var Theming = {
    isThemingEnabled: false,
    onThemeInitialized: function onThemeInitialized(data) {
      return _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
        return regenerator.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              Theming.isThemingEnabled = true;
              _context.next = 3;
              return Theming.onThemeChanged(data);
            case 3:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }))();
    },
    onThemeChanged: function onThemeChanged(data) {
      return _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2() {
        var newTheme;
        return regenerator.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              if (Theming.isThemingEnabled) {
                _context2.next = 2;
                break;
              }
              return _context2.abrupt("return");
            case 2:
              // There will always be either an `initialTheme` or `newTheme`.
              newTheme = data.initialTheme || data.newTheme;
              if (!(!newTheme || Object.keys(newTheme).length === 0)) {
                _context2.next = 11;
                break;
              }
              if (!(data.featureFlags && data.featureFlags.isTokensFirstEnabled)) {
                _context2.next = 8;
                break;
              }
              _context2.next = 7;
              return setGlobalTheme$1({
                colorMode: 'light'
              });
            case 7:
              return _context2.abrupt("return");
            case 8:
              document.documentElement.removeAttribute('data-theme');
              document.documentElement.removeAttribute('data-color-mode');
              return _context2.abrupt("return");
            case 11:
              _context2.next = 13;
              return setGlobalTheme$1(newTheme);
            case 13:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }))();
    },
    initializeThemeListeners: function initializeThemeListeners() {
      if (!combined.theming) {
        return;
      }
      combined.register({
        theme_initialized: Theming.onThemeInitialized,
        theme_changed: Theming.onThemeChanged
      });
    }
  };

  // duplicated from ./host/stores/extension_configuration_options_store
  var ExtensionConfigurationOptionsStore = /*#__PURE__*/function () {
    function ExtensionConfigurationOptionsStore() {
      this.store = {};
    }
    var _proto = ExtensionConfigurationOptionsStore.prototype;
    _proto.set = function set(obj, val) {
      if (val) {
        var toSet = {};
        toSet[obj] = val;
      } else {
        toSet = obj;
      }
      _util.extend(this.store, toSet);
    };
    _proto.get = function get(key) {
      if (key) {
        return this.store[key];
      }
      return _util.extend({}, this.store); //clone
    };
    return ExtensionConfigurationOptionsStore;
  }();
  var ExtensionConfigurationOptionsStore$1 = new ExtensionConfigurationOptionsStore();

  function getMetrics() {
    if (window.performance && window.performance.getEntries) {
      var navigationEntries = window.performance.getEntriesByType('navigation');
      if (navigationEntries && navigationEntries[0]) {
        var timingInfo = navigationEntries[0];
        // dns loookup time
        var domainLookupTime = timingInfo.domainLookupEnd - timingInfo.domainLookupStart;
        var connectStart = timingInfo.connectStart;
        // if it's a tls connection, use the secure connection start instead
        if (timingInfo.secureConnectionStart > 0) {
          connectStart = timingInfo.secureConnectionStart;
        }
        // connection negotiation time
        var connectionTime = timingInfo.connectEnd - connectStart;
        // page body size
        var decodedBodySize = timingInfo.decodedBodySize;
        // time to load dom
        var domContentLoadedTime = timingInfo.domContentLoadedEventEnd - timingInfo.domContentLoadedEventStart;
        // time to download the page
        var fetchTime = timingInfo.responseEnd - timingInfo.fetchStart;
        return {
          domainLookupTime: domainLookupTime,
          connectionTime: connectionTime,
          decodedBodySize: decodedBodySize,
          domContentLoadedTime: domContentLoadedTime,
          fetchTime: fetchTime
        };
      }
    }
  }
  function sendMetrics() {
    var metrics = getMetrics();
    if (combined._analytics && combined._analytics.trackIframePerformanceMetrics) {
      combined._analytics.trackIframePerformanceMetrics(metrics);
    }
  }
  var analytics = {
    sendMetrics: sendMetrics
  };

  combined._hostModules._dollar = $$1;
  combined._hostModules['inline-dialog'] = combined._hostModules.inlineDialog;
  if (consumerOptions.get('sizeToParent') === true) {
    combined.env && combined.env.sizeToParent(consumerOptions.get('hideFooter') === true);
  } else {
    combined.env && combined.env.hideFooter(consumerOptions.get('hideFooter') === true);
  }
  if (consumerOptions.get('base') === true) {
    combined.env && combined.env.getLocation(function (loc) {
      $$1('head').append({
        tag: 'base',
        href: loc,
        target: '_parent'
      });
    });
  }
  $$1.each(EventsInstance.methods, function (i, method) {
    if (combined._hostModules && combined._hostModules.events) {
      combined._hostModules.events[method] = combined.events[method] = EventsInstance[method].bind(EventsInstance);
      combined._hostModules.events[method + 'Public'] = combined.events[method + 'Public'] = PublicEventsInstance[method].bind(PublicEventsInstance);
    }
  });
  combined.define = deprecate(function () {
    return AMD.define.apply(AMD, arguments);
  }, 'AP.define()', null, '5.0');
  combined.require = deprecate(function () {
    return AMD.require.apply(AMD, arguments);
  }, 'AP.require()', null, '5.0');
  var margin = combined._data.options.isDialog ? '10px 10px 0 10px' : '0';
  if (consumerOptions.get('margin') !== false) {
    var setBodyMargin = function setBodyMargin() {
      if (document.body) {
        document.body.style.setProperty('margin', margin, 'important');
      }
    };
    setBodyMargin(); // Try to set it straight away
    window.addEventListener('DOMContentLoaded', setBodyMargin); // If it doesn't exist now (likely) we can set it later
  }

  combined.Meta = {
    get: Meta.getMeta
  };
  combined.meta = Meta.getMeta;
  combined.localUrl = Meta.localUrl;
  combined._hostModules._util = combined._util = {
    each: _util.each,
    log: _util.log,
    decodeQueryComponent: _util.decodeQueryComponent,
    bind: _util.bind,
    unbind: _util.unbind,
    extend: _util.extend,
    trim: _util.trim,
    debounce: _util.debounce,
    isFunction: _util.isFunction,
    handleError: _util.handleError
  };
  if (combined.defineModule) {
    combined.defineModule('env', {
      resize: function resize(w, h, callback) {
        var iframe = document.getElementById(callback._context.extension_id);
        iframe.style.width = w + (typeof w === 'number' ? 'px' : '');
        iframe.style.height = h + (typeof h === 'number' ? 'px' : '');
      }
    });
  }
  if (combined._data && combined._data.origin) {
    combined.registerAny(function (data, callback) {
      // dialog.close event doesn't have event data
      if (data && data.event && data.sender) {
        PublicEventsInstance._anyListener(data, callback);
      } else {
        EventsInstance._anyListener(data, callback);
      }
    });
  }

  // Sets up theme-related event listeners but DOES NOT react to them.
  // The Connect app has to call AP.theming.initializeTheming() to start reacting to theme changes in the host.
  Theming.initializeThemeListeners();

  // gets the global options from the parent iframe (if present) so they can propagate to future sub-iframes.
  ExtensionConfigurationOptionsStore$1.set(combined._data.options.globalOptions);
  if (document.readyState === 'complete') {
    if (typeof window.requestIdleCallback === 'function') {
      window.requestIdleCallback(analytics.sendMetrics, {
        timeout: 1000
      });
    } else {
      analytics.sendMetrics();
    }
  } else {
    window.addEventListener('load', analytics.sendMetrics);
  }

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::4775571c3069bfd6624c6d9e47870342>>
   * @codegenCommand yarn build tokens
   */
  var atlassianLight = "\nhtml[data-color-mode=\"light\"][data-theme~=\"light:light\"],\nhtml[data-color-mode=\"dark\"][data-theme~=\"dark:light\"] {\n  color-scheme: light;\n  --ds-text: #172B4D;\n  --ds-text-accent-lime: #4C6B1F;\n  --ds-text-accent-lime-bolder: #37471F;\n  --ds-text-accent-red: #AE2A19;\n  --ds-text-accent-red-bolder: #601E16;\n  --ds-text-accent-orange: #974F0C;\n  --ds-text-accent-orange-bolder: #5F3811;\n  --ds-text-accent-yellow: #7F5F01;\n  --ds-text-accent-yellow-bolder: #533F04;\n  --ds-text-accent-green: #216E4E;\n  --ds-text-accent-green-bolder: #164B35;\n  --ds-text-accent-teal: #206B74;\n  --ds-text-accent-teal-bolder: #1D474C;\n  --ds-text-accent-blue: #0055CC;\n  --ds-text-accent-blue-bolder: #09326C;\n  --ds-text-accent-purple: #5E4DB2;\n  --ds-text-accent-purple-bolder: #352C63;\n  --ds-text-accent-magenta: #943D73;\n  --ds-text-accent-magenta-bolder: #50253F;\n  --ds-text-accent-gray: #44546F;\n  --ds-text-accent-gray-bolder: #091E42;\n  --ds-text-disabled: #091E424F;\n  --ds-text-inverse: #FFFFFF;\n  --ds-text-selected: #0C66E4;\n  --ds-text-brand: #0C66E4;\n  --ds-text-danger: #AE2A19;\n  --ds-text-warning: #974F0C;\n  --ds-text-warning-inverse: #172B4D;\n  --ds-text-success: #216E4E;\n  --ds-text-discovery: #5E4DB2;\n  --ds-text-information: #0055CC;\n  --ds-text-subtlest: #626F86;\n  --ds-text-subtle: #44546F;\n  --ds-link: #0C66E4;\n  --ds-link-pressed: #0055CC;\n  --ds-icon: #44546F;\n  --ds-icon-accent-lime: #6A9A23;\n  --ds-icon-accent-red: #E34935;\n  --ds-icon-accent-orange: #D97008;\n  --ds-icon-accent-yellow: #B38600;\n  --ds-icon-accent-green: #22A06B;\n  --ds-icon-accent-teal: #1D9AAA;\n  --ds-icon-accent-blue: #1D7AFC;\n  --ds-icon-accent-purple: #8270DB;\n  --ds-icon-accent-magenta: #CD519D;\n  --ds-icon-accent-gray: #758195;\n  --ds-icon-disabled: #091E424F;\n  --ds-icon-inverse: #FFFFFF;\n  --ds-icon-selected: #0C66E4;\n  --ds-icon-brand: #0C66E4;\n  --ds-icon-danger: #E34935;\n  --ds-icon-warning: #D97008;\n  --ds-icon-warning-inverse: #172B4D;\n  --ds-icon-success: #22A06B;\n  --ds-icon-discovery: #8270DB;\n  --ds-icon-information: #1D7AFC;\n  --ds-icon-subtle: #626F86;\n  --ds-border: #091E4224;\n  --ds-border-accent-lime: #6A9A23;\n  --ds-border-accent-red: #E34935;\n  --ds-border-accent-orange: #D97008;\n  --ds-border-accent-yellow: #B38600;\n  --ds-border-accent-green: #22A06B;\n  --ds-border-accent-teal: #1D9AAA;\n  --ds-border-accent-blue: #1D7AFC;\n  --ds-border-accent-purple: #8270DB;\n  --ds-border-accent-magenta: #CD519D;\n  --ds-border-accent-gray: #758195;\n  --ds-border-disabled: #091E420F;\n  --ds-border-focused: #388BFF;\n  --ds-border-input: #091E4224;\n  --ds-border-inverse: #FFFFFF;\n  --ds-border-selected: #0C66E4;\n  --ds-border-brand: #0C66E4;\n  --ds-border-danger: #E34935;\n  --ds-border-warning: #D97008;\n  --ds-border-success: #22A06B;\n  --ds-border-discovery: #8270DB;\n  --ds-border-information: #1D7AFC;\n  --ds-border-bold: #758195;\n  --ds-background-accent-lime-subtlest: #EEFBDA;\n  --ds-background-accent-lime-subtler: #D3F1A7;\n  --ds-background-accent-lime-subtle: #94C748;\n  --ds-background-accent-lime-bolder: #5B7F24;\n  --ds-background-accent-red-subtlest: #FFEDEB;\n  --ds-background-accent-red-subtler: #FFD2CC;\n  --ds-background-accent-red-subtle: #F87462;\n  --ds-background-accent-red-bolder: #CA3521;\n  --ds-background-accent-orange-subtlest: #FFF4E5;\n  --ds-background-accent-orange-subtler: #FFE2BD;\n  --ds-background-accent-orange-subtle: #FAA53D;\n  --ds-background-accent-orange-bolder: #B65C02;\n  --ds-background-accent-yellow-subtlest: #FFF7D6;\n  --ds-background-accent-yellow-subtler: #F8E6A0;\n  --ds-background-accent-yellow-subtle: #E2B203;\n  --ds-background-accent-yellow-bolder: #946F00;\n  --ds-background-accent-green-subtlest: #DFFCF0;\n  --ds-background-accent-green-subtler: #BAF3DB;\n  --ds-background-accent-green-subtle: #4BCE97;\n  --ds-background-accent-green-bolder: #1F845A;\n  --ds-background-accent-teal-subtlest: #E3FAFC;\n  --ds-background-accent-teal-subtler: #C1F0F5;\n  --ds-background-accent-teal-subtle: #60C6D2;\n  --ds-background-accent-teal-bolder: #1D7F8C;\n  --ds-background-accent-blue-subtlest: #E9F2FF;\n  --ds-background-accent-blue-subtler: #CCE0FF;\n  --ds-background-accent-blue-subtle: #579DFF;\n  --ds-background-accent-blue-bolder: #0C66E4;\n  --ds-background-accent-purple-subtlest: #F3F0FF;\n  --ds-background-accent-purple-subtler: #DFD8FD;\n  --ds-background-accent-purple-subtle: #9F8FEF;\n  --ds-background-accent-purple-bolder: #6E5DC6;\n  --ds-background-accent-magenta-subtlest: #FFECF8;\n  --ds-background-accent-magenta-subtler: #FDD0EC;\n  --ds-background-accent-magenta-subtle: #E774BB;\n  --ds-background-accent-magenta-bolder: #AE4787;\n  --ds-background-accent-gray-subtlest: #F1F2F4;\n  --ds-background-accent-gray-subtler: #DCDFE4;\n  --ds-background-accent-gray-subtle: #8590A2;\n  --ds-background-accent-gray-bolder: #626F86;\n  --ds-background-disabled: #091E4208;\n  --ds-background-input: #FFFFFF;\n  --ds-background-input-hovered: #F7F8F9;\n  --ds-background-input-pressed: #FFFFFF;\n  --ds-background-inverse-subtle: #00000029;\n  --ds-background-inverse-subtle-hovered: #0000003D;\n  --ds-background-inverse-subtle-pressed: #00000052;\n  --ds-background-neutral: #091E420F;\n  --ds-background-neutral-hovered: #091E4224;\n  --ds-background-neutral-pressed: #091E424F;\n  --ds-background-neutral-subtle: #00000000;\n  --ds-background-neutral-subtle-hovered: #091E420F;\n  --ds-background-neutral-subtle-pressed: #091E4224;\n  --ds-background-neutral-bold: #44546F;\n  --ds-background-neutral-bold-hovered: #2C3E5D;\n  --ds-background-neutral-bold-pressed: #172B4D;\n  --ds-background-selected: #E9F2FF;\n  --ds-background-selected-hovered: #CCE0FF;\n  --ds-background-selected-pressed: #85B8FF;\n  --ds-background-selected-bold: #0C66E4;\n  --ds-background-selected-bold-hovered: #0055CC;\n  --ds-background-selected-bold-pressed: #09326C;\n  --ds-background-brand-bold: #0C66E4;\n  --ds-background-brand-bold-hovered: #0055CC;\n  --ds-background-brand-bold-pressed: #09326C;\n  --ds-background-danger: #FFEDEB;\n  --ds-background-danger-hovered: #FFD2CC;\n  --ds-background-danger-pressed: #FF9C8F;\n  --ds-background-danger-bold: #CA3521;\n  --ds-background-danger-bold-hovered: #AE2A19;\n  --ds-background-danger-bold-pressed: #601E16;\n  --ds-background-warning: #FFF7D6;\n  --ds-background-warning-hovered: #F8E6A0;\n  --ds-background-warning-pressed: #F5CD47;\n  --ds-background-warning-bold: #E2B203;\n  --ds-background-warning-bold-hovered: #CF9F02;\n  --ds-background-warning-bold-pressed: #B38600;\n  --ds-background-success: #DFFCF0;\n  --ds-background-success-hovered: #BAF3DB;\n  --ds-background-success-pressed: #7EE2B8;\n  --ds-background-success-bold: #1F845A;\n  --ds-background-success-bold-hovered: #216E4E;\n  --ds-background-success-bold-pressed: #164B35;\n  --ds-background-discovery: #F3F0FF;\n  --ds-background-discovery-hovered: #DFD8FD;\n  --ds-background-discovery-pressed: #B8ACF6;\n  --ds-background-discovery-bold: #6E5DC6;\n  --ds-background-discovery-bold-hovered: #5E4DB2;\n  --ds-background-discovery-bold-pressed: #352C63;\n  --ds-background-information: #E9F2FF;\n  --ds-background-information-hovered: #CCE0FF;\n  --ds-background-information-pressed: #85B8FF;\n  --ds-background-information-bold: #0C66E4;\n  --ds-background-information-bold-hovered: #0055CC;\n  --ds-background-information-bold-pressed: #09326C;\n  --ds-blanket: #091E427D;\n  --ds-blanket-selected: #388BFF14;\n  --ds-blanket-danger: #EF5C4814;\n  --ds-interaction-hovered: #00000029;\n  --ds-interaction-pressed: #00000052;\n  --ds-skeleton: #091E420F;\n  --ds-skeleton-subtle: #091E4208;\n  --ds-chart-categorical-1: #1D9AAA;\n  --ds-chart-categorical-1-hovered: #1D7F8C;\n  --ds-chart-categorical-2: #5E4DB2;\n  --ds-chart-categorical-2-hovered: #352C63;\n  --ds-chart-categorical-3: #D97008;\n  --ds-chart-categorical-3-hovered: #B65C02;\n  --ds-chart-categorical-4: #943D73;\n  --ds-chart-categorical-4-hovered: #50253F;\n  --ds-chart-categorical-5: #09326C;\n  --ds-chart-categorical-5-hovered: #092957;\n  --ds-chart-categorical-6: #8F7EE7;\n  --ds-chart-categorical-6-hovered: #8270DB;\n  --ds-chart-categorical-7: #50253F;\n  --ds-chart-categorical-7-hovered: #421F34;\n  --ds-chart-categorical-8: #974F0C;\n  --ds-chart-categorical-8-hovered: #5F3811;\n  --ds-chart-lime-bold: #6A9A23;\n  --ds-chart-lime-bold-hovered: #5B7F24;\n  --ds-chart-lime-bolder: #5B7F24;\n  --ds-chart-lime-bolder-hovered: #4C6B1F;\n  --ds-chart-lime-boldest: #4C6B1F;\n  --ds-chart-lime-boldest-hovered: #37471F;\n  --ds-chart-neutral: #8590A2;\n  --ds-chart-neutral-hovered: #758195;\n  --ds-chart-red-bold: #EF5C48;\n  --ds-chart-red-bold-hovered: #E34935;\n  --ds-chart-red-bolder: #E34935;\n  --ds-chart-red-bolder-hovered: #CA3521;\n  --ds-chart-red-boldest: #AE2A19;\n  --ds-chart-red-boldest-hovered: #601E16;\n  --ds-chart-orange-bold: #D97008;\n  --ds-chart-orange-bold-hovered: #B65C02;\n  --ds-chart-orange-bolder: #B65C02;\n  --ds-chart-orange-bolder-hovered: #974F0C;\n  --ds-chart-orange-boldest: #974F0C;\n  --ds-chart-orange-boldest-hovered: #5F3811;\n  --ds-chart-yellow-bold: #B38600;\n  --ds-chart-yellow-bold-hovered: #946F00;\n  --ds-chart-yellow-bolder: #946F00;\n  --ds-chart-yellow-bolder-hovered: #7F5F01;\n  --ds-chart-yellow-boldest: #7F5F01;\n  --ds-chart-yellow-boldest-hovered: #533F04;\n  --ds-chart-green-bold: #22A06B;\n  --ds-chart-green-bold-hovered: #1F845A;\n  --ds-chart-green-bolder: #1F845A;\n  --ds-chart-green-bolder-hovered: #216E4E;\n  --ds-chart-green-boldest: #216E4E;\n  --ds-chart-green-boldest-hovered: #164B35;\n  --ds-chart-teal-bold: #1D9AAA;\n  --ds-chart-teal-bold-hovered: #1D7F8C;\n  --ds-chart-teal-bolder: #1D7F8C;\n  --ds-chart-teal-bolder-hovered: #206B74;\n  --ds-chart-teal-boldest: #206B74;\n  --ds-chart-teal-boldest-hovered: #1D474C;\n  --ds-chart-blue-bold: #388BFF;\n  --ds-chart-blue-bold-hovered: #1D7AFC;\n  --ds-chart-blue-bolder: #1D7AFC;\n  --ds-chart-blue-bolder-hovered: #0C66E4;\n  --ds-chart-blue-boldest: #0055CC;\n  --ds-chart-blue-boldest-hovered: #09326C;\n  --ds-chart-purple-bold: #8F7EE7;\n  --ds-chart-purple-bold-hovered: #8270DB;\n  --ds-chart-purple-bolder: #8270DB;\n  --ds-chart-purple-bolder-hovered: #6E5DC6;\n  --ds-chart-purple-boldest: #5E4DB2;\n  --ds-chart-purple-boldest-hovered: #352C63;\n  --ds-chart-magenta-bold: #DA62AC;\n  --ds-chart-magenta-bold-hovered: #CD519D;\n  --ds-chart-magenta-bolder: #CD519D;\n  --ds-chart-magenta-bolder-hovered: #AE4787;\n  --ds-chart-magenta-boldest: #943D73;\n  --ds-chart-magenta-boldest-hovered: #50253F;\n  --ds-chart-gray-bold: #8590A2;\n  --ds-chart-gray-bold-hovered: #758195;\n  --ds-chart-gray-bolder: #758195;\n  --ds-chart-gray-bolder-hovered: #626F86;\n  --ds-chart-gray-boldest: #44546F;\n  --ds-chart-gray-boldest-hovered: #2C3E5D;\n  --ds-chart-brand: #1D7AFC;\n  --ds-chart-brand-hovered: #0C66E4;\n  --ds-chart-danger: #EF5C48;\n  --ds-chart-danger-hovered: #E34935;\n  --ds-chart-danger-bold: #AE2A19;\n  --ds-chart-danger-bold-hovered: #601E16;\n  --ds-chart-warning: #B38600;\n  --ds-chart-warning-hovered: #946F00;\n  --ds-chart-warning-bold: #7F5F01;\n  --ds-chart-warning-bold-hovered: #533F04;\n  --ds-chart-success: #22A06B;\n  --ds-chart-success-hovered: #1F845A;\n  --ds-chart-success-bold: #216E4E;\n  --ds-chart-success-bold-hovered: #164B35;\n  --ds-chart-discovery: #8F7EE7;\n  --ds-chart-discovery-hovered: #8270DB;\n  --ds-chart-discovery-bold: #5E4DB2;\n  --ds-chart-discovery-bold-hovered: #352C63;\n  --ds-chart-information: #388BFF;\n  --ds-chart-information-hovered: #1D7AFC;\n  --ds-chart-information-bold: #0055CC;\n  --ds-chart-information-bold-hovered: #09326C;\n  --ds-surface: #FFFFFF;\n  --ds-surface-hovered: #F1F2F4;\n  --ds-surface-pressed: #DCDFE4;\n  --ds-surface-overlay: #FFFFFF;\n  --ds-surface-overlay-hovered: #F1F2F4;\n  --ds-surface-overlay-pressed: #DCDFE4;\n  --ds-surface-raised: #FFFFFF;\n  --ds-surface-raised-hovered: #F1F2F4;\n  --ds-surface-raised-pressed: #DCDFE4;\n  --ds-surface-sunken: #F7F8F9;\n  --ds-shadow-overflow: 0px 0px 8px #091E4229, 0px 0px 1px #091E421F;\n  --ds-shadow-overflow-perimeter: #091e421f;\n  --ds-shadow-overflow-spread: #091e4229;\n  --ds-shadow-overlay: 0px 8px 12px #091E4226, 0px 0px 1px #091E424F;\n  --ds-shadow-raised: 0px 1px 1px #091E4240, 0px 0px 1px #091E424F;\n  --ds-opacity-disabled: 0.4;\n  --ds-opacity-loading: 0.2;\n  --ds-UNSAFE-transparent: transparent;\n}\n";

  var atlassianLight$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianLight
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::0171fd710aa3b4936cef88004b263fd0>>
   * @codegenCommand yarn build tokens
   */
  var atlassianDark = "\nhtml[data-color-mode=\"light\"][data-theme~=\"light:dark\"],\nhtml[data-color-mode=\"dark\"][data-theme~=\"dark:dark\"] {\n  color-scheme: dark;\n  --ds-text: #B6C2CF;\n  --ds-text-accent-lime: #B3DF72;\n  --ds-text-accent-lime-bolder: #D3F1A7;\n  --ds-text-accent-red: #FF9C8F;\n  --ds-text-accent-red-bolder: #FFD2CC;\n  --ds-text-accent-orange: #FEC57B;\n  --ds-text-accent-orange-bolder: #FFE2BD;\n  --ds-text-accent-yellow: #F5CD47;\n  --ds-text-accent-yellow-bolder: #F8E6A0;\n  --ds-text-accent-green: #7EE2B8;\n  --ds-text-accent-green-bolder: #BAF3DB;\n  --ds-text-accent-teal: #8BDBE5;\n  --ds-text-accent-teal-bolder: #C1F0F5;\n  --ds-text-accent-blue: #85B8FF;\n  --ds-text-accent-blue-bolder: #CCE0FF;\n  --ds-text-accent-purple: #B8ACF6;\n  --ds-text-accent-purple-bolder: #DFD8FD;\n  --ds-text-accent-magenta: #F797D2;\n  --ds-text-accent-magenta-bolder: #FDD0EC;\n  --ds-text-accent-gray: #9FADBC;\n  --ds-text-accent-gray-bolder: #DEE4EA;\n  --ds-text-disabled: #BFDBF847;\n  --ds-text-inverse: #1D2125;\n  --ds-text-selected: #579DFF;\n  --ds-text-brand: #579DFF;\n  --ds-text-danger: #FF9C8F;\n  --ds-text-warning: #F5CD47;\n  --ds-text-warning-inverse: #1D2125;\n  --ds-text-success: #7EE2B8;\n  --ds-text-discovery: #B8ACF6;\n  --ds-text-information: #85B8FF;\n  --ds-text-subtlest: #8C9BAB;\n  --ds-text-subtle: #9FADBC;\n  --ds-link: #579DFF;\n  --ds-link-pressed: #85B8FF;\n  --ds-icon: #9FADBC;\n  --ds-icon-accent-lime: #82B536;\n  --ds-icon-accent-red: #EF5C48;\n  --ds-icon-accent-orange: #F18D13;\n  --ds-icon-accent-yellow: #CF9F02;\n  --ds-icon-accent-green: #2ABB7F;\n  --ds-icon-accent-teal: #37B4C3;\n  --ds-icon-accent-blue: #388BFF;\n  --ds-icon-accent-purple: #8F7EE7;\n  --ds-icon-accent-magenta: #DA62AC;\n  --ds-icon-accent-gray: #738496;\n  --ds-icon-disabled: #BFDBF847;\n  --ds-icon-inverse: #1D2125;\n  --ds-icon-selected: #579DFF;\n  --ds-icon-brand: #579DFF;\n  --ds-icon-danger: #EF5C48;\n  --ds-icon-warning: #CF9F02;\n  --ds-icon-warning-inverse: #1D2125;\n  --ds-icon-success: #2ABB7F;\n  --ds-icon-discovery: #8F7EE7;\n  --ds-icon-information: #388BFF;\n  --ds-icon-subtle: #8C9BAB;\n  --ds-border: #A6C5E229;\n  --ds-border-accent-lime: #82B536;\n  --ds-border-accent-red: #EF5C48;\n  --ds-border-accent-orange: #F18D13;\n  --ds-border-accent-yellow: #CF9F02;\n  --ds-border-accent-green: #2ABB7F;\n  --ds-border-accent-teal: #37B4C3;\n  --ds-border-accent-blue: #388BFF;\n  --ds-border-accent-purple: #8F7EE7;\n  --ds-border-accent-magenta: #DA62AC;\n  --ds-border-accent-gray: #738496;\n  --ds-border-disabled: #A1BDD914;\n  --ds-border-focused: #85B8FF;\n  --ds-border-input: #A6C5E229;\n  --ds-border-inverse: #161A1D;\n  --ds-border-selected: #579DFF;\n  --ds-border-brand: #579DFF;\n  --ds-border-danger: #EF5C48;\n  --ds-border-warning: #CF9F02;\n  --ds-border-success: #2ABB7F;\n  --ds-border-discovery: #8F7EE7;\n  --ds-border-information: #388BFF;\n  --ds-border-bold: #738496;\n  --ds-background-accent-lime-subtlest: #2A3818;\n  --ds-background-accent-lime-subtler: #37471F;\n  --ds-background-accent-lime-subtle: #4C6B1F;\n  --ds-background-accent-lime-bolder: #94C748;\n  --ds-background-accent-red-subtlest: #4F1C16;\n  --ds-background-accent-red-subtler: #601E16;\n  --ds-background-accent-red-subtle: #AE2A19;\n  --ds-background-accent-red-bolder: #F87462;\n  --ds-background-accent-orange-subtlest: #4A2B0F;\n  --ds-background-accent-orange-subtler: #5F3811;\n  --ds-background-accent-orange-subtle: #974F0C;\n  --ds-background-accent-orange-bolder: #FAA53D;\n  --ds-background-accent-yellow-subtlest: #3F3102;\n  --ds-background-accent-yellow-subtler: #533F04;\n  --ds-background-accent-yellow-subtle: #7F5F01;\n  --ds-background-accent-yellow-bolder: #E2B203;\n  --ds-background-accent-green-subtlest: #143C2B;\n  --ds-background-accent-green-subtler: #164B35;\n  --ds-background-accent-green-subtle: #216E4E;\n  --ds-background-accent-green-bolder: #4BCE97;\n  --ds-background-accent-teal-subtlest: #15373B;\n  --ds-background-accent-teal-subtler: #1D474C;\n  --ds-background-accent-teal-subtle: #206B74;\n  --ds-background-accent-teal-bolder: #60C6D2;\n  --ds-background-accent-blue-subtlest: #092957;\n  --ds-background-accent-blue-subtler: #09326C;\n  --ds-background-accent-blue-subtle: #0055CC;\n  --ds-background-accent-blue-bolder: #579DFF;\n  --ds-background-accent-purple-subtlest: #2B2451;\n  --ds-background-accent-purple-subtler: #352C63;\n  --ds-background-accent-purple-subtle: #5E4DB2;\n  --ds-background-accent-purple-bolder: #9F8FEF;\n  --ds-background-accent-magenta-subtlest: #421F34;\n  --ds-background-accent-magenta-subtler: #50253F;\n  --ds-background-accent-magenta-subtle: #943D73;\n  --ds-background-accent-magenta-bolder: #E774BB;\n  --ds-background-accent-gray-subtlest: #2C333A;\n  --ds-background-accent-gray-subtler: #454F59;\n  --ds-background-accent-gray-subtle: #596773;\n  --ds-background-accent-gray-bolder: #8C9BAB;\n  --ds-background-disabled: #BCD6F00A;\n  --ds-background-input: #22272B;\n  --ds-background-input-hovered: #282E33;\n  --ds-background-input-pressed: #22272B;\n  --ds-background-inverse-subtle: #FFFFFF29;\n  --ds-background-inverse-subtle-hovered: #FFFFFF3D;\n  --ds-background-inverse-subtle-pressed: #FFFFFF52;\n  --ds-background-neutral: #A1BDD914;\n  --ds-background-neutral-hovered: #A6C5E229;\n  --ds-background-neutral-pressed: #BFDBF847;\n  --ds-background-neutral-subtle: #00000000;\n  --ds-background-neutral-subtle-hovered: #A1BDD914;\n  --ds-background-neutral-subtle-pressed: #A6C5E229;\n  --ds-background-neutral-bold: #9FADBC;\n  --ds-background-neutral-bold-hovered: #B6C2CF;\n  --ds-background-neutral-bold-pressed: #C7D1DB;\n  --ds-background-selected: #092957;\n  --ds-background-selected-hovered: #09326C;\n  --ds-background-selected-pressed: #0055CC;\n  --ds-background-selected-bold: #579DFF;\n  --ds-background-selected-bold-hovered: #85B8FF;\n  --ds-background-selected-bold-pressed: #CCE0FF;\n  --ds-background-brand-bold: #579DFF;\n  --ds-background-brand-bold-hovered: #85B8FF;\n  --ds-background-brand-bold-pressed: #CCE0FF;\n  --ds-background-danger: #4F1C16;\n  --ds-background-danger-hovered: #601E16;\n  --ds-background-danger-pressed: #AE2A19;\n  --ds-background-danger-bold: #F87462;\n  --ds-background-danger-bold-hovered: #FF9C8F;\n  --ds-background-danger-bold-pressed: #FFD2CC;\n  --ds-background-warning: #3F3102;\n  --ds-background-warning-hovered: #533F04;\n  --ds-background-warning-pressed: #7F5F01;\n  --ds-background-warning-bold: #E2B203;\n  --ds-background-warning-bold-hovered: #F5CD47;\n  --ds-background-warning-bold-pressed: #F8E6A0;\n  --ds-background-success: #143C2B;\n  --ds-background-success-hovered: #164B35;\n  --ds-background-success-pressed: #216E4E;\n  --ds-background-success-bold: #4BCE97;\n  --ds-background-success-bold-hovered: #7EE2B8;\n  --ds-background-success-bold-pressed: #BAF3DB;\n  --ds-background-discovery: #2B2451;\n  --ds-background-discovery-hovered: #352C63;\n  --ds-background-discovery-pressed: #5E4DB2;\n  --ds-background-discovery-bold: #9F8FEF;\n  --ds-background-discovery-bold-hovered: #B8ACF6;\n  --ds-background-discovery-bold-pressed: #DFD8FD;\n  --ds-background-information: #092957;\n  --ds-background-information-hovered: #09326C;\n  --ds-background-information-pressed: #0055CC;\n  --ds-background-information-bold: #579DFF;\n  --ds-background-information-bold-hovered: #85B8FF;\n  --ds-background-information-bold-pressed: #CCE0FF;\n  --ds-blanket: #10121499;\n  --ds-blanket-selected: #1D7AFC14;\n  --ds-blanket-danger: #E3493514;\n  --ds-interaction-hovered: #ffffff33;\n  --ds-interaction-pressed: #ffffff5c;\n  --ds-skeleton: #A1BDD914;\n  --ds-skeleton-subtle: #BCD6F00A;\n  --ds-chart-categorical-1: #1D9AAA;\n  --ds-chart-categorical-1-hovered: #37B4C3;\n  --ds-chart-categorical-2: #B8ACF6;\n  --ds-chart-categorical-2-hovered: #DFD8FD;\n  --ds-chart-categorical-3: #D97008;\n  --ds-chart-categorical-3-hovered: #F18D13;\n  --ds-chart-categorical-4: #F797D2;\n  --ds-chart-categorical-4-hovered: #FDD0EC;\n  --ds-chart-categorical-5: #CCE0FF;\n  --ds-chart-categorical-5-hovered: #E9F2FF;\n  --ds-chart-categorical-6: #8270DB;\n  --ds-chart-categorical-6-hovered: #8F7EE7;\n  --ds-chart-categorical-7: #FDD0EC;\n  --ds-chart-categorical-7-hovered: #FFECF8;\n  --ds-chart-categorical-8: #FEC57B;\n  --ds-chart-categorical-8-hovered: #FFE2BD;\n  --ds-chart-lime-bold: #37B4C3;\n  --ds-chart-lime-bold-hovered: #60C6D2;\n  --ds-chart-lime-bolder: #60C6D2;\n  --ds-chart-lime-bolder-hovered: #8BDBE5;\n  --ds-chart-lime-boldest: #8BDBE5;\n  --ds-chart-lime-boldest-hovered: #C1F0F5;\n  --ds-chart-neutral: #738496;\n  --ds-chart-neutral-hovered: #8C9BAB;\n  --ds-chart-red-bold: #E34935;\n  --ds-chart-red-bold-hovered: #EF5C48;\n  --ds-chart-red-bolder: #EF5C48;\n  --ds-chart-red-bolder-hovered: #F87462;\n  --ds-chart-red-boldest: #FF9C8F;\n  --ds-chart-red-boldest-hovered: #FFD2CC;\n  --ds-chart-orange-bold: #F18D13;\n  --ds-chart-orange-bold-hovered: #FAA53D;\n  --ds-chart-orange-bolder: #FAA53D;\n  --ds-chart-orange-bolder-hovered: #FEC57B;\n  --ds-chart-orange-boldest: #FEC57B;\n  --ds-chart-orange-boldest-hovered: #FFE2BD;\n  --ds-chart-yellow-bold: #CF9F02;\n  --ds-chart-yellow-bold-hovered: #E2B203;\n  --ds-chart-yellow-bolder: #E2B203;\n  --ds-chart-yellow-bolder-hovered: #F5CD47;\n  --ds-chart-yellow-boldest: #F5CD47;\n  --ds-chart-yellow-boldest-hovered: #F8E6A0;\n  --ds-chart-green-bold: #2ABB7F;\n  --ds-chart-green-bold-hovered: #4BCE97;\n  --ds-chart-green-bolder: #4BCE97;\n  --ds-chart-green-bolder-hovered: #7EE2B8;\n  --ds-chart-green-boldest: #7EE2B8;\n  --ds-chart-green-boldest-hovered: #BAF3DB;\n  --ds-chart-teal-bold: #37B4C3;\n  --ds-chart-teal-bold-hovered: #60C6D2;\n  --ds-chart-teal-bolder: #60C6D2;\n  --ds-chart-teal-bolder-hovered: #8BDBE5;\n  --ds-chart-teal-boldest: #8BDBE5;\n  --ds-chart-teal-boldest-hovered: #C1F0F5;\n  --ds-chart-blue-bold: #1D7AFC;\n  --ds-chart-blue-bold-hovered: #388BFF;\n  --ds-chart-blue-bolder: #388BFF;\n  --ds-chart-blue-bolder-hovered: #579DFF;\n  --ds-chart-blue-boldest: #85B8FF;\n  --ds-chart-blue-boldest-hovered: #CCE0FF;\n  --ds-chart-purple-bold: #8270DB;\n  --ds-chart-purple-bold-hovered: #8F7EE7;\n  --ds-chart-purple-bolder: #8F7EE7;\n  --ds-chart-purple-bolder-hovered: #9F8FEF;\n  --ds-chart-purple-boldest: #B8ACF6;\n  --ds-chart-purple-boldest-hovered: #DFD8FD;\n  --ds-chart-magenta-bold: #CD519D;\n  --ds-chart-magenta-bold-hovered: #DA62AC;\n  --ds-chart-magenta-bolder: #DA62AC;\n  --ds-chart-magenta-bolder-hovered: #E774BB;\n  --ds-chart-magenta-boldest: #F797D2;\n  --ds-chart-magenta-boldest-hovered: #FDD0EC;\n  --ds-chart-gray-bold: #738496;\n  --ds-chart-gray-bold-hovered: #8C9BAB;\n  --ds-chart-gray-bolder: #8C9BAB;\n  --ds-chart-gray-bolder-hovered: #9FADBC;\n  --ds-chart-gray-boldest: #9FADBC;\n  --ds-chart-gray-boldest-hovered: #B6C2CF;\n  --ds-chart-brand: #388BFF;\n  --ds-chart-brand-hovered: #579DFF;\n  --ds-chart-danger: #E34935;\n  --ds-chart-danger-hovered: #EF5C48;\n  --ds-chart-danger-bold: #FF9C8F;\n  --ds-chart-danger-bold-hovered: #FFD2CC;\n  --ds-chart-warning: #CF9F02;\n  --ds-chart-warning-hovered: #E2B203;\n  --ds-chart-warning-bold: #F5CD47;\n  --ds-chart-warning-bold-hovered: #F8E6A0;\n  --ds-chart-success: #2ABB7F;\n  --ds-chart-success-hovered: #4BCE97;\n  --ds-chart-success-bold: #7EE2B8;\n  --ds-chart-success-bold-hovered: #BAF3DB;\n  --ds-chart-discovery: #8270DB;\n  --ds-chart-discovery-hovered: #8F7EE7;\n  --ds-chart-discovery-bold: #B8ACF6;\n  --ds-chart-discovery-bold-hovered: #DFD8FD;\n  --ds-chart-information: #1D7AFC;\n  --ds-chart-information-hovered: #388BFF;\n  --ds-chart-information-bold: #85B8FF;\n  --ds-chart-information-bold-hovered: #CCE0FF;\n  --ds-surface: #1D2125;\n  --ds-surface-hovered: #22272B;\n  --ds-surface-pressed: #282E33;\n  --ds-surface-overlay: #282E33;\n  --ds-surface-overlay-hovered: #2C333A;\n  --ds-surface-overlay-pressed: #38414A;\n  --ds-surface-raised: #22272B;\n  --ds-surface-raised-hovered: #282E33;\n  --ds-surface-raised-pressed: #2C333A;\n  --ds-surface-sunken: #161A1D;\n  --ds-shadow-overflow: 0px 0px 12px #0304048F, 0px 0px 1px #03040480;\n  --ds-shadow-overflow-perimeter: #03040480;\n  --ds-shadow-overflow-spread: #0304048f;\n  --ds-shadow-overlay: inset 0px 0px 0px 1px #BCD6F01F, 0px 8px 12px #0304045C, 0px 0px 1px #03040480;\n  --ds-shadow-raised: inset 0px 0px 0px 1px #00000000, 0px 1px 1px #03040480, 0px 0px 1px #03040480;\n  --ds-opacity-disabled: 0.4;\n  --ds-opacity-loading: 0.2;\n  --ds-UNSAFE-transparent: transparent;\n}\n";

  var atlassianDark$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianDark
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::b26866f21e474d3a67f6b1454ba31352>>
   * @codegenCommand yarn build tokens
   */
  var atlassianLegacyLight = "\nhtml[data-color-mode=\"light\"][data-theme~=\"light:legacy-light\"],\nhtml[data-color-mode=\"dark\"][data-theme~=\"dark:legacy-light\"] {\n  color-scheme: light;\n  --ds-text: #172B4D;\n  --ds-text-accent-lime: #4C6B1F;\n  --ds-text-accent-lime-bolder: #37471F;\n  --ds-text-accent-red: #DE350B;\n  --ds-text-accent-red-bolder: #BF2600;\n  --ds-text-accent-orange: #F18D13;\n  --ds-text-accent-orange-bolder: #B65C02;\n  --ds-text-accent-yellow: #FF991F;\n  --ds-text-accent-yellow-bolder: #FF8B00;\n  --ds-text-accent-green: #00875A;\n  --ds-text-accent-green-bolder: #006644;\n  --ds-text-accent-teal: #00A3BF;\n  --ds-text-accent-teal-bolder: #008DA6;\n  --ds-text-accent-blue: #0052CC;\n  --ds-text-accent-blue-bolder: #0747A6;\n  --ds-text-accent-purple: #5243AA;\n  --ds-text-accent-purple-bolder: #403294;\n  --ds-text-accent-magenta: #E774BB;\n  --ds-text-accent-magenta-bolder: #DA62AC;\n  --ds-text-accent-gray: #505F79;\n  --ds-text-accent-gray-bolder: #172B4D;\n  --ds-text-disabled: #A5ADBA;\n  --ds-text-inverse: #FFFFFF;\n  --ds-text-selected: #0052CC;\n  --ds-text-brand: #0065FF;\n  --ds-text-danger: #DE350B;\n  --ds-text-warning: #974F0C;\n  --ds-text-warning-inverse: #172B4D;\n  --ds-text-success: #006644;\n  --ds-text-discovery: #403294;\n  --ds-text-information: #0052CC;\n  --ds-text-subtlest: #7A869A;\n  --ds-text-subtle: #42526E;\n  --ds-link: #0052CC;\n  --ds-link-pressed: #0747A6;\n  --ds-icon: #505F79;\n  --ds-icon-accent-lime: #6A9A23;\n  --ds-icon-accent-red: #FF5630;\n  --ds-icon-accent-orange: #D94008;\n  --ds-icon-accent-yellow: #FFAB00;\n  --ds-icon-accent-green: #36B37E;\n  --ds-icon-accent-teal: #00B8D9;\n  --ds-icon-accent-blue: #0065FF;\n  --ds-icon-accent-purple: #6554C0;\n  --ds-icon-accent-magenta: #CD519D;\n  --ds-icon-accent-gray: #5E6C84;\n  --ds-icon-disabled: #8993A4;\n  --ds-icon-inverse: #FFFFFF;\n  --ds-icon-selected: #0052CC;\n  --ds-icon-brand: #0065FF;\n  --ds-icon-danger: #DE350B;\n  --ds-icon-warning: #FFC400;\n  --ds-icon-warning-inverse: #253858;\n  --ds-icon-success: #00875A;\n  --ds-icon-discovery: #8777D9;\n  --ds-icon-information: #0747A6;\n  --ds-icon-subtle: #6B778C;\n  --ds-border: #091e4221;\n  --ds-border-accent-lime: #6A9A23;\n  --ds-border-accent-red: #FF5630;\n  --ds-border-accent-orange: #D94008;\n  --ds-border-accent-yellow: #FFAB00;\n  --ds-border-accent-green: #36B37E;\n  --ds-border-accent-teal: #00B8D9;\n  --ds-border-accent-blue: #0065FF;\n  --ds-border-accent-purple: #6554C0;\n  --ds-border-accent-magenta: #CD519D;\n  --ds-border-accent-gray: #5E6C84;\n  --ds-border-disabled: #FAFBFC;\n  --ds-border-focused: #4C9AFF;\n  --ds-border-input: #FAFBFC;\n  --ds-border-inverse: #FFFFFF;\n  --ds-border-selected: #0052CC;\n  --ds-border-brand: #0052CC;\n  --ds-border-danger: #FF5630;\n  --ds-border-warning: #FFC400;\n  --ds-border-success: #00875A;\n  --ds-border-discovery: #998DD9;\n  --ds-border-information: #0065FF;\n  --ds-border-bold: #344563;\n  --ds-background-accent-lime-subtlest: #EEFBDA;\n  --ds-background-accent-lime-subtler: #D3F1A7;\n  --ds-background-accent-lime-subtle: #94C748;\n  --ds-background-accent-lime-bolder: #5B7F24;\n  --ds-background-accent-red-subtlest: #FF8F73;\n  --ds-background-accent-red-subtler: #FF7452;\n  --ds-background-accent-red-subtle: #DE350B;\n  --ds-background-accent-red-bolder: #DE350B;\n  --ds-background-accent-orange-subtlest: #F18D13;\n  --ds-background-accent-orange-subtler: #B65C02;\n  --ds-background-accent-orange-subtle: #5F3811;\n  --ds-background-accent-orange-bolder: #43290F;\n  --ds-background-accent-yellow-subtlest: #FFE380;\n  --ds-background-accent-yellow-subtler: #FFC400;\n  --ds-background-accent-yellow-subtle: #FF991F;\n  --ds-background-accent-yellow-bolder: #FF991F;\n  --ds-background-accent-green-subtlest: #79F2C0;\n  --ds-background-accent-green-subtler: #57D9A3;\n  --ds-background-accent-green-subtle: #00875A;\n  --ds-background-accent-green-bolder: #00875A;\n  --ds-background-accent-teal-subtlest: #79E2F2;\n  --ds-background-accent-teal-subtler: #00C7E6;\n  --ds-background-accent-teal-subtle: #00A3BF;\n  --ds-background-accent-teal-bolder: #00A3BF;\n  --ds-background-accent-blue-subtlest: #4C9AFF;\n  --ds-background-accent-blue-subtler: #2684FF;\n  --ds-background-accent-blue-subtle: #0052CC;\n  --ds-background-accent-blue-bolder: #0052CC;\n  --ds-background-accent-purple-subtlest: #998DD9;\n  --ds-background-accent-purple-subtler: #8777D9;\n  --ds-background-accent-purple-subtle: #5243AA;\n  --ds-background-accent-purple-bolder: #5243AA;\n  --ds-background-accent-magenta-subtlest: #E774BB;\n  --ds-background-accent-magenta-subtler: #E774BB;\n  --ds-background-accent-magenta-subtle: #E774BB;\n  --ds-background-accent-magenta-bolder: #E774BB;\n  --ds-background-accent-gray-subtlest: #6B778C;\n  --ds-background-accent-gray-subtler: #5E6C84;\n  --ds-background-accent-gray-subtle: #42526E;\n  --ds-background-accent-gray-bolder: #505F79;\n  --ds-background-disabled: #091e4289;\n  --ds-background-input: #FAFBFC;\n  --ds-background-input-hovered: #EBECF0;\n  --ds-background-input-pressed: #FFFFFF;\n  --ds-background-inverse-subtle: #00000029;\n  --ds-background-inverse-subtle-hovered: #0000003D;\n  --ds-background-inverse-subtle-pressed: #00000052;\n  --ds-background-neutral: #DFE1E6;\n  --ds-background-neutral-hovered: #091e4214;\n  --ds-background-neutral-pressed: #B3D4FF;\n  --ds-background-neutral-subtle: transparent;\n  --ds-background-neutral-subtle-hovered: #091e4214;\n  --ds-background-neutral-subtle-pressed: #B3D4FF;\n  --ds-background-neutral-bold: #42526E;\n  --ds-background-neutral-bold-hovered: #505F79;\n  --ds-background-neutral-bold-pressed: #344563;\n  --ds-background-selected: #DEEBFF;\n  --ds-background-selected-hovered: #B3D4FF;\n  --ds-background-selected-pressed: #4C9AFF;\n  --ds-background-selected-bold: #0052CC;\n  --ds-background-selected-bold-hovered: #2684FF;\n  --ds-background-selected-bold-pressed: #0052CC;\n  --ds-background-brand-bold: #0052CC;\n  --ds-background-brand-bold-hovered: #0065FF;\n  --ds-background-brand-bold-pressed: #0747A6;\n  --ds-background-danger: #FFEBE6;\n  --ds-background-danger-hovered: #FFBDAD;\n  --ds-background-danger-pressed: #FF8F73;\n  --ds-background-danger-bold: #DE350B;\n  --ds-background-danger-bold-hovered: #FF5630;\n  --ds-background-danger-bold-pressed: #BF2600;\n  --ds-background-warning: #FFFAE6;\n  --ds-background-warning-hovered: #FFF0B3;\n  --ds-background-warning-pressed: #FFE380;\n  --ds-background-warning-bold: #FFAB00;\n  --ds-background-warning-bold-hovered: #FFC400;\n  --ds-background-warning-bold-pressed: #FF991F;\n  --ds-background-success: #E3FCEF;\n  --ds-background-success-hovered: #ABF5D1;\n  --ds-background-success-pressed: #79F2C0;\n  --ds-background-success-bold: #00875A;\n  --ds-background-success-bold-hovered: #57D9A3;\n  --ds-background-success-bold-pressed: #00875A;\n  --ds-background-discovery: #EAE6FF;\n  --ds-background-discovery-hovered: #C0B6F2;\n  --ds-background-discovery-pressed: #998DD9;\n  --ds-background-discovery-bold: #5243AA;\n  --ds-background-discovery-bold-hovered: #8777D9;\n  --ds-background-discovery-bold-pressed: #5243AA;\n  --ds-background-information: #DEEBFF;\n  --ds-background-information-hovered: #B3D4FF;\n  --ds-background-information-pressed: #4C9AFF;\n  --ds-background-information-bold: #0052CC;\n  --ds-background-information-bold-hovered: #2684FF;\n  --ds-background-information-bold-pressed: #0052CC;\n  --ds-blanket: #091e4289;\n  --ds-blanket-selected: #388BFF14;\n  --ds-blanket-danger: #EF5C4814;\n  --ds-interaction-hovered: #00000029;\n  --ds-interaction-pressed: #00000052;\n  --ds-skeleton: #F4F5F7;\n  --ds-skeleton-subtle: #091e420a;\n  --ds-chart-categorical-1: #00B8D9;\n  --ds-chart-categorical-1-hovered: #00A3BF;\n  --ds-chart-categorical-2: #5243AA;\n  --ds-chart-categorical-2-hovered: #403294;\n  --ds-chart-categorical-3: #D94008;\n  --ds-chart-categorical-3-hovered: #B65C02;\n  --ds-chart-categorical-4: #943D73;\n  --ds-chart-categorical-4-hovered: #50253F;\n  --ds-chart-categorical-5: #0052CC;\n  --ds-chart-categorical-5-hovered: #0747A6;\n  --ds-chart-categorical-6: #5243AA;\n  --ds-chart-categorical-6-hovered: #403294;\n  --ds-chart-categorical-7: #50253F;\n  --ds-chart-categorical-7-hovered: #341829;\n  --ds-chart-categorical-8: #974F0C;\n  --ds-chart-categorical-8-hovered: #5F3811;\n  --ds-chart-lime-bold: #6A9A23;\n  --ds-chart-lime-bold-hovered: #5B7F24;\n  --ds-chart-lime-bolder: #5B7F24;\n  --ds-chart-lime-bolder-hovered: #4C6B1F;\n  --ds-chart-lime-boldest: #4C6B1F;\n  --ds-chart-lime-boldest-hovered: #37471F;\n  --ds-chart-neutral: #5E6C84;\n  --ds-chart-neutral-hovered: #505F79;\n  --ds-chart-red-bold: #FF5630;\n  --ds-chart-red-bold-hovered: #DE350B;\n  --ds-chart-red-bolder: #DE350B;\n  --ds-chart-red-bolder-hovered: #BF2600;\n  --ds-chart-red-boldest: #BF2600;\n  --ds-chart-red-boldest-hovered: #BF2600;\n  --ds-chart-orange-bold: #D97008;\n  --ds-chart-orange-bold-hovered: #B65C02;\n  --ds-chart-orange-bolder: #B65C02;\n  --ds-chart-orange-bolder-hovered: #974F0C;\n  --ds-chart-orange-boldest: #974F0C;\n  --ds-chart-orange-boldest-hovered: #5F3811;\n  --ds-chart-yellow-bold: #FFAB00;\n  --ds-chart-yellow-bold-hovered: #FF991F;\n  --ds-chart-yellow-bolder: #FF991F;\n  --ds-chart-yellow-bolder-hovered: #FF8B00;\n  --ds-chart-yellow-boldest: #FF8B00;\n  --ds-chart-yellow-boldest-hovered: #FF8B00;\n  --ds-chart-green-bold: #36B37E;\n  --ds-chart-green-bold-hovered: #00875A;\n  --ds-chart-green-bolder: #00875A;\n  --ds-chart-green-bolder-hovered: #006644;\n  --ds-chart-green-boldest: #006644;\n  --ds-chart-green-boldest-hovered: #006644;\n  --ds-chart-teal-bold: #00B8D9;\n  --ds-chart-teal-bold-hovered: #00A3BF;\n  --ds-chart-teal-bolder: #00A3BF;\n  --ds-chart-teal-bolder-hovered: #008DA6;\n  --ds-chart-teal-boldest: #008DA6;\n  --ds-chart-teal-boldest-hovered: #008DA6;\n  --ds-chart-blue-bold: #0065FF;\n  --ds-chart-blue-bold-hovered: #0052CC;\n  --ds-chart-blue-bolder: #0052CC;\n  --ds-chart-blue-bolder-hovered: #0747A6;\n  --ds-chart-blue-boldest: #0747A6;\n  --ds-chart-blue-boldest-hovered: #0747A6;\n  --ds-chart-purple-bold: #6554C0;\n  --ds-chart-purple-bold-hovered: #5243AA;\n  --ds-chart-purple-bolder: #5243AA;\n  --ds-chart-purple-bolder-hovered: #403294;\n  --ds-chart-purple-boldest: #403294;\n  --ds-chart-purple-boldest-hovered: #403294;\n  --ds-chart-magenta-bold: #DA62AC;\n  --ds-chart-magenta-bold-hovered: #CD519D;\n  --ds-chart-magenta-bolder: #CD519D;\n  --ds-chart-magenta-bolder-hovered: #AE4787;\n  --ds-chart-magenta-boldest: #943D73;\n  --ds-chart-magenta-boldest-hovered: #50253F;\n  --ds-chart-gray-bold: #5E6C84;\n  --ds-chart-gray-bold-hovered: #505F79;\n  --ds-chart-gray-bolder: #505F79;\n  --ds-chart-gray-bolder-hovered: #42526E;\n  --ds-chart-gray-boldest: #42526E;\n  --ds-chart-gray-boldest-hovered: #42526E;\n  --ds-chart-brand: #0065FF;\n  --ds-chart-brand-hovered: #0052CC;\n  --ds-chart-danger: #FF5630;\n  --ds-chart-danger-hovered: #DE350B;\n  --ds-chart-danger-bold: #DE350B;\n  --ds-chart-danger-bold-hovered: #BF2600;\n  --ds-chart-warning: #FFAB00;\n  --ds-chart-warning-hovered: #FF991F;\n  --ds-chart-warning-bold: #FF991F;\n  --ds-chart-warning-bold-hovered: #FF8B00;\n  --ds-chart-success: #36B37E;\n  --ds-chart-success-hovered: #00875A;\n  --ds-chart-success-bold: #00875A;\n  --ds-chart-success-bold-hovered: #006644;\n  --ds-chart-discovery: #6554C0;\n  --ds-chart-discovery-hovered: #5243AA;\n  --ds-chart-discovery-bold: #5243AA;\n  --ds-chart-discovery-bold-hovered: #403294;\n  --ds-chart-information: #0065FF;\n  --ds-chart-information-hovered: #0052CC;\n  --ds-chart-information-bold: #0052CC;\n  --ds-chart-information-bold-hovered: #0747A6;\n  --ds-surface: #FFFFFF;\n  --ds-surface-hovered: #FAFBFC;\n  --ds-surface-pressed: #F4F5F7;\n  --ds-surface-overlay: #FFFFFF;\n  --ds-surface-overlay-hovered: #FAFBFC;\n  --ds-surface-overlay-pressed: #F4F5F7;\n  --ds-surface-raised: #FFFFFF;\n  --ds-surface-raised-hovered: #FAFBFC;\n  --ds-surface-raised-pressed: #F4F5F7;\n  --ds-surface-sunken: #F4F5F7;\n  --ds-shadow-overflow: 0px 0px 8px #091e4229, 0px 0px 1px #091e421F;\n  --ds-shadow-overflow-perimeter: #091e421f;\n  --ds-shadow-overflow-spread: #091e4229;\n  --ds-shadow-overlay: 0px 8px 12px #091e4226, 0px 0px 1px #091e424F;\n  --ds-shadow-raised: 0px 1px 1px #091e4240, 0px 0px 1px #091e424F;\n  --ds-opacity-disabled: 0.4;\n  --ds-opacity-loading: 0.2;\n  --ds-UNSAFE-transparent: transparent;\n}\n";

  var atlassianLegacyLight$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianLegacyLight
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::14cda525a141150d5667a66bc997b8d3>>
   * @codegenCommand yarn build tokens
   */
  var atlassianLegacyDark = "\nhtml[data-color-mode=\"light\"][data-theme~=\"light:legacy-dark\"],\nhtml[data-color-mode=\"dark\"][data-theme~=\"dark:legacy-dark\"] {\n  color-scheme: dark;\n  --ds-text: #E6EDFA;\n  --ds-text-accent-lime: #4C6B1F;\n  --ds-text-accent-lime-bolder: #37471F;\n  --ds-text-accent-red: #FF5630;\n  --ds-text-accent-red-bolder: #FF7452;\n  --ds-text-accent-orange: #FEC57B;\n  --ds-text-accent-orange-bolder: #F18D13;\n  --ds-text-accent-yellow: #FFAB00;\n  --ds-text-accent-yellow-bolder: #FFC400;\n  --ds-text-accent-green: #36B37E;\n  --ds-text-accent-green-bolder: #57D9A3;\n  --ds-text-accent-teal: #00B8D9;\n  --ds-text-accent-teal-bolder: #00C7E6;\n  --ds-text-accent-blue: #0065FF;\n  --ds-text-accent-blue-bolder: #2684FF;\n  --ds-text-accent-purple: #6554C0;\n  --ds-text-accent-purple-bolder: #8777D9;\n  --ds-text-accent-magenta: #F797D2;\n  --ds-text-accent-magenta-bolder: #FDD0EC;\n  --ds-text-accent-gray: #8C9CB8;\n  --ds-text-accent-gray-bolder: #ABBBD6;\n  --ds-text-disabled: #1B2638;\n  --ds-text-inverse: #0D1424;\n  --ds-text-selected: #0052CC;\n  --ds-text-brand: #0052CC;\n  --ds-text-danger: #FF5630;\n  --ds-text-warning: #172B4D;\n  --ds-text-warning-inverse: #0D1424;\n  --ds-text-success: #36B37E;\n  --ds-text-discovery: #6554C0;\n  --ds-text-information: #0065FF;\n  --ds-text-subtlest: #7988A3;\n  --ds-text-subtle: #9FB0CC;\n  --ds-link: #0052CC;\n  --ds-link-pressed: #0065FF;\n  --ds-icon: #DCE5F5;\n  --ds-icon-accent-lime: #6A9A23;\n  --ds-icon-accent-red: #BF2600;\n  --ds-icon-accent-orange: #F18D13;\n  --ds-icon-accent-yellow: #FF8B00;\n  --ds-icon-accent-green: #006644;\n  --ds-icon-accent-teal: #008DA6;\n  --ds-icon-accent-blue: #0747A6;\n  --ds-icon-accent-purple: #403294;\n  --ds-icon-accent-magenta: #DA62AC;\n  --ds-icon-accent-gray: #B8C7E0;\n  --ds-icon-disabled: #0d14245b;\n  --ds-icon-inverse: #202B3D;\n  --ds-icon-selected: #4C9AFF;\n  --ds-icon-brand: #4C9AFF;\n  --ds-icon-danger: #FF8F73;\n  --ds-icon-warning: #FFF0B3;\n  --ds-icon-warning-inverse: #202B3D;\n  --ds-icon-success: #57D9A3;\n  --ds-icon-discovery: #998DD9;\n  --ds-icon-information: #B3D4FF;\n  --ds-icon-subtle: #202B3D;\n  --ds-border: #202B3D;\n  --ds-border-accent-lime: #6A9A23;\n  --ds-border-accent-red: #BF2600;\n  --ds-border-accent-orange: #F18D13;\n  --ds-border-accent-yellow: #FF8B00;\n  --ds-border-accent-green: #006644;\n  --ds-border-accent-teal: #008DA6;\n  --ds-border-accent-blue: #0747A6;\n  --ds-border-accent-purple: #403294;\n  --ds-border-accent-magenta: #DA62AC;\n  --ds-border-accent-gray: #B8C7E0;\n  --ds-border-disabled: #0E1624;\n  --ds-border-focused: #B3D4FF;\n  --ds-border-input: #202B3D;\n  --ds-border-inverse: #0D1424;\n  --ds-border-selected: #0052CC;\n  --ds-border-brand: #0052CC;\n  --ds-border-danger: #DE350B;\n  --ds-border-warning: #FF8B00;\n  --ds-border-success: #006644;\n  --ds-border-discovery: #403294;\n  --ds-border-information: #0747A6;\n  --ds-border-bold: #7988A3;\n  --ds-background-accent-lime-subtlest: #EEFBDA;\n  --ds-background-accent-lime-subtler: #D3F1A7;\n  --ds-background-accent-lime-subtle: #94C748;\n  --ds-background-accent-lime-bolder: #5B7F24;\n  --ds-background-accent-red-subtlest: #BF2600;\n  --ds-background-accent-red-subtler: #DE350B;\n  --ds-background-accent-red-subtle: #FF5630;\n  --ds-background-accent-red-bolder: #FF8F73;\n  --ds-background-accent-orange-subtlest: #43290F;\n  --ds-background-accent-orange-subtler: #5F3811;\n  --ds-background-accent-orange-subtle: #974F0C;\n  --ds-background-accent-orange-bolder: #F18D13;\n  --ds-background-accent-yellow-subtlest: #FF8B00;\n  --ds-background-accent-yellow-subtler: #FF991F;\n  --ds-background-accent-yellow-subtle: #FFAB00;\n  --ds-background-accent-yellow-bolder: #FFE380;\n  --ds-background-accent-green-subtlest: #006644;\n  --ds-background-accent-green-subtler: #00875A;\n  --ds-background-accent-green-subtle: #36B37E;\n  --ds-background-accent-green-bolder: #79F2C0;\n  --ds-background-accent-teal-subtlest: #008DA6;\n  --ds-background-accent-teal-subtler: #00A3BF;\n  --ds-background-accent-teal-subtle: #00B8D9;\n  --ds-background-accent-teal-bolder: #79E2F2;\n  --ds-background-accent-blue-subtlest: #0747A6;\n  --ds-background-accent-blue-subtler: #0052CC;\n  --ds-background-accent-blue-subtle: #0065FF;\n  --ds-background-accent-blue-bolder: #4C9AFF;\n  --ds-background-accent-purple-subtlest: #403294;\n  --ds-background-accent-purple-subtler: #5243AA;\n  --ds-background-accent-purple-subtle: #6554C0;\n  --ds-background-accent-purple-bolder: #998DD9;\n  --ds-background-accent-magenta-subtlest: #341829;\n  --ds-background-accent-magenta-subtler: #50253F;\n  --ds-background-accent-magenta-subtle: #943D73;\n  --ds-background-accent-magenta-bolder: #E774BB;\n  --ds-background-accent-gray-subtlest: #8C9CB8;\n  --ds-background-accent-gray-subtler: #9FB0CC;\n  --ds-background-accent-gray-subtle: #ABBBD6;\n  --ds-background-accent-gray-bolder: #CED9EB;\n  --ds-background-disabled: #3B475C;\n  --ds-background-input: #0E1624;\n  --ds-background-input-hovered: #1B2638;\n  --ds-background-input-pressed: #0D1424;\n  --ds-background-inverse-subtle: #FFFFFF29;\n  --ds-background-inverse-subtle-hovered: #FFFFFF3D;\n  --ds-background-inverse-subtle-pressed: #FFFFFF52;\n  --ds-background-neutral: #3B475C;\n  --ds-background-neutral-hovered: #313D52;\n  --ds-background-neutral-pressed: #B3D4FF;\n  --ds-background-neutral-subtle: transparent;\n  --ds-background-neutral-subtle-hovered: #313D52;\n  --ds-background-neutral-subtle-pressed: #B3D4FF;\n  --ds-background-neutral-bold: #CED9EB;\n  --ds-background-neutral-bold-hovered: #B8C7E0;\n  --ds-background-neutral-bold-pressed: #DCE5F5;\n  --ds-background-selected: #DEEBFF;\n  --ds-background-selected-hovered: #B3D4FF;\n  --ds-background-selected-pressed: #4C9AFF;\n  --ds-background-selected-bold: #0052CC;\n  --ds-background-selected-bold-hovered: #0065FF;\n  --ds-background-selected-bold-pressed: #0747A6;\n  --ds-background-brand-bold: #0052CC;\n  --ds-background-brand-bold-hovered: #0065FF;\n  --ds-background-brand-bold-pressed: #0747A6;\n  --ds-background-danger: #FFEBE6;\n  --ds-background-danger-hovered: #FFBDAD;\n  --ds-background-danger-pressed: #FF8F73;\n  --ds-background-danger-bold: #FF5630;\n  --ds-background-danger-bold-hovered: #FF7452;\n  --ds-background-danger-bold-pressed: #DE350B;\n  --ds-background-warning: #FFFAE6;\n  --ds-background-warning-hovered: #FFF0B3;\n  --ds-background-warning-pressed: #FFE380;\n  --ds-background-warning-bold: #FFAB00;\n  --ds-background-warning-bold-hovered: #FFC400;\n  --ds-background-warning-bold-pressed: #FF991F;\n  --ds-background-success: #E3FCEF;\n  --ds-background-success-hovered: #ABF5D1;\n  --ds-background-success-pressed: #79F2C0;\n  --ds-background-success-bold: #00875A;\n  --ds-background-success-bold-hovered: #36B37E;\n  --ds-background-success-bold-pressed: #006644;\n  --ds-background-discovery: #EAE6FF;\n  --ds-background-discovery-hovered: #C0B6F2;\n  --ds-background-discovery-pressed: #998DD9;\n  --ds-background-discovery-bold: #5243AA;\n  --ds-background-discovery-bold-hovered: #6554C0;\n  --ds-background-discovery-bold-pressed: #403294;\n  --ds-background-information: #DEEBFF;\n  --ds-background-information-hovered: #B3D4FF;\n  --ds-background-information-pressed: #4C9AFF;\n  --ds-background-information-bold: #0052CC;\n  --ds-background-information-bold-hovered: #0065FF;\n  --ds-background-information-bold-pressed: #0747A6;\n  --ds-blanket: #0d1424a0;\n  --ds-blanket-selected: #1D7AFC14;\n  --ds-blanket-danger: #E3493514;\n  --ds-interaction-hovered: #ffffff33;\n  --ds-interaction-pressed: #ffffff5c;\n  --ds-skeleton: #0d1424f2;\n  --ds-skeleton-subtle: #0d1424f7;\n  --ds-chart-categorical-1: #00B8D9;\n  --ds-chart-categorical-1-hovered: #00C7E6;\n  --ds-chart-categorical-2: #6554C0;\n  --ds-chart-categorical-2-hovered: #8777D9;\n  --ds-chart-categorical-3: #D97008;\n  --ds-chart-categorical-3-hovered: #F18D13;\n  --ds-chart-categorical-4: #F797D2;\n  --ds-chart-categorical-4-hovered: #FDD0EC;\n  --ds-chart-categorical-5: #0065FF;\n  --ds-chart-categorical-5-hovered: #2684FF;\n  --ds-chart-categorical-6: #6554C0;\n  --ds-chart-categorical-6-hovered: #8777D9;\n  --ds-chart-categorical-7: #FDD0EC;\n  --ds-chart-categorical-7-hovered: #FFECF8;\n  --ds-chart-categorical-8: #FEC57B;\n  --ds-chart-categorical-8-hovered: #FFE2BD;\n  --ds-chart-lime-bold: #6A9A23;\n  --ds-chart-lime-bold-hovered: #5B7F24;\n  --ds-chart-lime-bolder: #5B7F24;\n  --ds-chart-lime-bolder-hovered: #4C6B1F;\n  --ds-chart-lime-boldest: #4C6B1F;\n  --ds-chart-lime-boldest-hovered: #37471F;\n  --ds-chart-neutral: #B8C7E0;\n  --ds-chart-neutral-hovered: #ABBBD6;\n  --ds-chart-red-bold: #BF2600;\n  --ds-chart-red-bold-hovered: #DE350B;\n  --ds-chart-red-bolder: #DE350B;\n  --ds-chart-red-bolder-hovered: #FF5630;\n  --ds-chart-red-boldest: #FF5630;\n  --ds-chart-red-boldest-hovered: #FF7452;\n  --ds-chart-orange-bold: #F18D13;\n  --ds-chart-orange-bold-hovered: #FAA53D;\n  --ds-chart-orange-bolder: #FAA53D;\n  --ds-chart-orange-bolder-hovered: #FEC57B;\n  --ds-chart-orange-boldest: #FEC57B;\n  --ds-chart-orange-boldest-hovered: #FFE2BD;\n  --ds-chart-yellow-bold: #FF8B00;\n  --ds-chart-yellow-bold-hovered: #FF991F;\n  --ds-chart-yellow-bolder: #FF991F;\n  --ds-chart-yellow-bolder-hovered: #FFAB00;\n  --ds-chart-yellow-boldest: #FFAB00;\n  --ds-chart-yellow-boldest-hovered: #FFC400;\n  --ds-chart-green-bold: #006644;\n  --ds-chart-green-bold-hovered: #00875A;\n  --ds-chart-green-bolder: #00875A;\n  --ds-chart-green-bolder-hovered: #36B37E;\n  --ds-chart-green-boldest: #36B37E;\n  --ds-chart-green-boldest-hovered: #57D9A3;\n  --ds-chart-teal-bold: #008DA6;\n  --ds-chart-teal-bold-hovered: #00A3BF;\n  --ds-chart-teal-bolder: #00A3BF;\n  --ds-chart-teal-bolder-hovered: #00B8D9;\n  --ds-chart-teal-boldest: #00B8D9;\n  --ds-chart-teal-boldest-hovered: #00C7E6;\n  --ds-chart-blue-bold: #0747A6;\n  --ds-chart-blue-bold-hovered: #0052CC;\n  --ds-chart-blue-bolder: #0052CC;\n  --ds-chart-blue-bolder-hovered: #0065FF;\n  --ds-chart-blue-boldest: #0065FF;\n  --ds-chart-blue-boldest-hovered: #2684FF;\n  --ds-chart-purple-bold: #403294;\n  --ds-chart-purple-bold-hovered: #5243AA;\n  --ds-chart-purple-bolder: #5243AA;\n  --ds-chart-purple-bolder-hovered: #6554C0;\n  --ds-chart-purple-boldest: #6554C0;\n  --ds-chart-purple-boldest-hovered: #8777D9;\n  --ds-chart-magenta-bold: #CD519D;\n  --ds-chart-magenta-bold-hovered: #DA62AC;\n  --ds-chart-magenta-bolder: #DA62AC;\n  --ds-chart-magenta-bolder-hovered: #E774BB;\n  --ds-chart-magenta-boldest: #F797D2;\n  --ds-chart-magenta-boldest-hovered: #FDD0EC;\n  --ds-chart-gray-bold: #B8C7E0;\n  --ds-chart-gray-bold-hovered: #CED9EB;\n  --ds-chart-gray-bolder: #CED9EB;\n  --ds-chart-gray-bolder-hovered: #DCE5F5;\n  --ds-chart-gray-boldest: #DCE5F5;\n  --ds-chart-gray-boldest-hovered: #E6EDFA;\n  --ds-chart-brand: #0052CC;\n  --ds-chart-brand-hovered: #0065FF;\n  --ds-chart-danger: #DE350B;\n  --ds-chart-danger-hovered: #FF5630;\n  --ds-chart-danger-bold: #FF5630;\n  --ds-chart-danger-bold-hovered: #FF7452;\n  --ds-chart-warning: #FF991F;\n  --ds-chart-warning-hovered: #FFAB00;\n  --ds-chart-warning-bold: #FFAB00;\n  --ds-chart-warning-bold-hovered: #FFC400;\n  --ds-chart-success: #00875A;\n  --ds-chart-success-hovered: #36B37E;\n  --ds-chart-success-bold: #36B37E;\n  --ds-chart-success-bold-hovered: #57D9A3;\n  --ds-chart-discovery: #5243AA;\n  --ds-chart-discovery-hovered: #6554C0;\n  --ds-chart-discovery-bold: #6554C0;\n  --ds-chart-discovery-bold-hovered: #8777D9;\n  --ds-chart-information: #0052CC;\n  --ds-chart-information-hovered: #0065FF;\n  --ds-chart-information-bold: #0065FF;\n  --ds-chart-information-bold-hovered: #2684FF;\n  --ds-surface: #1B2638;\n  --ds-surface-hovered: #202B3D;\n  --ds-surface-pressed: #283447;\n  --ds-surface-overlay: #7988A3;\n  --ds-surface-overlay-hovered: #8C9CB8;\n  --ds-surface-overlay-pressed: #9FB0CC;\n  --ds-surface-raised: #455166;\n  --ds-surface-raised-hovered: #56637A;\n  --ds-surface-raised-pressed: #67758F;\n  --ds-surface-sunken: #67758F;\n  --ds-shadow-overflow: 0px 0px 12px #0304048F, 0px 0px 1px #03040480;\n  --ds-shadow-overflow-perimeter: #03040480;\n  --ds-shadow-overflow-spread: #0304048f;\n  --ds-shadow-overlay: inset 0px 0px 0px 1px #0d14240A, 0px 8px 12px #0d14245C, 0px 0px 1px #0d142480;\n  --ds-shadow-raised: inset 0px 0px 0px 1px #00000000, 0px 1px 1px #0d142480, 0px 0px 1px #0d142480;\n  --ds-opacity-disabled: 0.4;\n  --ds-opacity-loading: 0.2;\n  --ds-UNSAFE-transparent: transparent;\n}\n";

  var atlassianLegacyDark$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianLegacyDark
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::36f0214aaedb62d3639cb79a9195eaf6>>
   * @codegenCommand yarn build tokens
   */
  var atlassianSpacing = "\nhtml[data-theme~=\"spacing:spacing\"] {\n  --ds-space-0: 0rem;\n  --ds-space-025: 0.125rem;\n  --ds-space-050: 0.25rem;\n  --ds-space-075: 0.375rem;\n  --ds-space-100: 0.5rem;\n  --ds-space-150: 0.75rem;\n  --ds-space-200: 1rem;\n  --ds-space-250: 1.25rem;\n  --ds-space-300: 1.5rem;\n  --ds-space-400: 2rem;\n  --ds-space-500: 2.5rem;\n  --ds-space-600: 3rem;\n  --ds-space-800: 4rem;\n  --ds-space-1000: 5rem;\n}\n";

  var atlassianSpacing$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianSpacing
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::3e4dc097014124b77e69b832281f37ed>>
   * @codegenCommand yarn build tokens
   */
  var atlassianTypography = "\nhtml[data-theme~=\"typography:typography\"] {\n  --ds-font-family-monospace: \"SFMono-Medium\", \"SF Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Ubuntu Mono\", Menlo, Consolas, Courier, monospace;\n  --ds-font-family-sans: -apple-system, BlinkMacSystemFont, \"Segoe UI\", \"Roboto\", \"Oxygen\", \"Ubuntu\", \"Fira Sans\", \"Droid Sans\", \"Helvetica Neue\", sans-serif;\n  --ds-font-size-050: 0.6875rem;\n  --ds-font-size-075: 0.75rem;\n  --ds-font-size-100: 0.875rem;\n  --ds-font-size-200: 1rem;\n  --ds-font-size-300: 1.25rem;\n  --ds-font-size-400: 1.5rem;\n  --ds-font-size-500: 1.8125rem;\n  --ds-font-size-600: 2.1875rem;\n  --ds-font-weight-bold: 700;\n  --ds-font-weight-medium: 500;\n  --ds-font-weight-regular: 400;\n  --ds-font-weight-semibold: 600;\n  --ds-font-lineHeight-100: 1rem;\n  --ds-font-lineHeight-200: 1.25rem;\n  --ds-font-lineHeight-300: 1.5rem;\n  --ds-font-lineHeight-400: 1.75rem;\n  --ds-font-lineHeight-500: 2rem;\n  --ds-font-lineHeight-600: 2.5rem;\n}\n";

  var atlassianTypography$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianTypography
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::861a4448ac467155c8290f2b211e99c5>>
   * @codegenCommand yarn build tokens
   */
  var atlassianShape = "\nhtml[data-theme~=\"shape:shape\"] {\n  --ds-border-radius-050: 0.125rem;\n  --ds-border-radius: 0.25rem;\n  --ds-border-radius-100: 0.25rem;\n  --ds-border-radius-200: 0.5rem;\n  --ds-border-radius-300: 0.75rem;\n  --ds-border-radius-400: 1rem;\n  --ds-border-radius-circle: 2002rem;\n  --ds-border-width: 0.0625rem;\n  --ds-border-width-0: 0rem;\n  --ds-border-width-050: 0.0625rem;\n  --ds-border-width-100: 0.125rem;\n}\n";

  var atlassianShape$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianShape
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::b14cc1106ad737bfef0b77e4b645c1df>>
   * @codegenCommand yarn build tokens
   */
  var atlassianLightNewInputBorder = "\nhtml[data-color-mode=\"light\"][data-theme~=\"light:light\"],\nhtml[data-color-mode=\"dark\"][data-theme~=\"dark:light\"] {\n  color-scheme: light;\n  --ds-border-input: #8590A2;\n}\n";

  var atlassianLightNewInputBorder$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianLightNewInputBorder
  });

  /**
   * THIS FILE WAS CREATED VIA CODEGEN DO NOT MODIFY {@see http://go/af-codegen}
   * @codegen <<SignedSource::b255ff03ae4f781bb3016003a111bed0>>
   * @codegenCommand yarn build tokens
   */
  var atlassianDarkNewInputBorder = "\nhtml[data-color-mode=\"light\"][data-theme~=\"light:dark\"],\nhtml[data-color-mode=\"dark\"][data-theme~=\"dark:dark\"] {\n  color-scheme: dark;\n  --ds-border-input: #596773;\n}\n";

  var atlassianDarkNewInputBorder$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': atlassianDarkNewInputBorder
  });

  return combined;

})();
