(function () {
    if (!window.lrefDescriptor) {
        window.lrefDescriptor = {}
    }
    window.lrefDescriptor['com.bilith.lref.confluence-asana'] = {
 "baseUrl": "/plugins/servlet/lref/asana-confluence",
 "key": "com.bilith.lref.confluence-asana",
 "modules": {
  "adminPages": [{
   "name": {"value": "Asana"},
   "key": "admin-page",
   "url": "/view?id=admin_page&provider=asana&bundle=asana-confluence"
  }],
  "dynamicContentMacros": [
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Asana Live Link Macro"},
     "editTitle": {"value": "Edit Asana Live Link Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_link_macro_editor&provider=asana&bundle=asana-confluence&key=lref-asana-task",
     "height": "350px"
    },
    "featured": true,
    "hidden": false,
    "icon": {
     "width": 80,
     "url": "/static/img/asana_80x80.png",
     "height": 80
    },
    "description": {"value": "Live Link to Asana task or project"},
    "outputType": "INLINE",
    "url": "/view?id=conf_ref_link_macro&provider=asana&bundle=asana-confluence&key=lref-asana-task&c={c}&url={url}",
    "autoconvert": {
     "matchers": [
      {"pattern": "https://app.asana.com/0/{}/{}"},
      {"pattern": "https://app.asana.com/0/{}/{}/f"},
      {"pattern": "https://app.asana.com/0/portfolio/{}/{}"}
     ],
     "urlParameter": "url"
    },
    "name": {"value": "Asana Live Link"},
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c",
      "name": {"value": "c"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-asana-task"
   },
   {
    "bodyType": "none",
    "editor": {
     "insertTitle": {"value": "Insert Embedded Asana Project Macro"},
     "editTitle": {"value": "Edit Embedded Asana Project Macro"},
     "width": "700px",
     "url": "/view?id=conf_ref_children_list_macro_editor&provider=asana&bundle=asana-confluence&key=lref-asana-tasks-list",
     "height": "400px"
    },
    "featured": true,
    "hidden": false,
    "name": {"value": "Embedded Asana Project"},
    "icon": {
     "width": 80,
     "url": "/static/img/asana_80x80.png",
     "height": 80
    },
    "description": {"value": "Content of Asana project"},
    "outputType": "BLOCK",
    "categories": ["external-content"],
    "parameters": [
     {
      "identifier": "c",
      "name": {"value": "c"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "url",
      "name": {"value": "url"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "limit",
      "name": {"value": "limit"},
      "type": "string",
      "required": false
     },
     {
      "identifier": "completion",
      "name": {"value": "completion"},
      "type": "string",
      "required": false
     }
    ],
    "key": "lref-asana-tasks-list",
    "url": "/view?id=conf_ref_children_list_macro&provider=asana&bundle=asana-confluence&key=lref-asana-tasks-list&c={c}&url={url}&limit={limit}&completion={completion}"
   }
  ],
  "dialogs": [
   {
    "options": {"header": {"value": ""}},
    "key": "dialog",
    "url": "/view?id=dialog&provider=asana&bundle=asana-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "picker",
    "url": "/view?id=picker&provider=asana&bundle=asana-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "creator",
    "url": "/view?id=creator&provider=asana&bundle=asana-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "uploader",
    "url": "/view?id=uploader&provider=asana&bundle=asana-confluence"
   },
   {
    "options": {"header": {"value": ""}},
    "key": "sharer",
    "url": "/view?id=sharer&provider=asana&bundle=asana-confluence"
   }
  ]
 }
}
}())