/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AttachmentsCommentsMacro
implements Macro {
    private static String TEMPLATE;
    private final PluginLicenseManager pluginLicenseManager;
    private final PageManager pageManager;
    private final VelocityHelperService velocityHelperService;

    public AttachmentsCommentsMacro(PluginLicenseManager pluginLicenseManager, PageManager pageManager, VelocityHelperService velocityHelperService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pageManager = pageManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String applyConfDateParam;
        boolean confDate;
        PluginLicense license;
        Map context = MacroUtils.defaultVelocityContext();
        TEMPLATE = this.pluginLicenseManager.getLicense().isDefined() ? ((license = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined() ? "templates/no-license.vm" : "templates/macros/attachments-macro-2.vm") : "templates/no-license.vm";
        String isInlineParam = params.get("inline");
        String includeDescParam = params.get("include-descendents");
        String isResolvedParam = params.get("is-resolved");
        String authorParam = params.get("author");
        String dateParam = params.get("date");
        String pageNameParam = params.get("page-name");
        String colWidthParam = params.get("comment-column-width");
        String attColWidthParam = params.get("attachment-column-width");
        String authorColWodthParam = params.get("author-column-width");
        String dateColParam = params.get("date-column-width");
        boolean inlineToDisplay = Boolean.parseBoolean(isInlineParam);
        context.put("inlineToDisplay", inlineToDisplay);
        boolean descendents = Boolean.parseBoolean(includeDescParam);
        context.put("descendents", descendents);
        boolean isResolved = Boolean.parseBoolean(isResolvedParam);
        context.put("isResolved", isResolved);
        context.put("author", Boolean.valueOf(authorParam));
        context.put("date", Boolean.valueOf(dateParam));
        context.put("page-name", Boolean.parseBoolean(pageNameParam));
        context.put("comment-column-width", colWidthParam);
        context.put("attachment-column-width", params.get("attachment-column-width"));
        context.put("author-column-width", params.get("author-column-width"));
        context.put("date-column-width", params.get("date-column-width"));
        String SPACEKEY = "";
        String PAGETITLE = "";
        String spaceKeyParam = params.get("space");
        String pageTitleParam = params.get("page-title");
        SPACEKEY = spaceKeyParam != null && spaceKeyParam.isEmpty() ? spaceKeyParam : conversionContext.getSpaceKey();
        PAGETITLE = pageTitleParam != null && pageTitleParam.isEmpty() ? pageTitleParam : conversionContext.getEntity().getTitle();
        Page pageWithAttachments = this.pageManager.getPage(SPACEKEY, PAGETITLE);
        context.put("pageWithAttachments", pageWithAttachments);
        List pageAttachments = pageWithAttachments.getAttachments();
        boolean hasVersionedComments = false;
        for (Attachment attachment : pageAttachments) {
            if (attachment.isDeleted() || !attachment.isVersionCommentAvailable()) continue;
            hasVersionedComments = true;
        }
        context.put("hasVersionedComments", hasVersionedComments);
        context.put("pageAttachments", pageAttachments);
        String dateFormat = params.get("date-format");
        if (dateFormat != null && dateFormat.isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            context.put("Formatter", formatter);
        }
        if (confDate = Boolean.parseBoolean(applyConfDateParam = params.get("apply-confluence-date"))) {
            SimpleDateFormat confFormatter = new SimpleDateFormat("dd MMM yyyy");
            context.put("confFormatter", confFormatter);
        }
        ArrayList attachmentsInlineComments = new ArrayList();
        ArrayList<Comment> parentInlineComments = new ArrayList<Comment>();
        for (Attachment attachment : pageAttachments) {
            attachmentsInlineComments.addAll(attachment.getComments());
        }
        for (Comment comment : attachmentsInlineComments) {
            if (comment.isDeleted() || comment.getParent() != null) continue;
            parentInlineComments.add(comment);
        }
        context.put("parentInlineComments", parentInlineComments);
        List pagesDescendents = pageWithAttachments.getDescendants();
        HashSet allAttachments = new HashSet();
        allAttachments.addAll(pageWithAttachments.getAttachments());
        for (Page page : pagesDescendents) {
            allAttachments.addAll(page.getAttachments());
        }
        context.put("allAttachments", allAttachments);
        HashSet inlineAllComments = new HashSet();
        HashSet<Comment> parentInlineAllComments = new HashSet<Comment>();
        for (Attachment attachment : allAttachments) {
            inlineAllComments.addAll(attachment.getComments());
        }
        for (Comment comment : inlineAllComments) {
            if (comment.isDeleted() || comment.getParent() != null) continue;
            parentInlineAllComments.add(comment);
        }
        context.put("parentInlineAllComments", parentInlineAllComments);
        return this.velocityHelperService.getRenderedTemplate(TEMPLATE, context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

