/*
 * Decompiled with CFR 0.152.
 */
package com.bh.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySpaceAdminCondition
extends BaseConfluenceCondition {
    private final Logger LOG = LoggerFactory.getLogger(MySpaceAdminCondition.class);
    private final SpacePermissionManager spacePermissionManager;
    private final PermissionManager permissionManager;

    public MySpaceAdminCondition(SpacePermissionManager spacePermissionManager, PermissionManager permissionManager) {
        this.spacePermissionManager = spacePermissionManager;
        this.permissionManager = permissionManager;
    }

    protected boolean shouldDisplay(WebInterfaceContext webInterfaceContext) {
        Space space = webInterfaceContext.getSpace();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        boolean isSystemAdmin = this.permissionManager.isSystemAdministrator(user);
        boolean isConfAdmin = this.permissionManager.isConfluenceAdministrator(user);
        boolean isSpaceAdmin = this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user);
        return isSystemAdmin || isConfAdmin || isSpaceAdmin;
    }
}

