/*
 * Decompiled with CFR 0.152.
 */
package com.bh.rest;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.bh.models.dto.BhtCommentWebModel;
import com.bh.models.dto.SpaceBannerModelDto;
import com.bh.services.AoModelsService;
import com.bh.services.BhtCommentsService;
import com.bh.services.CommentsStatsService;
import com.bh.services.UsersExtractorService;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
@Path(value="/bht-comments")
public class BhtCommentsRestResource {
    private final BhtCommentsService bhtCommentsService;
    private final CommentsStatsService statsService;
    private final AoModelsService aoModelsService;
    private final UsersExtractorService extractorService;
    private final CommentManager commentManager;

    @Inject
    public BhtCommentsRestResource(BhtCommentsService bhtCommentsService, CommentsStatsService statsService, AoModelsService aoModelsService, UsersExtractorService extractorService, CommentManager commentManager) {
        this.bhtCommentsService = bhtCommentsService;
        this.statsService = statsService;
        this.aoModelsService = aoModelsService;
        this.extractorService = extractorService;
        this.commentManager = commentManager;
    }

    @Path(value="/spaces")
    @GET
    @Produces(value={"application/json"})
    public Response getSpacesComments(@Context HttpServletRequest request, @QueryParam(value="spaceKeys") String spaceKeys, @QueryParam(value="commentType") String commentType, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo) {
        return Response.ok(this.bhtCommentsService.getSpaceComments(spaceKeys, commentType, dateFrom, dateTo)).build();
    }

    @Path(value="/user")
    @GET
    @Produces(value={"application/json"})
    public Response getUserComments(@QueryParam(value="userName") String userName) {
        List<BhtCommentWebModel> userComments = this.bhtCommentsService.getUserBhtComments(userName);
        return Response.ok(userComments).status(200).header("vendor", (Object)"BHT").build();
    }

    @Path(value="/stats/footer-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getFooterCommentsStats() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getFooterCommentsSize())).status(200).build();
    }

    @Path(value="/stats/inline-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getInlineCommentsStats() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getInlineCommentsSize())).status(200).build();
    }

    @Path(value="/stats/unres-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getUnresCommentsStats() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getInlineUNRESCommentsSize())).status(200).build();
    }

    @Path(value="/stats/res-comments")
    @GET
    @Produces(value={"application/json"})
    public Response getResCommentsStats() {
        return Response.ok((Object)String.format("{\"size\": %d}", this.statsService.getInlineRESCommentsSize())).status(200).build();
    }

    @Path(value="/panel/location")
    @GET
    @Produces(value={"application/json"})
    public Response getPanelLocations() {
        return Response.ok(this.aoModelsService.getAllModels().stream().map(s -> new SpaceBannerModelDto(s.getSpaceKey(), s.getDisplayValue())).collect(Collectors.toList())).status(200).build();
    }

    @Path(value="/user/{commentId}/comments")
    @GET
    @Produces(value={"application/json"})
    public Response getUsersFromComment(@PathParam(value="commentId") String commentId) {
        Comment comment = this.commentManager.getComment(Long.parseLong(commentId));
        return Response.ok(this.extractorService.extractUsers(comment)).build();
    }
}

