/*
 * Decompiled with CFR 0.152.
 */
package com.bh.rest;

import com.bh.models.dto.BhtCommentWebModel;
import com.bh.services.BhtCommentsService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/bht-comments-pages/")
public class BhtCommentsPageResource {
    private final BhtCommentsService bhtCommentsService;

    @Autowired
    public BhtCommentsPageResource(BhtCommentsService bhtCommentsService) {
        this.bhtCommentsService = bhtCommentsService;
    }

    @GET
    @Path(value="/page")
    @Produces(value={"application/json"})
    public Response getPageComments(@QueryParam(value="id") long id, @QueryParam(value="commentType") String commentType, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="limit") int limit) {
        List<BhtCommentWebModel> comments = this.bhtCommentsService.getPageComments(id, commentType, fromDate, toDate);
        if (comments == null || comments.isEmpty()) {
            return Response.ok(List.of()).build();
        }
        comments.sort((o1, o2) -> (int)(o1.getId() - o2.getId()));
        int commentsSize = comments.size();
        if (commentsSize > 200) {
            return Response.ok(comments.subList(0, 200)).build();
        }
        if (limit != 0 && limit <= commentsSize) {
            return Response.ok(comments.subList(0, limit)).build();
        }
        return Response.ok(comments).build();
    }
}

