/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.bh.models.dto.BhtCommentWebModel;
import com.bh.services.CommentToModelConv;
import com.bh.services.UsersExtractorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesCommentsMacro
implements Macro {
    private final Logger LOG = LoggerFactory.getLogger(PagesCommentsMacro.class);
    private static String TEMPLATE;
    private final PluginLicenseManager pluginLicenseManager;
    private final UsersExtractorService usersExtractorService;
    private final PermissionManager permissionManager;
    private final VelocityHelperService velocityHelperService;
    private final PageService pageService;
    private final CommentToModelConv commentToModelConv;

    public PagesCommentsMacro(PluginLicenseManager pluginLicenseManager, UsersExtractorService usersExtractorService, PermissionManager permissionManager, VelocityHelperService velocityHelperService, PageService pageService, CommentToModelConv commentToModelConv) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.usersExtractorService = usersExtractorService;
        this.permissionManager = permissionManager;
        this.velocityHelperService = velocityHelperService;
        this.pageService = pageService;
        this.commentToModelConv = commentToModelConv;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException, NullPointerException {
        PluginLicense license;
        Map context = MacroUtils.defaultVelocityContext();
        TEMPLATE = this.pluginLicenseManager.getLicense().isDefined() ? ((license = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined() ? "templates/no-license.vm" : "templates/macros/page_comments_with_replies-simple.vm") : "templates/no-license.vm";
        String spaceKeyParam = params.get("space-key");
        String pageNameParam = params.get("page-title");
        Boolean commentAuthor = Boolean.parseBoolean(params.get("author"));
        Boolean descendents = Boolean.parseBoolean(params.get("include-descendents"));
        Boolean includePageName = Boolean.parseBoolean(params.get("display-page-name"));
        Boolean includeContentBody = Boolean.parseBoolean(params.get("content-body"));
        Boolean parentComment = Boolean.parseBoolean(params.get("parent-comment"));
        Boolean isInline = Boolean.parseBoolean(params.get("inline-comments"));
        String resolvedOrUnresolved = params.get("inline-comments-type");
        Boolean showCreationDate = Boolean.parseBoolean(params.get("date"));
        String dateFormat = params.get("date-format");
        boolean confFormat = Boolean.parseBoolean(params.get("apply-confluence-date"));
        String bodyLength = params.get("body-length");
        int bodyLengthInt = 0;
        if (bodyLength != null) {
            bodyLengthInt = Integer.parseInt(bodyLength);
        }
        context.put("bodyLengthInt", bodyLengthInt);
        String commentedContentColumnWidthFromParams = params.get("commented-content-column-width");
        String authorColumnWidthFromParams = params.get("author-column-width");
        String commentColumnWidthFromParams = params.get("comment-column-width");
        String isResolvedColumnWidthFromParams = params.get("is-resolved-column-width");
        String pageNameColumnWidthFromParams = params.get("page-name-column-width");
        String dateColumnWidthFromParams = params.get("date-column-width");
        if (commentedContentColumnWidthFromParams != null) {
            context.put("commentedContentColumnWidthFromParams", commentedContentColumnWidthFromParams);
        }
        if (authorColumnWidthFromParams != null) {
            context.put("authorColumnWidthFromParams", authorColumnWidthFromParams);
        }
        if (commentColumnWidthFromParams != null) {
            context.put("commentColumnWidthFromParams", commentColumnWidthFromParams);
        }
        if (isResolvedColumnWidthFromParams != null) {
            context.put("isResolvedColumnWidthFromParams", isResolvedColumnWidthFromParams);
        }
        if (pageNameColumnWidthFromParams != null) {
            context.put("pageNameColumnWidthFromParams", pageNameColumnWidthFromParams);
        }
        if (dateColumnWidthFromParams != null) {
            context.put("dateColumnWidthFromParams", dateColumnWidthFromParams);
        }
        context.put("showCreationDate", showCreationDate);
        context.put("confFormat", confFormat);
        context.put("commentAuthor", commentAuthor);
        context.put("Descendents", descendents);
        context.put("IncludePageName", includePageName);
        context.put("IncludeContentBody", includeContentBody);
        context.put("IsInline", isInline);
        context.put("resolvedOrUnresolved", resolvedOrUnresolved == null ? "ALL" : resolvedOrUnresolved);
        context.put("ParentComment", parentComment);
        String spaceTitle = spaceKeyParam != null ? spaceKeyParam : conversionContext.getSpaceKey();
        String pageTitle = pageNameParam != null ? (pageNameParam.contains(":") ? pageNameParam.substring(pageNameParam.indexOf(":") + 1) : pageNameParam) : conversionContext.getEntity().getTitle();
        Page currentPage = this.pageService.getTitleAndSpaceKeyPageLocator(spaceTitle, pageTitle).getPage();
        if (this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)currentPage)) {
            List descendentsFromSpecifiedPage = currentPage.getDescendants();
            List currentPageALLComments = currentPage.getComments();
            ArrayList<BhtCommentWebModel> currentPageSimpleNOTInlineCommentsDto = new ArrayList<BhtCommentWebModel>();
            for (Comment comment : currentPageALLComments) {
                if (comment.isInlineComment()) continue;
                currentPageSimpleNOTInlineCommentsDto.add(this.commentToModelConv.convertToModel(comment));
            }
            context.put("currentPageSimpleNOTInlineComments", currentPageSimpleNOTInlineCommentsDto);
            ArrayList<Comment> currentPageAllInlineComments = new ArrayList<Comment>();
            ArrayList<BhtCommentWebModel> currentPageAllInlineCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Object comment : currentPageALLComments) {
                if (!comment.isInlineComment()) continue;
                currentPageAllInlineComments.add((Comment)comment);
                currentPageAllInlineCommentsWeb.add(this.commentToModelConv.convertToModel((Comment)comment));
            }
            context.put("CurrentPageAllInlineComments", currentPageAllInlineCommentsWeb);
            ArrayList<BhtCommentWebModel> currentPageInlineUnresolvedCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Object comment : currentPageALLComments) {
                if (!PagesCommentsMacro.isUnresolvedComment((Comment)comment)) continue;
                currentPageInlineUnresolvedCommentsWeb.add(this.commentToModelConv.convertToModel((Comment)comment));
            }
            context.put("CurrentPageInlineUnresolvedComments", currentPageInlineUnresolvedCommentsWeb);
            ArrayList<BhtCommentWebModel> currentPageInlineResolvedCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Object comment : currentPageALLComments) {
                if (!PagesCommentsMacro.isResolvedComment((Comment)comment)) continue;
                currentPageInlineResolvedCommentsWeb.add(this.commentToModelConv.convertToModel((Comment)comment));
            }
            context.put("CurrentPageInlineResolvedComments", currentPageInlineResolvedCommentsWeb);
            ArrayList allComments = new ArrayList();
            for (Object page : descendentsFromSpecifiedPage) {
                if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, page)) continue;
                allComments.addAll(page.getComments());
            }
            ArrayList<BhtCommentWebModel> allSimpleNOTInlineCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Comment comment : allComments) {
                if (comment.isInlineComment()) continue;
                allSimpleNOTInlineCommentsWeb.add(this.commentToModelConv.convertToModel(comment));
            }
            allSimpleNOTInlineCommentsWeb.addAll(currentPageSimpleNOTInlineCommentsDto);
            context.put("AllSimpleNOTInlineComments", allSimpleNOTInlineCommentsWeb);
            ArrayList<Comment> allInlineComments = new ArrayList<Comment>();
            ArrayList<BhtCommentWebModel> allInlineCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Object comment : allComments) {
                if (!comment.isInlineComment()) continue;
                allInlineComments.add((Comment)comment);
            }
            allInlineComments.addAll(currentPageAllInlineComments);
            allInlineCommentsWeb.addAll(allInlineComments.stream().map(this.commentToModelConv::convertToModel).toList());
            context.put("AllInlineComments", allInlineCommentsWeb);
            ArrayList<BhtCommentWebModel> allInlineUnresolvedCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Comment comment : allComments) {
                if (!PagesCommentsMacro.isUnresolvedComment(comment)) continue;
                allInlineUnresolvedCommentsWeb.add(this.commentToModelConv.convertToModel(comment));
            }
            allInlineUnresolvedCommentsWeb.addAll(currentPageInlineUnresolvedCommentsWeb);
            context.put("AllInlineUnresolvedComments", allInlineUnresolvedCommentsWeb);
            ArrayList<BhtCommentWebModel> allInlineResolvedCommentsWeb = new ArrayList<BhtCommentWebModel>();
            for (Comment comment : allComments) {
                if (!PagesCommentsMacro.isResolvedComment(comment)) continue;
                allInlineResolvedCommentsWeb.add(this.commentToModelConv.convertToModel(comment));
            }
            allInlineResolvedCommentsWeb.addAll(currentPageInlineResolvedCommentsWeb);
            context.put("AllInlineResolvedComments", allInlineResolvedCommentsWeb);
            context.put("usersExtractorService", this.usersExtractorService);
            return this.velocityHelperService.getRenderedTemplate(TEMPLATE, context);
        }
        return "<b>You have no access to this page or it does not exist</b>";
    }

    private static boolean isResolvedComment(Comment comment) {
        return comment.isInlineComment() && comment.getStatus().isResolved() || comment.isInlineComment() && comment.getStatus().isDangling();
    }

    private static boolean isUnresolvedComment(Comment comment) {
        return comment.isInlineComment() && !comment.getStatus().isResolved() && !comment.getStatus().isDangling();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

