/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.bh.models.SpaceBannerModel;
import com.bh.services.AoModelsService;
import com.bh.services.CommentToModelConv;
import com.bh.services.MarkersService;
import com.bh.services.UsersExtractorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BannerMapping
implements ContextProvider {
    private final Logger LOG = LoggerFactory.getLogger(BannerMapping.class);
    private final HttpContext httpContext;
    private final PageService pageService;
    private final PluginLicenseManager pluginLicenseManager;
    private final MarkersService markersService;
    private final UsersExtractorService usersExtractorService;
    private final AoModelsService aoModelsService;
    private final UserProfilePictureAccessor userProfilePictureAccessor;
    private final ConfluenceUserResolver userResolver;
    private final CommentToModelConv commentToModelConv;

    public BannerMapping(HttpContext httpContext, PageService pageService, PluginLicenseManager pluginLicenseManager, MarkersService markersService, UsersExtractorService usersExtractorService, AoModelsService aoModelsService, UserProfilePictureAccessor userProfilePictureAccessor, ConfluenceUserResolver userResolver, CommentToModelConv commentToModelConv) {
        this.httpContext = httpContext;
        this.pageService = pageService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.markersService = markersService;
        this.usersExtractorService = usersExtractorService;
        this.aoModelsService = aoModelsService;
        this.userProfilePictureAccessor = userProfilePictureAccessor;
        this.userResolver = userResolver;
        this.commentToModelConv = commentToModelConv;
    }

    private boolean licenseOK() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return false;
        }
        return !((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined();
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        boolean licenseIsOK = this.licenseOK();
        finalMap.put("licenseIsOK", licenseIsOK);
        this.LOG.warn("  [BHT] context:");
        ViewPageAction viewPageAction = (ViewPageAction)context.get("action");
        context.forEach((key, value) -> this.LOG.warn("  [BHT] key: " + key + " value: " + value.toString()));
        String pageIdFromHttp = this.httpContext.getRequest().getParameter("pageId");
        String spaceKeyFromHttp = this.httpContext.getRequest().getParameter("spaceKey");
        String pageTitleFromHttp = this.httpContext.getRequest().getParameter("title");
        finalMap.put("pageIdFromHttp", pageIdFromHttp);
        finalMap.put("spaceKeyFromHttp", spaceKeyFromHttp);
        finalMap.put("pageTitleFromHttp", pageTitleFromHttp);
        Page page = this.pageService.getIdPageLocator(viewPageAction.getPageId()).getPage();
        List allComments = page.getComments();
        try {
            Optional<String> shouldDisplayOptional = Optional.ofNullable(this.aoModelsService.getIconSwitcher().getWhatToDisplay());
            finalMap.put("shouldDisplay", "always");
        }
        catch (Exception e) {
            finalMap.put("shouldDisplay", this.getShouldDisplay("always", page.getSpaceKey()));
            this.LOG.error(String.format("[BHT] [ERROR] when getting 'getWhatToDisplay': %s", e.getMessage()));
        }
        ArrayList allSimpleComments = new ArrayList();
        ArrayList<Comment> allInlineUnresolvedComments = new ArrayList<Comment>();
        ArrayList<Comment> allInlineResolvedComments = new ArrayList<Comment>();
        allComments.stream().filter(c -> !c.isInlineComment()).forEach(allSimpleComments::add);
        for (Comment comment : allComments) {
            if (!comment.isInlineComment() || comment.getStatus().isResolved() || comment.getStatus().isDangling() || comment.getParent() != null) continue;
            allInlineUnresolvedComments.add(comment);
            allInlineUnresolvedComments.addAll(comment.getChildren());
        }
        for (Comment comment : allComments) {
            if ((!comment.isInlineComment() || !comment.getStatus().isResolved() || comment.getParent() != null) && (comment.getParent() != null || !comment.getStatus().isDangling())) continue;
            allInlineResolvedComments.add(comment);
            allInlineResolvedComments.addAll(comment.getChildren());
        }
        List pageAttachments = page.getAttachments();
        ArrayList attachmentsInlineComments = new ArrayList();
        ArrayList<Comment> attachmentsInlineUnresComments = new ArrayList<Comment>();
        ArrayList<Comment> attachmentsInlineResComments = new ArrayList<Comment>();
        for (Attachment attachment : pageAttachments) {
            attachmentsInlineComments.addAll(attachment.getComments());
        }
        for (Comment comment : attachmentsInlineComments) {
            if (comment.getStatus().isResolved() || comment.isDeleted() || comment.getParent() != null) continue;
            attachmentsInlineUnresComments.add(comment);
            attachmentsInlineUnresComments.addAll(comment.getChildren());
        }
        for (Comment comment : attachmentsInlineComments) {
            if (!comment.getStatus().isResolved() || comment.isDeleted() || comment.getParent() != null) continue;
            attachmentsInlineResComments.add(comment);
            attachmentsInlineResComments.addAll(comment.getChildren());
        }
        ArrayList<Comment> pageUnresMainForCount = new ArrayList<Comment>();
        ArrayList<Comment> pageResMainForCount = new ArrayList<Comment>();
        ArrayList<Comment> attachUnresMainForCount = new ArrayList<Comment>();
        ArrayList<Comment> attachResMainForCount = new ArrayList<Comment>();
        for (Comment comment : allInlineUnresolvedComments) {
            if (comment.getParent() != null) continue;
            pageUnresMainForCount.add(comment);
        }
        for (Comment comment : allInlineResolvedComments) {
            if (comment.getParent() != null) continue;
            pageResMainForCount.add(comment);
        }
        for (Comment comment : attachmentsInlineUnresComments) {
            if (comment.getParent() != null) continue;
            attachUnresMainForCount.add(comment);
        }
        for (Comment comment : attachmentsInlineResComments) {
            if (comment.getParent() != null) continue;
            attachResMainForCount.add(comment);
        }
        this.LOG.warn("[BHT] >>> comments");
        this.LOG.warn(((Object)allSimpleComments).toString());
        this.LOG.warn("[BHT] >>> inline unresolved");
        this.LOG.warn(((Object)allInlineUnresolvedComments).toString());
        this.LOG.warn("[BHT] >>> inline resolved");
        this.LOG.warn(((Object)allInlineResolvedComments).toString());
        finalMap.put("firstUnresComment", this.markersService.getFirstComment(pageUnresMainForCount, page.getBodyAsString()));
        finalMap.put("firstResComment", this.markersService.getFirstComment(pageResMainForCount, page.getBodyAsString()));
        finalMap.put("pageUnresMainForCount", pageUnresMainForCount);
        finalMap.put("pageResMainForCount", pageResMainForCount);
        finalMap.put("attachUnresMainForCount", attachUnresMainForCount);
        finalMap.put("attachResMainForCount", attachResMainForCount);
        List allSimpleCommentsWeb = allSimpleComments.stream().map(this.commentToModelConv::convertToModel).collect(Collectors.toList());
        finalMap.put("allSimpleComments", allSimpleCommentsWeb);
        List allInlineUnresolvedCommentsWeb = allInlineUnresolvedComments.stream().map(this.commentToModelConv::convertToModel).collect(Collectors.toList());
        finalMap.put("allInlineUnresolvedComments", allInlineUnresolvedCommentsWeb);
        List allInlineResolvedCommentsWeb = allInlineResolvedComments.stream().map(this.commentToModelConv::convertToModel).collect(Collectors.toList());
        finalMap.put("allInlineResolvedComments", allInlineResolvedCommentsWeb);
        finalMap.put("attachmentsInlineUnresComments", attachmentsInlineUnresComments);
        finalMap.put("attachmentsInlineResComments", attachmentsInlineResComments);
        finalMap.put("contextPath", this.httpContext.getRequest().getContextPath());
        finalMap.put("usersExtractorService", this.usersExtractorService);
        finalMap.put("displayMainDialog", this.aoModelsService.getPanelType().isDisplayMainDialog());
        return finalMap;
    }

    private boolean getShouldDisplay(String iconsSwitcherValue, String spaceKey) {
        if (iconsSwitcherValue.equals("always")) {
            return true;
        }
        if (iconsSwitcherValue.equals("hide")) {
            for (SpaceBannerModel spaceBannerModel : this.aoModelsService.getAllModels()) {
                if (!spaceKey.equals(spaceBannerModel.getSpaceKey())) continue;
                return false;
            }
        }
        if (iconsSwitcherValue.equals("display")) {
            for (SpaceBannerModel spaceBannerModel : this.aoModelsService.getAllModels()) {
                if (!spaceKey.equals(spaceBannerModel.getSpaceKey())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

