/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.confluence.util.HTMLSearchableTextUtil;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.bh.models.dto.BhtCommentWebModel;
import com.bh.models.dto.BhtExtractedUserWeb;
import com.bh.rest.BhtCommentCreator;
import com.bh.rest.BhtPage;
import com.bh.services.CommentToModelConv;
import com.bh.services.UsersExtractorService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service
public class CommentToModelConvImpl
implements CommentToModelConv {
    private final Logger LOG = LoggerFactory.getLogger(CommentToModelConvImpl.class);
    private final ConfluenceUserResolver userResolver;
    private final UserProfilePictureAccessor userProfilePictureAccessor;
    private final UsersExtractorService usersExtractorService;
    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MMMM dd, yyyy");
    SimpleDateFormat macroDateFormat = new SimpleDateFormat("dd MMM yyyy");

    @Autowired
    public CommentToModelConvImpl(ConfluenceUserResolver userResolver, UserProfilePictureAccessor userProfilePictureAccessor, UsersExtractorService usersExtractorService) {
        this.userResolver = userResolver;
        this.userProfilePictureAccessor = userProfilePictureAccessor;
        this.usersExtractorService = usersExtractorService;
    }

    @Override
    public BhtCommentWebModel convertToModel(Comment comment) {
        BhtCommentWebModel model = new BhtCommentWebModel();
        model.setId(comment.getId());
        model.setBody(Jsoup.parseBodyFragment(comment.getBodyAsStringWithoutMarkup()).text());
        BhtCommentCreator bhtCommentCreator = new BhtCommentCreator();
        bhtCommentCreator.setName(comment.getCreator().getName());
        bhtCommentCreator.setDisplayName(comment.getCreator().getFullName());
        bhtCommentCreator.setLink("/display/~" + comment.getCreator().getName());
        bhtCommentCreator.setIconLink(this.userProfilePictureAccessor.getUserProfilePicture((User)comment.getCreator()).getUriReference());
        model.setCreator(bhtCommentCreator);
        model.setDangling(comment.getStatus().isDangling());
        model.setSpace(comment.getSpace().getDisplayTitle());
        BhtPage bhtPage = new BhtPage();
        bhtPage.setTitle(comment.getContainer().getTitle());
        bhtPage.setLink(comment.getContainer().getUrlPath());
        model.setPage(bhtPage);
        model.setPageLink(comment.getContainer().getUrlPath());
        model.setPageTitle(comment.getContainer().getTitle());
        model.setType(comment.isInlineComment() ? "inline" : "footer");
        if (comment.getProperties().getStringProperty("inline-original-selection") != null) {
            model.setMarkedContent(comment.getProperties().getStringProperty("inline-original-selection"));
        } else {
            model.setMarkedContent("");
        }
        if (comment.getStatus().isResolved() || comment.getStatus().isDangling()) {
            model.setStatus("Resolved");
        } else {
            model.setStatus("Unresolved");
        }
        model.setLink(comment.getUrlPath());
        model.setHasParent(comment.getParent() != null);
        model.setParentId(comment.getParent() != null ? comment.getParent().getId() : 0L);
        model.setCreationDate(this.simpleDateFormat2.format(comment.getCreationDate()));
        model.setFormattedDate(this.macroDateFormat.format(comment.getCreationDate()));
        model.setProfilePicture(this.userProfilePictureAccessor.getUserProfilePicture((User)comment.getCreator()).getUriReference());
        Set<BhtExtractedUserWeb> bhtExtractedUserWebs = this.usersExtractorService.extractUsers(comment).stream().map(BhtExtractedUserWeb::new).collect(Collectors.toSet());
        model.setExtractedUsers(bhtExtractedUserWebs);
        this.LOG.warn("[BHT] Page : " + String.valueOf(model.getPage()));
        this.LOG.warn(model.toString());
        model.setChildren(comment.getChildren().stream().map(child -> {
            BhtCommentWebModel childModel = new BhtCommentWebModel();
            childModel.setId(child.getId());
            childModel.setBody(Jsoup.parseBodyFragment(child.getBodyAsStringWithoutMarkup()).text());
            BhtCommentCreator creator = new BhtCommentCreator();
            creator.setName(child.getCreator().getName());
            creator.setDisplayName(child.getCreator().getFullName());
            creator.setLink("/display/~" + child.getCreator().getName());
            creator.setIconLink(this.userProfilePictureAccessor.getUserProfilePicture((User)child.getCreator()).getUriReference());
            childModel.setCreator(creator);
            childModel.setDangling(child.getStatus().isDangling());
            childModel.setSpace(child.getSpace().getDisplayTitle());
            BhtPage bhtChildPage = new BhtPage();
            bhtChildPage.setTitle(child.getContainer().getDisplayTitle());
            bhtChildPage.setLink(child.getContainer().getUrlPath());
            childModel.setPage(bhtChildPage);
            childModel.setPageLink(child.getContainer().getUrlPath());
            childModel.setPageTitle(child.getContainer().getTitle());
            childModel.setType(child.isInlineComment() ? "inline" : "footer");
            if (child.getProperties().getStringProperty("inline-original-selection") != null) {
                childModel.setMarkedContent(child.getProperties().getStringProperty("inline-original-selection"));
            } else {
                childModel.setMarkedContent("");
            }
            if (child.getStatus().isResolved() || child.getStatus().isDangling()) {
                childModel.setStatus("Resolved");
            } else {
                childModel.setStatus("Unresolved");
            }
            childModel.setLink(child.getUrlPath());
            childModel.setHasParent(child.getParent() != null);
            childModel.setParentId(child.getParent() != null ? child.getParent().getId() : 0L);
            childModel.setCreationDate(this.simpleDateFormat2.format(child.getCreationDate()));
            childModel.setProfilePicture(this.userProfilePictureAccessor.getUserProfilePicture((User)child.getCreator()).getUriReference());
            Set<BhtExtractedUserWeb> extractedUserWebs = this.usersExtractorService.extractUsers((Comment)child).stream().map(BhtExtractedUserWeb::new).collect(Collectors.toSet());
            model.setExtractedUsers(extractedUserWebs);
            return childModel;
        }).collect(Collectors.toList()));
        return model;
    }

    @Override
    public BhtCommentWebModel convertToModel(Content content) throws IOException {
        BhtCommentWebModel bhtCommentWebModel = new BhtCommentWebModel();
        bhtCommentWebModel.setId(content.getId().asLong());
        try {
            String replacedHtml = "";
            if (content.getBody() != null && content.getBody().get(ContentRepresentation.VIEW) != null) {
                replacedHtml = HTMLSearchableTextUtil.stripTags((String)((ContentBody)content.getBody().get(ContentRepresentation.VIEW)).getValue()).replace("\\n", "");
            }
            bhtCommentWebModel.setBody(replacedHtml);
        }
        catch (SAXException e) {
            this.LOG.error("[BHT Comments addon] Error parsing comment: " + e.getMessage());
        }
        bhtCommentWebModel.setCreationDate(content.getHistory().getCreatedAt().toString());
        bhtCommentWebModel.setType("comment");
        bhtCommentWebModel.setStatus("current");
        bhtCommentWebModel.setSpace(content.getSpace().getName());
        bhtCommentWebModel.setLocation(content.getExtension("location").toString());
        BhtPage page = new BhtPage();
        page.setTitle(((Content)content.getContainer()).getTitle());
        page.setLink(((Link)((Content)content.getContainer()).getLinks().get(LinkType.WEB_UI)).getPath());
        bhtCommentWebModel.setPage(page);
        BhtCommentCreator bhtCommentCreator = new BhtCommentCreator();
        bhtCommentCreator.setDisplayName(content.getHistory().getCreatedBy().getDisplayName());
        bhtCommentCreator.setName(content.getHistory().getCreatedBy().optionalUsername().orElse(""));
        bhtCommentCreator.setUserKey(((UserKey)content.getHistory().getCreatedBy().optionalUserKey().get()).getStringValue());
        bhtCommentCreator.setIconLink(content.getHistory().getCreatedBy().getProfilePicture().getPath());
        bhtCommentWebModel.setCreator(bhtCommentCreator);
        return bhtCommentWebModel;
    }
}

