/*
 * Decompiled with CFR 0.152.
 */
package com.bh.servlets;

import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.bh.models.IconsSwitcher;
import com.bh.models.SpaceBannerModel;
import com.bh.services.AoModelsService;
import com.bh.services.ConditionsCheckerService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentsAdminMenuServlet
extends HttpServlet {
    private static final String I_SWITCHER_KEY = "bht.iconsSwitcher";
    private final Logger LOG = LoggerFactory.getLogger(CommentsAdminMenuServlet.class);
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final TemplateRenderer templateRenderer;
    private final ConditionsCheckerService conditionsCheckerService;
    private final AoModelsService aoModelsService;

    public CommentsAdminMenuServlet(SpaceManager spaceManager, SpaceService spaceService, TemplateRenderer templateRenderer, ConditionsCheckerService conditionsCheckerService, AoModelsService aoModelsService) {
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.templateRenderer = templateRenderer;
        this.conditionsCheckerService = conditionsCheckerService;
        this.aoModelsService = aoModelsService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.conditionsCheckerService.isLicenseOK() && this.conditionsCheckerService.isSystemConfAdmin(AuthenticatedUserThreadLocal.get())) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            List spaces = this.spaceManager.getAllSpaces();
            List<SpaceBannerModel> models = this.aoModelsService.getAllModels();
            context.put("spaces", spaces);
            context.put("contextPath", req.getContextPath());
            context.put("models", models);
            context.put("spaceManager", this.spaceManager);
            try {
                IconsSwitcher iconsSwitcher;
                String toDisplay;
                if (this.aoModelsService.getIconSwitcher() == null) {
                    this.aoModelsService.createIconSwitcher("always");
                }
                switch (toDisplay = (iconsSwitcher = this.aoModelsService.getIconSwitcher()).getWhatToDisplay() == null ? "always" : iconsSwitcher.getWhatToDisplay()) {
                    case "display": {
                        context.put("showIcons", "Only for specified spaces");
                        break;
                    }
                    case "hide": {
                        context.put("showIcons", "For all spaces except specified");
                        break;
                    }
                    case "always": {
                        context.put("showIcons", "For all spaces");
                    }
                }
            }
            catch (NullPointerException e) {
                context.put("showIcons", "For all spaces");
                this.LOG.error("[ BHT ] NullPointerException getting IconsSwitcher: " + e.getMessage());
            }
            this.templateRenderer.render("templates/display-spaces-admin-menu.vm", context, (Writer)resp.getWriter());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.conditionsCheckerService.isLicenseOK() && this.conditionsCheckerService.isSystemConfAdmin(AuthenticatedUserThreadLocal.get())) {
            String[] parameters = req.getParameterValues("multiselect");
            String value = req.getParameter("value");
            if (parameters != null) {
                this.aoModelsService.createIconSwitcher(value);
            }
            this.aoModelsService.createModels(parameters, value);
            resp.sendRedirect(req.getContextPath() + "/plugins/servlet/admin-comments-config");
        }
    }
}

