/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.bh.services.CommentsStatsService;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentsStatsServiceImpl
implements CommentsStatsService {
    private final Logger LOG = LoggerFactory.getLogger(CommentsStatsServiceImpl.class);
    private final CQLSearchService cqlSearchService;
    private final SpaceService spaceService;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final CommentManager commentManager;

    @Autowired
    public CommentsStatsServiceImpl(CQLSearchService cqlSearchService, SpaceService spaceService, SpaceManager spaceManager, PageManager pageManager, CommentManager commentManager) {
        this.cqlSearchService = cqlSearchService;
        this.spaceService = spaceService;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.commentManager = commentManager;
    }

    @Override
    public int getAllCommentsSize() {
        return this.cqlSearchService.searchContent("type=comment", new Expansion[0]).getResults().size();
    }

    @Override
    public long getFooterCommentsSize() {
        AtomicLong total = new AtomicLong(0L);
        this.cqlSearchService.searchContent("type=space", new Expansion[0]).getResults();
        PageResponse spaces = this.spaceService.find(new Expansion[0]).withStatus(SpaceStatus.CURRENT).fetchMany((PageRequest)new SimplePageRequest(1, 50));
        this.spaceManager.getAllSpaces().forEach(s -> {
            List pages = this.pageManager.getPages(s, true);
            pages.forEach(p -> {
                Date since = Date.from(LocalDate.now().minusMonths(12L).atStartOfDay().toInstant(ZoneOffset.UTC));
                List pageComments = this.commentManager.getPageComments(p.getId(), since);
                long count = pageComments.stream().filter(c -> !c.isInlineComment()).count();
                total.set(total.addAndGet(count));
            });
        });
        return total.get();
    }

    @Override
    public long getInlineCommentsSize() {
        AtomicLong total = new AtomicLong(0L);
        this.spaceManager.getAllSpaces().forEach(s -> {
            List pages = this.pageManager.getPages(s, true);
            pages.forEach(p -> {
                Date since = Date.from(LocalDate.now().minusMonths(12L).atStartOfDay().toInstant(ZoneOffset.UTC));
                List pageComments = this.commentManager.getPageComments(p.getId(), since);
                long count = pageComments.stream().filter(Comment::isInlineComment).count();
                total.set(total.addAndGet(count));
            });
        });
        return total.get();
    }

    @Override
    public long getInlineUNRESCommentsSize() {
        AtomicLong total = new AtomicLong(0L);
        this.spaceManager.getAllSpaces().forEach(s -> {
            List pages = this.pageManager.getPages(s, true);
            pages.forEach(p -> {
                Date since = Date.from(LocalDate.now().minusMonths(12L).atStartOfDay().toInstant(ZoneOffset.UTC));
                List pageComments = this.commentManager.getPageComments(p.getId(), since);
                long count = pageComments.stream().filter(c -> c.isInlineComment() && !c.getStatus().isResolved()).count();
                total.set(total.addAndGet(count));
            });
        });
        return total.get();
    }

    @Override
    public long getInlineRESCommentsSize() {
        AtomicLong total = new AtomicLong(0L);
        this.spaceManager.getAllSpaces().forEach(s -> {
            List pages = this.pageManager.getPages(s, true);
            pages.forEach(p -> {
                Date since = Date.from(LocalDate.now().minusMonths(12L).atStartOfDay().toInstant(ZoneOffset.UTC));
                List pageComments = this.commentManager.getPageComments(p.getId(), since);
                long count = pageComments.stream().filter(c -> c.isInlineComment() && c.getStatus().isResolved()).count();
                total.set(total.addAndGet(count));
            });
        });
        return total.get();
    }
}

