/*
 * Decompiled with CFR 0.152.
 */
package com.bh.models.dto;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.bh.models.dto.BhtExtractedUserWeb;
import com.bh.rest.BhtCommentCreator;
import com.bh.rest.BhtPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="bht-web-comment")
public class BhtCommentWebModel {
    @XmlAttribute
    private long id;
    @XmlAttribute
    private String body;
    @XmlAttribute
    private long parentId;
    @XmlAttribute
    private boolean hasParent;
    @XmlElement
    private BhtCommentCreator creator;
    @XmlElement
    private BhtPage page;
    @XmlAttribute
    private String pageTitle;
    @XmlAttribute
    private String pageLink;
    @XmlAttribute
    private String space;
    @XmlAttribute
    private String link;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private String status;
    @XmlAttribute
    private String location;
    @XmlAttribute
    private boolean dangling;
    @XmlAttribute
    private List<BhtCommentWebModel> children = new ArrayList<BhtCommentWebModel>();
    @XmlAttribute
    private Set<BhtExtractedUserWeb> extractedUsers = new HashSet<BhtExtractedUserWeb>();
    @XmlAttribute
    private String markedContent;
    @XmlAttribute
    private String creationDate;
    @XmlAttribute
    private String formattedDate;
    @XmlAttribute
    private String profilePicture;

    public BhtCommentWebModel() {
    }

    public BhtCommentWebModel(Comment comment) {
        this.id = comment.getId();
        this.body = comment.getBodyAsString();
        this.creationDate = comment.getCreationDate().toString();
        this.page = new BhtPage(Objects.requireNonNull((Page)comment.getContainer()));
        this.type = comment.getType();
        this.space = comment.getSpace().getName();
        this.creator = new BhtCommentCreator(comment.getCreator());
        this.dangling = comment.getStatus().isDangling();
    }

    public BhtCommentWebModel(Content content) {
        this.body = ((ContentBody)content.getBody().get("raw")).getValue();
        this.type = "comment";
        BhtCommentCreator bhtCommentCreator = new BhtCommentCreator();
        bhtCommentCreator.setName(content.getHistory().getCreatedBy().getDisplayName());
        bhtCommentCreator.setIconLink(content.getHistory().getCreatedBy().getProfilePicture().getPath());
        this.space = content.getSpace().getName();
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public BhtCommentCreator getCreator() {
        return this.creator;
    }

    public void setCreator(BhtCommentCreator creator) {
        this.creator = creator;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public BhtPage getPage() {
        return this.page;
    }

    public void setPage(BhtPage page) {
        this.page = page;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMarkedContent() {
        return this.markedContent;
    }

    public void setMarkedContent(String markedContent) {
        this.markedContent = markedContent;
    }

    public List<BhtCommentWebModel> getChildren() {
        return this.children;
    }

    public void setChildren(List<BhtCommentWebModel> children) {
        this.children = children;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getProfilePicture() {
        return this.profilePicture;
    }

    public void setProfilePicture(String profilePicture) {
        this.profilePicture = profilePicture;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public boolean isHasParent() {
        return this.hasParent;
    }

    public void setHasParent(boolean hasParent) {
        this.hasParent = hasParent;
    }

    public boolean isDangling() {
        return this.dangling;
    }

    public void setDangling(boolean dangling) {
        this.dangling = dangling;
    }

    public Set<BhtExtractedUserWeb> getExtractedUsers() {
        return this.extractedUsers;
    }

    public void setExtractedUsers(Set<BhtExtractedUserWeb> extractedUsers) {
        this.extractedUsers = extractedUsers;
    }

    public String getFormattedDate() {
        return this.formattedDate;
    }

    public void setFormattedDate(String formattedDate) {
        this.formattedDate = formattedDate;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPageLink() {
        return this.pageLink;
    }

    public void setPageLink(String pageLink) {
        this.pageLink = pageLink;
    }

    public String toString() {
        return "BhtCommentWebModel{id=" + this.id + ", body='" + this.body + "', parentId=" + this.parentId + ", hasParent=" + this.hasParent + ", creator=" + String.valueOf(this.creator) + ", page=" + String.valueOf(this.page) + ", pageTitle='" + this.pageTitle + "', pageLink='" + this.pageLink + "', space='" + this.space + "', link='" + this.link + "', type='" + this.type + "', status='" + this.status + "', location='" + this.location + "', dangling=" + this.dangling + ", children=" + String.valueOf(this.children) + ", extractedUsers=" + String.valueOf(this.extractedUsers) + ", markedContent='" + this.markedContent + "', creationDate='" + this.creationDate + "', formattedDate='" + this.formattedDate + "', profilePicture='" + this.profilePicture + "'}";
    }
}

