import React, {useState, useEffect, Fragment} from 'react';
import DynamicTable from "@atlaskit/dynamic-table";
import {SimpleTag as Tag} from '@atlaskit/tag';
import Avatar from "@atlaskit/avatar";
import Lozenge from '@atlaskit/lozenge';

const CommentsListTable = (props) => {

    const InlineStatus = ({status}) => {
        let appearance = status === 'Resolved' ? 'success' : 'moved';
        return <Lozenge appearance={appearance} isBold>{status}</Lozenge>
    }

    const CommentType = ({type}) => {
        if (type === 'footer') {
            return <Lozenge>{type}</Lozenge>
        } else {
            return <Lozenge appearance={'new'}>{type}</Lozenge>
        }
    }

    const head = {
        cells: [
            // {
            //     key: 'space',
            //     content: 'Space',
            //     isSortable: true,
            // },
            {
                key: 'page',
                content: 'Page',
                isSortable: true,
            },
            {
                key: 'author',
                content: 'Author',
                isSortable: true,
            },
            {
                key: 'commented',
                content: 'Commented',
                isSortable: true,
            },
            {
                key: 'body',
                content: 'Body',
                isSortable: true,
            },
            {
                key: 'type',
                content: 'Type',
                isSortable: true,
            },
            {
                key: 'status',
                content: 'Status',
                isSortable: true,
            },
            {
                key: 'creation-date',
                content: 'Creation Date',
                isSortable: true,
            },
        ],
    };

    const rows = props.comments.map((comm, index) => ({
        key: index,
        cells: [
            // {
            //     key: index,
            //     content: <p>{comm.container.space.name}</p>,
            // },
            {
                key: comm.id,
                content: <p>
                    <a target={'_blank'}
                       href={comm.link}>
                        {comm.page.title}</a>
                </p>,
            },
            {
                key: index,
                content: <div style={{display: 'flex'}}>
                    <Avatar src={comm.creator.iconLink}
                            name={comm.creator.name} size="medium"/>
                    <div className={'bhtUserName'}>
                        <a target={'_blank'}
                           href={`/users/viewuserprofile.action?username=${comm.creator.name}`}>
                            {comm.creator.name}
                        </a>

                    </div>
                </div>,
            },
            {
                key: index,
                content:
                    <p>{comm.markedContent !== null ? comm.markedContent : ''}</p>,
            },
            {
                key: index,
                content: <p>{comm.body}</p>,
            },
            {
                key: index,
                content: <p>{comm.type !== null
                    ? <CommentType type={comm.type}/>
                    : <CommentType type={'Simple'}/>}
                </p>,
            },
            {
                key: index,
                content: <p>{comm.status !== null ? <InlineStatus status={comm.status}/> : ''}</p>,
            },
            {
                key: index,
                content: <Tag text={comm.creationDate}/>,
            },
        ],
    }));

    return (
        <DynamicTable
            // caption={caption}
            head={head}
            rows={rows}
            rowsPerPage={20}
            defaultPage={1}
            loadingSpinnerSize="large"
            isLoading={false}
            isFixedSize
            defaultSortKey="page"
            defaultSortOrder="ASC"
        />
    )

}

export default CommentsListTable;