/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.bh.services.UsersExtractorService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesCommentsMacro
implements Macro {
    private final Logger LOG = LoggerFactory.getLogger(PagesCommentsMacro.class);
    private static String TEMPLATE;
    private final PluginLicenseManager pluginLicenseManager;
    private final PageService pageService;
    private final UsersExtractorService usersExtractorService;
    private final PermissionManager permissionManager;
    private final VelocityHelperService velocityHelperService;

    public PagesCommentsMacro(PluginLicenseManager pluginLicenseManager, PageService pageService, UsersExtractorService usersExtractorService, PermissionManager permissionManager, VelocityHelperService velocityHelperService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pageService = pageService;
        this.usersExtractorService = usersExtractorService;
        this.permissionManager = permissionManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException, NullPointerException {
        boolean confDate;
        PluginLicense license;
        Map context = MacroUtils.defaultVelocityContext();
        TEMPLATE = this.pluginLicenseManager.getLicense().isDefined() ? ((license = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined() ? "templates/no-license.vm" : "templates/macros/page_comments_with_replies-simple.vm") : "templates/no-license.vm";
        String spaceKeyParam = params.get("space-key");
        String pageNameParam = params.get("page-title");
        Boolean dateParam = Optional.ofNullable(Boolean.parseBoolean(params.get("date"))).orElse(false);
        Boolean commentAuthor = Optional.ofNullable(Boolean.parseBoolean(params.get("author"))).orElse(false);
        Boolean descendents = Optional.ofNullable(Boolean.parseBoolean(params.get("include-descendents"))).orElse(false);
        Boolean includePageName = Optional.of(Boolean.parseBoolean(params.get("display-page-name"))).orElse(false);
        Boolean includeContentBody = Optional.of(Boolean.parseBoolean(params.get("content-body"))).orElse(false);
        Boolean parentComment = Optional.of(Boolean.parseBoolean(params.get("parent-comment"))).orElse(false);
        Boolean isInline = Optional.of(Boolean.parseBoolean(params.get("inline-comments"))).orElse(false);
        String resolvedOrUnresolved = Optional.ofNullable(params.get("inline-comments-type")).orElse("");
        String dateFormat = Optional.ofNullable(params.get("date-format")).orElse("yyyy-MM-dd");
        context.put("bodyLengthInt", 0);
        String commentedContentColumnWidthFromParams = Optional.ofNullable(params.get("commented-content-column-width")).orElse("50");
        String authorColumnWidthFromParams = Optional.ofNullable(params.get("author-column-width")).orElse("50");
        String commentColumnWidthFromParams = Optional.ofNullable(params.get("comment-column-width")).orElse("50");
        String isResolvedColumnWidthFromParams = Optional.ofNullable(params.get("is-resolved-column-width")).orElse("50");
        String pageNameColumnWidthFromParams = Optional.ofNullable(params.get("page-name-column-width")).orElse("50");
        String dateColumnWidthFromParams = Optional.ofNullable(params.get("date-column-width")).orElse("50");
        this.LOG.warn("[BHT] commentedContentColumnWidthFromParams : " + commentedContentColumnWidthFromParams);
        this.LOG.warn("[BHT] authorColumnWidthFromParams : " + authorColumnWidthFromParams);
        this.LOG.warn("[BHT] commentColumnWidthFromParams : " + commentColumnWidthFromParams);
        this.LOG.warn("[BHT] isResolvedColumnWidthFromParams : " + isResolvedColumnWidthFromParams);
        this.LOG.warn("[BHT] pageNameColumnWidthFromParams : " + pageNameColumnWidthFromParams);
        this.LOG.warn("[BHT] dateColumnWidthFromParams : " + dateColumnWidthFromParams);
        this.LOG.warn("[BHT] resolvedOrUnresolved : " + resolvedOrUnresolved);
        context.put("commentedContentColumnWidthFromParams", commentedContentColumnWidthFromParams);
        context.put("authorColumnWidthFromParams", authorColumnWidthFromParams);
        context.put("commentColumnWidthFromParams", commentColumnWidthFromParams);
        context.put("isResolvedColumnWidthFromParams", isResolvedColumnWidthFromParams);
        context.put("pageNameColumnWidthFromParams", pageNameColumnWidthFromParams);
        context.put("dateColumnWidthFromParams", dateColumnWidthFromParams);
        context.put("Date", dateParam);
        context.put("CommentAuthor", commentAuthor);
        context.put("Descendents", descendents);
        context.put("IncludePageName", includePageName);
        context.put("IncludeContentBody", includeContentBody);
        context.put("IsInline", isInline);
        context.put("ResolvedOrUnresolved", resolvedOrUnresolved);
        context.put("DateFormat", dateFormat);
        context.put("ParentComment", parentComment);
        context.put("usersExtractorService", this.usersExtractorService);
        if (dateFormat != null && !dateFormat.isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            context.put("Formatter", formatter);
        }
        boolean bl = confDate = params.get("apply-confluence-date") != null && Boolean.parseBoolean(params.get("apply-confluence-date"));
        if (confDate) {
            SimpleDateFormat confFormatter = new SimpleDateFormat("dd MMM yyyy");
            context.put("confFormatter", confFormatter);
        }
        String spaceTitle = spaceKeyParam != null ? spaceKeyParam : conversionContext.getSpaceKey();
        String pageTitle = pageNameParam != null ? (pageNameParam.contains(":") ? pageNameParam.substring(pageNameParam.indexOf(":") + 1) : pageNameParam) : conversionContext.getEntity().getTitle();
        Page currentPage = this.pageService.getTitleAndSpaceKeyPageLocator(spaceTitle, pageTitle).getPage();
        if (this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)currentPage)) {
            List descendentsFromSpecifiedPage = currentPage.getDescendants();
            List currentPageALLComments = currentPage.getComments();
            ArrayList<Comment> currentPageSimpleNOTInlineComments = new ArrayList<Comment>();
            for (Object comment : currentPageALLComments) {
                if (comment.isInlineComment()) continue;
                currentPageSimpleNOTInlineComments.add((Comment)comment);
            }
            this.LOG.warn("[BHT] currentPageSimpleNOTInlineComments");
            this.LOG.warn(((Object)currentPageSimpleNOTInlineComments).toString());
            context.put("CurrentPageSimpleNOTInlineComments", currentPageSimpleNOTInlineComments);
            ArrayList<Comment> currentPageAllInlineComments = new ArrayList<Comment>();
            for (Object comment : currentPageALLComments) {
                if (!comment.isInlineComment()) continue;
                currentPageAllInlineComments.add((Comment)comment);
            }
            context.put("CurrentPageAllInlineComments", currentPageAllInlineComments);
            ArrayList<Object> currentPageInlineUnresolvedComments = new ArrayList<Object>();
            for (Object comment : currentPageALLComments) {
                if (!comment.isInlineComment() || comment.getStatus().isResolved() || comment.getStatus().isDangling()) continue;
                currentPageInlineUnresolvedComments.add(comment);
            }
            context.put("CurrentPageInlineUnresolvedComments", currentPageInlineUnresolvedComments);
            ArrayList<Object> currentPageInlineResolvedComments = new ArrayList<Object>();
            for (Object comment : currentPageALLComments) {
                if ((!comment.isInlineComment() || !comment.getStatus().isResolved()) && (!comment.isInlineComment() || !comment.getStatus().isDangling())) continue;
                currentPageInlineResolvedComments.add(comment);
            }
            context.put("CurrentPageInlineResolvedComments", currentPageInlineResolvedComments);
            ArrayList allComments = new ArrayList();
            for (Object page : descendentsFromSpecifiedPage) {
                if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, page)) continue;
                allComments.addAll(page.getComments());
            }
            ArrayList<Comment> allSimpleNOTInlineComments = new ArrayList<Comment>();
            for (Object comment : allComments) {
                if (comment.isInlineComment()) continue;
                allSimpleNOTInlineComments.add((Comment)comment);
            }
            allSimpleNOTInlineComments.addAll(currentPageSimpleNOTInlineComments);
            context.put("AllSimpleNOTInlineComments", allSimpleNOTInlineComments);
            ArrayList<Comment> allInlineComments = new ArrayList<Comment>();
            for (Object comment : allComments) {
                if (!comment.isInlineComment()) continue;
                allInlineComments.add((Comment)comment);
            }
            allInlineComments.addAll(currentPageAllInlineComments);
            context.put("AllInlineComments", allInlineComments);
            ArrayList<Object> allInlineUnresolvedComments = new ArrayList<Object>();
            for (Comment comment : allComments) {
                if (!comment.isInlineComment() || comment.getStatus().isResolved() || comment.getStatus().isDangling()) continue;
                allInlineUnresolvedComments.add(comment);
            }
            allInlineUnresolvedComments.addAll(currentPageInlineUnresolvedComments);
            context.put("AllInlineUnresolvedComments", allInlineUnresolvedComments);
            ArrayList<Object> allInlineResolvedComments = new ArrayList<Object>();
            for (Comment comment : allComments) {
                if ((!comment.isInlineComment() || !comment.getStatus().isResolved()) && (!comment.isInlineComment() || !comment.getStatus().isDangling())) continue;
                allInlineResolvedComments.add(comment);
            }
            allInlineResolvedComments.addAll(currentPageInlineResolvedComments);
            context.put("AllInlineResolvedComments", allInlineResolvedComments);
            context.put("usersExtractorService", this.usersExtractorService);
            return this.velocityHelperService.getRenderedTemplate(TEMPLATE, context);
        }
        return "<b>You have no access to this page or it does not exist</b>";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

