/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.bh.models.dto.BhtCommentWebModel;
import com.bh.services.BhtCommentsService;
import com.bh.services.CommentToModelConv;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BhtCommentsServiceImpl
implements BhtCommentsService {
    private final Logger LOG = LoggerFactory.getLogger(BhtCommentsServiceImpl.class);
    SimpleDateFormat formatterOld = new SimpleDateFormat("yyyy-MM-dd");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final PageManager pageManager;
    private final PageService pageService;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final CommentToModelConv commentToModelConv;
    private final CQLSearchService cqlSearchService;

    @Autowired
    public BhtCommentsServiceImpl(PageManager pageManager, PageService pageService, SpaceManager spaceManager, PermissionManager permissionManager, CommentToModelConv commentToModelConv, CQLSearchService cqlSearchService) {
        this.pageManager = pageManager;
        this.pageService = pageService;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.commentToModelConv = commentToModelConv;
        this.cqlSearchService = cqlSearchService;
    }

    @Override
    public List<BhtCommentWebModel> getSpaceComments(String spaceKeys, String commentType, String dateFrom, String dateTo) {
        if (spaceKeys != null && !spaceKeys.isEmpty()) {
            String[] spaceKeysArr;
            Date dateFromNew = null;
            Date dateToNew = null;
            if (dateFrom == null || dateFrom.isEmpty()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(5, -7);
                dateFromNew = calendar.getTime();
            } else {
                try {
                    dateFromNew = this.formatterOld.parse(dateFrom);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (dateTo == null || dateTo.isEmpty()) {
                dateToNew = new Date();
            } else {
                try {
                    dateToNew = this.formatterOld.parse(dateTo);
                }
                catch (ParseException e) {
                    this.LOG.error(" [BHT Comments Manager] . Error getting Space" + spaceKeys + " comments: " + e.getMessage());
                }
            }
            ArrayList<Page> allPages = new ArrayList<Page>();
            for (String string : spaceKeysArr = spaceKeys.split(",")) {
                List list = this.pageManager.getPages(this.spaceManager.getSpace(string), true);
                for (Page page : list) {
                    if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) continue;
                    allPages.add(page);
                }
            }
            if (commentType.equals("All")) {
                ArrayList allComments = new ArrayList();
                ArrayList<Comment> simpleComments = new ArrayList<Comment>();
                ArrayList<Comment> inlineComments = new ArrayList<Comment>();
                for (Page page : allPages) {
                    for (Comment comment : page.getComments()) {
                        if (comment.isInlineComment()) continue;
                        simpleComments.add(comment);
                    }
                }
                for (Page page : allPages) {
                    for (Comment comment : page.getComments()) {
                        if (!comment.isInlineComment() || comment.getParent() != null) continue;
                        inlineComments.add(comment);
                        for (Comment child : comment.getChildren()) {
                            child.setStatus(comment.getStatus());
                            inlineComments.add(child);
                        }
                    }
                }
                allComments.addAll(simpleComments);
                allComments.addAll(inlineComments);
                ArrayList<BhtCommentWebModel> arrayList = new ArrayList<BhtCommentWebModel>();
                for (Comment comment : allComments) {
                    if (!comment.getCreationDate().after(dateFromNew) || !comment.getCreationDate().before(dateToNew)) continue;
                    arrayList.add(this.commentToModelConv.convertToModel(comment));
                }
                return arrayList;
            }
            if (commentType.equals("Simple")) {
                ArrayList<Comment> simpleComments = new ArrayList<Comment>();
                for (Page page : allPages) {
                    for (Comment comment : page.getComments()) {
                        if (comment.isInlineComment()) continue;
                        simpleComments.add(comment);
                    }
                }
                ArrayList<BhtCommentWebModel> returnComments = new ArrayList<BhtCommentWebModel>();
                for (Comment comment : simpleComments) {
                    if (!comment.getCreationDate().after(dateFromNew) || !comment.getCreationDate().before(dateToNew)) continue;
                    returnComments.add(this.commentToModelConv.convertToModel(comment));
                }
                return returnComments;
            }
            if (commentType.equals("Inline")) {
                ArrayList<Comment> inlineComments = new ArrayList<Comment>();
                for (Page page : allPages) {
                    for (Comment comment : page.getComments()) {
                        if (!comment.isInlineComment() || comment.getParent() != null) continue;
                        inlineComments.add(comment);
                        for (Comment child : comment.getChildren()) {
                            child.setStatus(comment.getStatus());
                            inlineComments.add(child);
                        }
                    }
                }
                ArrayList returnComments = new ArrayList();
                for (Comment comment : inlineComments) {
                    if (!comment.getCreationDate().after(dateFromNew) || !comment.getCreationDate().before(dateToNew)) continue;
                    returnComments.add(this.commentToModelConv.convertToModel(comment));
                }
                return returnComments;
            }
        }
        return new ArrayList<BhtCommentWebModel>();
    }

    @Override
    public List<Comment> getPageInlineComments(long pageId) {
        return this.pageService.getIdPageLocator(pageId).getPage().getComments().stream().filter(Comment::isInlineComment).collect(Collectors.toList());
    }

    @Override
    public List<Comment> getCommentsByDates(List<Comment> comments, String dateFrom, String dateTo) {
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        try {
            Date fromDate = this.formatterOld.parse(dateFrom);
            Date toDate = this.formatterOld.parse(dateTo);
            comments.stream().filter(c -> c.getCreationDate().after(fromDate) && c.getCreationDate().before(toDate)).forEach(commentList::add);
        }
        catch (ParseException e) {
            this.LOG.error(" [BHT Comments Manager] . Error in method getCommentsByDates: " + e.getMessage());
        }
        return commentList;
    }

    @Override
    public List<BhtCommentWebModel> getPageComments(long pageId, String commentsType, String dateFrom, String dateTo) {
        Page page = this.pageService.getIdPageLocator(pageId).getPage();
        ArrayList<BhtCommentWebModel> models = new ArrayList<BhtCommentWebModel>();
        List comments = page.getComments();
        if (comments != null) {
            try {
                Date dateFromDate = dateFrom != null && !dateFrom.equals("") && !dateFrom.contains(" ") ? this.formatterOld.parse(dateFrom) : Date.from(LocalDate.now().minusDays(8L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                Date dateToDate = dateTo != null && !dateTo.isEmpty() ? Date.from(LocalDate.parse(dateTo, this.formatter).plusDays(1L).atTime(1, 1).atZone(ZoneId.systemDefault()).toInstant()) : Date.from(LocalDate.now().plusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                comments.stream().filter(Objects::nonNull).filter(c -> Objects.nonNull(c.getCreationDate())).filter(c -> c.getCreationDate().after(dateFromDate) && c.getCreationDate().before(dateToDate)).forEach(c -> models.add(this.commentToModelConv.convertToModel((Comment)c)));
                return models;
            }
            catch (ParseException e) {
                this.LOG.error(" [BHT Comments Manager] . Error parsing comment dates: " + e.getMessage());
            }
        }
        return models;
    }

    @Override
    public List<Content> getUserComments(String userName) {
        List comments = this.cqlSearchService.searchContent(String.format("type=comment and creator = %s", userName), new Expansion[]{new Expansion("body", Expansions.of((String[])new String[]{"view"})), new Expansion("space"), new Expansion("container"), new Expansion("history")}).getResults();
        return comments;
    }

    @Override
    public List<BhtCommentWebModel> getUserBhtComments(String username) {
        List comments = this.cqlSearchService.searchContent(String.format("type=comment and creator = %s", username), new Expansion[]{new Expansion("body", Expansions.of((String[])new String[]{"view"})), new Expansion("space"), new Expansion("container"), new Expansion("history")}).getResults();
        List<BhtCommentWebModel> bhtComments = comments.stream().map(c -> {
            try {
                return this.commentToModelConv.convertToModel((Content)c);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return bhtComments;
    }

    @Override
    @Deprecated
    public List<Content> getFooterComments() {
        return null;
    }

    @Override
    @Deprecated
    public List<Content> getInlineComments() {
        return null;
    }
}

