/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.bh.services.UsersExtractorService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PagesCommentsMacro
implements Macro {
    private static String TEMPLATE;
    private final PluginLicenseManager pluginLicenseManager;
    private final PageManager pageManager;
    private final UsersExtractorService usersExtractorService;
    private final PermissionManager permissionManager;

    public PagesCommentsMacro(PluginLicenseManager pluginLicenseManager, PageManager pageManager, UsersExtractorService usersExtractorService, PermissionManager permissionManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pageManager = pageManager;
        this.usersExtractorService = usersExtractorService;
        this.permissionManager = permissionManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException, NullPointerException {
        boolean confDate;
        PluginLicense license;
        Map context = MacroUtils.defaultVelocityContext();
        TEMPLATE = this.pluginLicenseManager.getLicense().isDefined() ? ((license = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined() ? "templates/no-license.vm" : "templates/macros/page_comments_with_replies-simple.vm") : "templates/no-license.vm";
        String spaceKeyParam = params.get("space-key");
        String pageNameParam = params.get("page-title");
        Boolean dateParam = Boolean.valueOf(params.get("date"));
        Boolean commentAuthor = Boolean.valueOf(params.get("author"));
        Boolean descendents = Boolean.valueOf(params.get("include-descendents"));
        Boolean includePageName = Boolean.valueOf(params.get("display-page-name"));
        Boolean includeContentBody = Boolean.valueOf(params.get("content-body"));
        Boolean parentComment = Boolean.valueOf(params.get("parent-comment"));
        Boolean isInline = Boolean.valueOf(params.get("inline-comments"));
        String resolvedOrUnresolved = params.get("inline-comments-type");
        String dateFormat = params.get("date-format");
        String bodyLength = params.get("body-length");
        int bodyLengthInt = 0;
        if (bodyLength != null) {
            bodyLengthInt = Integer.parseInt(params.get("body-length"));
        }
        context.put("bodyLengthInt", bodyLengthInt);
        String commentedContentColumnWidthFromParams = params.get("commented-content-column-width");
        String authorColumnWidthFromParams = params.get("author-column-width");
        String commentColumnWidthFromParams = params.get("comment-column-width");
        String isResolvedColumnWidthFromParams = params.get("is-resolved-column-width");
        String pageNameColumnWidthFromParams = params.get("page-name-column-width");
        String dateColumnWidthFromParams = params.get("date-column-width");
        context.put("commentedContentColumnWidthFromParams", commentedContentColumnWidthFromParams);
        context.put("authorColumnWidthFromParams", authorColumnWidthFromParams);
        context.put("commentColumnWidthFromParams", commentColumnWidthFromParams);
        context.put("isResolvedColumnWidthFromParams", isResolvedColumnWidthFromParams);
        context.put("pageNameColumnWidthFromParams", pageNameColumnWidthFromParams);
        context.put("dateColumnWidthFromParams", dateColumnWidthFromParams);
        context.put("Date", dateParam);
        context.put("CommentAuthor", commentAuthor);
        context.put("Descendents", descendents);
        context.put("IncludePageName", includePageName);
        context.put("IncludeContentBody", includeContentBody);
        context.put("IsInline", isInline);
        context.put("ResolvedOrUnresolved", resolvedOrUnresolved);
        context.put("DateFormat", dateFormat);
        context.put("ParentComment", parentComment);
        context.put("usersExtractorService", this.usersExtractorService);
        if (!dateFormat.isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            context.put("Formatter", formatter);
        }
        if (confDate = Boolean.parseBoolean(params.get("apply-confluence-date"))) {
            SimpleDateFormat confFormatter = new SimpleDateFormat("dd MMM yyyy");
            context.put("confFormatter", confFormatter);
        }
        String spaceTitle = spaceKeyParam != null ? spaceKeyParam : conversionContext.getSpaceKey();
        String pageTitle = pageNameParam != null ? (pageNameParam.contains(":") ? pageNameParam.substring(pageNameParam.indexOf(":") + 1) : pageNameParam) : conversionContext.getEntity().getTitle();
        Page currentPage = this.pageManager.getPage(spaceTitle, pageTitle);
        if (this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)currentPage)) {
            List descendentsFromSpecifiedPage = currentPage.getDescendants();
            List currentPageALLComments = currentPage.getComments();
            ArrayList<Comment> currentPageSimpleNOTInlineComments = new ArrayList<Comment>();
            for (Object comment : currentPageALLComments) {
                if (comment.isInlineComment()) continue;
                currentPageSimpleNOTInlineComments.add((Comment)comment);
            }
            context.put("CurrentPageSimpleNOTInlineComments", currentPageSimpleNOTInlineComments);
            ArrayList<Comment> currentPageAllInlineComments = new ArrayList<Comment>();
            for (Object comment : currentPageALLComments) {
                if (!comment.isInlineComment()) continue;
                currentPageAllInlineComments.add((Comment)comment);
            }
            context.put("CurrentPageAllInlineComments", currentPageAllInlineComments);
            ArrayList<Object> currentPageInlineUnresolvedComments = new ArrayList<Object>();
            for (Object comment : currentPageALLComments) {
                if (!comment.isInlineComment() || comment.getStatus().isResolved() || comment.getStatus().isDangling()) continue;
                currentPageInlineUnresolvedComments.add(comment);
            }
            context.put("CurrentPageInlineUnresolvedComments", currentPageInlineUnresolvedComments);
            ArrayList<Object> currentPageInlineResolvedComments = new ArrayList<Object>();
            for (Object comment : currentPageALLComments) {
                if ((!comment.isInlineComment() || !comment.getStatus().isResolved()) && (!comment.isInlineComment() || !comment.getStatus().isDangling())) continue;
                currentPageInlineResolvedComments.add(comment);
            }
            context.put("CurrentPageInlineResolvedComments", currentPageInlineResolvedComments);
            ArrayList allComments = new ArrayList();
            for (Object page : descendentsFromSpecifiedPage) {
                if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, page)) continue;
                allComments.addAll(page.getComments());
            }
            ArrayList<Comment> allSimpleNOTInlineComments = new ArrayList<Comment>();
            for (Object comment : allComments) {
                if (comment.isInlineComment()) continue;
                allSimpleNOTInlineComments.add((Comment)comment);
            }
            allSimpleNOTInlineComments.addAll(currentPageSimpleNOTInlineComments);
            context.put("AllSimpleNOTInlineComments", allSimpleNOTInlineComments);
            ArrayList<Comment> allInlineComments = new ArrayList<Comment>();
            for (Object comment : allComments) {
                if (!comment.isInlineComment()) continue;
                allInlineComments.add((Comment)comment);
            }
            allInlineComments.addAll(currentPageAllInlineComments);
            context.put("AllInlineComments", allInlineComments);
            ArrayList<Object> allInlineUnresolvedComments = new ArrayList<Object>();
            for (Comment comment : allComments) {
                if (!comment.isInlineComment() || comment.getStatus().isResolved() || comment.getStatus().isDangling()) continue;
                allInlineUnresolvedComments.add(comment);
            }
            allInlineUnresolvedComments.addAll(currentPageInlineUnresolvedComments);
            context.put("AllInlineUnresolvedComments", allInlineUnresolvedComments);
            ArrayList<Object> allInlineResolvedComments = new ArrayList<Object>();
            for (Comment comment : allComments) {
                if ((!comment.isInlineComment() || !comment.getStatus().isResolved()) && (!comment.isInlineComment() || !comment.getStatus().isDangling())) continue;
                allInlineResolvedComments.add(comment);
            }
            allInlineResolvedComments.addAll(currentPageInlineResolvedComments);
            context.put("AllInlineResolvedComments", allInlineResolvedComments);
            context.put("usersExtractorService", this.usersExtractorService);
            return VelocityUtils.getRenderedTemplate((String)TEMPLATE, (Map)context);
        }
        return "<b>You have no access to this page or it does not exist</b>";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

