/*
 * Decompiled with CFR 0.152.
 */
package com.bh.spacecomments;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AttachmentsCommentsMacro
implements Macro {
    private static String TEMPLATE;
    private final PluginLicenseManager pluginLicenseManager;
    private final PageManager pageManager;

    public AttachmentsCommentsMacro(PluginLicenseManager pluginLicenseManager, PageManager pageManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pageManager = pageManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Boolean confDate;
        PluginLicense license;
        Map context = MacroUtils.defaultVelocityContext();
        TEMPLATE = this.pluginLicenseManager.getLicense().isDefined() ? ((license = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined() ? "templates/no-license.vm" : "templates/macros/attachments-macro-2.vm") : "templates/no-license.vm";
        Boolean inlineToDisplay = Boolean.valueOf(params.get("inline"));
        context.put("inlineToDisplay", inlineToDisplay);
        Boolean descendents = Boolean.valueOf(params.get("include-descendents"));
        context.put("descendents", descendents);
        Boolean isResolved = Boolean.valueOf(params.get("is-resolved"));
        context.put("isResolved", isResolved);
        context.put("author", Boolean.valueOf(params.get("author")));
        context.put("date", Boolean.valueOf(params.get("date")));
        context.put("page-name", Boolean.valueOf(params.get("page-name")));
        context.put("comment-column-width", params.get("comment-column-width"));
        context.put("attachment-column-width", params.get("attachment-column-width"));
        context.put("author-column-width", params.get("author-column-width"));
        context.put("date-column-width", params.get("date-column-width"));
        String SPACEKEY = "";
        String PAGETITLE = "";
        SPACEKEY = params.get("space").isEmpty() ? params.get("space") : conversionContext.getSpaceKey();
        PAGETITLE = params.get("page-title").isEmpty() ? params.get("page-title") : conversionContext.getEntity().getTitle();
        Page pageWithAttachments = this.pageManager.getPage(SPACEKEY, PAGETITLE);
        context.put("pageWithAttachments", pageWithAttachments);
        List pageAttachments = pageWithAttachments.getAttachments();
        boolean hasVersionedComments = false;
        for (Attachment attachment : pageAttachments) {
            if (attachment.isDeleted() || !attachment.isVersionCommentAvailable()) continue;
            hasVersionedComments = true;
        }
        context.put("hasVersionedComments", hasVersionedComments);
        context.put("pageAttachments", pageAttachments);
        String dateFormat = params.get("date-format");
        if (dateFormat.isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            context.put("Formatter", formatter);
        }
        if ((confDate = Boolean.valueOf(params.get("apply-confluence-date"))).booleanValue()) {
            SimpleDateFormat confFormatter = new SimpleDateFormat("dd MMM yyyy");
            context.put("confFormatter", confFormatter);
        }
        ArrayList attachmentsInlineComments = new ArrayList();
        ArrayList<Comment> parentInlineComments = new ArrayList<Comment>();
        for (Attachment attachment : pageAttachments) {
            attachmentsInlineComments.addAll(attachment.getComments());
        }
        for (Comment comment : attachmentsInlineComments) {
            if (comment.isDeleted() || comment.getParent() != null) continue;
            parentInlineComments.add(comment);
        }
        context.put("parentInlineComments", parentInlineComments);
        List pagesDescendents = pageWithAttachments.getDescendants();
        HashSet allAttachments = new HashSet();
        allAttachments.addAll(pageWithAttachments.getAttachments());
        for (Page page : pagesDescendents) {
            allAttachments.addAll(page.getAttachments());
        }
        context.put("allAttachments", allAttachments);
        HashSet inlineAllComments = new HashSet();
        HashSet<Comment> parentInlineAllComments = new HashSet<Comment>();
        for (Attachment attachment : allAttachments) {
            inlineAllComments.addAll(attachment.getComments());
        }
        for (Comment comment : inlineAllComments) {
            if (comment.isDeleted() || comment.getParent() != null) continue;
            parentInlineAllComments.add(comment);
        }
        context.put("parentInlineAllComments", parentInlineAllComments);
        return VelocityUtils.getRenderedTemplate((String)TEMPLATE, (Map)context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

