/*
 * Decompiled with CFR 0.152.
 */
package com.bh.services;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HTMLSearchableTextUtil;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.bh.models.dto.BhtCommentWebModel;
import com.bh.rest.BhtCommentCreator;
import com.bh.rest.BhtPage;
import com.bh.services.CommentToModelConv;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service
public class CommentToModelConvImpl
implements CommentToModelConv {
    private final Logger LOG = LoggerFactory.getLogger(CommentToModelConvImpl.class);
    private final UserAccessor userAccessor;
    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MMMM dd, yyyy");

    public CommentToModelConvImpl(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public BhtCommentWebModel convertToModel(Comment comment) {
        BhtCommentWebModel model = new BhtCommentWebModel();
        model.setId(comment.getId());
        model.setBody(comment.getBodyAsStringWithoutMarkup());
        BhtCommentCreator bhtCommentCreator = new BhtCommentCreator();
        bhtCommentCreator.setName(comment.getCreator().getFullName());
        bhtCommentCreator.setLink("/display/~" + comment.getCreator().getName());
        bhtCommentCreator.setIconLink(this.userAccessor.getUserProfilePicture((User)comment.getCreator()).getUriReference());
        model.setCreator(bhtCommentCreator);
        model.setSpace(comment.getSpace().getDisplayTitle());
        BhtPage bhtPage = new BhtPage();
        bhtPage.setTitle(comment.getContainer().getDisplayTitle());
        bhtPage.setLink(comment.getContainer().getUrlPath());
        model.setPage(bhtPage);
        model.setType(comment.isInlineComment() ? "inline" : "footer");
        if (comment.getProperties().getStringProperty("inline-original-selection") != null) {
            model.setMarkedContent(comment.getProperties().getStringProperty("inline-original-selection"));
        } else {
            model.setMarkedContent("");
        }
        if (comment.getStatus().isResolved() || comment.getStatus().isDangling()) {
            model.setStatus("Resolved");
        } else {
            model.setStatus("Unresolved");
        }
        model.setLink(comment.getUrlPath());
        model.setCreationDate(this.simpleDateFormat2.format(comment.getCreationDate()));
        return model;
    }

    @Override
    public BhtCommentWebModel convertToModel(Content content) throws IOException {
        BhtCommentWebModel bhtCommentWebModel = new BhtCommentWebModel();
        bhtCommentWebModel.setId(content.getId().asLong());
        try {
            String replacedHtml = "";
            if (content.getBody() != null && content.getBody().get(ContentRepresentation.VIEW) != null) {
                replacedHtml = HTMLSearchableTextUtil.stripTags((String)((ContentBody)content.getBody().get(ContentRepresentation.VIEW)).getValue()).replace("\\n", "");
            }
            bhtCommentWebModel.setBody(replacedHtml);
        }
        catch (SAXException e) {
            this.LOG.error("[BHT Comments addon] Error parsing comment: " + e.getMessage());
        }
        bhtCommentWebModel.setCreationDate(content.getHistory().getCreatedAt().toString());
        bhtCommentWebModel.setType("comment");
        bhtCommentWebModel.setStatus("current");
        bhtCommentWebModel.setSpace(content.getSpace().getName());
        bhtCommentWebModel.setLocation(content.getExtension("location").toString());
        BhtPage page = new BhtPage();
        page.setTitle(((Content)content.getContainer()).getTitle());
        page.setLink(((Link)((Content)content.getContainer()).getLinks().get(LinkType.WEB_UI)).getPath());
        bhtCommentWebModel.setPage(page);
        BhtCommentCreator bhtCommentCreator = new BhtCommentCreator();
        bhtCommentCreator.setDisplayName(content.getHistory().getCreatedBy().getDisplayName());
        bhtCommentCreator.setName(content.getHistory().getCreatedBy().optionalUsername().orElse(""));
        bhtCommentCreator.setUserKey(((UserKey)content.getHistory().getCreatedBy().optionalUserKey().get()).getStringValue());
        bhtCommentCreator.setIconLink(content.getHistory().getCreatedBy().getProfilePicture().getPath());
        bhtCommentWebModel.setCreator(bhtCommentCreator);
        return bhtCommentWebModel;
    }
}

